/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.specador;

import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.comment.formatter.ICommentLinkResolver;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.specador.LanguageContributor;
import ro.amiq.dvt.specador.templates.IFreeMarkerWrapper;
import ro.amiq.dvt.utils.parser.CommentBlock;
import ro.amiq.dvt.wizards.specador.SpecadorModel;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfKind;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.specador.ClassWrapper;
import ro.amiq.vlogdt.specador.FunctionWrapper;
import ro.amiq.vlogdt.specador.InterfaceWrapper;
import ro.amiq.vlogdt.specador.ModuleWrapper;
import ro.amiq.vlogdt.specador.PackageWrapper;
import ro.amiq.vlogdt.specador.SpecadorVlogLinkResolver;
import ro.amiq.vlogdt.specador.TypeWrapper;

public abstract class Wrapper
implements IFreeMarkerWrapper {
    protected final RfNamedElement namedElement;
    protected final SpecadorModel model;
    final Comparator<IFreeMarkerWrapper> alphabeticComparator = (o1, o2) -> o1.getName().compareTo(o2.getName());

    public SpecadorModel getModel() {
        return this.model;
    }

    Wrapper(SpecadorModel model, RfNamedElement namedElement) {
        this.namedElement = namedElement;
        this.model = model;
    }

    public IRfNamedElement getNamedElement() {
        return this.namedElement;
    }

    public CommentBlock getCommentBlock() {
        return this.namedElement.getCommentBlock();
    }

    public ICommentLinkResolver getLinker() {
        return SpecadorVlogLinkResolver.getInstance();
    }

    public String getLibraryName() {
        return LanguageContributor.get((LanguageKind)LanguageKind.VLOG).getLibraryName((IRfNamedElement)this.namedElement);
    }

    public String createFileReferenceContent(File codeLocation) {
        RfFileDef fileDef = this.namedElement.getFile();
        if (fileDef == null) {
            return "";
        }
        ParserPath parserPath = fileDef.getParserPath();
        IPath fileLocation = Path.fromOSString((String)parserPath.toString());
        String sourceCodeFileContent = this.readSourceCodeFileForExporting(fileLocation.toFile());
        LinkedList<String> segments = new LinkedList<String>();
        LinkedList insertions = new LinkedList();
        Collection<RfDefElement> children = fileDef.getChildren();
        LinkedList<Wrapper> list = new LinkedList<Wrapper>();
        for (RfDefElement child : children) {
            RfNamedElement element = child.getNamedElement();
            if (element instanceof RfModule) {
                list.add(new ModuleWrapper(this.getModel(), (RfModule)element));
                continue;
            }
            if (element instanceof RfInterface) {
                list.add(new InterfaceWrapper(this.getModel(), (RfInterface)element));
                continue;
            }
            if (element instanceof RfClass) {
                list.add(new ClassWrapper(this.getModel(), (RfClass)element));
                continue;
            }
            if (element instanceof RfPackage) {
                list.add(new PackageWrapper(this.getModel(), (RfPackage)element));
                continue;
            }
            if (element instanceof RfTypeAlias) {
                list.add(new TypeWrapper(this.getModel(), (RfTypeAlias)element));
                continue;
            }
            if (!(element instanceof RfFunction) || ((RfFunction)element).isExtern()) continue;
            list.add(new FunctionWrapper(this.getModel(), (RfFunction)element));
        }
        segments.add(sourceCodeFileContent);
        this.addLinksToPage(segments, insertions, list, codeLocation);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < insertions.size()) {
            sb.append(StringEscapeUtils.escapeHtml((String)((String)segments.get(i)))).append((String)insertions.get(i));
            ++i;
        }
        sb.append(StringEscapeUtils.escapeHtml((String)((String)segments.get(segments.size() - 1))));
        return sb.toString();
    }

    public String getKind() {
        return RfKind.of(this.namedElement).getName().replace(" ", "-");
    }

    public String getScopeName() {
        return this.namedElement.getEnclosingScope() == null ? "work-" : String.valueOf(this.namedElement.getEnclosingScope().getName()) + "-";
    }

    protected String getLinkToRef(IRfNamedElement element) {
        return SpecadorVlogLinkResolver.getInstance().getLinkToRef(element);
    }

    public String getLanguageKind() {
        return "SystemVerilog";
    }

    public String getPackageName() {
        return this.namedElement.getEnclosingPackage() == null ? "work" : this.namedElement.getEnclosingPackage().getName().trim();
    }

    public String getFullPath() {
        return String.valueOf(super.getFullPath()) + "libraries" + File.separator + this.getLibraryName() + File.separator;
    }

    public static enum TypedefKinds {
        ENUM,
        STRUCT,
        TYPEDEF,
        OTHER;

    }
}

