/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.statistics;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.statistics.FileInfo;
import ro.amiq.dvt.statistics.Info;
import ro.amiq.dvt.statistics.Metric;
import ro.amiq.dvt.statistics.RelevantInfo;
import ro.amiq.dvt.statistics.StatisticsUtilProviderBase;
import ro.amiq.vlogdt.builders.VlogBuilderUtils;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.parser.VlogException;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.parser.VlogPreprocessingInfo;

public class StatisticsUtilProvider
extends StatisticsUtilProviderBase {
    private static final Pattern MACRO_CALL_PATTERN = Pattern.compile("`([a-zA-Z_][a-zA-Z_0-9]*)");
    private Map<String, Integer> fMacroNofLinesCache;
    public VlogInfo classInfo;
    public VlogInfo moduleInfo;
    public VlogInfo shallowModuleInfo;
    public VlogInfo programInfo;
    public VlogInfo interfaceInfo;
    public VlogInfo functionInfo;
    public VlogInfo shallowFunctionInfo;
    public VlogInfo taskInfo;
    public VlogInfo shallowTaskInfo;
    public int allNofEnumTypes;
    public int allNofStructTypes;
    public int allNofUnionTypes;
    public int allNofTypedefTypes;
    public int allNofCovergroups;

    public void clean() {
        super.clean();
        this.fMacroNofLinesCache = null;
        this.classInfo = null;
        this.moduleInfo = null;
        this.shallowModuleInfo = null;
        this.programInfo = null;
        this.interfaceInfo = null;
        this.functionInfo = null;
        this.shallowFunctionInfo = null;
        this.taskInfo = null;
        this.shallowTaskInfo = null;
    }

    public void init() {
        super.init();
        this.fMacroNofLinesCache = new HashMap<String, Integer>();
        this.classInfo = new VlogClassInfo();
        this.moduleInfo = new VlogModuleInfo();
        this.shallowModuleInfo = new VlogModuleInfo();
        this.programInfo = new VlogProgramInfo();
        this.interfaceInfo = new VlogInterfaceInfo();
        this.functionInfo = new VlogFunctionInfo();
        this.shallowFunctionInfo = new VlogFunctionInfo();
        this.taskInfo = new VlogTaskInfo();
        this.shallowTaskInfo = new VlogTaskInfo();
    }

    protected void collectSpecificStatistics(IProject project, IProgressMonitor progressMonitor) {
        RfNamedElement[] allTypes;
        super.collectSpecificStatistics(project, progressMonitor);
        RfProject rfProject = (RfProject)this.getRfProject(project);
        if (rfProject == null) {
            return;
        }
        if (!this.setCurrentTask("Collecting macro statistics ...", true)) {
            return;
        }
        this.computeMacroInfo(rfProject);
        if (!this.setCurrentTask("Collecting type statistics ...", true)) {
            return;
        }
        RfNamedElement[] rfNamedElementArray = allTypes = rfProject.getAllTypes(true, false);
        int n = allTypes.length;
        int n2 = 0;
        while (n2 < n) {
            RfNamedElement rfType = rfNamedElementArray[n2];
            if (!this.setCurrentTask("Collecting type statistics for " + rfType.getSignature() + " ...", false)) {
                return;
            }
            if (!this.isFiltered(rfType)) {
                if (rfType instanceof RfClass) {
                    RfClass rfClass = (RfClass)rfType;
                    VlogInfo classInfo = this.computeClassInfo(rfClass);
                    this.classInfo.update(classInfo);
                } else if (rfType instanceof RfModule) {
                    VlogInfo moduleInfo = this.computeOtherInfo(rfType);
                    if (rfType.isShallowCompiled() || rfType.isIncrementalShallowCompiled()) {
                        this.shallowModuleInfo.update(moduleInfo);
                    }
                    this.moduleInfo.update(moduleInfo);
                } else if (rfType instanceof RfProgram) {
                    VlogInfo programInfo = this.computeOtherInfo(rfType);
                    this.programInfo.update(programInfo);
                } else if (rfType instanceof RfInterface) {
                    VlogInfo interfaceInfo = this.computeOtherInfo(rfType);
                    this.interfaceInfo.update(interfaceInfo);
                } else if (rfType instanceof RfTypeAlias) {
                    IRfNamedElement translatedType = ((RfTypeAlias)rfType).getTranslatedType();
                    if (translatedType instanceof RfStruct && translatedType.getName().startsWith("enum/")) {
                        ++this.allNofEnumTypes;
                    } else if (translatedType instanceof RfStruct && translatedType.getName().startsWith("struct/")) {
                        ++this.allNofStructTypes;
                    } else if (translatedType instanceof RfStruct && translatedType.getName().startsWith("union/")) {
                        ++this.allNofUnionTypes;
                    } else {
                        ++this.allNofTypedefTypes;
                    }
                } else if (rfType instanceof RfCovergroup) {
                    ++this.allNofCovergroups;
                }
            }
            ++n2;
        }
        if (!this.setCurrentTask("Collecting function statistics ...", true)) {
            return;
        }
        List<RfFunction> functions = rfProject.getLocalMembers(RfFunction.class);
        if (functions != null) {
            for (RfFunction function : functions) {
                if (!this.setCurrentTask("Collecting function/task statistics for " + function.getSignature() + " ...", false)) {
                    return;
                }
                if (function.isPredefined() || this.isFiltered(function)) continue;
                if (function.isTask()) {
                    VlogInfo taskInfo = this.computeFunctionInfo(function);
                    if (function.isShallowCompiled() || function.isIncrementalShallowCompiled()) {
                        this.shallowTaskInfo.update(taskInfo);
                    }
                    this.taskInfo.update(taskInfo);
                    continue;
                }
                VlogInfo functionInfo = this.computeFunctionInfo(function);
                if (function.isShallowCompiled() || function.isIncrementalShallowCompiled()) {
                    this.shallowFunctionInfo.update(functionInfo);
                }
                this.functionInfo.update(functionInfo);
            }
        }
        this.addSeparator();
        this.createAndAddMetric("Nof Classes", this.classInfo.counter);
        this.createAndAddMetric("Nof Functions", this.functionInfo.counter);
        this.createAndAddMetric("Nof Shallow Functions", this.shallowFunctionInfo.counter);
        this.createAndAddMetric("Nof Tasks", this.taskInfo.counter);
        this.createAndAddMetric("Nof Shallow Tasks", this.shallowTaskInfo.counter);
        this.createAndAddMetric("Nof Enums", this.allNofEnumTypes);
        this.createAndAddMetric("Nof Structs", this.allNofStructTypes);
        this.createAndAddMetric("Nof Unions", this.allNofUnionTypes);
        this.createAndAddMetric("Nof Typedefs", this.allNofTypedefTypes);
        this.createAndAddMetric("Nof Modules", this.moduleInfo.counter);
        this.createAndAddMetric("Nof Shallow Modules", this.shallowModuleInfo.counter);
        this.createAndAddMetric("Nof Programs", this.programInfo.counter);
        this.createAndAddMetric("Nof Interfaces", this.interfaceInfo.counter);
        this.createAndAddMetric("Nof Covergroups", this.allNofCovergroups);
        if (this.classInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.classInfo);
        }
        if (this.programInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.programInfo);
        }
        if (this.moduleInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.moduleInfo);
        }
        if (this.shallowModuleInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.shallowModuleInfo);
        }
        if (this.interfaceInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.interfaceInfo);
        }
        if (this.functionInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.functionInfo);
        }
        if (this.shallowFunctionInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.shallowFunctionInfo);
        }
        if (this.taskInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.taskInfo);
        }
        if (this.shallowTaskInfo.counter > 0) {
            this.addSeparator();
            this.createAndAddMetrics(this.shallowTaskInfo);
        }
        this.fProgressMonitor = null;
    }

    private void computeMacroInfo(RfProject rfProject) {
        int allNofDefines = 0;
        int nofMacroCalls = 0;
        int nofExpandedLines = 0;
        String largestMacroExpansion = null;
        int nofLinesLargestMacroExpansion = 0;
        Matcher macroCallMatcher = MACRO_CALL_PATTERN.matcher("");
        for (VlogMacroInfo macro : rfProject.getAllMacros()) {
            if (macro == null || macro.isPredefined() || macro.getMacroText() == null || this.isFiltered(macro)) continue;
            ++allNofDefines;
        }
        if (this.fSpm.isCollectMacroExpansionInfo()) {
            for (ParserPath fileName : this.getCompiledParserPaths(rfProject)) {
                if (!this.setCurrentTask("Collecting macro call statistics for " + fileName + "...", false)) {
                    return;
                }
                if (this.isFiltered(fileName)) continue;
                BufferedReader in = null;
                try {
                    try {
                        in = new BufferedReader(new FileReader(fileName.path));
                        String line = null;
                        int lineNumber = 0;
                        while ((line = in.readLine()) != null) {
                            ++lineNumber;
                            macroCallMatcher.reset(line);
                            while (macroCallMatcher.find()) {
                                String macroName = macroCallMatcher.group(1);
                                if (this.fMacroNofLinesCache.containsKey(macroName)) {
                                    nofExpandedLines += this.fMacroNofLinesCache.get(macroName).intValue();
                                    ++nofMacroCalls;
                                    continue;
                                }
                                List<RfNamedElement> macros = rfProject.getMacrosWithPrefix(macroName, 1);
                                if (macros == null || macros.isEmpty() || !(macros.get(0) instanceof VlogMacroInfo)) continue;
                                ++nofMacroCalls;
                                VlogMacroInfo macro = (VlogMacroInfo)macros.get(0);
                                try {
                                    int nofExpansionLines = macro.getReplacement(null, null, lineNumber, fileName).replace("\r\n", "\n").replace("\r", "\n").split("\n").length;
                                    if (nofLinesLargestMacroExpansion < nofExpansionLines) {
                                        nofLinesLargestMacroExpansion = nofExpansionLines;
                                        largestMacroExpansion = macroName;
                                    }
                                    this.fMacroNofLinesCache.put(macroName, nofExpansionLines);
                                    nofExpandedLines += nofExpansionLines;
                                }
                                catch (VlogException e) {
                                    DVTLogger.INSTANCE.logError((Throwable)e);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        if (in == null) continue;
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            DVTLogger.INSTANCE.logError((Throwable)e2);
                        }
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    }
                    throw throwable;
                }
                if (in == null) continue;
                try {
                    in.close();
                }
                catch (IOException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }
        this.addSeparator();
        this.createAndAddMetric("Nof Macros", allNofDefines);
        if (this.fSpm.isCollectMacroExpansionInfo()) {
            this.createAndAddMetric("Nof Macro Calls", nofMacroCalls);
            this.createAndAddMetric("Nof Expanded Macro Lines", nofExpandedLines);
            if (largestMacroExpansion != null) {
                this.createAndAddMetric("Max Macro Expansion", nofLinesLargestMacroExpansion);
                this.createAndAddMetric("Max Macro Expansion Name", largestMacroExpansion);
            }
        }
    }

    protected FileInfo computeFileInfo(String fileName) {
        FileInfo result;
        block18: {
            result = new FileInfo(fileName);
            BufferedReader in = null;
            try {
                try {
                    in = new BufferedReader(new FileReader(fileName));
                    String line = null;
                    boolean inComment = false;
                    while ((line = in.readLine()) != null) {
                        ++result.totalNofLines;
                        if ((line = line.trim()).startsWith("/*")) {
                            inComment = true;
                        }
                        if (line.contains("*/")) {
                            inComment = false;
                        }
                        if (line.startsWith("//")) {
                            ++result.commentNofLines;
                            continue;
                        }
                        if (line.length() == 0) {
                            ++result.emptyNofLines;
                            continue;
                        }
                        if (inComment) {
                            ++result.commentNofLines;
                            continue;
                        }
                        ++result.codeNofLines;
                        result.codeNofChars += line.length();
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    if (in == null) break block18;
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        DVTLogger.INSTANCE.logError((Throwable)e2);
                    }
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    private VlogInfo computeClassInfo(RfClass rfClass) {
        List<RfFunction> functions;
        VlogInfo result = new VlogInfo(rfClass.getName());
        RfClass clazz = rfClass;
        while ((clazz = clazz.getParent()) != null) {
            if (clazz.isPredefined()) break;
            ++result.nofParents.counter;
        }
        Set<RfClass> childClasses = rfClass.getChildren();
        result.nofChildren.counter = childClasses == null ? 0 : childClasses.size();
        List<RfField> fields = rfClass.getFields();
        if (fields != null) {
            for (RfField field : fields) {
                if (field.isPredefined()) continue;
                if (field.isEvent()) {
                    ++result.nofEvents.counter;
                    continue;
                }
                if (!field.isField()) continue;
                ++result.nofFields.counter;
            }
        }
        if ((functions = rfClass.getLocalMembers(RfFunction.class)) != null) {
            for (RfFunction function : functions) {
                if (function.isPredefined()) continue;
                if (function.isTask()) {
                    ++result.nofTasks.counter;
                    VlogInfo taskInfo = this.computeFunctionInfo(function);
                    if (function.isShallowCompiled() || function.isIncrementalShallowCompiled()) {
                        ++result.nofShallowTasks.counter;
                        this.shallowTaskInfo.update(taskInfo);
                    }
                    this.taskInfo.update(taskInfo);
                    continue;
                }
                ++result.nofFunctions.counter;
                VlogInfo functionInfo = this.computeFunctionInfo(function);
                if (function.isShallowCompiled() || function.isIncrementalShallowCompiled()) {
                    ++result.nofShallowFunctions.counter;
                    this.shallowFunctionInfo.update(functionInfo);
                }
                this.functionInfo.update(functionInfo);
            }
        }
        List<RfField> events = rfClass.getEvents();
        result.nofEvents.counter = events == null ? 0 : events.size();
        RfDefElement declaration = rfClass.getDeclaration();
        if (declaration != null) {
            result.nofDefinitionLines.counter = declaration.getEndLine() - declaration.getStartLine() + 1;
        }
        return result;
    }

    private VlogInfo computeOtherInfo(RfNamedElement rfNamedElement) {
        List<RfPort> ports;
        List<RfFunction> functions;
        VlogInfo result = new VlogInfo(rfNamedElement.getName());
        List<RfField> fields = rfNamedElement.getFields();
        if (fields != null) {
            for (RfField field : fields) {
                if (field.isPredefined() || field instanceof RfPort) continue;
                if (field.isEvent()) {
                    ++result.nofEvents.counter;
                    continue;
                }
                if (!field.isField()) continue;
                ++result.nofFields.counter;
            }
        }
        if ((functions = rfNamedElement.getLocalMembers(RfFunction.class)) != null) {
            for (RfFunction function : functions) {
                if (function.isPredefined()) continue;
                if (function.isTask()) {
                    ++result.nofTasks.counter;
                    VlogInfo taskInfo = this.computeFunctionInfo(function);
                    if (function.isShallowCompiled() || function.isIncrementalShallowCompiled()) {
                        ++result.nofShallowTasks.counter;
                        this.shallowTaskInfo.update(taskInfo);
                    }
                    this.taskInfo.update(taskInfo);
                    continue;
                }
                ++result.nofFunctions.counter;
                VlogInfo functionInfo = this.computeFunctionInfo(function);
                if (function.isShallowCompiled() || function.isIncrementalShallowCompiled()) {
                    ++result.nofShallowFunctions.counter;
                    this.shallowFunctionInfo.update(functionInfo);
                }
                this.functionInfo.update(functionInfo);
            }
        }
        List<RfField> events = rfNamedElement.getEvents();
        result.nofEvents.counter = events == null ? 0 : events.size();
        RfDefElement declaration = rfNamedElement.getDeclaration();
        if (declaration != null) {
            result.nofDefinitionLines.counter = declaration.getEndLine() - declaration.getStartLine() + 1;
        }
        if ((ports = rfNamedElement.getPortsWithPrefix("", 2)) != null) {
            result.nofPorts.counter = ports.size();
        }
        return result;
    }

    private VlogInfo computeFunctionInfo(RfFunction rfFunction) {
        VlogInfo result = new VlogInfo(String.valueOf(rfFunction.getEnclosingScope().getName()) + "." + rfFunction.getName());
        Collection layers = rfFunction.getDeclarations();
        if (layers != null) {
            for (IRfDefElement layer : layers) {
                result.nofDefinitionLines.counter += layer.getEndLine() - layer.getStartLine() + 1;
            }
        }
        return result;
    }

    protected boolean isFiltered(Object o) {
        if (o instanceof VlogMacroInfo) {
            String fn = ((VlogMacroInfo)o).getFileInstance().getParserPath().path;
            if (this.fSpm.isFiltered(fn)) {
                return true;
            }
        } else if (o instanceof RfNamedElement) {
            Collection defs = ((RfNamedElement)o).getDeclarations();
            if (defs != null && !defs.isEmpty()) {
                for (RfDefElement def : defs) {
                    if (!this.fSpm.isFiltered(def.getDefFile().getParserPath().path)) continue;
                    return true;
                }
            }
        } else if (o instanceof String) {
            return this.fSpm.isFiltered((String)o);
        }
        return false;
    }

    public String getNature() {
        return "ro.amiq.vlogdt.VlogNature";
    }

    protected String heading() {
        return "SystemVerilog statistics";
    }

    protected IRfSingleLangProject getRfProject(IProject project) {
        return RfManager.getInstance().getRfProject(project);
    }

    protected List<ParserPath> getCompiledParserPaths(IRfSingleLangProject rfProject) {
        RfProject vlogRfProject = (RfProject)rfProject;
        VlogPreprocessingInfo preprocessingTable = vlogRfProject.getPreprocessingTable();
        VlogFileInstance topFile = preprocessingTable.getTopFileInstance();
        List<VlogFileInstance> allInstances = VlogBuilderUtils.getRecursiveFileInstances(topFile.getIncludedInstances());
        return allInstances.stream().map(x -> x.getParserPath()).distinct().collect(Collectors.toList());
    }

    private static class VlogClassInfo
    extends VlogInfo {
        public VlogClassInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Nof Class Parents", this.nofParents));
            result.addAll(this.createMetric("Nof Class Children", this.nofChildren));
            result.addAll(this.createMetric("Class Size (lines)", this.nofDefinitionLines));
            result.addAll(this.createMetric("Nof Class Functions", this.nofFunctions));
            result.addAll(this.createMetric("Nof Class Shallow Functions", this.nofShallowFunctions));
            result.addAll(this.createMetric("Nof Class Tasks", this.nofTasks));
            result.addAll(this.createMetric("Nof Class Shallow Tasks", this.nofShallowTasks));
            result.addAll(this.createMetric("Nof Class Fields", this.nofFields));
            result.addAll(this.createMetric("Nof Class Events", this.nofEvents));
            return result;
        }
    }

    private static class VlogFunctionInfo
    extends VlogInfo {
        public VlogFunctionInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Function Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }

    public static class VlogInfo
    extends Info {
        public RelevantInfo nofParents;
        public RelevantInfo nofChildren;
        public RelevantInfo nofDefinitionLines;
        public RelevantInfo nofFields;
        public RelevantInfo nofFunctions;
        public RelevantInfo nofShallowFunctions;
        public RelevantInfo nofTasks;
        public RelevantInfo nofShallowTasks;
        public RelevantInfo nofEvents;
        public RelevantInfo nofPorts;

        protected VlogInfo(String elementName) {
            this.nofParents = new RelevantInfo(elementName);
            this.nofChildren = new RelevantInfo(elementName);
            this.nofDefinitionLines = new RelevantInfo(elementName);
            this.nofFields = new RelevantInfo(elementName);
            this.nofFunctions = new RelevantInfo(elementName);
            this.nofShallowFunctions = new RelevantInfo(elementName);
            this.nofTasks = new RelevantInfo(elementName);
            this.nofShallowTasks = new RelevantInfo(elementName);
            this.nofEvents = new RelevantInfo(elementName);
            this.nofPorts = new RelevantInfo(elementName);
        }

        public void update(VlogInfo info) {
            ++this.counter;
            this.nofParents.update(info.nofParents);
            this.nofChildren.update(info.nofChildren);
            this.nofDefinitionLines.update(info.nofDefinitionLines);
            this.nofFields.update(info.nofFields);
            this.nofFunctions.update(info.nofFunctions);
            this.nofShallowFunctions.update(info.nofShallowFunctions);
            this.nofTasks.update(info.nofTasks);
            this.nofShallowTasks.update(info.nofShallowTasks);
            this.nofEvents.update(info.nofEvents);
            this.nofPorts.update(info.nofPorts);
        }
    }

    private static class VlogInterfaceInfo
    extends VlogInfo {
        public VlogInterfaceInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Interface Size (lines)", this.nofDefinitionLines));
            result.addAll(this.createMetric("Nof Interface Functions", this.nofFunctions));
            result.addAll(this.createMetric("Nof Interface Shallow Functions", this.nofShallowFunctions));
            result.addAll(this.createMetric("Nof Interface Tasks", this.nofTasks));
            result.addAll(this.createMetric("Nof Interface Shallow Tasks", this.nofShallowTasks));
            result.addAll(this.createMetric("Nof Interface Ports", this.nofPorts));
            result.addAll(this.createMetric("Nof Interface Fields", this.nofFields));
            result.addAll(this.createMetric("Nof Interface Events", this.nofEvents));
            return result;
        }
    }

    private static class VlogModuleInfo
    extends VlogInfo {
        public VlogModuleInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Module Size (lines)", this.nofDefinitionLines));
            result.addAll(this.createMetric("Nof Module Functions", this.nofFunctions));
            result.addAll(this.createMetric("Nof Module Shallow Functions", this.nofShallowFunctions));
            result.addAll(this.createMetric("Nof Module Tasks", this.nofTasks));
            result.addAll(this.createMetric("Nof Module Shallow Tasks", this.nofShallowTasks));
            result.addAll(this.createMetric("Nof Module Ports", this.nofPorts));
            result.addAll(this.createMetric("Nof Module Fields", this.nofFields));
            result.addAll(this.createMetric("Nof Module Events", this.nofEvents));
            return result;
        }
    }

    private static class VlogProgramInfo
    extends VlogInfo {
        public VlogProgramInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Program Size (lines)", this.nofDefinitionLines));
            result.addAll(this.createMetric("Nof Program Functions", this.nofFunctions));
            result.addAll(this.createMetric("Nof Program Shallow Functions", this.nofShallowFunctions));
            result.addAll(this.createMetric("Nof Program Tasks", this.nofTasks));
            result.addAll(this.createMetric("Nof Program Shallow Tasks", this.nofShallowTasks));
            result.addAll(this.createMetric("Nof Program Ports", this.nofPorts));
            result.addAll(this.createMetric("Nof Program Fields", this.nofFields));
            result.addAll(this.createMetric("Nof Program Events", this.nofEvents));
            return result;
        }
    }

    private static class VlogTaskInfo
    extends VlogInfo {
        public VlogTaskInfo() {
            super("N/A");
        }

        public List<Metric> getMetrics() {
            ArrayList<Metric> result = new ArrayList<Metric>();
            result.addAll(this.createMetric("Task Size (lines)", this.nofDefinitionLines));
            return result;
        }
    }
}

