/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.test;

import antlr.Token;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.TextInvocationContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.buildconfig.ChecksKindWrapper;
import ro.amiq.dvt.buildconfig.FullChecksKind;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.XThreadDefinition;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfElementPath;
import ro.amiq.dvt.model.reflection.RfElementPathInProject;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.precompiled.PrecompiledDbStats;
import ro.amiq.dvt.startup.DVTProjectImporter;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.ForTestingOrDebuggingOnly;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.ProductSafe;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.buildconfig.editor.BCEditor;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.trace.connections.model.TCNode;
import ro.amiq.dvt.ui.views.DVTBaseLabelProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.designhierarchy.IDHLabelProvider;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.views.IDVTLazyView;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.CompileOrderTestUtils;
import ro.amiq.dvt.ui.views.lazy.views.compileorder.CompileOrderView;
import ro.amiq.dvt.ui.views.lazy.views.designhierarchy.LazyDesignHierarchyView;
import ro.amiq.dvt.ui.views.lazy.views.types.TypesView;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.LazyVerificationHierarchyTestUtils;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyPortsView;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.VerificationHierarchyView;
import ro.amiq.dvt.ui.views.semantic.HHWrapper;
import ro.amiq.dvt.ui.views.templates.CustomTemplate;
import ro.amiq.dvt.ui.views.templates.TemplatesViewUtils;
import ro.amiq.dvt.ui.views.trace.connections.TraceConnectionsView;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.dvt.utils.benchmark.StopWatch;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.interpreter.XSimDebugAction;
import ro.amiq.vlogdt.interpreter.XSimVlog;
import ro.amiq.vlogdt.linter.OVMComplianceBuilder;
import ro.amiq.vlogdt.linter.OVMComplianceCheck;
import ro.amiq.vlogdt.linter.OVMComplianceCheckHit;
import ro.amiq.vlogdt.linter.api.impl.CustomRulesTestRuleset;
import ro.amiq.vlogdt.linter.ruleset.RulesetKind;
import ro.amiq.vlogdt.model.reflection.IncrementalDeltaContainer;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPort;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.SearchDependencyContainer;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.views.CompileOrderLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.MacroViewLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.RefactoringHelper;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.TypesViewLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.UIQuickTHTreeViewProvider;
import ro.amiq.vlogdt.model.reflection.views.VlogQuickViewersUtil;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmPort;
import ro.amiq.vlogdt.ui.actions.FieldEditorAction;
import ro.amiq.vlogdt.ui.actions.ScriptRefactorAction;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.editor.VlogEditorMessages;
import ro.amiq.vlogdt.ui.editor.VlogSourceViewerConfiguration;
import ro.amiq.vlogdt.ui.editor.actions.VlogRenameRefactorAction;
import ro.amiq.vlogdt.ui.editor.override.GetterSetterMethodsUtils;
import ro.amiq.vlogdt.ui.editor.override.OverrideMethodsUtils;
import ro.amiq.vlogdt.ui.search.TextSearchPage;

@ForTestingOrDebuggingOnly
public class TestHelper
extends ro.amiq.dvt.test.TestHelper {
    private static final TestHelper INSTANCE = new TestHelper();
    @ProductSafe
    public static String fRefactorXmlPath;
    static Comparator<OVMComplianceCheckHit> checkHitsComparator;
    static Comparator<RfFunction> functionComparator;
    public static DVTBaseLabelProvider wrp2;
    public static IDHLabelProvider wrp3;
    public static UIQuickTHTreeViewProvider wrp4;
    public static CompileOrderLabelProvider wrp6;
    public static MacroViewLabelProvider wrp7;
    @ProductSafe
    public static long fSuccessfullGuessingTime;
    @ProductSafe
    public static long fUnSuccessfullGuessingTime;
    @ProductSafe
    public static PrecompiledDbStats fPrecompiledLoadStats;
    @ProductSafe
    public static IncrementalDeltaContainer fIncrementalDeltaContainer;

    static {
        checkHitsComparator = (o1, o2) -> {
            String fileName1 = o1.getShortFileNameAndMacroPath();
            String fileName2 = o2.getShortFileNameAndMacroPath();
            Integer line1 = o1.getLine();
            Integer line2 = o2.getLine();
            String details1 = o1.getDetails();
            String details2 = o2.getDetails();
            if (fileName1.compareTo(fileName2) == 0) {
                if (line1.compareTo(line2) == 0) {
                    return details1.compareTo(details2);
                }
                return line1.compareTo(line2);
            }
            return fileName1.compareTo(fileName2);
        };
        functionComparator = (o1, o2) -> {
            String name1 = o1.getName();
            String name2 = o2.getName();
            return name1.compareTo(name2);
        };
    }

    protected TestHelper() {
        this.fPreferenceStore = VlogPlugin.getDefault().getPreferenceStore();
    }

    @ProductSafe
    public static TestHelper getInstance() {
        return INSTANCE;
    }

    public static void openEditorForModuleName(IProject project, String libraryName, String moduleName) {
        RfModule candidate = RfManager.getInstance().getRfProject(project).getLibrariesWithPrefix(libraryName, 1).get(0).getModulesWithPrefix(moduleName, 1, 3).get(0);
        RfUtils.createOpenAction(candidate, project, null).open();
    }

    public static Object getQuickHierarchyData(IProject project, ITextEditor editor, int offset) {
        return TestHelper.getTypeHierarchyRoot();
    }

    public static Object getTraceViewTreeRootElement() {
        try {
            TraceConnectionsView tracePortsView = (TraceConnectionsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ro.amiq.dvt.ui.views.TraceConnectionsView");
            return tracePortsView.testHelpGetInput();
        }
        catch (PartInitException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void selectTraceViewTreeItem(TreeItem item) {
        try {
            TraceConnectionsView tracePortsView = (TraceConnectionsView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ro.amiq.dvt.ui.views.TraceConnectionsView");
            tracePortsView.testHelpSelectViewItem(item, "default-tree");
            if (tracePortsView.hasPortsView()) {
                ObjectionManager.getInstance().waitFor(new Objection[]{Objection.TRACE_PORTS_VIEW});
            }
        }
        catch (PartInitException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static List<?> getDesignHierarchyPorts() {
        LazyDesignHierarchyView lazyDesignHierarchyView = (LazyDesignHierarchyView)TestHelper.getInstance().showView("ro.amiq.dvt.ui.views.LazyDesignHierarchyView");
        return lazyDesignHierarchyView.getLazyTreeTestUtils().testHelpGetInstancePorts();
    }

    public static void selectPortInDesignHierarchy(int index, boolean emulateUserSelection) {
        try {
            LazyDesignHierarchyView lazyDesignHierarchyView = (LazyDesignHierarchyView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ro.amiq.dvt.ui.views.LazyDesignHierarchyView");
            lazyDesignHierarchyView.getLazyTreeTestUtils().testHelpSelectPortByIndex(index, emulateUserSelection);
        }
        catch (PartInitException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    static BaseLabelProvider getUIRfTypesTreeViewProvider() {
        if (wrp2 == null) {
            wrp2 = ((TypesView)ViewsUtils.getViewById((String)"ro.amiq.dvt.ui.views.TypesView", (boolean)false)).getLazyTreeTestUtils().getTreeLabelProvider();
        }
        return wrp2;
    }

    public String getTypesText(Object wrapper) {
        return ((LabelProvider)TestHelper.getUIRfTypesTreeViewProvider()).getText(wrapper);
    }

    public Image getTypesImage(Object wrapper) {
        return ((LabelProvider)TestHelper.getUIRfTypesTreeViewProvider()).getImage(wrapper);
    }

    public static Object[] getTypesChildren(Object wrapper) {
        if (!(wrapper instanceof IDVTElementWrapper)) {
            return null;
        }
        IDVTElementWrapper wrapper2 = (IDVTElementWrapper)wrapper;
        if (wrapper2.hasChildren()) {
            return wrapper2.getChildren().toArray();
        }
        return null;
    }

    public static Object[] getDesignHierarchyChildren(Object wrapper) {
        if (!(wrapper instanceof IDVTElementWrapper)) {
            return null;
        }
        IDVTElementWrapper wrapper2 = (IDVTElementWrapper)wrapper;
        if (wrapper2.hasChildren()) {
            return wrapper2.getChildren().toArray();
        }
        return null;
    }

    static TypesViewLabelProvider getRfTypeHierarchyViewProvider() {
        if (wrp4 == null) {
            wrp4 = new UIQuickTHTreeViewProvider();
        }
        return wrp4;
    }

    public static String getTypeHierarchyText(Object wrapper) {
        return TestHelper.getRfTypeHierarchyViewProvider().getText(wrapper);
    }

    public static Image getTypeHierarchyImage(Object wrapper) {
        return TestHelper.getRfTypeHierarchyViewProvider().getImage(wrapper);
    }

    public static Object[] getTypeHierarchyChildren(Object wrapper) {
        if (!(wrapper instanceof IDVTElementWrapper)) {
            return null;
        }
        IDVTElementWrapper wrapper2 = (IDVTElementWrapper)wrapper;
        if (wrapper2.hasChildren()) {
            return wrapper2.getChildren().toArray();
        }
        return null;
    }

    static CompileOrderLabelProvider getIncludeTreeViewProvider() {
        if (wrp6 == null) {
            wrp6 = new CompileOrderLabelProvider();
        }
        return wrp6;
    }

    public static String getIncludeTreeText(Object wrapper) {
        return TestHelper.getIncludeTreeViewProvider().getText(wrapper);
    }

    public static Image getIncludeTreeImage(Object wrapper) {
        return TestHelper.getIncludeTreeViewProvider().getImage(wrapper);
    }

    public static Object[] getIncludeTreeChildren(Object wrapper) {
        return TestHelper.getIncludeTreeViewProvider().getChildren(wrapper);
    }

    static MacroViewLabelProvider getMacrosViewProvider() {
        if (wrp7 == null) {
            wrp7 = new MacroViewLabelProvider();
        }
        return wrp7;
    }

    public static String getMacrosText(Object wrapper) {
        return TestHelper.getMacrosViewProvider().getText(wrapper);
    }

    public static Image getImageByFieldName(String fieldName, Object with) {
        if (with instanceof IDVTElementWrapper) {
            Object element = ((IDVTElementWrapper)with).getRfElement();
            IRfNamedElement namedElem = null;
            if (element instanceof IRfNamedElement) {
                namedElem = (IRfNamedElement)element;
            } else if (element instanceof IRfDefElement) {
                namedElem = ((IRfDefElement)element).getNamedElement();
            } else {
                if (element instanceof IDVTFileInstance) {
                    CompileOrderLabelProvider itvp = TestHelper.getIncludeTreeViewProvider();
                    return itvp.getImage(with);
                }
                if (element instanceof TCNode) {
                    namedElem = ((TCNode)element).namedElement;
                }
            }
            if (namedElem != null) {
                return namedElem.testGetImage(fieldName);
            }
        }
        return null;
    }

    protected List<String> getFieldNameByDescriptor(Field[] fields, ImageDescriptor descriptor) {
        ArrayList<String> matches = new ArrayList<String>();
        try {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (field != null && (field.getModifiers() & 1) != 0 && field.getType() == ImageDescriptor.class && field.get(null).equals(descriptor)) {
                    matches.add(field.getName());
                }
                ++n2;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException exception) {
            return null;
        }
        return matches;
    }

    public List<String> getImageDescriptors(Image image) {
        ArrayList<String> results = new ArrayList<String>();
        List descriptors = DVTImages.imageCache.getImageDescriptors(image);
        for (ImageDescriptor descriptor : descriptors) {
            results.addAll(this.getFieldNameByDescriptor(DVTImages.class.getDeclaredFields(), descriptor));
        }
        return results;
    }

    public static String getFieldNameByImage(Image image, String targetDescriptorName) {
        List<String> descriptorNames = TestHelper.getInstance().getImageDescriptors(image);
        String result = null;
        if ("".equals(targetDescriptorName) && !descriptorNames.isEmpty()) {
            return descriptorNames.get(0);
        }
        for (String descriptorName : descriptorNames) {
            if (!targetDescriptorName.equals(descriptorName)) continue;
            result = descriptorName;
        }
        if (result == null) {
            result = "IMAGE_WAS_NOT_LOADED";
        }
        return result;
    }

    public static BCEditor getBCEditor() {
        return (BCEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
    }

    public int getCurrentLine() {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof DVTEditor) {
            return ((DVTEditor)editor).testGetCurrentLine();
        }
        return -1;
    }

    public static int getCurrentColumn() {
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editor instanceof DVTEditor) {
            return ((DVTEditor)editor).testGetCurrentColumn();
        }
        return -1;
    }

    public static IPreferenceStore getPreferenceStore() {
        return TestHelper.getInstance().fPreferenceStore;
    }

    public static IPreferenceStore getSearchPreferenceStore() {
        return SearchPlugin.getDefault().getPreferenceStore();
    }

    public static void setTestRuleset(Class<?>[] rules) {
        CustomRulesTestRuleset.setRules(rules);
    }

    public static void importAndLintProject(String aProjectFullPath, RulesetKind rulesetKind) throws CoreException {
        TestHelper.importAndLintProject(aProjectFullPath, rulesetKind, null, false, null);
    }

    public static void importAndLintProject(String aProjectFullPath, RulesetKind rulesetKind, String htmlReportLocation, boolean autoExportOn) throws CoreException {
        TestHelper.importAndLintProject(aProjectFullPath, rulesetKind, htmlReportLocation, autoExportOn, null);
    }

    public static void importAndLintProject(String aProjectFullPath, RulesetKind rulesetKind, String htmlReportLocation, boolean autoExportOn, String baselineReportLocation) throws CoreException {
        TestHelper.importAndLintProject(aProjectFullPath, rulesetKind, htmlReportLocation, autoExportOn, baselineReportLocation, false);
    }

    public static void importAndLintProject(String aProjectFullPath, RulesetKind rulesetKind, String htmlReportLocation, boolean autoExportOn, String baselineReportLocation, boolean prewaiveUnchangedFiles) throws CoreException {
        DVTProjectImporter.setLintTestMode((boolean)true);
        DVTProjectImporter.setLintTestRulesetKindName((String)rulesetKind.toString());
        if (rulesetKind.equals((Object)RulesetKind.IMPORT_FROM_HTML) && htmlReportLocation != null) {
            DVTProjectImporter.setLintTestImportHTMLReportLocation((String)htmlReportLocation);
        }
        if (autoExportOn && htmlReportLocation != null) {
            DVTProjectImporter.setLintTestAutoExportHTMLReportLocation((String)htmlReportLocation);
        }
        if (baselineReportLocation != null) {
            DVTProjectImporter.setLintTestBaselineReportLocation((String)baselineReportLocation);
            DVTProjectImporter.setLintTestPrewaiveUnchangedFiles((boolean)prewaiveUnchangedFiles);
        }
        DVTProjectImporter.importProject((String)aProjectFullPath, (boolean)true);
        ObjectionManager.getInstance().waitFor(new Objection[]{Objection.LINT_DONE});
    }

    public static void clearOVMProjects() {
        OVMComplianceBuilder.getInstance().clearOVMProjects();
    }

    public static boolean hadErrorsWhileLinting(IProject project) {
        boolean hadErrors = true;
        try {
            hadErrors = OVMComplianceBuilder.getInstance().checkErrors(project);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hadErrors;
    }

    public static List<OVMComplianceCheck> getOVMComplianceChecks(IProject project) {
        return OVMComplianceBuilder.getInstance().getOVMProject(project).getChecks();
    }

    public static boolean isOVMComplianceCheckEnabled(String checkName, IProject project) {
        OVMComplianceCheck check = OVMComplianceBuilder.getInstance().getCheck(checkName, project);
        return check.isEnabled();
    }

    public static Object getOVMComplianceCheckHits(String checkName, IProject project) {
        OVMComplianceCheck check = OVMComplianceBuilder.getInstance().getCheck(checkName, project);
        if (check == null) {
            return null;
        }
        return check.getAllHitsForRReport(false);
    }

    public static String getCheckHitFileName(Object ob) {
        if (ob == null || !(ob instanceof OVMComplianceCheckHit)) {
            return null;
        }
        return ((OVMComplianceCheckHit)ob).getShortFileNameAndMacroPath();
    }

    public static String getCheckHitFilePath(Object ob) {
        if (ob == null || !(ob instanceof OVMComplianceCheckHit)) {
            return null;
        }
        return ((OVMComplianceCheckHit)ob).getParserPath().path;
    }

    public static int getCheckHitLine(Object ob) {
        if (ob == null || !(ob instanceof OVMComplianceCheckHit)) {
            return -1;
        }
        return ((OVMComplianceCheckHit)ob).getLine();
    }

    public static String getCheckHitDetails(Object ob) {
        if (ob == null || !(ob instanceof OVMComplianceCheckHit)) {
            return "";
        }
        return ((OVMComplianceCheckHit)ob).getDetails();
    }

    public static String getCheckHitMessage(Object ob) {
        if (ob == null || !(ob instanceof OVMComplianceCheckHit)) {
            return "";
        }
        return ((OVMComplianceCheckHit)ob).getDetails();
    }

    public static String getCheckHitSeverity(Object ob) {
        if (ob == null || !(ob instanceof OVMComplianceCheckHit)) {
            return "";
        }
        return ((OVMComplianceCheckHit)ob).getSeverity().toString();
    }

    public static Set<String> getCompareAnnotations(Object ob) {
        if (ob == null || !(ob instanceof OVMComplianceCheckHit)) {
            return null;
        }
        return ((OVMComplianceCheckHit)ob).getCompareAnnotations();
    }

    public static Object sortOVMComplianceCheckHits(List<?> hits) {
        ArrayList<OVMComplianceCheckHit> orderedHits = new ArrayList<OVMComplianceCheckHit>();
        for (Object hit : hits) {
            if (!(hit instanceof OVMComplianceCheckHit)) continue;
            orderedHits.add((OVMComplianceCheckHit)hit);
        }
        Collections.sort(orderedHits, checkHitsComparator);
        return orderedHits;
    }

    public static RfModule getInstance(String projectName, String moduleName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        return rfProject.getModule(moduleName);
    }

    public static RfProject getProject(String projectName) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        return RfManager.getInstance().getRfProject(project);
    }

    public static List<RfInstance> getInstances(String projectName, RfModule top) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        return RefactoringHelper.getAllInstances(rfProject);
    }

    public static void createTemplate(IProject project, String name, String description, String contextId, String code) {
        Template template = new Template(name, description, contextId, code, true);
        TemplatesViewUtils.addTemplate((CustomTemplate)new CustomTemplate(template, project));
    }

    public static CustomTemplate getTemplate(IProject project, String name, String description, String contextId, String code) {
        ArrayList allTemplates = new ArrayList();
        String natureId = TemplatesViewUtils.getNatureFromContextId((String)contextId);
        if (natureId == null || natureId.isEmpty()) {
            return null;
        }
        CustomTemplate customTemplate = new CustomTemplate(new Template(name, description, contextId, code, true), project);
        if (project != null) {
            allTemplates.addAll(TemplatesViewUtils.getProjectTemplates((IProject)project, (String)natureId));
        } else {
            allTemplates.addAll(TemplatesViewUtils.getGlobalTemplates((String)natureId));
        }
        for (Template template : allTemplates) {
            if (!template.equals((Object)customTemplate)) continue;
            return new CustomTemplate(template, project);
        }
        return null;
    }

    public static List<CustomTemplate> getTemplatesWithSpecifiedName(IProject project, String name, String contextId) {
        ArrayList<CustomTemplate> result = new ArrayList<CustomTemplate>();
        ArrayList allTemplates = new ArrayList();
        String natureId = TemplatesViewUtils.getNatureFromContextId((String)contextId);
        if (natureId == null || natureId.isEmpty()) {
            return result;
        }
        if (project != null) {
            allTemplates.addAll(TemplatesViewUtils.getProjectTemplates((IProject)project, (String)natureId));
        } else {
            allTemplates.addAll(TemplatesViewUtils.getGlobalTemplates((String)natureId));
        }
        for (Template template : allTemplates) {
            if (!template.getName().equals(name)) continue;
            result.add(new CustomTemplate(template, project));
        }
        return result;
    }

    public static List<CustomTemplate> getAllCustomTemplates(IProject project, String contextId) {
        ArrayList<CustomTemplate> result = new ArrayList<CustomTemplate>();
        ArrayList allTemplates = new ArrayList();
        String natureId = TemplatesViewUtils.getNatureFromContextId((String)contextId);
        if (natureId == null || natureId.isEmpty()) {
            return result;
        }
        if (project != null) {
            allTemplates.addAll(TemplatesViewUtils.getProjectTemplates((IProject)project, (String)natureId));
        } else {
            allTemplates.addAll(TemplatesViewUtils.getGlobalTemplates((String)natureId));
        }
        for (Template template : allTemplates) {
            if (!(template instanceof CustomTemplate)) continue;
            result.add(new CustomTemplate(template, project));
        }
        return result;
    }

    public static void deleteTemplate(IProject project, CustomTemplate customTemplate) {
        TemplatesViewUtils.deleteTemplate((CustomTemplate)customTemplate);
    }

    public static RfNamedElement getModule(IProject project, String module) {
        RfModule[] mods;
        RfProject rfProj = RfManager.getInstance().getRfProject(project);
        RfModule[] rfModuleArray = mods = rfProj.getAllModules();
        int n = mods.length;
        int n2 = 0;
        while (n2 < n) {
            RfModule mod = rfModuleArray[n2];
            if (module.equals(mod.getName())) {
                return mod;
            }
            ++n2;
        }
        return null;
    }

    public static String computeNetType(String portDir, String type, String initialNetType, IRfNamedElement port) {
        String netType = "";
        if (!(port instanceof RfPort)) {
            return netType;
        }
        netType = "input".equals(portDir) || "inout".equals(portDir) ? ((RfPort)port).getDefaultNetType(port) : ("output".equals(portDir) ? ("".equals(type) || type == null ? ((RfPort)port).getDefaultNetType(port) : "var") : "");
        return netType;
    }

    public static boolean hasModuleField(IProject project, String module, String signal, String signalType) {
        RfModule mod = (RfModule)TestHelper.getModule(project, module);
        List<? extends IRfNamedElement> signals = mod.getAllSignals();
        for (IRfNamedElement iRfNamedElement : signals) {
            if (!iRfNamedElement.getName().equals(signal)) continue;
            return true;
        }
        return false;
    }

    public static void invokeExtendedChecksBuild(IProject project) {
        DVTMixedLangModelManager.getInstance().notifyBuildListenersExtendedCkecksBuild(project, new ChecksKindWrapper(FullChecksKind.FULL));
    }

    public static Map<RfClass, List<RfFunction>> overrideMethodsGetContext(ITextEditor textEditor) {
        RfClass localClass = OverrideMethodsUtils.INSTANCE.getLocalClass(textEditor, false);
        if (localClass == null) {
            return null;
        }
        return OverrideMethodsUtils.INSTANCE.getOverrideMethodsContext(localClass);
    }

    public static boolean isOverrideMethodsProposal(ICompletionProposal proposal) {
        if (!"RfLazyCompletionProposal".equals(proposal.getClass().getSimpleName())) {
            System.err.println("Wrong proposal type given: " + proposal.getClass().getSimpleName() + "!");
            return false;
        }
        if (!proposal.getDisplayString().startsWith("Override Methods")) {
            System.err.println("Wrong proposal display string: " + proposal.getDisplayString() + "!");
            return false;
        }
        return true;
    }

    public static boolean checkAndInsertMethodOverride(DVTEditor editor, ICompletionProposal proposal, String prefix, List<String> functionNames, boolean onlyVirtual, boolean insertAsExtern) {
        if (!TestHelper.isOverrideMethodsProposal(proposal)) {
            return false;
        }
        RfClass currentClass = OverrideMethodsUtils.INSTANCE.getLocalClass((ITextEditor)editor, true);
        if (currentClass == null) {
            System.err.println("Current class could not be determined!");
            return false;
        }
        Map context = OverrideMethodsUtils.INSTANCE.getOverrideMethodsContext(currentClass);
        ArrayList<RfFunction> functions = new ArrayList<RfFunction>();
        boolean containsConstructor = false;
        for (RfClass clazz : context.keySet()) {
            List<RfFunction> classFunctions = context.get(clazz);
            Collections.sort(classFunctions, functionComparator);
            for (RfFunction rfFunction : classFunctions) {
                if (!functionNames.contains(rfFunction.getName()) || onlyVirtual && !rfFunction.isVirtual()) continue;
                if (rfFunction.isConstructor()) {
                    if (containsConstructor) continue;
                    containsConstructor = true;
                }
                functions.add(rfFunction);
            }
        }
        if (functions == null || functions.size() == 0) {
            return false;
        }
        RfElementPathInProject elementPath = RfElementPath.pathInProject((IRfNamedElement)currentClass);
        List<RfClass> parentsHierarchy = OverrideMethodsUtils.INSTANCE.getRelevantParents(currentClass, context);
        OverrideMethodsUtils.INSTANCE.insertInEditor(elementPath, (ITextEditor)editor, prefix.length(), functions, parentsHierarchy, insertAsExtern);
        return true;
    }

    public static int checkAndInsertGettersAndSetter(DVTEditor editor, ICompletionProposal proposal, String prefix, List<String> functions, boolean shouldGetProposal, boolean fromSource) {
        RfClass currentClass;
        if (!fromSource) {
            if (shouldGetProposal && !proposal.getDisplayString().startsWith("Generate Getters and Setters")) {
                return -1;
            }
            if (!shouldGetProposal && proposal.getDisplayString().startsWith("Generate Getters and Setters")) {
                return -2;
            }
        }
        if ((currentClass = GetterSetterMethodsUtils.getInstance().getLocalClass((ITextEditor)editor, true)) == null) {
            return -3;
        }
        Map<RfField, List<String>> context = GetterSetterMethodsUtils.getInstance().getGetterSetterMethodsContext(currentClass);
        GetterSetterMethodsUtils.getInstance().insertInEditor((ITextEditor)editor, prefix.length(), functions, context);
        editor.doSave(null);
        return 0;
    }

    public static String doubleClick(int dbClickLineNo, int dbClickLineOffset, int refStartLineNo, int refStartOffset, int refEndLineNo, int refEndOffset) {
        int actualEndOffset;
        int actualEndLineNo;
        int actualStartOffset;
        int actualStartLineNo;
        block3: {
            try {
                VlogEditor editor = (VlogEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                int dbClickOffset = TestHelper.getInstance().computeOffset(editor, dbClickLineNo - 1, dbClickLineOffset - 1);
                VlogSourceViewerConfiguration sourceViewerConfiguration = editor.testGetSourceViewerConfiguration();
                ISourceViewer sourceViewer = editor.testGetSourceViewer();
                ITextDoubleClickStrategy doubleClickStrategy = sourceViewerConfiguration.getDoubleClickStrategy(sourceViewer, "__dftl_partition_content_type");
                editor.selectAndReveal(dbClickOffset, 1);
                doubleClickStrategy.doubleClicked((ITextViewer)sourceViewer);
                Point selectedRange = sourceViewer.getSelectedRange();
                actualStartLineNo = document.getLineOfOffset(selectedRange.x) + 1;
                actualStartOffset = selectedRange.x - document.getLineOffset(actualStartLineNo - 1);
                actualEndLineNo = document.getLineOfOffset(selectedRange.x + selectedRange.y) + 1;
                actualEndOffset = selectedRange.x + selectedRange.y - document.getLineOffset(actualEndLineNo - 1);
                int refStartOffsetInDoc = TestHelper.getInstance().computeOffset(editor, refStartLineNo - 1, refStartOffset - 1);
                int refLength = TestHelper.getInstance().computeLengthInDocument(editor, refStartLineNo - 1, refStartOffset - 1, refEndLineNo - 1, refEndOffset - 1);
                if (selectedRange.x != refStartOffsetInDoc || selectedRange.y != refLength) break block3;
                return "";
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        return "Mismatch for double click at  [" + dbClickLineNo + ", " + dbClickLineOffset + "] :\n" + "Selection reference was : start [" + refStartLineNo + ", " + refStartOffset + "], end [" + refEndLineNo + ", " + refEndOffset + "]\n" + "Actual  selection was    : start [" + actualStartLineNo + ", " + actualStartOffset + "], end [" + actualEndLineNo + ", " + actualEndOffset + "]\n";
    }

    public static List<HHWrapper> getUnresolvedHidOperators(List<IDVTElementWrapper> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<HHWrapper> unresolved = new ArrayList<HHWrapper>();
        for (IDVTElementWrapper wrapper : list) {
            Object obj = wrapper.getRfElement();
            if (!(obj instanceof HHWrapper)) {
                return null;
            }
            HHWrapper hhWrapper = (HHWrapper)obj;
            if (!(hhWrapper.getHidObject() instanceof IHidOperator)) {
                return null;
            }
            IHidOperator operator = (IHidOperator)hhWrapper.getHidObject();
            if (HidUtils.isResolved((IHidObject)operator)) continue;
            unresolved.add(hhWrapper);
        }
        return unresolved;
    }

    public static int selectText(int startLineNo, int startLineCol, int endLineNo, int endLineCol) {
        VlogEditor editor = (VlogEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        int startSelOffset = TestHelper.getInstance().computeOffset(editor, startLineNo - 1, startLineCol - 1);
        int endSelOffset = TestHelper.getInstance().computeOffset(editor, endLineNo - 1, endLineCol - 1);
        int selectedTextLength = endSelOffset - startSelOffset;
        editor.selectAndReveal(startSelOffset, selectedTextLength);
        return selectedTextLength;
    }

    public static String[] getValidSearchExtensions() {
        return TextSearchPage.getExtensions();
    }

    public static void executeRefactoringScript(IProject project) {
        ScriptRefactorAction sra = new ScriptRefactorAction();
        sra.testSetProject(project);
        sra.run(null);
    }

    public static void executeRefactoringRename(DVTEditor editor, String name) {
        ro.amiq.dvt.test.TestHelper.getInstance().setRefactoringText(name);
        VlogRenameRefactorAction rra = new VlogRenameRefactorAction(VlogEditorMessages.getResourceBundle(), "RefactorRename.", editor);
        rra.run();
    }

    public static void executeFieldEditor(int line, int column) {
        try {
            VlogEditor editor = (VlogEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            int offset = document.getLineOffset(--line) + --column;
            editor.setCursor(offset);
            FieldEditorAction fieldAction = new FieldEditorAction(VlogEditorMessages.getResourceBundle(), "UVMFieldEditor", (ITextEditor)editor, false);
            fieldAction.run();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public static void setRefactorXmlPath(String refactorXmlPath) {
        fRefactorXmlPath = refactorXmlPath;
    }

    public static String doCopyHierarchyPathAction(String father, String port_name) throws Exception {
        VerificationHierarchyView vhView = (VerificationHierarchyView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("ro.amiq.dvt.ui.views.VerificationHierarchyView");
        VerificationHierarchyPortsView portsView = vhView.testHelpGetPortsView();
        LazyVerificationHierarchyTestUtils lazyTreeTestUtils = vhView.getLazyTreeTestUtils();
        lazyTreeTestUtils.search(father);
        lazyTreeTestUtils.selectInLazyTree(father, 0);
        Object selectedTreePath = portsView.getSelectedPath();
        IDVTElementWrapper element = TestHelper.selectVerificationHierarchyPortByName(port_name);
        portsView.doCopyHierarchyWirePathAction(element, selectedTreePath);
        lazyTreeTestUtils.resetSearch();
        return Utils.pasteFromClipboard();
    }

    public static void selectVerificationHierarchyTreeItemByName(String father) {
        if (father == null) {
            return;
        }
        TreeItem[] rootList = TestHelper.getVerificationHierarchyTreeItems();
        TreeItem root = rootList[0];
        LinkedList<TreeItem> q = new LinkedList<TreeItem>();
        q.push(root);
        while (!q.isEmpty()) {
            TreeItem w = (TreeItem)q.pop();
            if (w == null) continue;
            if (father.equals(w.getText())) {
                TestHelper.selectVerificationHierarchyTreeItem((TreeItem)w);
                return;
            }
            TreeItem[] children = w.getItems();
            if (children == null) continue;
            q.addAll(Arrays.asList(children));
        }
        throw new IllegalStateException("Can't find \u201c" + father + "\u201d in Verification Hierarchy View tree");
    }

    public static IDVTElementWrapper selectVerificationHierarchyPortByName(String name) {
        for (Object obj : TestHelper.getVerificationHierarchyPorts()) {
            RfXvmPort port;
            RfTreeElementWrapper rfTree;
            if (!(obj instanceof RfTreeElementWrapper) || !((rfTree = (RfTreeElementWrapper)((Object)obj)).getRfElement() instanceof RfXvmPort) || !name.equals((port = (RfXvmPort)rfTree.getRfElement()).getName())) continue;
            return rfTree;
        }
        throw new IllegalStateException("Can't find port \u201c" + name + "\u201d in the verification hierarchy");
    }

    public ICompletionProposal[] getQuickFixes(int line, int column) {
        try {
            DVTEditor editor = (DVTEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            int offset = this.computeOffset(editor, line, column);
            IQuickAssistProcessor ca = editor.testGetQuickAssistAssistant().getQuickAssistProcessor();
            return ca.computeQuickAssistProposals((IQuickAssistInvocationContext)new TextInvocationContext(editor.testGetSourceViewer(), offset, -1));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getNofQuickFixes(int line, int column, boolean resetSelection) {
        ICompletionProposal[] proposals = TestHelper.getQuickFixes(line, column, resetSelection);
        return proposals != null ? proposals.length : 0;
    }

    public static ICompletionProposal[] getQuickFixes(int line, int column, boolean resetSelection) {
        try {
            DVTEditor editor = (DVTEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            int offset = TestHelper.getInstance().computeOffset(editor, line, column);
            if (resetSelection) {
                editor.getStyledText().setSelection(offset);
            }
            IQuickAssistProcessor ca = editor.testGetQuickAssistAssistant().getQuickAssistProcessor();
            return ca.computeQuickAssistProposals((IQuickAssistInvocationContext)new TextInvocationContext(editor.testGetSourceViewer(), offset, -1));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IRfNamedElement getElementAtCursor() {
        return VlogQuickViewersUtil.getInstance().getElementAtExactCursor();
    }

    public static Set<IRfNamedElement> getAllDependencies(List<RfNamedElement> elements) {
        HashSet<IRfNamedElement> alldependencies = new HashSet<IRfNamedElement>();
        if (elements == null || elements.isEmpty()) {
            return alldependencies;
        }
        for (RfNamedElement element : elements) {
            alldependencies.addAll(SearchDependencyContainer.getAllDependencies(element, RfManager.getInstance().getRfProject(project), false, false, true, false));
        }
        return alldependencies;
    }

    public static List<IDVTElementWrapper> getViewElements(IDVTLazyView view) {
        if (view instanceof CompileOrderView) {
            ArrayList<IDVTElementWrapper> result = new ArrayList<IDVTElementWrapper>();
            CompileOrderTestUtils lazyTreeTestUtils = ((CompileOrderView)view).getLazyTreeTestUtils();
            for (TreePath path : lazyTreeTestUtils.getViewContent()) {
                if (!(path.getElement() instanceof IDVTElementWrapper)) continue;
                result.add((IDVTElementWrapper)path.getElement());
            }
            return result;
        }
        return null;
    }

    public static List<String> execute(String projectName, String packageName, String className, String functionName) {
        return TestHelper.execute(projectName, false, packageName, className, functionName, null, false);
    }

    public static List<String> execute(String projectName, boolean disableNullChecks, String packageName, String className, String functionName, List<String> argv, boolean uvm) {
        RfProject rfProject = TestHelper.getProject(projectName);
        RfLibrary rfLibrary = rfProject.getLibraryWithPrefix("work", 1);
        ELManager elManager = XUtils.getNonElabManager((RfMixedLangProject)rfProject.getMixedLangProjectParent());
        RfLibrary classScope = rfLibrary;
        if (packageName != null && !packageName.isEmpty()) {
            classScope = classScope.getPackageWithPrefix(packageName, 1);
        }
        RfLibrary methodScope = classScope;
        if (className != null && !className.isEmpty()) {
            methodScope = methodScope.getLocalMember(Collections.singleton(RfClass.class), className, null);
        }
        RfFunction rfFunction = (RfFunction)methodScope.getLocalMember(Collections.singleton(RfFunction.class), functionName, null);
        TestHelper.delay((long)200L);
        List<String> errorsList = Collections.synchronizedList(new ArrayList());
        ArrayList<String> newArgv = new ArrayList<String>();
        newArgv.add("+dvt_test_mode");
        if (argv != null) {
            newArgv.addAll(argv);
        }
        Thread thread = new Thread(() -> {
            XSimVlog xSim = new XSimVlog(rfProject.getMixedLangProjectParent(), IXSim.XSimMode.UVM_RUNTIME_ELAB, elManager, false, (IProgressMonitor)new NullProgressMonitor());
            xSim.setCommandLineArguments(newArgv);
            if (disableNullChecks) {
                xSim.setDisableNullChecks();
            }
            xSim.execute(rfFunction, "initial", XThreadDefinition.ThreadKind.INITIAL);
            errorsList.addAll(xSim.getErrors());
        });
        thread.start();
        try {
            Display display = Display.getCurrent();
            if (display == null) {
                thread.join();
                return errorsList;
            }
            TestHelper.delay((long)100L);
            while (!display.readAndDispatch() || thread.getState() != Thread.State.TERMINATED) {
                display.sleep();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return errorsList;
    }

    public static void executeDPICDebugger(List<String> argv, boolean uvm) {
        String projectName = project.getName();
        RfProject rfProject = TestHelper.getProject(projectName);
        ArrayList<String> newArgv = new ArrayList<String>();
        newArgv.add("+dvt_test_mode");
        if (argv != null) {
            newArgv.addAll(argv);
        }
        XSimDebugAction simDebugAction = new XSimDebugAction(null, null, rfProject, newArgv, (IProgressMonitor)new NullProgressMonitor(), false, false);
        simDebugAction.run();
        ObjectionManager.getInstance().waitFor(new Objection[]{Objection.RUN_SIM_STARTED});
    }

    public static List<String> executeSim(String projectName, List<String> argv, boolean uvm) {
        RfProject rfProject = TestHelper.getProject(projectName);
        ELManager elManager = rfProject.getMixedLangProjectParent().getELManager();
        List<String> errorsList = Collections.synchronizedList(new ArrayList());
        ArrayList<String> newArgv = new ArrayList<String>();
        newArgv.add("+dvt_test_mode");
        if (argv != null) {
            newArgv.addAll(argv);
        }
        Thread thread = new Thread(() -> {
            XSimVlog xVlog = new XSimVlog(rfProject.getMixedLangProjectParent(), IXSim.XSimMode.SIMULATOR, elManager, false, (IProgressMonitor)new NullProgressMonitor());
            xVlog.setCommandLineArguments(newArgv);
            StopWatch.reset((String)"[SIM] total").start();
            xVlog.execute(null, null, XThreadDefinition.ThreadKind.NONE);
            StopWatch.stop((String)"[SIM] total");
            errorsList.addAll(xVlog.getErrors());
        });
        thread.start();
        try {
            Display display = Display.getCurrent();
            if (display == null) {
                thread.join();
                return errorsList;
            }
            TestHelper.delay((long)100L);
            while (!display.readAndDispatch() || thread.getState() != Thread.State.TERMINATED) {
                display.sleep();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return errorsList;
    }

    public static void startSimDebugger(String projectName, DVTEditor editor) {
        XSimDebugAction action = new XSimDebugAction(VlogEditorMessages.getResourceBundle(), "DebugBuildPhaseTest", (ITextEditor)editor);
        action.run();
        ObjectionManager.getInstance().waitFor(new Objection[]{Objection.RUN_SIM_STARTED});
    }

    public static class Identifier {
        private String text;
        private String filename;
        private int line;
        private int column;

        public Identifier(Token token) {
            this.text = token.getText();
            this.line = token.getLine();
            this.column = token.getColumn();
            this.filename = token.getFilename();
        }

        public String getFilename() {
            return this.filename;
        }

        public String getText() {
            return this.text;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }
}

