/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.HighlightKind;
import ro.amiq.dvt.ui.preferences.DVTPreviewSourceViewer;
import ro.amiq.dvt.ui.preferences.OverlayPreferenceStore;
import ro.amiq.dvt.ui.preferences.theme.IThemePreviewContributor;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.ui.editor.VlogDocumentSetupParticipant;
import ro.amiq.vlogdt.ui.editor.VlogSourceViewerConfiguration;
import ro.amiq.vlogdt.ui.editor.VlogStyle;
import ro.amiq.vlogdt.ui.preferences.VlogSourcePreviewerUpdater;

public class VlogThemePreviewContributor
implements IThemePreviewContributor {
    private DVTPreviewSourceViewer fPreviewViewer;
    private IPreferenceStore fPluginStore = VlogPlugin.getDefault().getPreferenceStore();
    private OverlayPreferenceStore fOverlayStore = new OverlayPreferenceStore(VlogPlugin.getDefault().getCombinedPreferenceStore(), this.createOverlayStoreKeys());
    private Control previewControl;

    public Control createLanguagePreviewer(Composite parent) {
        VlogSourceViewerConfiguration configuration = new VlogSourceViewerConfiguration(null, false);
        this.fPreviewViewer = new DVTPreviewSourceViewer(parent, 2560);
        this.fPreviewViewer.setPreferenceStore(VlogPlugin.getDefault().getCombinedPreferenceStore());
        this.fPreviewViewer.configure((SourceViewerConfiguration)configuration);
        this.fPreviewViewer.getTextWidget().setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont"));
        this.fPreviewViewer.setEditable(false);
        String content = this.loadPreviewContentFromFile("ColorSettingsPreviewCode.v");
        Document document = new Document(content);
        VlogDocumentSetupParticipant docSetup = new VlogDocumentSetupParticipant();
        docSetup.setup((IDocument)document);
        this.fPreviewViewer.setDocument((IDocument)document);
        VlogSourcePreviewerUpdater.registerPreviewer((SourceViewer)this.fPreviewViewer, configuration, (IPreferenceStore)this.fOverlayStore);
        this.addAllSemanticPositions((IDocument)document);
        this.previewControl = this.fPreviewViewer.getControl();
        return this.previewControl;
    }

    protected OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic.value"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.template_id.value"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.x_template_id.value"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.default.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.default.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.default.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment_task.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_task.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_task.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment_pragma.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_pragma.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_pragma.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.javadoc_tags.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.javadoc_tags.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.javadoc_tags.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.keyword.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.keyword.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.keyword.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.preproc.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.preproc.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.preproc.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.ovm_macro.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.ovm_macro.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.ovm_macro.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.macro.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.macro.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.macro.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.method.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.method.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.method.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.parameterized_elem.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.parameterized_elem.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.parameterized_elem.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.comment_hyperlink.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_hyperlink.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.comment_hyperlink.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.system_task.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.system_task.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.system_task.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.escaped_id.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.escaped_id.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.escaped_id.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.number.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.number.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.number.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.string.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.string.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.string.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.template_id.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.template_id.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.template_id.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.label.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.label.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.label.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.end_label.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.end_label.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.end_label.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_port.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_port.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_port.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_out_port.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_out_port.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_out_port.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_constant.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_constant.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_constant.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_types.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_types.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_types.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_static_member.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_static_member.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_static_member.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_static_method.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_static_method.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_static_method.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_field.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_field.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_field.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_argument.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_argument.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_argument.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_variable.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_variable.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_variable.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_event.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_event.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_event.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_constraint.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_constraint.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_constraint.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_object_field.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_object_field.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_object_field.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_uvm_object_field.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_uvm_object_field.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_uvm_object_field.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_object_variable.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_object_variable.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_object_variable.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_uvm_object_variable.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_uvm_object_variable.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_uvm_object_variable.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_object_argument.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_object_argument.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_object_argument.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_uvm_object_argument.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_uvm_object_argument.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_uvm_object_argument.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_static_object_member.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_static_object_member.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_static_object_member.italic"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "highlight.semantic_uvm_static_object_member.color"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_uvm_static_object_member.bold"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "highlight.semantic_uvm_static_object_member.italic"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return keys;
    }

    private String loadPreviewContentFromFile(String filename) {
        StringBuilder buffer;
        block15: {
            buffer = new StringBuilder(512);
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(filename)));
                    while ((line = reader.readLine()) != null) {
                        buffer.append(line);
                        buffer.append("\n");
                    }
                }
                catch (IOException io) {
                    DVTLogger.INSTANCE.logError((Throwable)io);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buffer.toString();
    }

    private void addAllSemanticPositions(IDocument document) {
        try {
            if (!document.containsPositionCategory("SEMANTIC_HIGHLIGHT")) {
                document.addPositionCategory("SEMANTIC_HIGHLIGHT");
            } else {
                document.removePositionCategory("SEMANTIC_HIGHLIGHT");
                document.addPositionCategory("SEMANTIC_HIGHLIGHT");
            }
            HashMap positions = new HashMap();
            DVTHlUtils.addPosition((IDocument)document, (int)48, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)55, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)63, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)70, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)42, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)85, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)103, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)116, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)129, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)125, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)318, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)211, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)230, (HighlightKind)HighlightKind.EVENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)224, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)247, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)243, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)266, (HighlightKind)HighlightKind.STATIC_CLASS_MEMBER, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)262, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)291, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)287, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)335, (HighlightKind)HighlightKind.SV_OBJECT_FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)305, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)330, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)369, (HighlightKind)HighlightKind.SV_STATIC_OBJECT_VARIABLES, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)357, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)673, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)789, (HighlightKind)HighlightKind.STATIC_METHOD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)696, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)581, (HighlightKind)HighlightKind.METHOD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)576, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)599, (HighlightKind)HighlightKind.ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)595, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)629, (HighlightKind)HighlightKind.SV_OBJECT_ARGUMENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)618, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)656, (HighlightKind)HighlightKind.VARIABLE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)649, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)713, (HighlightKind)HighlightKind.SV_OBJECT_VARIABLE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)683, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)708, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)749, (HighlightKind)HighlightKind.STATIC_CLASS_MEMBER, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)745, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)901, (HighlightKind)HighlightKind.EVENT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)845, (HighlightKind)HighlightKind.METHOD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)966, (HighlightKind)HighlightKind.METHOD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)945, (HighlightKind)HighlightKind.STATIC_METHOD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)940, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1016, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1034, (HighlightKind)HighlightKind.PORT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1050, (HighlightKind)HighlightKind.OUT_PORT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1082, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1062, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1079, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1197, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1154, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1181, (HighlightKind)HighlightKind.CONSTANT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1210, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1190, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1226, (HighlightKind)HighlightKind.FIELD, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1220, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1244, (HighlightKind)HighlightKind.TYPE, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1263, (HighlightKind)HighlightKind.PORT, positions);
            DVTHlUtils.addPosition((IDocument)document, (int)1279, (HighlightKind)HighlightKind.OUT_PORT, positions);
            DVTHlUtils.addPositionsToDocument((IDocument)document, positions.values());
            DVTHlUtils.notifyListeners((IDocument)document, null);
            this.fPreviewViewer.invalidateTextPresentation();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public String getLanguage() {
        return "SystemVerilog";
    }

    public OverlayPreferenceStore getOverlayPreferenceStore() {
        return this.fOverlayStore;
    }

    public IPreferenceStore getPluginPreferenceStore() {
        return this.fPluginStore;
    }

    public String getPluginId() {
        return "ro.amiq.vlogdt";
    }

    public void cancelPreview() {
        VlogStyle.getInstance().updateTokens();
    }

    public Integer getPreviewOrderId() {
        return 0;
    }

    public void updateBackground(Color color) {
        if (this.fPreviewViewer == null) {
            return;
        }
        if (this.fPreviewViewer.getTextWidget() == null) {
            return;
        }
        DVTColorUtil.INSTANCE.setBackground((Control)this.fPreviewViewer.getTextWidget(), color, true);
    }

    public Control getPreviewControl() {
        return this.previewControl;
    }
}

