/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.ui.refactor.DVTRefactoringProcessor;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.connect.TextChange;
import ro.amiq.dvt.ui.refactor.rename.DVTCompositeChange;
import ro.amiq.vlogdt.ui.actions.DVTCollapseMacrosInfo;

public class DVTCollapseMacrosProcessor
extends DVTRefactoringProcessor {
    private DVTCollapseMacrosInfo collapseMacrosInfo;
    private List<DVTTextFileChange> edits;
    private List<Integer> ignoredDiffOffsets;
    private boolean isCancelled;

    public DVTCollapseMacrosProcessor(DVTCollapseMacrosInfo macrosInfo) {
        this.collapseMacrosInfo = macrosInfo;
        this.edits = new ArrayList<DVTTextFileChange>();
        this.ignoredDiffOffsets = new ArrayList<Integer>();
    }

    public String getProcessorName() {
        return "Collapse Macro Differences";
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        String rootChangeName = this.getRootChangeName();
        DVTCompositeChange baseChange = new DVTCompositeChange(rootChangeName);
        List<TextChange> differences = this.collapseMacrosInfo.getDifferences();
        for (TextChange textDifference : differences) {
            DVTTextFileChange textEdit = this.createTextEdit(this.collapseMacrosInfo.getFile(), (CompositeChange)baseChange);
            this.addEdit(textEdit, textDifference, (IRegion)new Region(0, textDifference.length));
        }
        return baseChange;
    }

    protected void addEdit(DVTTextFileChange textFileChange, TextChange textDifference, IRegion track) {
        ReplaceEdit replaceEdit = new ReplaceEdit(textDifference.offset, textDifference.length, textDifference.text);
        textFileChange.addEdit((TextEdit)replaceEdit, track);
        this.edits.add(textFileChange);
    }

    public DVTTextFileChange createTextEdit(IFile file, CompositeChange rootChange) {
        DVTTextFileChange textFileChange = new DVTTextFileChange(file.getName(), file);
        textFileChange.setEdit((TextEdit)new MultiTextEdit());
        rootChange.add((Change)textFileChange);
        return textFileChange;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return new RefactoringParticipant[0];
    }

    private String getRootChangeName() {
        return this.getProcessorName();
    }

    public DVTCollapseMacrosInfo getMacrosInfo() {
        return this.collapseMacrosInfo;
    }

    public List<Integer> getIgnoredDiffOffsets() {
        return this.ignoredDiffOffsets;
    }

    public void updateModificationsList() {
        int i = 0;
        while (i < this.edits.size()) {
            DVTTextFileChange dvtTextFileChange = this.edits.get(i);
            if (!dvtTextFileChange.isEnabled() && dvtTextFileChange.getEdit() != null) {
                this.ignoredDiffOffsets.add(this.getActualOffset(dvtTextFileChange));
            }
            dvtTextFileChange.setEnabled(false);
            ++i;
        }
    }

    public void cancelAllModifications() {
        this.isCancelled = true;
    }

    private int getActualOffset(DVTTextFileChange textFileChange) {
        return textFileChange.getEdit().getOffset() - 1;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public Object[] getElements() {
        return null;
    }

    public String getIdentifier() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }
}

