/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.actions;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTJobsUtils;
import ro.amiq.vlogdt.model.IVlogModule;
import ro.amiq.vlogdt.model.VlogModelManager;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FEConstants;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FEUtils;
import ro.amiq.vlogdt.model.reflection.ovm.fieldeditor.FieldEditor;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;

public class FieldEditorAction
extends TextEditorAction {
    private boolean deprecatedShortcutUsed;
    private static boolean disableForSession;
    private Shell fTestShell;

    public FieldEditorAction(ResourceBundle bundle, String prefix, ITextEditor editor, boolean deprecatedShortcutUsed) {
        super(bundle, prefix, editor);
        this.deprecatedShortcutUsed = deprecatedShortcutUsed;
    }

    public void run() {
        try {
            IBindingService bindingService;
            TriggerSequence[] binding;
            RfProject rfProject;
            IEditorInput editorInput = this.getTextEditor().getEditorInput();
            if (editorInput == null) {
                return;
            }
            IFile file = (IFile)editorInput.getAdapter(IFile.class);
            if (file == null) {
                return;
            }
            IProject project = file.getProject();
            if (project == null) {
                return;
            }
            final IDocument document = this.getDocument(this.getTextEditor());
            if (document == null) {
                return;
            }
            final IVlogModule vlogModule = VlogModelManager.getInstance().getVlogModel().getOrCreateVlogModule((IFile)this.getTextEditor().getAdapter(IResource.class));
            if (vlogModule == null) {
                return;
            }
            if (vlogModule.isDirty()) {
                DVTJobsUtils.runWithBusyIndicator((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        vlogModule.scheduleReparse(true, true, 0L, document, true);
                    }
                });
            }
            if ((rfProject = RfManager.getInstance().getRfProject(project)) == null) {
                return;
            }
            int offset = ((DVTEditor)this.getTextEditor()).getCursor();
            RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(rfProject, this.getTextEditor(), document, offset);
            if (namedElementAndScope == null) {
                return;
            }
            RfNamedElement namedElement = namedElementAndScope.getNamedElement();
            IRfScopeElement scope = namedElementAndScope.getScope();
            RfClass clazz = FEUtils.getEnclosingClass(scope);
            if (clazz == null) {
                if (TestHelper.isTestMode()) {
                    DVTLogger.INSTANCE.logError("Please place the cursor inside the class you want to use with Field Editor.");
                } else {
                    FEUtils.showError(this.getTextEditor().getSite().getShell(), "Field Editor", "Please place the cursor inside the class you want to use with Field Editor.");
                }
                return;
            }
            if (this.deprecatedShortcutUsed && !disableForSession && (binding = (bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class)).getActiveBindingsFor("ro.amiq.vlogdt.ui.editor.UVMFieldEditor")).length == 1) {
                MessageDialog dialog = new MessageDialog(this.getTextEditor().getSite().getShell(), "Field Editor", null, "The shortcut you used is deprecated, please use " + binding[0].format(), 4, new String[]{IDialogConstants.OK_LABEL}, 0){
                    public Button dontShowAgain;

                    protected Control createMessageArea(Composite composite) {
                        Image image = this.getImage();
                        if (image != null) {
                            this.imageLabel = new Label(composite, 0);
                            image.setBackground(this.imageLabel.getBackground());
                            this.imageLabel.setImage(image);
                            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
                        }
                        Composite wrapper = new Composite(composite, 0);
                        wrapper.setLayout((Layout)new RowLayout());
                        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)wrapper);
                        if (this.message != null) {
                            this.messageLabel = new Label(wrapper, this.getMessageLabelStyle());
                            this.messageLabel.setText(this.message);
                        }
                        this.dontShowAgain = new Button(wrapper, 32);
                        this.dontShowAgain.setText("Don't show me this message again during this session");
                        return composite;
                    }

                    protected void buttonPressed(int buttonId) {
                        if (buttonId == 0 && this.dontShowAgain.getSelection()) {
                            disableForSession = true;
                        }
                        super.buttonPressed(buttonId);
                    }
                };
                dialog.open();
            }
            if (namedElement instanceof RfField && ((RfField)namedElement).getEnclosingScope() == clazz) {
                this.openEditor(rfProject, clazz, (RfField)namedElement, offset);
            } else {
                this.openEditor(rfProject, clazz, null, offset);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void openEditor(RfProject rfProject, RfClass clazz, RfField field, int offset) throws BadLocationException {
        Shell shell = this.getTextEditor().getSite().getShell();
        if (shell == null) {
            return;
        }
        FEConstants constants = null;
        if (clazz.isSubClass("uvm_void", true)) {
            constants = FEConstants.getInstance(1);
        } else if (clazz.isSubClass("ovm_void", true)) {
            constants = FEConstants.getInstance(0);
        } else {
            FEUtils.showError(this.getTextEditor().getSite().getShell(), "Field Editor", "The enclosing class must extend a class from the OVM/UVM library!");
            return;
        }
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            return;
        }
        FieldEditor fieldEditor = new FieldEditor(shell, this.getDocument(this.getTextEditor()), textEditor, offset, rfProject, clazz, field, constants);
        if (!TestHelper.isTestMode()) {
            fieldEditor.open();
        } else {
            this.testApplyFieldEditor(fieldEditor);
        }
    }

    private void testApplyFieldEditor(final FieldEditor fieldEditor) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    fieldEditor.open();
                }
                catch (BadLocationException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        };
        new Thread(new Runnable(){
            private volatile boolean finished = false;

            @Override
            public void run() {
                while (!this.finished) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell[] shells;
                            Shell[] shellArray = shells = Display.getDefault().getShells();
                            int n = shells.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Shell shell = shellArray[n2];
                                if (shell.getText().equals("UVM Field Editor ")) {
                                    (this).FieldEditorAction.this.fTestShell = shell;
                                }
                                ++n2;
                            }
                            if ((this).FieldEditorAction.this.fTestShell != null) {
                                Control[] children = (this).FieldEditorAction.this.fTestShell.getChildren();
                                LinkedList<Control> childrenList = new LinkedList<Control>();
                                childrenList.addAll(Arrays.asList(children));
                                Button ok = null;
                                Button selectAll = null;
                                if (children.length > 0) {
                                    while (!childrenList.isEmpty()) {
                                        Object top = childrenList.poll();
                                        if (top instanceof Table) {
                                            childrenList.addAll(Arrays.asList(((Table)top).getChildren()));
                                            TableItem[] tableItemArray = ((Table)top).getItems();
                                            int n3 = tableItemArray.length;
                                            int n4 = 0;
                                            while (n4 < n3) {
                                                TableItem obj = tableItemArray[n4];
                                                obj.setChecked(true);
                                                ++n4;
                                            }
                                            ((Table)top).notifyListeners(13, new Event());
                                            continue;
                                        }
                                        if (top instanceof Composite) {
                                            childrenList.addAll(Arrays.asList(((Composite)top).getChildren()));
                                            continue;
                                        }
                                        if (!(top instanceof Button)) continue;
                                        Button b = (Button)top;
                                        if (b.getText().equals("OK")) {
                                            ok = b;
                                        }
                                        if (!b.getText().equals("Select all")) continue;
                                        selectAll = b;
                                    }
                                    if (selectAll != null) {
                                        selectAll.notifyListeners(13, new Event());
                                    }
                                    if (ok != null) {
                                        ok.notifyListeners(13, new Event());
                                    }
                                    finished = true;
                                }
                            }
                        }
                    });
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }).start();
        Display.getDefault().syncExec(r);
    }

    private IDocument getDocument(ITextEditor _editor) {
        if (_editor == null) {
            return null;
        }
        IDocumentProvider documentProvider = _editor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IEditorInput editorInput = _editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        return documentProvider.getDocument((Object)editorInput);
    }
}

