/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.actions;

import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.buildconfig.NothingToCompileDialog;
import ro.amiq.vlogdt.ui.actions.DVTCollapseMacrosInfo;
import ro.amiq.vlogdt.ui.actions.DVTCollapseMacrosProcessor;
import ro.amiq.vlogdt.ui.actions.DVTCollapseMacrosRefactoring;
import ro.amiq.vlogdt.ui.actions.DVTCollapseMacrosWizard;
import ro.amiq.vlogdt.ui.actions.MacroCollapseAllInlineExpansionsActionCommon;
import ro.amiq.vlogdt.ui.actions.MacroExpandAction;
import ro.amiq.vlogdt.ui.macroexpansion.MacroExpansionScanner;

public class MacroCollapseAllInlineExpansionsAction
extends MacroCollapseAllInlineExpansionsActionCommon {
    private Display display;
    private IFile file;

    public MacroCollapseAllInlineExpansionsAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        this.setDisplay();
        this.setFile();
    }

    private void setFile() {
        IEditorInput editorInput = this.getTextEditor().getEditorInput();
        if (editorInput == null) {
            return;
        }
        this.file = (IFile)editorInput.getAdapter(IFile.class);
    }

    private void setDisplay() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        this.display = workbench != null ? workbench.getDisplay() : null;
    }

    @Override
    protected void openNestedExpansionsWarning(List<Integer> lines, ITextEditor textEditor, IDocument document, MacroExpansionScanner expansionScanner, List<MacroExpansionScanner.Expansion> expansions, IProgressMonitor monitor) {
        this.display.asyncExec(() -> MacroExpandAction.showWarning(this.initShell(this.getTextEditor()), "Nested expansions detected", "There are nested expansions inside the expansions beginning at lines: " + lines.toString() + ".\nDo you wish to proceed?").thenAccept(proceed -> {
            if (!proceed.booleanValue()) {
                return;
            }
            this.collapseExpansions(textEditor, document, expansionScanner, expansions, monitor);
        }));
    }

    @Override
    protected void openFaultyExpansionsDialog(List<Integer> lines) {
        this.display.asyncExec(() -> MacroExpandAction.showError(this.initShell(this.getTextEditor()), "Could not perform collapse operation", "The expansions at the following lines could not be collapsed: " + lines.toString() + ".\n\n" + "Please ensure that each expansion contains:\n\n" + "    " + "@DVT_EXPAND_MACRO_INLINE_START" + "\n" + "    " + "@DVT_EXPAND_MACRO_INLINE_ORIGINAL" + "\n" + "    " + "@DVT_EXPAND_MACRO_INLINE_END" + "\n\n" + "Press Ctrl + L to jump to a specific line."));
    }

    @Override
    protected void openDiffDialog() {
        if (this.file == null) {
            return;
        }
        this.display.asyncExec(() -> {
            DVTCollapseMacrosProcessor processor = new DVTCollapseMacrosProcessor(new DVTCollapseMacrosInfo(this.macroExpansionDifferences, this.file));
            DVTCollapseMacrosRefactoring refactoring = new DVTCollapseMacrosRefactoring(processor);
            DVTCollapseMacrosWizard wizard = new DVTCollapseMacrosWizard((Refactoring)refactoring);
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            try {
                try {
                    op.run(this.initShell(this.getTextEditor()), "");
                }
                catch (InterruptedException interruptedException) {
                    this.removeIgnoredModifications(processor);
                    this.macroExpansionDifferences.clear();
                    this.performChanges();
                }
            }
            finally {
                this.removeIgnoredModifications(processor);
                this.macroExpansionDifferences.clear();
                this.performChanges();
            }
        });
    }

    private void removeIgnoredModifications(DVTCollapseMacrosProcessor processor) {
        if (processor.isCancelled()) {
            this.modifications.clear();
        }
        List<Integer> ignoredDifOffsets = processor.getIgnoredDiffOffsets();
        int i = 0;
        while (i < ignoredDifOffsets.size()) {
            this.modifications.remove(ignoredDifOffsets.get(i));
            ++i;
        }
    }

    @Override
    protected void displayNoFileCompiled(Display display, IProject project) {
        display.asyncExec(() -> NothingToCompileDialog.openWarning((IProject)project));
    }

    @Override
    protected Shell initShell(ITextEditor textEditor) {
        if (textEditor == null) {
            return null;
        }
        return textEditor.getSite().getShell();
    }

    @Override
    protected boolean checkIfValidShell(Shell shell) {
        return shell != null;
    }

    @Override
    protected void collapseMacro(Display display, String modifiedMacro, String originalMacro, String originalCall, IDocument document, String lineDelimiter, MacroExpansionScanner.Expansion expansion) {
        this.macroCollapseAction(modifiedMacro, originalMacro, originalCall, document, lineDelimiter, expansion);
    }

    @Override
    protected IDocument getDocument(ITextEditor textEditor) {
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        return documentProvider.getDocument((Object)textEditor.getEditorInput());
    }

    @Override
    protected void replaceInDocument(IDocument document, int offset, int length, String replacement) {
        if (document == null) {
            return;
        }
        try {
            document.replace(offset, length, replacement);
            ((DVTEditor)this.getTextEditor()).selectAndReveal(this.currentCursorOffset, 0);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected void handleNoExpansionsDetected() {
        this.display.asyncExec(() -> MacroExpandAction.showError(this.initShell(this.getTextEditor()), "No expansions detected", "There are no macro expansions in file!"));
    }

    @Override
    protected void performChanges() {
        this.display.asyncExec(() -> super.performChanges());
    }

    @Override
    protected CompletableFuture<Boolean> showCompareDialog(String modifiedMacro, String originalMacro) {
        return null;
    }

    @Override
    protected int getCursor() {
        ITextEditor editor = this.getTextEditor();
        if (!(editor instanceof DVTEditor)) {
            return -1;
        }
        return ((DVTEditor)editor).getCursor();
    }
}

