/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.refactor.connect.TextChange;
import ro.amiq.vlogdt.ui.actions.MacroCollapseInlineExpansionActionCommon;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.macroexpansion.MacroExpansionScanner;

public abstract class MacroCollapseAllInlineExpansionsActionCommon
extends MacroCollapseInlineExpansionActionCommon {
    private static final int COLLAPSE_PADDING = 4;
    protected TreeMap<Integer, TextChange> modifications = new TreeMap(Collections.reverseOrder());
    protected List<TextChange> macroExpansionDifferences = new ArrayList<TextChange>();
    protected static final String START_PRAGMA = "@DVT_EXPAND_MACRO_INLINE_START";
    protected static final String ORIGINAL_PRAGMA = "@DVT_EXPAND_MACRO_INLINE_ORIGINAL";
    protected static final String END_PRAGMA = "@DVT_EXPAND_MACRO_INLINE_END";
    protected int currentCursorOffset;

    protected MacroCollapseAllInlineExpansionsActionCommon(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor, false);
    }

    @Override
    public void run() {
        this.modifications.clear();
        this.macroExpansionDifferences.clear();
        Job computeReplacementJob = new Job("Macro collapse"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                monitor.beginTask("Macro collapse", -1);
                MacroCollapseAllInlineExpansionsActionCommon.this.doReplacement(MacroCollapseAllInlineExpansionsActionCommon.this.getTextEditor(), monitor);
                if (monitor.isCanceled()) {
                    status = Status.CANCEL_STATUS;
                    MacroCollapseAllInlineExpansionsActionCommon.this.modifications.clear();
                    MacroCollapseAllInlineExpansionsActionCommon.this.macroExpansionDifferences.clear();
                }
                return status;
            }
        };
        computeReplacementJob.setUser(true);
        computeReplacementJob.schedule();
    }

    public void doReplacement(ITextEditor textEditor, IProgressMonitor monitor) {
        if (textEditor == null) {
            return;
        }
        Shell shell = this.initShell(textEditor);
        if (!this.checkIfValidShell(shell)) {
            return;
        }
        IDocument document = this.getDocument(textEditor);
        if (document == null) {
            return;
        }
        if (!(textEditor instanceof VlogEditor)) {
            return;
        }
        ArrayList<MacroExpansionScanner.Expansion> expansions = new ArrayList<MacroExpansionScanner.Expansion>();
        ArrayList<MacroExpansionScanner.Expansion> faultyExpansions = new ArrayList<MacroExpansionScanner.Expansion>();
        MacroExpansionScanner expansionScanner = MacroExpansionScanner.INSTANCE;
        AtomicBoolean hasNestedExpansions = new AtomicBoolean();
        expansionScanner.collectExpansionsForCollapseAll(document, expansions, faultyExpansions, hasNestedExpansions);
        if (!faultyExpansions.isEmpty()) {
            this.handleFaultyExpansions(document, faultyExpansions);
            return;
        }
        if (expansions.isEmpty()) {
            this.handleNoExpansionsDetected();
            return;
        }
        if (hasNestedExpansions.get()) {
            this.handleNestedExpansions(textEditor, document, expansions, expansionScanner, monitor);
            return;
        }
        this.collapseExpansions(textEditor, document, expansionScanner, expansions, monitor);
    }

    protected void handleFaultyExpansions(IDocument document, List<MacroExpansionScanner.Expansion> faultyExpansions) {
        try {
            ArrayList<Integer> lines = new ArrayList<Integer>();
            for (MacroExpansionScanner.Expansion expansion : faultyExpansions) {
                int startOffset = expansion.getStartOffset() + 4;
                lines.add(document.getLineOfOffset(startOffset) + 1);
            }
            lines.sort(Comparator.naturalOrder());
            this.openFaultyExpansionsDialog(lines);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected void handleMacroDiff(String originalCall, IDocument document, MacroExpansionScanner.Expansion expansion, String newModifiedMacro, String newOriginalMacro) {
        int startOffset = expansion.getStartOffset();
        int endOffset = expansion.getEndOffset();
        if (startOffset >= document.getLength() || endOffset - startOffset <= 0) {
            return;
        }
        this.macroExpansionDifferences.add(new TextChange(null, startOffset + 1, endOffset - startOffset - 1, newOriginalMacro));
        this.handleReplacement(document, startOffset, endOffset - startOffset, originalCall);
    }

    @Override
    protected void handleReplacement(IDocument document, int startOffset, int length, String originalCall) {
        this.modifications.put(startOffset, new TextChange(null, startOffset, length, originalCall));
    }

    private void handleNestedExpansions(ITextEditor textEditor, IDocument document, List<MacroExpansionScanner.Expansion> expansions, MacroExpansionScanner expansionScanner, IProgressMonitor monitor) {
        try {
            ArrayList<Integer> lines = new ArrayList<Integer>();
            int i = 0;
            while (i < expansions.size()) {
                if (expansions.get(i).isNested()) {
                    int startOffset = expansions.get(i).getStartOffset() + 4;
                    lines.add(document.getLineOfOffset(startOffset) + 1);
                }
                ++i;
            }
            lines.sort(Comparator.naturalOrder());
            this.openNestedExpansionsWarning(lines, textEditor, document, expansionScanner, expansions, monitor);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected void collapseExpansions(ITextEditor textEditor, IDocument document, MacroExpansionScanner expansionScanner, List<MacroExpansionScanner.Expansion> expansions, IProgressMonitor monitor) {
        try {
            expansions.removeIf(e -> e.isInsideNested());
            int i = 0;
            while (i < expansions.size()) {
                MacroExpansionScanner.Expansion expansion = expansions.get(i);
                int startPragmaOffset = expansion.getStartOffset() + 4;
                this.collapseMacroWrapper(textEditor, startPragmaOffset, document, expansionScanner, expansion);
                if (monitor.isCanceled()) {
                    return;
                }
                ++i;
            }
            if (!this.macroExpansionDifferences.isEmpty()) {
                this.openDiffDialog();
                return;
            }
            this.performChanges();
        }
        catch (Exception e2) {
            DVTLogger.INSTANCE.logError((Throwable)e2);
        }
    }

    protected void performChanges() {
        Map.Entry<Integer, TextChange> entry;
        if (this.modifications.isEmpty()) {
            return;
        }
        this.currentCursorOffset = this.getCursor();
        int offsetDiff = 0;
        IDocument document = this.getDocument(this.getTextEditor());
        StringBuilder documentContent = new StringBuilder(document.get());
        while ((entry = this.modifications.pollFirstEntry()) != null) {
            TextChange textChange = entry.getValue();
            if (textChange.offset <= this.currentCursorOffset) {
                if (this.currentCursorOffset <= textChange.offset + textChange.length) {
                    offsetDiff += this.currentCursorOffset - textChange.offset;
                } else {
                    offsetDiff += textChange.length;
                    offsetDiff -= textChange.text.length();
                }
            }
            documentContent.replace(textChange.offset, textChange.offset + textChange.length, textChange.text);
        }
        this.currentCursorOffset -= offsetDiff;
        this.replaceInDocument(document, 0, document.getLength(), documentContent.toString());
    }

    @Override
    protected void collapseNormalMacroWrapper(MacroCollapseInlineExpansionActionCommon.ExpandParams expandParams, MacroExpansionScanner.Expansion expansion, String originalCall) {
        try {
            this.collapseNormalMacro(expandParams, expansion, originalCall, null);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected void collapseNestedMacroWrapper(MacroCollapseInlineExpansionActionCommon.ExpandParams expandParams, MacroExpansionScanner.Expansion expansion, String originalCall, String modifiedMacroContent, List<MacroExpansionScanner.Expansion> expansionList) {
        try {
            this.collapseNestedMacro(expandParams, expansion, originalCall, modifiedMacroContent, expansionList, null);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected abstract void openDiffDialog();

    protected abstract void openFaultyExpansionsDialog(List<Integer> var1);

    protected abstract void handleNoExpansionsDetected();

    protected abstract void openNestedExpansionsWarning(List<Integer> var1, ITextEditor var2, IDocument var3, MacroExpansionScanner var4, List<MacroExpansionScanner.Expansion> var5, IProgressMonitor var6);

    protected abstract int getCursor();
}

