/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.actions;

import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.draw.utils.FontFactory;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.buildconfig.NothingToCompileDialog;
import ro.amiq.vlogdt.ui.actions.MacroCollapseInlineExpansionActionCommon;
import ro.amiq.vlogdt.ui.editor.SvCompareItem;
import ro.amiq.vlogdt.ui.macroexpansion.MacroExpansionScanner;

public class MacroCollapseInlineExpansionAction
extends MacroCollapseInlineExpansionActionCommon {
    private static final int FONT_HEIGHT_DEFAULT = 12;
    private static final String ORIGINAL_MACRO_EXPANSION = "Expansion with current macro definitions";
    private static final String MODIFIED_MACRO_EXPANSION = "Editor expansion";
    private static final String TITLE = "Expansion Changed";

    public MacroCollapseInlineExpansionAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor, true);
    }

    @Override
    protected CompletableFuture<Boolean> showCompareDialog(String modifiedMacro, String originalMacro) {
        MacroExpansionCompareInput ci = new MacroExpansionCompareInput(modifiedMacro, originalMacro);
        CompareUI.openCompareDialog((CompareEditorInput)ci);
        return CompletableFuture.completedFuture(ci.isOKButtonPressed());
    }

    @Override
    protected void displayNoFileCompiled(Display display, IProject project) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> NothingToCompileDialog.openWarning((IProject)project));
    }

    @Override
    protected Shell initShell(ITextEditor textEditor) {
        if (textEditor == null) {
            return null;
        }
        return textEditor.getSite().getShell();
    }

    @Override
    protected boolean checkIfValidShell(Shell shell) {
        return shell != null;
    }

    @Override
    protected void collapseMacro(Display display, String modifiedMacro, String originalMacro, String originalCall, IDocument document, String lineDelimiter, MacroExpansionScanner.Expansion expansion) {
        display.asyncExec(() -> this.macroCollapseAction(modifiedMacro, originalMacro, originalCall, document, lineDelimiter, expansion));
    }

    @Override
    protected IDocument getDocument(ITextEditor textEditor) {
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        return documentProvider.getDocument((Object)textEditor.getEditorInput());
    }

    @Override
    protected void replaceInDocument(IDocument document, int offset, int length, String replacement) {
        if (document == null) {
            return;
        }
        try {
            document.replace(offset, length, replacement);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private static class MacroExpansionCompareConfiguration
    extends CompareConfiguration {
        public MacroExpansionCompareConfiguration() {
            this.setLeftEditable(true);
            this.setLeftLabel(MacroCollapseInlineExpansionAction.MODIFIED_MACRO_EXPANSION);
            this.setRightEditable(false);
            this.setRightLabel(MacroCollapseInlineExpansionAction.ORIGINAL_MACRO_EXPANSION);
        }
    }

    private static class MacroExpansionCompareInput
    extends CompareEditorInput {
        private final String fLeft;
        private final String fRight;
        private Composite fParentComposite;
        private boolean fOKButtonPressed;

        public MacroExpansionCompareInput(String left, String right) {
            super((CompareConfiguration)new MacroExpansionCompareConfiguration());
            this.setTitle(MacroCollapseInlineExpansionAction.TITLE);
            this.fLeft = left;
            this.fRight = right;
        }

        protected Object prepareInput(IProgressMonitor pm) {
            SvCompareItem left = new SvCompareItem(this.fLeft);
            SvCompareItem right = new SvCompareItem(this.fRight);
            return new DiffNode((ITypedElement)left, (ITypedElement)right);
        }

        public String getOKButtonLabel() {
            return "Collapse";
        }

        public Control createContents(Composite parent) {
            this.fParentComposite = parent;
            Label label1 = new Label(this.fParentComposite, 64);
            label1.setText("The expansion you are trying to collapse does not match the current macro definitions");
            label1.setFont(FontFactory.getInstance().getSWTFont(new FontData("info", 12, 1)));
            GridData layoutData1 = new GridData(4, 128, true, false);
            label1.setLayoutData((Object)layoutData1);
            Label label2 = new Label(this.fParentComposite, 64);
            label2.setText("Either the editor expansion or the definitions of the involved macros have been modified. Please review the diff below before continuing the operation.");
            GridData layoutData2 = new GridData(4, 128, true, false);
            label2.setLayoutData((Object)layoutData2);
            return super.createContents(parent);
        }

        protected void contentsCreated() {
            super.contentsCreated();
            this.setDirty(true);
            if (this.fParentComposite != null) {
                this.fParentComposite.requestLayout();
            }
        }

        public boolean okPressed() {
            this.fOKButtonPressed = true;
            return super.okPressed();
        }

        public boolean isOKButtonPressed() {
            return this.fOKButtonPressed;
        }

        protected void setMessage(String message) {
            super.setMessage(message);
        }
    }
}

