/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.VlogException;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.ui.actions.MacroExpandAction;
import ro.amiq.vlogdt.ui.actions.MacroExpandActionUtils;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.macroexpansion.MacroExpander;
import ro.amiq.vlogdt.ui.macroexpansion.MacroExpansionScanner;
import ro.amiq.vlogdt.ui.macroexpansion.MacroScanner;

public abstract class MacroCollapseInlineExpansionActionCommon
extends TextEditorAction {
    private static final Set<String> NON_MACRO_CALLS = new HashSet<String>(Arrays.asList("define", "include", "timescale", "ifdef", "ifndef", "endif", "else", "elsif", "resetall", "undef", "begin_keywords", "end_keywords", "default_nettype", "pragma", "celldefine", "endcelldefine", "unconnected_drive", "nounconnected_drive", "undefineall"));
    private static final int PRAGMA_ORIGINAL_LENGTH = "\n// @DVT_EXPAND_MACRO_INLINE_ORIGINAL\n".length();
    private static final int PRAGMA_END_LENGTH = "\n// @DVT_EXPAND_MACRO_INLINE_END\n".length();
    protected static final String MESSAGE_1 = "The expansion you are trying to collapse does not match the current macro definitions";
    protected static final String MESSAGE_2 = "Either the editor expansion or the definitions of the involved macros have been modified. Please review the diff below before continuing the operation.";
    protected boolean removeTrailingWS;

    protected MacroCollapseInlineExpansionActionCommon(ResourceBundle bundle, String prefix, ITextEditor editor, boolean removeTrailingWS) {
        super(bundle, prefix, editor);
        this.removeTrailingWS = removeTrailingWS;
    }

    private String processMacro(String macro, String currentDelimiter, String universalDelimiter) {
        StringBuilder processedMacro = new StringBuilder();
        Arrays.asList(macro.split(universalDelimiter)).stream().forEach(line -> {
            processedMacro.append(DVTStringUtil.replaceFirst((Pattern)DVTStringUtil.TRAILING_WS, (CharSequence)line, (String)""));
            processedMacro.append(currentDelimiter);
        });
        return processedMacro.toString();
    }

    protected void macroCollapseAction(String modifiedMacro, String originalMacro, String originalCall, IDocument document, String currentDelimiter, MacroExpansionScanner.Expansion expansion) {
        try {
            String universalDelimiter = "\\r\\n|\\n\\r|\\n|\\r";
            String newModifiedMacro = this.processMacro(modifiedMacro, currentDelimiter, universalDelimiter);
            String newOriginalMacro = this.processMacro(originalMacro, currentDelimiter, universalDelimiter);
            if (!newModifiedMacro.equals(newOriginalMacro)) {
                this.handleMacroDiff(originalCall, document, expansion, this.removeTrailingWS ? newModifiedMacro : modifiedMacro, this.removeTrailingWS ? newOriginalMacro : originalMacro);
            } else {
                this.handleReplacement(document, expansion.getStartOffset(), expansion.getEndOffset() - expansion.getStartOffset(), originalCall);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected void handleMacroDiff(String originalCall, IDocument document, MacroExpansionScanner.Expansion expansion, String newModifiedMacro, String newOriginalMacro) {
        if (TestHelper.isTestMode() && !TestHelper.isLanguageServerMode()) {
            return;
        }
        this.showCompareDialog(newModifiedMacro, newOriginalMacro).thenAccept(isOkButtonPressed -> {
            if (!isOkButtonPressed.booleanValue()) {
                return;
            }
            this.handleReplacement(document, expansion.getStartOffset(), expansion.getEndOffset() - expansion.getStartOffset(), originalCall);
        });
    }

    protected void handleReplacement(IDocument document, int startOffset, int length, String originalCall) {
        this.replaceInDocument(document, startOffset, length, originalCall);
        ((DVTEditor)this.getTextEditor()).selectAndReveal(startOffset, originalCall.length());
    }

    public void run() {
        try {
            this.doReplacement(this.getTextEditor(), -1);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void doReplacement(ITextEditor textEditor, int offset) throws BadLocationException {
        if (textEditor == null) {
            return;
        }
        Shell shell = this.initShell(textEditor);
        if (!this.checkIfValidShell(shell)) {
            return;
        }
        IDocument document = this.getDocument(textEditor);
        if (document == null) {
            return;
        }
        if (!(textEditor instanceof VlogEditor)) {
            return;
        }
        MacroExpansionScanner expansionScanner = MacroExpansionScanner.INSTANCE;
        MacroExpansionScanner.Expansion expansion = expansionScanner.getExpansion(document, offset = offset == -1 ? ((VlogEditor)textEditor).getCursor() : offset);
        if (expansion == null || expansion.isIllegal()) {
            MacroExpandAction.showError(shell, "No expansion detected", "There is no macro expansion starting at the current cursor position!");
            return;
        }
        if (expansion.isBroken()) {
            MacroExpandAction.showError(shell, "Broken expansion", "The expansion you are trying to collapse has been broken! (DVT pragmas modified/removed)");
            return;
        }
        if (expansion.isNested()) {
            Integer offsetWrapper = offset;
            MacroExpandAction.showWarning(shell, "Nested expansions detected", "There are nested expansions inside the expansion you want to collapse. Do you wish to proceed?").thenAccept(proceed -> {
                if (!proceed.booleanValue()) {
                    return;
                }
                try {
                    this.collapseMacroWrapper(textEditor, offsetWrapper, document, expansionScanner, expansion);
                }
                catch (BadLocationException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            });
            return;
        }
        this.collapseMacroWrapper(textEditor, offset, document, expansionScanner, expansion);
    }

    protected void collapseMacroWrapper(ITextEditor textEditor, int offset, IDocument document, MacroExpansionScanner expansionScanner, MacroExpansionScanner.Expansion expansion) throws BadLocationException {
        Display display;
        String commentedOriginal = document.get(expansion.getOriginalStartOffset(), expansion.getOriginalEndOffset() - expansion.getOriginalStartOffset());
        String originalCall = MacroExpandActionUtils.blockUncomment(commentedOriginal, DVTDocumentCommon.getLineDelimiter((IEditorPart)textEditor));
        RfProject project = ((VlogEditor)textEditor).getRfProject();
        if (project == null) {
            return;
        }
        VlogFileInstance tops = project.getPreprocessingTable().getTopFileInstance();
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display display2 = display = workbench != null ? workbench.getDisplay() : null;
        if (tops == null) {
            this.displayNoFileCompiled(display, project.getProject());
            return;
        }
        String modifiedMacroContent = document.get(expansion.getOriginalEndOffset() + PRAGMA_ORIGINAL_LENGTH, expansion.getEndOffset() - PRAGMA_END_LENGTH - expansion.getOriginalEndOffset() - PRAGMA_ORIGINAL_LENGTH);
        ExpandParams expandParams = new ExpandParams(textEditor, document, project, expansion, display);
        if (!expansion.isNested()) {
            Matcher m = DVTStringUtil.TICK_FOLLOWED_BY_WORD.matcher(modifiedMacroContent);
            boolean macroCall = false;
            while (m.find() && !macroCall) {
                String macroName = modifiedMacroContent.substring(m.start() + 1, m.end());
                if (NON_MACRO_CALLS.contains(macroName)) continue;
                macroCall = true;
            }
            if (!macroCall) {
                this.collapseNormalMacroWrapper(expandParams, expansion, originalCall);
                return;
            }
        }
        List<MacroExpansionScanner.Expansion> expansionList = expansionScanner.getAllExpansions(document, offset);
        this.collapseNestedMacroWrapper(expandParams, expansion, originalCall, modifiedMacroContent, expansionList);
    }

    protected void collapseNestedMacroWrapper(final ExpandParams expandParams, final MacroExpansionScanner.Expansion expansion, final String originalCall, final String modifiedMacroContent, final List<MacroExpansionScanner.Expansion> expansionList) {
        Job expandNestedJob = new Job("Macro collapse"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    MacroCollapseInlineExpansionActionCommon.this.collapseNestedMacro(expandParams, expansion, originalCall, modifiedMacroContent, expansionList, monitor);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        expandNestedJob.setUser(true);
        expandNestedJob.schedule();
    }

    protected void collapseNestedMacro(ExpandParams expandParams, MacroExpansionScanner.Expansion expansion, String originalCall, String modifiedMacroContent, List<MacroExpansionScanner.Expansion> expansionList, IProgressMonitor monitor) throws BadLocationException, VlogException {
        if (monitor != null) {
            monitor.beginTask("Macro collapse", -1);
        }
        IDocument document = expandParams.document;
        String lineDelimiter = expandParams.lineDelimiter;
        String originalMacroContent = MacroExpander.expand(expandParams.macroScanner, monitor, expandParams.firstInstance, originalCall, expandParams.project, null, 1, expandParams.line, expandParams.parserPath, true, false);
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        StringBuilder originalMacroContentBuffer = new StringBuilder(originalMacroContent);
        StringBuilder modifiedMacroContentBuffer = new StringBuilder(modifiedMacroContent);
        int i = 0;
        while (i < expansionList.size()) {
            try {
                if (expandParams.line != document.getLineOfOffset(expansionList.get(i).getOriginalStartOffset())) {
                    String nestedCommentedOriginal = document.get(expansionList.get(i).getOriginalStartOffset(), expansionList.get(i).getOriginalEndOffset() - expansionList.get(i).getOriginalStartOffset());
                    String nestedOriginalCall = MacroExpandActionUtils.blockUncomment(nestedCommentedOriginal, lineDelimiter);
                    modifiedMacroContentBuffer.replace(expansionList.get(i).getStartOffset() - expansion.getOriginalEndOffset() - PRAGMA_ORIGINAL_LENGTH, expansionList.get(i).getEndOffset() - expansion.getOriginalEndOffset() - PRAGMA_ORIGINAL_LENGTH, nestedOriginalCall);
                    int fromIndexForCollapsed = 0;
                    ArrayList<Integer> positionsInCollapsedBuffer = new ArrayList<Integer>();
                    while (modifiedMacroContentBuffer.indexOf(nestedOriginalCall, fromIndexForCollapsed) != -1) {
                        positionsInCollapsedBuffer.add(modifiedMacroContentBuffer.indexOf(nestedOriginalCall, fromIndexForCollapsed));
                        fromIndexForCollapsed = modifiedMacroContentBuffer.indexOf(nestedOriginalCall, fromIndexForCollapsed) + 1;
                    }
                    modifiedMacroContentBuffer = new StringBuilder(modifiedMacroContent);
                    int index = positionsInCollapsedBuffer.indexOf(expansionList.get(i).getStartOffset() - (expansion.getOriginalEndOffset() + PRAGMA_ORIGINAL_LENGTH));
                    String nestedOriginalMacroContent = MacroExpander.expand(expandParams.macroScanner, null, expandParams.firstInstance, nestedOriginalCall, expandParams.project, null, 1, document.getLineOfOffset(expansionList.get(i).getOriginalStartOffset()), expandParams.parserPath, true, false);
                    if (monitor != null && monitor.isCanceled()) {
                        return;
                    }
                    String replacement = "";
                    replacement = String.valueOf(replacement) + MacroExpandActionUtils.blockComment(String.valueOf(lineDelimiter) + "@DVT_EXPAND_MACRO_INLINE_START", lineDelimiter);
                    replacement = String.valueOf(replacement) + MacroExpandActionUtils.blockComment(String.valueOf(lineDelimiter) + nestedOriginalCall, lineDelimiter);
                    replacement = String.valueOf(replacement) + MacroExpandActionUtils.blockComment(String.valueOf(lineDelimiter) + "@DVT_EXPAND_MACRO_INLINE_ORIGINAL", lineDelimiter);
                    replacement = String.valueOf(replacement) + lineDelimiter + nestedOriginalMacroContent;
                    replacement = String.valueOf(replacement) + MacroExpandActionUtils.blockComment(String.valueOf(lineDelimiter) + "@DVT_EXPAND_MACRO_INLINE_END", lineDelimiter);
                    replacement = String.valueOf(replacement) + lineDelimiter;
                    ArrayList<Integer> replacePositions = new ArrayList<Integer>();
                    int fromIndex = 0;
                    while (originalMacroContentBuffer.indexOf(nestedOriginalCall, fromIndex) != -1 && replacePositions.size() <= index) {
                        replacePositions.add(originalMacroContentBuffer.indexOf(nestedOriginalCall, fromIndex));
                        fromIndex = originalMacroContentBuffer.indexOf(nestedOriginalCall, fromIndex) + 1;
                    }
                    if (replacePositions.size() - 1 == index) {
                        originalMacroContentBuffer.replace((Integer)replacePositions.get(index), (Integer)replacePositions.get(index) + nestedOriginalCall.length(), replacement);
                    }
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            ++i;
        }
        originalMacroContent = originalMacroContentBuffer.toString();
        String replacement = "";
        replacement = String.valueOf(replacement) + MacroExpandActionUtils.blockComment(String.valueOf(lineDelimiter) + "@DVT_EXPAND_MACRO_INLINE_START", lineDelimiter);
        replacement = String.valueOf(replacement) + MacroExpandActionUtils.blockComment(String.valueOf(lineDelimiter) + originalCall, lineDelimiter);
        replacement = String.valueOf(replacement) + MacroExpandActionUtils.blockComment(String.valueOf(lineDelimiter) + "@DVT_EXPAND_MACRO_INLINE_ORIGINAL", lineDelimiter);
        replacement = String.valueOf(replacement) + lineDelimiter + originalMacroContent;
        replacement = String.valueOf(replacement) + MacroExpandActionUtils.blockComment(String.valueOf(lineDelimiter) + "@DVT_EXPAND_MACRO_INLINE_END", lineDelimiter);
        replacement = String.valueOf(replacement) + lineDelimiter;
        String originalMacro = replacement.substring(1);
        String modifiedMacro = document.get(expansion.getStartOffset() + 1, expansion.getEndOffset() - expansion.getStartOffset() - 1);
        if (monitor != null) {
            monitor.done();
        }
        this.collapseMacro(expandParams.display, modifiedMacro, originalMacro, originalCall, document, lineDelimiter, expansion);
    }

    protected void collapseNormalMacroWrapper(final ExpandParams expandParams, final MacroExpansionScanner.Expansion expansion, final String originalCall) {
        Job expandJob = new Job("Macro collapse"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    MacroCollapseInlineExpansionActionCommon.this.collapseNormalMacro(expandParams, expansion, originalCall, monitor);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        expandJob.setUser(true);
        expandJob.schedule();
    }

    protected void collapseNormalMacro(ExpandParams expandParams, MacroExpansionScanner.Expansion expansion, String originalCall, IProgressMonitor monitor) {
        IDocument document = expandParams.document;
        String lineDelimiter = expandParams.lineDelimiter;
        try {
            if (monitor != null) {
                monitor.beginTask("Macro collapse", -1);
            }
            int originalMacroLine = expandParams.line - 1;
            String originalMacroContent = MacroExpander.expand(expandParams.macroScanner, null, expandParams.firstInstance, originalCall, expandParams.project, null, Integer.MAX_VALUE, originalMacroLine, expandParams.parserPath, true, false);
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            String replacement = "";
            replacement = String.valueOf(replacement) + MacroExpandActionUtils.blockComment(String.valueOf(lineDelimiter) + "@DVT_EXPAND_MACRO_INLINE_START", lineDelimiter);
            replacement = String.valueOf(replacement) + MacroExpandActionUtils.blockComment(String.valueOf(lineDelimiter) + originalCall, lineDelimiter);
            replacement = String.valueOf(replacement) + MacroExpandActionUtils.blockComment(String.valueOf(lineDelimiter) + "@DVT_EXPAND_MACRO_INLINE_ORIGINAL", lineDelimiter);
            replacement = String.valueOf(replacement) + lineDelimiter + originalMacroContent;
            replacement = String.valueOf(replacement) + MacroExpandActionUtils.blockComment(String.valueOf(lineDelimiter) + "@DVT_EXPAND_MACRO_INLINE_END", lineDelimiter);
            replacement = String.valueOf(replacement) + lineDelimiter;
            String originalMacro = replacement.substring(1);
            String modifiedMacro = document.get(expansion.getStartOffset() + 1, expansion.getEndOffset() - expansion.getStartOffset() - 1);
            if (monitor != null) {
                monitor.done();
            }
            this.collapseMacro(expandParams.display, modifiedMacro, originalMacro, originalCall, document, lineDelimiter, expansion);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected abstract Shell initShell(ITextEditor var1);

    protected abstract boolean checkIfValidShell(Shell var1);

    protected abstract IDocument getDocument(ITextEditor var1);

    protected abstract CompletableFuture<Boolean> showCompareDialog(String var1, String var2);

    protected abstract void displayNoFileCompiled(Display var1, IProject var2);

    protected abstract void collapseMacro(Display var1, String var2, String var3, String var4, IDocument var5, String var6, MacroExpansionScanner.Expansion var7);

    protected abstract void replaceInDocument(IDocument var1, int var2, int var3, String var4);

    protected static class ExpandParams {
        private IDocument document;
        private RfProject project;
        private Display display;
        private ParserPath parserPath;
        private int line;
        private String lineDelimiter;
        private VlogFileInstance firstInstance;
        private MacroScanner macroScanner;

        public ExpandParams(ITextEditor textEditor, IDocument document, RfProject project, MacroExpansionScanner.Expansion expansion, Display display) {
            this.document = document;
            this.project = project;
            this.display = display;
            TextSelection selection = new TextSelection(document, expansion.getOriginalStartOffset() + 3, expansion.getOriginalEndOffset() - expansion.getOriginalStartOffset() - 3);
            this.line = selection.getStartLine();
            IEditorInput editorInput = ((VlogEditor)textEditor).getEditorInput();
            if (editorInput == null) {
                return;
            }
            IFile file = (IFile)editorInput.getAdapter(IFile.class);
            if (file == null) {
                return;
            }
            this.parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
            VlogFileInstance tops = project.getPreprocessingTable().getTopFileInstance();
            List<VlogFileInstance> instances = tops.getFileInstances(this.parserPath);
            this.firstInstance = instances == null || instances.isEmpty() ? null : instances.get(0);
            this.lineDelimiter = DVTDocumentCommon.getLineDelimiter((IEditorPart)textEditor);
            this.macroScanner = new MacroScanner();
        }
    }
}

