/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.actions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.buildconfig.NothingToCompileDialog;
import ro.amiq.vlogdt.ui.actions.MacroExpandActionCommon;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public class MacroExpandAction
extends MacroExpandActionCommon {
    public MacroExpandAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    @Override
    public void replaceInDocument(IDocument document, TextSelection selection, String replacement) {
        try {
            document.replace(selection.getOffset(), selection.getLength(), replacement);
            this.setCursorAfterReplace(selection.getOffset() + 10);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected void setCursorAfterReplace(int offset) {
        ((DVTEditor)this.getTextEditor()).setCursor(offset);
    }

    @Override
    protected void openEditor(String text) {
        String file = String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString()) + '/' + "__expand_macro__.sv";
        try {
            File f2 = new File(file);
            f2.createNewFile();
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedWriter out = new BufferedWriter(new FileWriter(file));){
                out.write(text);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.openEditorAndSetCursor(f2);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected void openEditorAndSetCursor(File f2) {
        VlogFileUtils.getInstance().openEditor(f2, 1, null);
    }

    public static CompletableFuture<Boolean> showWarning(Shell shell, String title, String message) {
        MessageDialog dialog = new MessageDialog(shell, title, null, message, 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        return CompletableFuture.completedFuture(dialog.open() == 0);
    }

    public static void showError(Shell shell, String title, String message) {
        MessageDialog dialog = new MessageDialog(shell, title, null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        dialog.open();
    }

    @Override
    protected void initShell(ITextEditor textEditor) {
        this.fShell = textEditor.getSite().getShell();
    }

    @Override
    protected boolean checkIfValidShell() {
        return this.fShell != null;
    }

    @Override
    protected IDocument getDocument() {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            return null;
        }
        return textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
    }

    @Override
    protected int getCursor() {
        ITextEditor editor = this.getTextEditor();
        if (!(editor instanceof DVTEditor)) {
            return -1;
        }
        return ((DVTEditor)editor).getCursor();
    }

    @Override
    protected void displayNoFileCompiled(Display display, IProject project) {
        display.asyncExec(() -> NothingToCompileDialog.openWarning((IProject)project));
    }

    @Override
    protected void checkExpansion(Display display, IDocument document, String expanded, TextSelection finalSelection, String finalSelectedText) {
        display.asyncExec(() -> this.expandMacro(document, expanded, finalSelection, finalSelectedText));
    }

    @Override
    protected ISelection getSelection(ISelectionProvider selectionProvider) {
        return selectionProvider != null ? selectionProvider.getSelection() : null;
    }
}

