/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.actions;

import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.parser.IDefinesProvider;
import ro.amiq.vlogdt.parser.VlogException;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.ui.actions.MacroExpandAction;
import ro.amiq.vlogdt.ui.actions.MacroExpandActionUtils;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.macroexpansion.MacroExpander;
import ro.amiq.vlogdt.ui.macroexpansion.MacroScanner;

public abstract class MacroExpandActionCommon
extends TextEditorAction {
    protected static final String NO_MACRO_CALL_IN_FILE_MESSAGE = "No macro call found in the current file!";
    protected static final int SCAN_LIMIT = 1000;
    protected int fExpandLevel = Integer.MAX_VALUE;
    protected boolean fExpandInline;
    protected Shell fShell;
    protected boolean fSkipSelectionChecks;

    protected MacroExpandActionCommon(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public int getExpandLevel() {
        return this.fExpandLevel;
    }

    public void setExpandLevel(int expandLevel) {
        this.fExpandLevel = expandLevel;
    }

    public boolean isExpandInline() {
        return this.fExpandInline;
    }

    public void setExpandInline(boolean expandInline) {
        this.fExpandInline = expandInline;
    }

    public void setSkipSelectionChecks(boolean skipSelectionChecks) {
        this.fSkipSelectionChecks = skipSelectionChecks;
    }

    public void run() {
        try {
            Display display;
            int offset1;
            ITextEditor textEditor = this.getTextEditor();
            if (textEditor == null) {
                return;
            }
            ISelectionProvider selectionProvider = textEditor.getSelectionProvider();
            ISelection selection = this.getSelection(selectionProvider);
            String selectedText = selection instanceof TextSelection ? ((TextSelection)selection).getText() : null;
            int n = offset1 = selection instanceof TextSelection ? ((TextSelection)selection).getOffset() : -1;
            if (offset1 < 0) {
                return;
            }
            final IDocument document = this.getDocument();
            if (document == null) {
                return;
            }
            this.initShell(textEditor);
            if (!this.checkIfValidShell()) {
                return;
            }
            IFile file = (IFile)textEditor.getAdapter(IResource.class);
            if (file == null) {
                MacroExpandAction.showError(this.fShell, "No macro found", this.getNoMacroCallAtCursorMessage());
                return;
            }
            final RfProject rfProject = ((VlogEditor)textEditor).getRfProject();
            if (rfProject == null) {
                MacroExpandAction.showError(this.fShell, "No macro found", this.getNoMacroCallAtCursorMessage());
                return;
            }
            final ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
            if (parserPath == null) {
                MacroExpandAction.showError(this.fShell, "No macro found", this.getNoMacroCallAtCursorMessage());
                return;
            }
            if (!this.fSkipSelectionChecks) {
                if (selectedText == null || selectedText.trim().length() == 0) {
                    int offset2 = this.getCursor();
                    IRegion region = RfBatchUtils.getMacroRegionAtOffset(rfProject, parserPath, document, offset2, 1000);
                    if (region == null) {
                        MacroExpandAction.showError(this.fShell, "No macro found", this.getNoMacroCallAtCursorMessage());
                        return;
                    }
                    selection = new TextSelection(document, region.getOffset(), region.getLength());
                    selectedText = ((TextSelection)selection).getText();
                } else if (this.isAMacroWithParams(textEditor, selectedText, document.getLineOfOffset(offset1))) {
                    int selectionLength = selection instanceof TextSelection ? ((TextSelection)selection).getLength() : 0;
                    int offset = offset1 + selectionLength;
                    IRegion region = RfBatchUtils.getMacroRegionAtOffset(rfProject, parserPath, document, offset, 1000);
                    if (region == null) {
                        MacroExpandAction.showError(this.fShell, "No macro found", this.getNoMacroCallInSelectionMessage());
                        return;
                    }
                    selection = new TextSelection(document, region.getOffset(), region.getLength());
                    selectedText = ((TextSelection)selection).getText();
                }
                if (selectedText.contains("@DVT_EXPAND_MACRO_INLINE_")) {
                    MacroExpandAction.showError(this.fShell, "Cannot expand selection", "The current selection cannot be expanded because it contains another macro expansion!");
                    return;
                }
            }
            final VlogFileInstance tops = rfProject.getPreprocessingTable().getTopFileInstance();
            IWorkbench workbench = PlatformUI.getWorkbench();
            Display display2 = display = workbench != null ? workbench.getDisplay() : null;
            if (tops == null) {
                this.displayNoFileCompiled(display, rfProject.getProject());
                return;
            }
            final String contentType = ((IDocumentExtension3)document).getDocumentPartitioner("__vlog_partitioning").getContentType(offset1);
            final int line = selection instanceof TextSelection ? ((TextSelection)selection).getEndLine() : -1;
            final int startLine = selection instanceof TextSelection ? ((TextSelection)selection).getStartLine() : -1;
            final String finalSelectedText = selectedText;
            final ISelection finalSelection = selection;
            Job expandJob = new Job("Macro expand"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask("Macro expand", -1);
                        List<VlogFileInstance> instances = tops.getFileInstances(parserPath);
                        VlogFileInstance firstInstance = instances == null || instances.isEmpty() ? null : instances.get(0);
                        String expanded = MacroExpandActionCommon.this.getExpandedMacro(monitor, firstInstance, finalSelectedText, rfProject, contentType, startLine + 1, line, parserPath);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        monitor.done();
                        MacroExpandActionCommon.this.checkExpansion(display, document, expanded, (TextSelection)finalSelection, finalSelectedText);
                    }
                    catch (Exception e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            expandJob.setUser(true);
            expandJob.schedule();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean isAMacroWithParams(ITextEditor textEditor, String macroName, int line) {
        IFile file;
        if (macroName.startsWith("`")) {
            macroName = macroName.substring(1);
        }
        if ((file = (IFile)textEditor.getAdapter(IResource.class)) == null) {
            return false;
        }
        RfProject rfProject = ((VlogEditor)textEditor).getRfProject();
        if (rfProject == null) {
            return false;
        }
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
        if (parserPath == null) {
            return false;
        }
        VlogMacroInfo macro = rfProject.getMacroBeforeLineInFile(macroName, parserPath, line);
        return macro != null && macro.hasParams();
    }

    public void doExpand(String expanded, IDocument document, TextSelection selection) {
        if (this.fExpandInline) {
            ITextEditor editor = this.getTextEditor();
            if (editor == null) {
                return;
            }
            Object adapter = editor.getAdapter(IResource.class);
            if (!(adapter instanceof IResource)) {
                return;
            }
            try {
                DVTFileModificationValidator.validateEdit((IFile)((IFile)adapter));
            }
            catch (CoreException coreException) {
                return;
            }
            this.replaceSelection(document, selection, expanded);
        } else {
            this.openEditor(expanded);
            ObjectionManager.getInstance().clear(Objection.MACRO_EXPAND);
        }
    }

    public void replaceSelection(IDocument document, TextSelection selection, String expanded) {
        String replacement = MacroExpandActionUtils.computeExpandedMacro(selection.getText(), expanded, (IEditorPart)this.getTextEditor());
        this.replaceInDocument(document, selection, replacement);
    }

    protected void expandMacro(IDocument document, String expanded, TextSelection finalSelection, String finalSelectedText) {
        if (expanded != null && expanded.trim().equals(finalSelectedText.trim())) {
            MacroExpandAction.showError(this.fShell, "No macro found", this.getNoMacroCallInSelectionMessage());
            return;
        }
        this.doExpand(expanded, document, finalSelection);
    }

    protected String getExpandedMacro(IProgressMonitor monitor, IDefinesProvider firstInstance, String finalSelectedText, RfProject rfProject, String contentType, int startLine, int line, ParserPath parserPath) throws VlogException {
        return MacroExpander.expand(new MacroScanner(), monitor, firstInstance, finalSelectedText, rfProject, contentType, this.fExpandLevel, startLine, line, parserPath, true, false, false);
    }

    protected String getNoMacroCallAtCursorMessage() {
        return "No macro call found at the current cursor position!";
    }

    protected String getNoMacroCallInSelectionMessage() {
        return "The selected text does not contain any macro calls!";
    }

    protected abstract ISelection getSelection(ISelectionProvider var1);

    protected abstract IDocument getDocument();

    protected abstract void initShell(ITextEditor var1);

    protected abstract boolean checkIfValidShell();

    protected abstract void checkExpansion(Display var1, IDocument var2, String var3, TextSelection var4, String var5);

    protected abstract void replaceInDocument(IDocument var1, TextSelection var2, String var3);

    protected abstract void openEditor(String var1);

    protected abstract int getCursor();

    protected abstract void displayNoFileCompiled(Display var1, IProject var2);
}

