/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.actions;

import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.IDefinesProvider;
import ro.amiq.vlogdt.parser.VlogException;
import ro.amiq.vlogdt.ui.actions.MacroExpandAction;
import ro.amiq.vlogdt.ui.macroexpansion.MacroExpander;
import ro.amiq.vlogdt.ui.macroexpansion.MacroScanner;

public class MacroExpandAllInlineActionCommon
extends MacroExpandAction {
    protected ITextEditor textEditor;
    protected IDocument document;
    protected AtomicInteger cursor = new AtomicInteger();

    public MacroExpandAllInlineActionCommon(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        this.setExpandLevel(Integer.MAX_VALUE);
        this.setExpandInline(true);
        this.setSkipSelectionChecks(true);
    }

    @Override
    protected ISelection getSelection(ISelectionProvider selectionProvider) {
        this.document = this.getDocument();
        this.cursor.set(this.getCursor());
        return new TextSelection(this.document, 0, this.document.getLength());
    }

    @Override
    public void replaceSelection(IDocument document, TextSelection selection, String expanded) {
        this.replaceInDocument(document, selection, expanded);
    }

    @Override
    protected String getExpandedMacro(IProgressMonitor monitor, IDefinesProvider firstInstance, String finalSelectedText, RfProject rfProject, String contentType, int startLine, int line, ParserPath parserPath) throws VlogException {
        return MacroExpander.expandAllMacrosInFile(new MacroScanner(), monitor, firstInstance, finalSelectedText, rfProject, this.fExpandLevel, line, parserPath, true, false, true, this.document, this.textEditor, this.cursor);
    }

    @Override
    protected String getNoMacroCallAtCursorMessage() {
        return "No macro call found in the current file!";
    }

    @Override
    protected String getNoMacroCallInSelectionMessage() {
        return "No macro call found in the current file!";
    }
}

