/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiPredicate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.ch.utils.CHConfig;
import ro.amiq.dvt.diagrams.design.editor.DDesignEditorFactory;
import ro.amiq.dvt.diagrams.uml.UMLDiagram;
import ro.amiq.dvt.diagrams.wave.WaveDiagramEditor;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.interpreter.IXXVMConfigDBGetCallInfo;
import ro.amiq.dvt.interpreter.IXXVMConfigDBSetCallInfo;
import ro.amiq.dvt.interpreter.IXXVMConfigDBSetGetCallInfo;
import ro.amiq.dvt.interpreter.IXXVMFactoryOverrideElement;
import ro.amiq.dvt.interpreter.IXXVMRegBlock;
import ro.amiq.dvt.model.reflection.DummyPort;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.HierarchicalElement;
import ro.amiq.dvt.model.reflection.IRfAssociatedTypeElement;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.model.reflection.views.DVTQuickViewersUtil;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.AMenuCommandDelegate;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.ui.search.RWKind;
import ro.amiq.dvt.ui.search.RWSearchTypeEnum;
import ro.amiq.dvt.ui.trace.connections.model.TCNodeSignalPair;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.DVTViewEvent;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.factory.overrides.FactoryOverridesView;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.DVTLazyViewUtils;
import ro.amiq.dvt.ui.views.lazy.views.IDVTLazyView;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHLabelProvider;
import ro.amiq.dvt.ui.waveviewer.AddToWaveMode;
import ro.amiq.dvt.ui.waveviewer.DVTVCDUtils;
import ro.amiq.dvt.ui.waveviewer.DVTWaveViewIDEFactory;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.diagrams.chd.VlogCHDiagramHelper;
import ro.amiq.vlogdt.diagrams.uml.VlogUMLHelper;
import ro.amiq.vlogdt.diagrams.uml.model.VlogUMLModel;
import ro.amiq.vlogdt.interpreter.views.verification.hierarchy.XXVMComponent;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFieldDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInstanceDef;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.model.reflection.util.VlogRfGUIReferencesUtils;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.RfVHUtils;
import ro.amiq.vlogdt.model.reflection.views.VHHistoryItem;
import ro.amiq.vlogdt.model.reflection.views.VHLabelProvider;
import ro.amiq.vlogdt.model.reflection.views.VlogMacrosViewContributor;
import ro.amiq.vlogdt.model.reflection.views.VlogQuickViewersUtil;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmBase;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmComponent;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmField;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObject;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObjectInstance;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.editor.VlogVHBreadcrumbUtils;
import ro.amiq.vlogdt.ui.editor.actions.ReferencesInWorkspaceAction;
import ro.amiq.vlogdt.ui.editor.actions.ShowConstraintsAction;
import ro.amiq.vlogdt.ui.editor.actions.ShowInstancesAction;
import ro.amiq.vlogdt.ui.editor.actions.ShowInstancesInDHAction;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfHyperlinkDetector;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfHyperlinkDetectorCommon;
import ro.amiq.vlogdt.ui.search.ReferenceSearchPageInput;
import ro.amiq.vlogdt.ui.search.importpakcage.ImportSearchQuery;

public class MenuCommandDelegate
extends AMenuCommandDelegate {
    public boolean canHandle(IDVTElementWrapper wrapper) {
        if (wrapper == null) {
            return false;
        }
        if (wrapper.getRfElement() instanceof VlogMacrosViewContributor.CategoryWrapper) {
            return false;
        }
        return wrapper instanceof RfTreeElementWrapper || wrapper.getRfElement() instanceof RfTreeElementWrapper || wrapper instanceof DVTTreeElementWrapper && LanguageKind.VLOG == wrapper.getLanguageKind() || wrapper instanceof DVTTreeElementWrapper && LanguageKind.PF == wrapper.getLanguageKind() || wrapper.getRfElement() instanceof RfField || wrapper.getRfElement() instanceof DummyPort || wrapper.getRfElement() instanceof HierarchicalElement || wrapper.getRfElement() instanceof VHHistoryItem || wrapper.getRfElement() instanceof RfXvmField || wrapper.getRfElement() instanceof RfXvmObject || wrapper.getRfElement() instanceof RfXvmObjectInstance || wrapper.getRfElement() instanceof IXXVMRegBlock || wrapper.getRfElement() instanceof IXXVMFactoryOverrideElement || wrapper.getRfElement() instanceof IXXVMConfigDBSetGetCallInfo;
    }

    protected IRfNamedElement getNamedElement(IDVTElementWrapper wrapper) {
        if (wrapper == null) {
            return null;
        }
        IAdaptable element = (IAdaptable)wrapper.getRfElement(IAdaptable.class);
        if (element != null) {
            return (IRfNamedElement)element.getAdapter(IRfNamedElement.class);
        }
        IRfNamedElementAndScope rfElement = (IRfNamedElementAndScope)wrapper.getRfElement(RfWNamedElementAndScope.class);
        if (rfElement != null) {
            return rfElement.getIRfNamedElement();
        }
        TCNodeSignalPair nodeSignalPair = (TCNodeSignalPair)wrapper.getRfElement(TCNodeSignalPair.class);
        if (nodeSignalPair != null) {
            return nodeSignalPair.hotSignal instanceof HierarchicalElement ? ((HierarchicalElement)nodeSignalPair.hotSignal).getFirstSegment() : nodeSignalPair.hotSignal;
        }
        return super.getNamedElement(wrapper);
    }

    public boolean showConnectedTLMPorts(IDVTElementWrapper wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (!this.canShowConnectedTLMPorts(namedElement)) {
            return false;
        }
        ArrayList<RfXvmBase> portTreePathElements = this.getPortTreePathXvmBaseObjects(wrapper);
        if (portTreePathElements == null) {
            return false;
        }
        BiPredicate<IHidObject, IRfClassElement> filterPredicate = (iHidObj, enlcosingScope) -> RfHyperlinkDetectorCommon.shouldFilterIHidObject(iHidObj, enlcosingScope, namedElement, portTreePathElements, null);
        VlogRfGUIReferencesUtils.showFilteredUsagesAction(namedElement, null, wrapper.getProject(), namedElement.getName(), filterPredicate);
        return true;
    }

    private ArrayList<RfXvmBase> getPortTreePathXvmBaseObjects(IDVTElementWrapper wrapper) {
        DVTTreeElementWrapper additionalInfo = (DVTTreeElementWrapper)wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.PORT_INSTANCE);
        if (additionalInfo == null) {
            return null;
        }
        Object rfElement = additionalInfo.getRfElement();
        if (!(rfElement instanceof TreePath)) {
            return null;
        }
        TreePath portTreePath = (TreePath)rfElement;
        ArrayList<RfXvmBase> portTreePathObjectInstances = new ArrayList<RfXvmBase>();
        while (portTreePath != null) {
            Object portTreePathElement = portTreePath.getElement();
            if (!(portTreePathElement instanceof RfXvmBase)) break;
            portTreePathObjectInstances.add((RfXvmBase)portTreePathElement);
            portTreePath = portTreePath.getParent();
        }
        return portTreePathObjectInstances;
    }

    public boolean showUsages(IDVTElementWrapper wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (!this.canShowUsages(namedElement)) {
            return false;
        }
        try {
            IProject project = wrapper.getProject();
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            String[] fileExtensions = ReferencesInWorkspaceAction.getFileExtensions((IRfSingleLangProject)rfProject);
            ElementPath designContextPath = this.getContextPathForReadersWriters(wrapper);
            ReferenceSearchPageInput input = new ReferenceSearchPageInput(namedElement, namedElement.getEnclosingScope(), designContextPath, true, false, true, FileTextSearchScope.newSearchScope((IResource[])new IResource[]{project}, (String[])fileExtensions, (boolean)false));
            ReferencesInWorkspaceAction.searchReferencesHelper(input, false, project, RWSearchTypeEnum.USAGES);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    public boolean showLayers(IDVTElementWrapper wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (!this.canShowLayers(namedElement)) {
            return false;
        }
        RfClass parent = (RfClass)((RfNamedElement)namedElement).getEnclosingScope();
        VlogQuickViewersUtil.getInstance().updateLayersView(parent, (RfNamedElement)namedElement, wrapper.getProject(), DVTViewEvent.EventKind.TRIGGER, "context_menu", true, true);
        return true;
    }

    public boolean showDesignHierarchy(IDVTElementWrapper wrapper, String partID) {
        IRfNamedElement namedElement = DesignUtils.toGenericDesignElement((IRfNamedElement)this.getNamedElement(wrapper));
        if (!this.canShowDesignHierarchy(namedElement)) {
            return false;
        }
        DVTQuickViewersUtil.updateNewDesignHierarchyViewer((IRfNamedElement)namedElement);
        return true;
    }

    public boolean showVerificationHierarchy(IDVTElementWrapper wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (!this.canShowVerificationHierarchy(namedElement)) {
            return false;
        }
        VlogQuickViewersUtil.getInstance().updateVerificationHierarchyViewer(namedElement, wrapper.getProject(), true);
        return true;
    }

    public boolean showInFactoryOverrides(IDVTElementWrapper wrapper) {
        if (!this.canShowInFactoryOverrides(wrapper)) {
            return false;
        }
        Object component = wrapper.getRfElement();
        if (!(component instanceof IXXVMComponent)) {
            return false;
        }
        GoToInfo goToInfo = ((IXXVMComponent)component).getCreateCallGoToInfo();
        if (goToInfo == null) {
            return false;
        }
        IRfNamedElement namedElement = ((IXXVMComponent)component).getRfClass();
        if (namedElement == null) {
            return false;
        }
        IViewPart view = ViewsUtils.getViewById((String)"ro.amiq.dvt.ui.views.FactoryOverridesView", (boolean)true, (IWorkbenchWindow)Utils.getActiveWorkbenchWindow());
        if (!(view instanceof FactoryOverridesView)) {
            return false;
        }
        FactoryOverridesView factoryOverridesView = (FactoryOverridesView)view;
        Display display = Display.getDefault();
        display.asyncExec(() -> display.timerExec(300, () -> factoryOverridesView.revealInView(goToInfo, namedElement)));
        return true;
    }

    public boolean showTypeHierarchy(IDVTElementWrapper wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (!this.canShowHierarchy(namedElement)) {
            return false;
        }
        VlogQuickViewersUtil.getInstance().updateTypeHierarchyViewer(namedElement, wrapper.getProject(), DVTViewEvent.EventKind.TRIGGER, "context_menu", true, true);
        return true;
    }

    public boolean showDiagram(IDVTElementWrapper wrapper, String partID) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if ("ro.amiq.dvt.ui.views.VerificationHierarchyView".equals(partID) || "ro.amiq.dvt.ui.editor.breadcrumb.VHBreadcrumbViewer".equals(partID)) {
            if (!this.canShowComponentDiagram(wrapper)) {
                return false;
            }
            this.makeComponentDiagramWithBreacrumb(wrapper, partID);
            return true;
        }
        if (!this.canShowDiagram(wrapper)) {
            return false;
        }
        if (VlogUMLModel.hasClassDiagram(namedElement)) {
            UMLDiagram diagram;
            IProject project = wrapper.getProject();
            if (project == null) {
                IResource fileAdapter = namedElement.getFileAdapter();
                IProject iProject = project = fileAdapter != null ? fileAdapter.getProject() : DVTPlugin.getSelectionManager().getLastSelectedProject();
            }
            if ((diagram = VlogUMLHelper.INSTANCE.makeStructDiagramFor(Collections.singleton(namedElement), project)) == null) {
                return false;
            }
            VlogUMLHelper.INSTANCE.openUMLDiagramEditor(diagram);
            return true;
        }
        if (DesignUtils.getDesignKind((Object)namedElement) != IRfNamedElement.ElementKind.UNKNOWN) {
            return this.showDesignDiagramWithBreadcrumb(wrapper, partID, namedElement);
        }
        if ("ro.amiq.dvt.ui.views.LazyDesignHierarchyView".equals(partID)) {
            if (this.canShowConnectionsDiagram(namedElement)) {
                return this.showConnectionsDiagram(wrapper);
            }
            return false;
        }
        if (namedElement instanceof IRfFieldElement && !(namedElement instanceof IRfInstanceElement)) {
            return this.showFSMDiagram(wrapper, namedElement, RfFunction.class);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean makeComponentDiagramWithBreacrumb(IDVTElementWrapper wrapper, String partID) {
        try {
            List segments = null;
            Object treePath = wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH);
            if ("ro.amiq.dvt.ui.views.VerificationHierarchyView".equals(partID)) {
                segments = treePath instanceof TreePath ? TreePathUtils.getAllElementsToRoot((TreePath)((TreePath)treePath), (boolean)true, (boolean)true) : wrapper.getAllElementsToRoot(true, true);
            } else if ("ro.amiq.dvt.ui.editor.breadcrumb.VHBreadcrumbViewer".equals(partID)) {
                IEditorPart activeEditor = DVTFileUtils.getInstance().getActiveEditor();
                if (!(activeEditor instanceof IDVTBreadcrumbHost)) {
                    return false;
                }
                BreadcrumbInput breadcrumbInput = AbstractBreadcrumbUtils.getBreadcrumbInput(VHBreadcrumbViewer.class, (IDVTBreadcrumbHost)((IDVTBreadcrumbHost)activeEditor));
                if (breadcrumbInput == null) {
                    return false;
                }
                Object element = wrapper.getRfElement();
                if (!(element instanceof IRfBreadcrumbElement)) {
                    return false;
                }
                segments = breadcrumbInput.getSegmentsUpTo((IRfBreadcrumbElement)element);
            }
            if (treePath == null) {
                treePath = TreePathUtils.getTreePathFromBreadcrumb((List)segments, (IVHLabelProvider)new VHLabelProvider());
            }
            wrapper.setAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH, treePath);
            CHConfig config = new CHConfig(null, LanguageKind.VLOG);
            config.setBreadcrumbInput(new BreadcrumbInput(wrapper.getProject(), segments, VlogVHBreadcrumbUtils.getInstance().getBreadcrumbSerializer()));
            VlogCHDiagramHelper.makeComponentDiagramFor(wrapper, wrapper.getProject(), config);
            return true;
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
            return false;
        }
    }

    public boolean showConnectionsDiagram(IDVTElementWrapper wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (!this.canShowConnectionsDiagram(namedElement)) {
            return false;
        }
        if (namedElement instanceof IRfPortElement && wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.PORT_INSTANCE) != null) {
            return this.showConnectionsOnPortDiagram(wrapper, (IRfPortElement)namedElement);
        }
        return false;
    }

    public boolean copyInView(IDVTElementWrapper wrapper, String partID) {
        String itemName = "";
        TreeItem item = (TreeItem)wrapper.getItem();
        if (item == null) {
            if (DVTLazyViewUtils.ALL_LAZY_VIEWS.contains(partID)) {
                IViewPart viewById = ViewsUtils.getViewById((String)partID, (boolean)false);
                if (!(viewById instanceof IDVTLazyView)) {
                    return false;
                }
                ILabelProvider labelProvider = ((IDVTLazyView)viewById).getLabelProvider();
                itemName = labelProvider.getText((Object)wrapper);
            } else if ("org.eclipse.ui.views.ContentOutline".equals(partID)) {
                itemName = (String)wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TO_STRING);
            } else if ("ro.amiq.dvt.ui.views.FactoryOverridesView".equals(partID)) {
                Object rfElement = wrapper.getRfElement();
                if (!(rfElement instanceof IXXVMFactoryOverrideElement)) {
                    return false;
                }
                IXXVMFactoryOverrideElement factoryOverrideElement = (IXXVMFactoryOverrideElement)rfElement;
                itemName = factoryOverrideElement.getFullInstancePath(true);
            } else if ("ro.amiq.dvt.ui.views.ConfigDBView".equals(partID)) {
                Object rfElement = wrapper.getRfElement();
                if (!(rfElement instanceof IXXVMConfigDBSetGetCallInfo)) {
                    return false;
                }
                IXXVMConfigDBSetGetCallInfo configDBElement = (IXXVMConfigDBSetGetCallInfo)rfElement;
                String configDBElementType = configDBElement instanceof IXXVMConfigDBSetCallInfo ? "set" : (configDBElement instanceof IXXVMConfigDBGetCallInfo ? "get" : "<unknown>");
                itemName = configDBElementType + " " + "[" + String.valueOf(configDBElement.getIdEvaluation()) + "]";
            } else {
                itemName = wrapper.getRfElement().toString();
            }
        } else {
            itemName = item.getText();
        }
        ro.amiq.dvt.utils.Utils.copyToClipboard((String)itemName, (int)3);
        return true;
    }

    public boolean showUVMSequenceTree(IDVTElementWrapper wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (!this.canShowUVMSequenceTree(namedElement)) {
            return false;
        }
        VlogQuickViewersUtil.getInstance().updateUVMSequenceTreeView(namedElement, wrapper.getProject(), DVTViewEvent.EventKind.TRIGGER, "context_menu", true, true);
        return true;
    }

    public boolean showCallHierarchy(IDVTElementWrapper wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (!this.canShowCallHierarchy(namedElement)) {
            return false;
        }
        VlogQuickViewersUtil.getInstance().updateCallHierarchyViewer(namedElement, wrapper.getProject(), DVTViewEvent.EventKind.TRIGGER, "context_menu", true, true);
        return true;
    }

    public boolean showPDDefinition(IDVTElementWrapper wrapper) {
        if (!this.canShowPDDefinition(wrapper)) {
            return false;
        }
        IProject project = wrapper.getProject();
        if (project == null) {
            return false;
        }
        DVTPFInfo pdInfo = this.getPDForInstance(wrapper);
        if (pdInfo == null) {
            return false;
        }
        GoToInfo.of((String)pdInfo.getFilePath(), (int)-1, (int)-1, (int)pdInfo.getStartLine(), (String)pdInfo.getPowerDomainName(), (LanguageKind)LanguageKind.PF).open(project, true);
        return true;
    }

    public boolean showSNDiagram(IDVTElementWrapper wrapper) {
        if (!this.canShowSNDiagram(wrapper)) {
            return false;
        }
        IProject project = wrapper.getProject();
        if (project == null) {
            return false;
        }
        DDesignEditorFactory.getInstance().newPowerDomainsDiagram(project, null).openEditor();
        return true;
    }

    public boolean canShowConnectedTLMPorts(IRfNamedElement namedElement) {
        if (namedElement == null) {
            return false;
        }
        return RfHyperlinkDetector.checkSelectionIsTLMPort(namedElement);
    }

    public boolean canShowUsages(IRfNamedElement namedElement) {
        if (namedElement == null) {
            return false;
        }
        if (namedElement instanceof RfConstraint) {
            return false;
        }
        if (namedElement instanceof RfAssertExpect) {
            return false;
        }
        if (namedElement instanceof RfActionBlock) {
            return false;
        }
        return !(namedElement instanceof DummyPort);
    }

    public boolean canShowLayers(IRfNamedElement namedElement) {
        if (namedElement == null) {
            return false;
        }
        if (namedElement instanceof IRfPortElement) {
            return false;
        }
        if (namedElement instanceof RfConstraint) {
            return false;
        }
        if (namedElement instanceof RfTypeAlias || namedElement instanceof RfCovergroup) {
            return false;
        }
        return namedElement.getEnclosingScope() instanceof RfClass;
    }

    public boolean canShowDesignHierarchy(IRfNamedElement namedElement) {
        if (namedElement == null) {
            return false;
        }
        if (namedElement instanceof IRfPortElement) {
            return false;
        }
        return VlogQuickViewersUtil.matchTypeForDesignHierarchyViewer(DesignUtils.toGenericDesignElement((IRfNamedElement)namedElement)) != 0;
    }

    public boolean canShowVerificationHierarchy(IRfNamedElement namedElement) {
        if (namedElement == null) {
            return false;
        }
        if (namedElement instanceof RfModule) {
            return false;
        }
        IRfSingleLangProject rfProject = namedElement.getRfProject();
        if (rfProject == null) {
            return false;
        }
        if (namedElement instanceof RfField) {
            RfField field = (RfField)namedElement;
            namedElement = field.getAssociatedType();
        }
        HashSet<IRfNamedElement> visited = new HashSet<IRfNamedElement>();
        visited.add(namedElement);
        while (namedElement instanceof IRfListType || namedElement instanceof IRfTypeAliasElement) {
            if (visited.contains(namedElement = ((IRfAssociatedTypeElement)namedElement).getAssociatedType())) break;
            visited.add(namedElement);
        }
        if (namedElement instanceof RfClass) {
            return RfVHUtils.getXvmObject(rfProject.getProject(), (RfClass)namedElement) instanceof RfXvmComponent;
        }
        return false;
    }

    public boolean canShowInFactoryOverrides(IDVTElementWrapper wrapper) {
        if (wrapper == null) {
            return false;
        }
        Object component = wrapper.getRfElement();
        if (!(component instanceof IXXVMComponent)) {
            return false;
        }
        return ((IXXVMComponent)component).getIsFactoryOverriden();
    }

    public boolean canShowHierarchy(IRfNamedElement namedElement) {
        if (namedElement == null) {
            return false;
        }
        IRfNamedElement type = null;
        if (namedElement instanceof RfClass) {
            type = namedElement;
        } else if (namedElement instanceof RfField) {
            type = ((RfField)namedElement).getAssociatedType();
        }
        return type instanceof RfClass;
    }

    public boolean canShowDiagram(IDVTElementWrapper wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (wrapper.getRfElement() instanceof IXXVMRegBlock) {
            return false;
        }
        if (namedElement instanceof IRfFieldElement && !(namedElement instanceof IRfInstanceElement)) {
            return true;
        }
        return VlogUMLModel.hasClassDiagram(namedElement) || DesignUtils.getDesignElement((IRfNamedElement)namedElement, (Object)wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH)) != null;
    }

    public boolean canShowComponentDiagram(IDVTElementWrapper wrapper) {
        Object namedElement = wrapper.getRfElement();
        return namedElement instanceof RfXvmObject || namedElement instanceof RfXvmObjectInstance || namedElement instanceof XXVMComponent;
    }

    public boolean showImports(IDVTElementWrapper wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (!(namedElement instanceof RfPackage)) {
            return false;
        }
        ImportSearchQuery query = new ImportSearchQuery((RfPackage)namedElement);
        NewSearchUI.runQueryInBackground((ISearchQuery)query);
        return true;
    }

    public boolean canShowImports(IDVTElementWrapper wrapper) {
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        return namedElement instanceof RfPackage;
    }

    public boolean canCopyInView(IRfNamedElement namedElement) {
        return !(namedElement instanceof RfActionBlock);
    }

    public boolean canShowUVMSequenceTree(IRfNamedElement namedElement) {
        RfClass rfClass;
        if (namedElement == null) {
            return false;
        }
        return namedElement instanceof RfClass && ((rfClass = (RfClass)namedElement).isSubClass(rfClass.getClassWithPrefix("uvm_sequence", 1, 3)) || rfClass.isSubClass(rfClass.getClassWithPrefix("ovm_sequence", 1, 3)));
    }

    public boolean showConstraints(IDVTElementWrapper wrapper) {
        IRfNamedElement rfElement = this.getNamedElement(wrapper);
        if (rfElement instanceof RfDefElement) {
            rfElement = ((RfDefElement)rfElement).getNamedElement();
        }
        if (!(rfElement instanceof RfField)) {
            return false;
        }
        ShowConstraintsAction.showConstraints((RfField)rfElement);
        return true;
    }

    public boolean showEmitters(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean canShowConstraints(IRfNamedElement namedElement, boolean onlyForRand) {
        if (!(namedElement instanceof RfField)) {
            return false;
        }
        RfField fieldNamedElement = (RfField)namedElement;
        if (!fieldNamedElement.isField()) {
            return false;
        }
        if (DesignUtils.getDesignKind((Object)namedElement.getEnclosingScope()) != IRfNamedElement.ElementKind.UNKNOWN) {
            return false;
        }
        if (onlyForRand) {
            return fieldNamedElement.isRand() || fieldNamedElement.isRandc();
        }
        return true;
    }

    public boolean canShowCallHierarchy(IRfNamedElement namedElement) {
        if (namedElement == null) {
            return false;
        }
        return namedElement instanceof RfFunction;
    }

    public boolean canShowPDDefinition(IDVTElementWrapper wrapper) {
        return this.getPDForInstance(wrapper) != null;
    }

    public boolean canShowSNDiagram(IDVTElementWrapper wrapper) {
        List topDesigns;
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (namedElement == null) {
            return false;
        }
        IRfSingleLangProject project = namedElement.getRfProject();
        if (!(project instanceof RfProject)) {
            return false;
        }
        ELManager elManager = project.getELManager();
        if (elManager != null && ((topDesigns = elManager.getTopDesigns()) == null || topDesigns.isEmpty() || !topDesigns.contains(namedElement))) {
            return false;
        }
        DVTPFModel pfModel = this.getPfModel(wrapper);
        return pfModel != null && pfModel.hasPowerDomains();
    }

    private DVTPFInfo getPDForInstance(IDVTElementWrapper wrapper) {
        DVTPFModel pfModel = this.getPfModel(wrapper);
        if (pfModel == null || !pfModel.hasPowerDomains()) {
            return null;
        }
        IRfNamedElement namedElement = this.getNamedElement(wrapper);
        if (namedElement == null) {
            return null;
        }
        TreePath treePath = (TreePath)wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH);
        ElementPath instancePath = treePath == null ? wrapper.getInstancePath() : TreePathUtils.getElementPathFromTreePath((TreePath)treePath);
        return pfModel.getPDInfoForInstance(instancePath);
    }

    private DVTPFModel getPfModel(IDVTElementWrapper wrapper) {
        IProject project = wrapper.getProject();
        if (project == null) {
            return null;
        }
        RfMixedLangProject mixedLangProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
        if (mixedLangProject == null) {
            return null;
        }
        return mixedLangProject.getPFModel();
    }

    public boolean showInstances(IDVTElementWrapper wrapper) {
        IRfNamedElement rfElement = this.getNamedElement(wrapper);
        if (rfElement instanceof RfDefElement) {
            rfElement = ((RfDefElement)rfElement).getNamedElement();
        }
        if (!this.canShowInstances(rfElement)) {
            return false;
        }
        ShowInstancesAction.showInstances(rfElement);
        return true;
    }

    public boolean showInstancesInDH(IDVTElementWrapper wrapper) {
        IRfNamedElement rfElement = this.getNamedElement(wrapper);
        if (rfElement instanceof RfDefElement) {
            rfElement = ((RfDefElement)rfElement).getNamedElement();
        }
        if (!this.canShowInstances(rfElement)) {
            return false;
        }
        ShowInstancesInDHAction.showInstancesInDHFor(rfElement);
        return true;
    }

    public boolean showAllInstancesInDH(IDVTElementWrapper wrapper) {
        IRfNamedElement rfElement = this.getNamedElement(wrapper);
        if (rfElement instanceof RfDefElement) {
            rfElement = ((RfDefElement)rfElement).getNamedElement();
        }
        if (rfElement instanceof IRfInstanceElement) {
            rfElement = DesignUtils.getDesign((DesignUtils.DesignRequest)DesignUtils.DesignRequest.of((IRfNamedElement)DesignUtils.toGenericDesignElement((IRfNamedElement)rfElement)));
        }
        if (!this.canShowInstances(rfElement)) {
            return false;
        }
        ShowInstancesInDHAction.showInstancesInDHFor(rfElement);
        return true;
    }

    public boolean canShowConnectionsDiagram(IRfNamedElement namedElement) {
        return namedElement instanceof IRfPortElement;
    }

    public boolean showReadersUsages(IDVTElementWrapper wrapper) {
        IRfNamedElement rfElement = this.getNamedElement(wrapper);
        if (rfElement instanceof RfDefElement) {
            rfElement = ((RfDefElement)rfElement).getNamedElement();
        }
        if (!RfSearchUtils.canBeReadOrWritten((IRfNamedElement)rfElement)) {
            return false;
        }
        IRfSingleLangProject rfProject = rfElement.getRfProject();
        if (rfProject == null) {
            return false;
        }
        ElementPath instancePath = this.getContextPathForReadersWriters(wrapper);
        VlogRfGUIReferencesUtils.showReadersAction((IRfFieldElement)rfElement, rfElement.getEnclosingScope(), instancePath, null, rfProject.getProject(), rfElement.getName(), false);
        return true;
    }

    public boolean showWritersUsages(IDVTElementWrapper wrapper) {
        IRfNamedElement rfElement = this.getNamedElement(wrapper);
        if (rfElement instanceof RfDefElement) {
            rfElement = ((RfDefElement)rfElement).getNamedElement();
        }
        if (!RfSearchUtils.canBeReadOrWritten((IRfNamedElement)rfElement)) {
            return false;
        }
        IRfSingleLangProject rfProject = rfElement.getRfProject();
        if (rfProject == null) {
            return false;
        }
        ElementPath instancePath = this.getContextPathForReadersWriters(wrapper);
        VlogRfGUIReferencesUtils.showWritersAction((IRfFieldElement)rfElement, rfElement.getEnclosingScope(), instancePath, null, rfProject.getProject(), rfElement.getName(), false);
        return true;
    }

    private ElementPath getContextPathForReadersWriters(IDVTElementWrapper wrapper) {
        IDVTElementWrapper portInstanceWrapper = (IDVTElementWrapper)wrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.PORT_INSTANCE);
        if (portInstanceWrapper == null) {
            return null;
        }
        TreePath treePath = (TreePath)portInstanceWrapper.getAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH);
        if (treePath == null) {
            return null;
        }
        return TreePathUtils.getElementPathFromTreePath((TreePath)treePath);
    }

    public boolean showScenarioDiagram(IDVTElementWrapper wrapper, String partID) {
        return false;
    }

    public boolean canShowScenarioDiagram(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean showActivityDiagram(IDVTElementWrapper wrapper, String partID) {
        return false;
    }

    public boolean canShowActivityDiagram(IDVTElementWrapper wrapper) {
        return false;
    }

    public boolean canShowWaveViewerFieldActions(IDVTElementWrapper wrapper) {
        Object element = wrapper.getRfElement();
        if (!(element instanceof RfFieldDef)) {
            return false;
        }
        RfNamedElement namedElement = ((RfFieldDef)element).getNamedElement();
        if (!(namedElement instanceof RfField)) {
            return false;
        }
        if (!((RfField)namedElement).isField()) {
            return false;
        }
        IProject project = namedElement.getRfProject().getProject();
        if (project == null) {
            return false;
        }
        return DVTWaveViewIDEFactory.getInstance().isVcdSetAsInput(project);
    }

    public boolean addToWaveViewer(IDVTElementWrapper wrapper) {
        if (wrapper == null) {
            return false;
        }
        VlogEditor vlogEditor = this.getActiveVlogEditor();
        if (vlogEditor == null) {
            return false;
        }
        Object element = wrapper.getRfElement();
        if (!(element instanceof RfFieldDef)) {
            return false;
        }
        int offset = ((RfFieldDef)element).getStartOffset();
        RfWNamedElementAndScope rfElementAndScope = this.getRfElementAndScope(vlogEditor, offset);
        if (rfElementAndScope == null) {
            return false;
        }
        DVTWaveViewIDEFactory.getInstance().addToWaveFromEditor((IDVTBreadcrumbHost)vlogEditor, (IRfNamedElementAndScope)rfElementAndScope, offset, AddToWaveMode.SELECTED_SIGNALS);
        return true;
    }

    public boolean addWithDriversToWaveViewer(IDVTElementWrapper wrapper) {
        return this.addWithDriversLoadsToWaveViewer(wrapper, RWKind.WRITE);
    }

    public boolean addWithLoadsToWaveViewer(IDVTElementWrapper wrapper) {
        return this.addWithDriversLoadsToWaveViewer(wrapper, RWKind.READ);
    }

    private boolean addWithDriversLoadsToWaveViewer(IDVTElementWrapper wrapper, RWKind rwKind) {
        if (wrapper == null) {
            return false;
        }
        VlogEditor vlogEditor = this.getActiveVlogEditor();
        if (vlogEditor == null) {
            return false;
        }
        Object element = wrapper.getRfElement();
        if (!(element instanceof RfFieldDef)) {
            return false;
        }
        int offset = ((RfFieldDef)element).getStartOffset();
        RfWNamedElementAndScope rfElementAndScope = this.getRfElementAndScope(vlogEditor, offset);
        if (rfElementAndScope == null) {
            return false;
        }
        IProject project = vlogEditor.getProject();
        if (project == null) {
            return false;
        }
        DVTWaveViewIDEFactory.getInstance().addDriversLoadsToWaveFromEditor((IDVTBreadcrumbHost)vlogEditor, (IRfNamedElementAndScope)rfElementAndScope, offset, rwKind, project);
        return true;
    }

    public boolean canShowWaveViewerInstanceActions(IDVTElementWrapper wrapper) {
        Object element = wrapper.getRfElement();
        if (!(element instanceof RfFieldDef)) {
            return false;
        }
        RfNamedElement namedElement = ((RfFieldDef)element).getNamedElement();
        if (!(namedElement instanceof RfInstance)) {
            return false;
        }
        if (!((RfInstance)namedElement).isInstance()) {
            return false;
        }
        IProject project = namedElement.getRfProject().getProject();
        if (project == null) {
            return false;
        }
        return DVTWaveViewIDEFactory.getInstance().isVcdSetAsInput(project);
    }

    public boolean addInstancePortsToWaveViewer(IDVTElementWrapper wrapper) {
        if (wrapper == null) {
            return false;
        }
        VlogEditor vlogEditor = this.getActiveVlogEditor();
        if (vlogEditor == null) {
            return false;
        }
        Object element = wrapper.getRfElement();
        if (!(element instanceof RfInstanceDef)) {
            return false;
        }
        int offset = ((RfInstanceDef)element).getStartOffset();
        RfWNamedElementAndScope rfElementAndScope = this.getRfElementAndScope(vlogEditor, offset);
        if (rfElementAndScope == null) {
            return false;
        }
        ElementPath elementPath = DVTWaveViewIDEFactory.getInstance().getSignalElementPathInEditor((IRfNamedElementAndScope)rfElementAndScope, (IDVTBreadcrumbHost)vlogEditor, offset);
        if (elementPath == null) {
            return false;
        }
        RfNamedElement namedElement = ((RfInstanceDef)element).getNamedElement();
        if (!(namedElement instanceof RfInstance)) {
            return false;
        }
        List ports = DesignUtils.getPorts((DesignUtils.DesignRequest)DesignUtils.DesignRequest.of((IRfNamedElement)namedElement), (boolean)false, new HashMap());
        if (ports == null || ports.isEmpty()) {
            return false;
        }
        ArrayList<String> portsNames = new ArrayList<String>();
        for (IRfPortElement port : ports) {
            String portName = port.getName();
            if (portName == null || portName.isEmpty()) continue;
            portsNames.add(portName);
        }
        if (portsNames.isEmpty()) {
            return false;
        }
        WaveDiagramEditor waveEditor = DVTWaveViewIDEFactory.getInstance().getInputWaveEditor(vlogEditor.getProject());
        if (waveEditor == null) {
            return false;
        }
        List signalsWrappers = DVTVCDUtils.getSignalsWrappers((WaveDiagramEditor)waveEditor);
        if (signalsWrappers == null || signalsWrappers.isEmpty()) {
            return false;
        }
        DVTWaveViewIDEFactory.getInstance().addToWave(waveEditor, elementPath, portsNames, signalsWrappers);
        return true;
    }

    public boolean addAllInstanceSignalsToWaveViewer(IDVTElementWrapper wrapper) {
        if (wrapper == null) {
            return false;
        }
        VlogEditor vlogEditor = this.getActiveVlogEditor();
        if (vlogEditor == null) {
            return false;
        }
        Object element = wrapper.getRfElement();
        if (!(element instanceof RfInstanceDef)) {
            return false;
        }
        int offset = ((RfInstanceDef)element).getStartOffset();
        RfWNamedElementAndScope rfElementAndScope = this.getRfElementAndScope(vlogEditor, offset);
        if (rfElementAndScope == null) {
            return false;
        }
        ElementPath elementPath = DVTWaveViewIDEFactory.getInstance().getSignalElementPathInEditor((IRfNamedElementAndScope)rfElementAndScope, (IDVTBreadcrumbHost)vlogEditor, offset);
        if (elementPath == null) {
            return false;
        }
        DVTWaveViewIDEFactory.getInstance().addAllSignalsInPathToWave(elementPath);
        return true;
    }

    private VlogEditor getActiveVlogEditor() {
        IWorkbenchPage activePage = DVTUiUtils.getActivePage();
        if (activePage == null) {
            return null;
        }
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (!(activeEditor instanceof VlogEditor)) {
            return null;
        }
        return (VlogEditor)activeEditor;
    }

    private RfWNamedElementAndScope getRfElementAndScope(VlogEditor vlogEditor, int offset) {
        RfProject rfProject = vlogEditor.getRfProject();
        if (rfProject == null) {
            return null;
        }
        IFile currentFile = vlogEditor.getCurrentFile();
        if (currentFile == null) {
            return null;
        }
        IDocument document = DVTFileUtils.getInstance().getDocument((ITextEditor)vlogEditor);
        if (document == null) {
            return null;
        }
        return RfUtils.getRfElement(rfProject, currentFile, document, offset, vlogEditor);
    }
}

