/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import ro.amiq.vlogdt.ui.refactor.ovm2uvm.OVM2UVMRefactorInfo;
import ro.amiq.vlogdt.ui.refactor.ovm2uvm.OVM2UVMRefactorWizard;
import ro.amiq.vlogdt.ui.refactor.scripts.ScriptRefactoring;

public class OVM2UVMAction
implements IObjectActionDelegate {
    private ArrayList<IResource> fSelectedResources = new ArrayList();
    private IProject fProject;
    private boolean fMultipleProjects;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        if (this.fMultipleProjects) {
            new MessageDialog(this.getShell(), "Multiple projects selected", MessageDialog.getImage((String)"dialog_message_error_image"), "Only resources from the same project can be migrated at once.", 1, new String[]{IDialogConstants.CANCEL_LABEL}, 0).open();
            return;
        }
        if (this.fSelectedResources.isEmpty()) {
            new MessageDialog(this.getShell(), "No resources selected", MessageDialog.getImage((String)"dialog_message_error_image"), "Please select some resources to perform migration for.", 1, new String[]{IDialogConstants.CANCEL_LABEL}, 0).open();
            return;
        }
        this.openWizard();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelectedResources.clear();
        this.fProject = null;
        this.fMultipleProjects = false;
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        Object[] objectArray = ((IStructuredSelection)selection).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IResource) {
                this.fSelectedResources.add((IResource)o);
                if (this.fProject == null) {
                    this.fProject = ((IResource)o).getProject();
                } else if (this.fProject != ((IResource)o).getProject()) {
                    this.fMultipleProjects = true;
                }
            }
            ++n2;
        }
    }

    private void openWizard() {
        OVM2UVMRefactorInfo oVM2UVMRefactorInfo = new OVM2UVMRefactorInfo(this.fProject);
        OVM2UVMRefactorWizard wizard = new OVM2UVMRefactorWizard(new ScriptRefactoring(oVM2UVMRefactorInfo.getScriptRefactorInfo()), oVM2UVMRefactorInfo);
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        try {
            String titleForFailedChecks = "";
            op.run(this.getShell(), titleForFailedChecks);
        }
        catch (InterruptedException interruptedException) {}
    }

    private Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }
}

