/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.actions;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.SAXParseException;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.ui.refactor.scripts.RefactorScriptValidationException;
import ro.amiq.vlogdt.ui.refactor.scripts.RefactorScriptXMLParser;
import ro.amiq.vlogdt.ui.refactor.scripts.ScriptRefactorInfo;
import ro.amiq.vlogdt.ui.refactor.scripts.ScriptRefactorWizard;
import ro.amiq.vlogdt.ui.refactor.scripts.ScriptRefactoring;

public class ScriptRefactorAction
implements IObjectActionDelegate {
    private IProject fProject;
    private Shell fTestShell;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        ScriptRefactorInfo info;
        if (this.fProject == null) {
            if (TestHelper.isTestMode()) {
                return;
            }
            new MessageDialog(this.getShell(), "No resource selected", MessageDialog.getImage((String)"dialog_message_error_image"), "Please select a resource prior to performing a script refactor.", 1, new String[]{IDialogConstants.CANCEL_LABEL}, 0).open();
            return;
        }
        String path = this.getPathFromCurrentFileSelection();
        if (ro.amiq.vlogdt.test.TestHelper.isTestMode()) {
            path = ro.amiq.vlogdt.test.TestHelper.fRefactorXmlPath;
        } else if (path == null) {
            FileDialog fileDialog = new FileDialog(this.getShell(), 4096);
            fileDialog.setFilterExtensions(new String[]{"*.xml"});
            fileDialog.setText("Select a refactor script to apply");
            fileDialog.setFilterPath(DVTFileUtils.getInstance().getLastDirectory());
            path = fileDialog.open();
        }
        if (path == null || path.length() == 0) {
            return;
        }
        DVTFileUtils.getInstance().setLastDirectory(path);
        this.debug("*** Loading refactoring script from:" + path);
        try {
            RefactorScriptXMLParser parser = RefactorScriptXMLParser.newParser(new File(path).toURI().toURL(), false);
            info = new ScriptRefactorInfo(this.fProject, parser.load());
        }
        catch (SAXParseException e) {
            this.debug("*** Error: " + e.getMessage() + "\n    at line " + e.getLineNumber() + " in " + path);
            if (TestHelper.isTestMode()) {
                return;
            }
            MessageDialog.openError((Shell)this.getShell(), (String)"Error loading script", (String)("An error has occured while loading script file '" + path + "':\n" + e.getMessage()));
            return;
        }
        catch (RefactorScriptValidationException e) {
            this.debug("*** Error: " + e.getMessage());
            if (TestHelper.isTestMode()) {
                return;
            }
            MessageDialog.openError((Shell)this.getShell(), (String)"Error loading script", (String)("An error has occured while loading script file '" + path + "':\n" + e.getMessage()));
            return;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return;
        }
        if (!ro.amiq.vlogdt.test.TestHelper.isTestMode()) {
            this.openWizard(info);
        } else {
            this.testApplyChanges(info);
        }
    }

    private void debug(String message) {
        if (!BuildConfigManager.isRefScriptsDebug((IProject)this.fProject)) {
            return;
        }
        DVTBuildConsoleRegistry.getConsole((IProject)this.fProject).print(message);
    }

    private String getPathFromCurrentFileSelection() {
        String prefix;
        IResource resource;
        block8: {
            block7: {
                block6: {
                    resource = DVTPlugin.getSelectionManager().getLastSelectedResource();
                    if (resource instanceof IFile && resource.getLocation() != null) break block6;
                    return null;
                }
                prefix = DVTFileUtils.getInstance().getPrefix((IFile)resource, 1024);
                if (prefix != null) break block7;
                return null;
            }
            if (prefix.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>")) break block8;
            return null;
        }
        try {
            if (prefix.contains("<refactor-script")) {
                return resource.getLocation().toOSString();
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fProject = null;
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        Object[] objectArray = ((IStructuredSelection)selection).toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IResource) {
                this.fProject = ((IResource)o).getProject();
            }
            ++n2;
        }
    }

    private void openWizard(ScriptRefactorInfo info) {
        ScriptRefactoring ref = new ScriptRefactoring(info);
        ScriptRefactorWizard wizard = new ScriptRefactorWizard(ref);
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        try {
            String titleForFailedChecks = "";
            op.run(this.getShell(), titleForFailedChecks);
        }
        catch (InterruptedException interruptedException) {}
    }

    private Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    public void testSetProject(IProject project) {
        this.fProject = project;
    }

    private void testApplyChanges(ScriptRefactorInfo info) {
        ScriptRefactoring ref = new ScriptRefactoring(info);
        final ScriptRefactorWizard wizard = new ScriptRefactorWizard(ref);
        final RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    op.run(ScriptRefactorAction.this.getShell(), "");
                }
                catch (InterruptedException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        };
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        executor.schedule(new Runnable(){
            private volatile boolean finished = false;

            @Override
            public void run() {
                while (!this.finished) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).ScriptRefactorAction.this.fTestShell = wizard.getShell();
                            if ((this).ScriptRefactorAction.this.fTestShell != null) {
                                Control[] children = (this).ScriptRefactorAction.this.fTestShell.getChildren();
                                LinkedList<Control> childrenList = new LinkedList<Control>();
                                childrenList.addAll(Arrays.asList(children));
                                if (children.length > 0) {
                                    while (!childrenList.isEmpty()) {
                                        Button b;
                                        Object top = childrenList.poll();
                                        if (top instanceof Composite) {
                                            childrenList.addAll(Arrays.asList(((Composite)top).getChildren()));
                                            continue;
                                        }
                                        if (!(top instanceof Button) || !(b = (Button)top).getText().equals("&Finish")) continue;
                                        b.notifyListeners(13, new Event());
                                        break;
                                    }
                                    finished = true;
                                }
                            }
                        }
                    });
                    try {
                        Thread.sleep(4000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }, 6L, TimeUnit.SECONDS);
        Display.getDefault().syncExec(r);
    }
}

