/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.decorators;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;

public class TestFileDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public static final String ID = "ro.amiq.vlogdt.TestFileDecorator";

    public void decorate(Object element, IDecoration decoration) {
        try {
            if (element instanceof RfTreeElementWrapper && ((RfTreeElementWrapper)((Object)element)).getAccessDecoratorEnable()) {
                return;
            }
            IResource objectResource = this.getResource(element);
            if (objectResource == null) {
                return;
            }
            if (!objectResource.isAccessible()) {
                return;
            }
            IProject project = objectResource.getProject();
            if (!project.hasNature("ro.amiq.vlogdt.VlogNature")) {
                return;
            }
            if (objectResource instanceof IFile && PropertiesManager.getSessionProperty((IResource)objectResource, (String)PropertyTypes.QN_TEST_FILE) != null && PropertiesManager.getSessionProperty((IResource)objectResource, (String)PropertyTypes.QN_IMPORTED_FILE) == null) {
                if (PropertiesManager.getSessionProperty((IResource)objectResource, (String)PropertyTypes.QN_ACTIVE_TEST_FILE) != null) {
                    if (BuildConfigManager.isSkip((IResource)objectResource)) {
                        decoration.addOverlay(DVTImages.DESC_OVR_IGNORED_ACTIVE_TEST_FILE, 0);
                    } else {
                        decoration.addOverlay(DVTImages.DESC_OVR_ACTIVE_TEST_FILE, 0);
                    }
                } else if (BuildConfigManager.isSkip((IResource)objectResource)) {
                    decoration.addOverlay(DVTImages.DESC_OVR_IGNORED_TEST_FILE, 0);
                } else {
                    decoration.addOverlay(DVTImages.DESC_OVR_TEST_FILE, 0);
                }
            }
        }
        catch (Exception exception) {}
    }

    private IResource getResource(Object object) {
        if (object instanceof RfTreeElementWrapper) {
            return this.getResource(((RfTreeElementWrapper)((Object)object)).getRfElement());
        }
        if (object instanceof RfNamedElement) {
            return ((RfNamedElement)object).getFileAdapter();
        }
        if (object instanceof RfDefElement) {
            return ((RfDefElement)object).getFileAdapter();
        }
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable) {
            return (IResource)((IAdaptable)object).getAdapter(IResource.class);
        }
        return null;
    }

    public void refresh(final Object[] elements) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                TestFileDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)TestFileDecorator.this, elements));
            }
        });
    }
}

