/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.vlogdt.core.VlogPlugin;

public class PVlogReadOnlyGFileErrorDialog
extends MessageDialog {
    private boolean fromCompareViewer;
    private static final String PREFERENCE_PAGE_ID = "ro.amiq.vlogdt.ui.preferences.EditorPage";
    private static final String DONT_SHOW_AGAIN_MESSAGE = "Don't show again";

    private PVlogReadOnlyGFileErrorDialog(IFile file, boolean fromCompareViewer) {
        super(Utils.getActiveShell(), "Operation not supported", null, String.valueOf(fromCompareViewer ? "Edit" : "Save") + " of the generated file '" + file.getName() + "' is not supported." + "\n\nThe <a href=\"link\">" + "Treat generated files as read-only" + "</a> preference is enabled. Do you want to disable it?", 1, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        this.fromCompareViewer = fromCompareViewer;
    }

    protected Control createMessageArea(Composite composite) {
        Image image = this.getErrorImage();
        if (image == null || this.message == null) {
            return composite;
        }
        this.imageLabel = new Label(composite, 0);
        image.setBackground(this.imageLabel.getBackground());
        this.imageLabel.setImage(image);
        GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        Link link = new Link(composite, this.getMessageLabelStyle());
        link.setText(this.message);
        DVTUiUtils.setPlatformLinkColor((Link)link);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)link);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PVlogReadOnlyGFileErrorDialog.this.close();
                PVlogReadOnlyGFileErrorDialog.this.setReturnCode(-1);
                PreferencesUtil.createPreferenceDialogOn((Shell)PVlogReadOnlyGFileErrorDialog.this.getShell(), (String)PVlogReadOnlyGFileErrorDialog.PREFERENCE_PAGE_ID, null, null).open();
            }
        });
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        if (!this.fromCompareViewer) {
            return super.createDialogArea(parent);
        }
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        Button checkbox = new Button(container, 32);
        checkbox.setText(DONT_SHOW_AGAIN_MESSAGE);
        checkbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                Button source = (Button)e.getSource();
                if (source == null) {
                    return;
                }
                VlogPlugin.getDefault().getPreferenceStore().setValue("pvlog.compareviewer.display_err_when_edit_readonly_g_file", !source.getSelection());
            }
        });
        return area;
    }

    public static boolean show(IFile file, boolean fromCompareViewer) {
        if (Display.getCurrent() == null) {
            DVTLogger.INSTANCE.logError("PVlogReadOnlyGFileErrorDialog.show() should never be called on a non-UI thread");
            return false;
        }
        return new PVlogReadOnlyGFileErrorDialog(file, fromCompareViewer).open() == 0;
    }
}

