/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor;

import java.util.ArrayList;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import ro.amiq.dvt.ui.editor.DVTBaseScanner;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.IHighlightListener;
import ro.amiq.vlogdt.ui.editor.VlogStyle;
import ro.amiq.vlogdt.ui.editor.rules.VlogCombinedWordRule;
import ro.amiq.vlogdt.ui.editor.rules.VlogFoldingZoneMarker;
import ro.amiq.vlogdt.ui.editor.rules.VlogNumericRule;
import ro.amiq.vlogdt.ui.editor.rules.VlogPreprocessRule;
import ro.amiq.vlogdt.ui.editor.rules.VlogSystemTaskDetector;
import ro.amiq.vlogdt.ui.editor.rules.VlogWhitespaceDetector;
import ro.amiq.vlogdt.ui.editor.rules.VlogWordDetector;
import ro.amiq.vlogdt.ui.preferences.PrefConst;

public class VlogCodeScanner
extends DVTBaseScanner {
    private VlogCombinedWordRule fVlogCombinedWordRule;

    public VlogCodeScanner(VlogStyle style, int nofLinesFolding, boolean isVerilogAMS, boolean shouldHlSemantically) {
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new WhitespaceRule((IWhitespaceDetector)new VlogWhitespaceDetector()));
        rules.add(new VlogPreprocessRule(PrefConst.getPreproc(), style.getToken("highlight.preproc"), style.getToken("highlight.ovm_macro"), style.getToken("highlight.macro"), nofLinesFolding));
        this.fVlogCombinedWordRule = new VlogCombinedWordRule(isVerilogAMS, style, nofLinesFolding, shouldHlSemantically);
        DVTHlUtils.addListener((IHighlightListener)this.fVlogCombinedWordRule);
        rules.add(this.fVlogCombinedWordRule);
        rules.add(new VlogNumericRule(style.getToken("highlight.number")));
        rules.add(new WordRule((IWordDetector)new VlogSystemTaskDetector(), style.getToken("highlight.system_task")));
        rules.add(new VlogFoldingZoneMarker(nofLinesFolding));
        rules.add(new WordRule((IWordDetector)new VlogWordDetector(), style.getToken("highlight.default")));
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }

    public void setNofLinesFolding(int nofLines) {
        if (this.fRules != null) {
            IRule[] iRuleArray = this.fRules;
            int n = this.fRules.length;
            int n2 = 0;
            while (n2 < n) {
                IRule rule = iRuleArray[n2];
                if (rule instanceof VlogCombinedWordRule) {
                    ((VlogCombinedWordRule)rule).setNofLinesFolding(nofLines);
                }
                if (rule instanceof VlogPreprocessRule) {
                    ((VlogPreprocessRule)rule).setNofLinesFolding(nofLines);
                }
                if (rule instanceof VlogFoldingZoneMarker) {
                    ((VlogFoldingZoneMarker)rule).setNofLinesFolding(nofLines);
                }
                ++n2;
            }
        }
    }

    public void dispose() {
        DVTHlUtils.removeListener((IHighlightListener)this.fVlogCombinedWordRule);
        super.dispose();
    }
}

