/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathProvider;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.ui.editor.pathmanager.VlogDesignPathProvider;

public class VlogDHBreadcrumbUtils
extends DHBreadcrumbUtils {
    private static VlogDHBreadcrumbUtils INSTANCE;
    private static final Object SYNC_OBJECT;

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DHBreadcrumbUtils getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new VlogDHBreadcrumbUtils();
            }
        }
        return INSTANCE;
    }

    protected boolean shouldInhibitDesignBreadcrumb(IDVTBreadcrumbHost editor) {
        IDVTFileInstance fileInstance;
        IDesignPathProvider pathProvider;
        RfProject rfProject;
        block12: {
            IFile currentFile;
            DVTEditor dvtEditor;
            block11: {
                block10: {
                    block9: {
                        IProject project;
                        block8: {
                            try {
                                dvtEditor = (DVTEditor)editor;
                                project = editor.getProject();
                                if (project != null) break block8;
                                return true;
                            }
                            catch (CoreException e) {
                                DVTLogger.INSTANCE.logError((Throwable)e);
                                return true;
                            }
                        }
                        rfProject = RfManager.getInstance().getRfProject(project);
                        if (rfProject != null) break block9;
                        return true;
                    }
                    currentFile = dvtEditor.getCurrentFile();
                    if (currentFile != null) break block10;
                    return true;
                }
                pathProvider = dvtEditor.getDesignPathProvider();
                if (pathProvider instanceof VlogDesignPathProvider) break block11;
                return true;
            }
            fileInstance = currentFile.getSessionProperty(IDVTConstants.FILE_INSTANCE_QN) != null ? pathProvider.getFileInstance(currentFile, true) : DesignPathManager.getInstance().getFileInstanceFor((IDVTBreadcrumbHost)dvtEditor);
            if (fileInstance == null) {
                fileInstance = this.computeFirstMatchFileInstance(dvtEditor);
            }
            if (fileInstance instanceof VlogFileInstance) break block12;
            return true;
        }
        VlogFileInstance vlogFileInstance = (VlogFileInstance)fileInstance;
        return this.invalidateDesignScope(vlogFileInstance, rfProject, (VlogDesignPathProvider)pathProvider);
    }

    private IDVTFileInstance computeFirstMatchFileInstance(DVTEditor dvtEditor) {
        IFile iFile = dvtEditor.getCurrentFile();
        if (iFile == null) {
            return null;
        }
        IProject project = iFile.getProject();
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        RfFileDef fileDef = rfProject.getFile((IResource)iFile);
        if (fileDef == null) {
            return null;
        }
        List fileInstances = RfMixedLangManager.getInstance().getFileInstances(project, fileDef.getParserPath());
        if (fileInstances == null || fileInstances.isEmpty()) {
            return null;
        }
        return (IDVTFileInstance)fileInstances.get(0);
    }

    private boolean invalidateDesignScope(VlogFileInstance fileInstance, RfProject project, VlogDesignPathProvider pathProvider) {
        ParserPath parserPath = fileInstance.getParserPath();
        RfFileDef fileDef = project.getFile(parserPath);
        if (fileDef == null) {
            return false;
        }
        RfNamedElement semanticScope = fileInstance.getSemanticScope();
        if (semanticScope == null) {
            return true;
        }
        boolean validDesignScope = pathProvider.validDesignScope(semanticScope.getDeclaration());
        if (validDesignScope) {
            return false;
        }
        return this.invalidateDesignScopeForFileDef(fileDef, pathProvider);
    }

    private boolean invalidateDesignScopeForFileDef(RfFileDef fileDef, VlogDesignPathProvider pathProvider) {
        if (fileDef.getChildren() == null) {
            return true;
        }
        for (RfDefElement child : fileDef.getChildren()) {
            if (!pathProvider.validDesignScope(child)) continue;
            return false;
        }
        return true;
    }
}

