/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import ro.amiq.dvt.debug.core.model.breakpoints.LineBreakpoint;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.editor.VlogSourceViewerConfiguration;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogDebugContentAssistProcessor;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogDebugContentAssistProcessorManager;

public class VlogDebugSourceViewerConfiguration
extends VlogSourceViewerConfiguration {
    private LineBreakpoint breakpoint;
    private ISourceViewer viewer;

    public VlogDebugSourceViewerConfiguration(LineBreakpoint breakpoint, ISourceViewer viewer, boolean isVerilogAMS) {
        super((VlogEditor)null, isVerilogAMS);
        this.breakpoint = breakpoint;
        this.viewer = viewer;
    }

    public VlogDebugSourceViewerConfiguration(LineBreakpoint breakpoint, ISourceViewer viewer, boolean isVerilogAMS, boolean shouldHlSemantically) {
        super(null, isVerilogAMS, shouldHlSemantically);
        this.breakpoint = breakpoint;
        this.viewer = viewer;
    }

    public VlogDebugSourceViewerConfiguration(LineBreakpoint breakpoint, ISourceViewer viewer) {
        super(null);
        this.breakpoint = breakpoint;
        this.viewer = viewer;
    }

    public VlogDebugSourceViewerConfiguration() {
    }

    @Override
    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        this.fContentAssistant = new ContentAssistant();
        this.fContentAssistant.enableColoredLabels(true);
        this.fContentAssistant.setRepeatedInvocationMode(true);
        this.fContentAssistant.setStatusLineVisible(true);
        this.fContentAssistant.setStatusMessage("Press 'Ctrl+Space' to show Template proposals");
        this.fContentAssistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        this.fSourceProcessorManager = new VlogDebugContentAssistProcessorManager(this.fContentAssistant, this.breakpoint, this.viewer);
        this.fContentAssistant.addCompletionListener((ICompletionListener)this.fSourceProcessorManager);
        IFile file = (IFile)this.breakpoint.getMarker().getResource();
        if (file == null) {
            return null;
        }
        int offset = 0;
        try {
            offset = DVTFileUtils.getInstance().getLineOffset(file, this.breakpoint.getLineNumber() - 1);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.fSourceProcessorManager.addContentAssistProcessor(new VlogDebugContentAssistProcessor(this.fSourceProcessorManager, file, offset));
        this.fContentAssistant.setContentAssistProcessor((IContentAssistProcessor)this.fSourceProcessorManager, "__dftl_partition_content_type");
        this.fContentAssistant.setContextInformationPopupOrientation(20);
        this.fContentAssistant.enableAutoActivation(true);
        this.fContentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        this.fDialogSettings = new DialogSettings("dvt.contentAssist");
        this.fContentAssistant.setRestoreCompletionProposalSize(this.fDialogSettings);
        return this.fContentAssistant;
    }

    public void detectIndentation() {
    }

    public void detectIndentation(IDocument document) {
    }

    public void refreshTabWidth(int tabWidth) {
        this.setTabWidth(tabWidth);
    }

    public void refreshInsertSpaces(boolean insertSpaces) {
        this.setInsertSpaces(insertSpaces);
    }
}

