/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor;

import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import ro.amiq.dvt.ui.editor.DVTPositionUpdater;
import ro.amiq.dvt.ui.editor.IDVTDocumentSetupParticipant;
import ro.amiq.vlogdt.ui.editor.MacroPositionUpdater;
import ro.amiq.vlogdt.ui.editor.VlogPartitionScanner;

public abstract class VlogDocumentSetupParticipantCommon
implements IDVTDocumentSetupParticipant {
    protected FastPartitioner partitioner;

    public void setup(IDocument document) {
        if (document == null) {
            return;
        }
        this.addPositionCategories(document);
    }

    public void addPositionCategories(IDocument document) {
        DVTPositionUpdater semanticUpdater = new DVTPositionUpdater("SEMANTIC_HIGHLIGHT");
        DVTPositionUpdater reflectionUpdater = new DVTPositionUpdater("REFLECTION");
        DefaultPositionUpdater foldingUpdater = new DefaultPositionUpdater("__dvt_folding_position");
        MacroPositionUpdater macroUpdater = new MacroPositionUpdater("__dvt_macro_position");
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            this.partitioner = new FastPartitioner((IPartitionTokenScanner)new VlogPartitionScanner(), new String[]{"__vlog_sl_comment", "__vlog_ml_comment", "__vlog_literal", "__vlog_escaped_id", "__dftl_partition_content_type"});
            extension3.setDocumentPartitioner("__vlog_partitioning", (IDocumentPartitioner)this.partitioner);
            this.partitioner.connect(document);
        }
        document.addPositionCategory("SEMANTIC_HIGHLIGHT");
        document.addPositionUpdater((IPositionUpdater)semanticUpdater);
        document.addPositionCategory("__dvt_folding_position");
        document.addPositionUpdater((IPositionUpdater)foldingUpdater);
        document.addPositionCategory("REFLECTION");
        document.addPositionUpdater((IPositionUpdater)reflectionUpdater);
        document.addPositionCategory("__dvt_macro_position");
        document.addPositionUpdater((IPositionUpdater)macroUpdater);
    }

    public void disconnect() {
        if (this.partitioner != null) {
            this.partitioner.disconnect();
        }
        this.partitioner = null;
    }
}

