/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTWordFinder;
import ro.amiq.dvt.ui.editor.TextUtils;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.DVTDocumentUtils;
import ro.amiq.dvt.utils.MatchBeginEndPositionInfo;
import ro.amiq.vlogdt.ui.editor.VlogWordFinder;

public class VlogDoubleClickStrategy
implements ITextDoubleClickStrategy {
    private ICharacterPairMatcher fPairMatcher;

    public VlogDoubleClickStrategy(ICharacterPairMatcher pairMatcher) {
        this.fPairMatcher = pairMatcher;
    }

    public void doubleClicked(ITextViewer textViewer) {
        try {
            int offset = textViewer.getSelectedRange().x;
            if (offset < 0) {
                return;
            }
            if (this.fPairMatcher == null) {
                return;
            }
            IDocument document = textViewer.getDocument();
            IRegion region = this.fPairMatcher.match(document, offset);
            if (region != null && region.getLength() >= 2) {
                textViewer.setSelectedRange(region.getOffset() + 1, region.getLength() - 2);
            } else {
                MatchBeginEndPositionInfo matchingBeginEndRegionInfo = DVTDocumentUtils.getMatchingBeginEndBlockForOffset((int)offset, (IDocument)document, (DVTWordFinder)VlogWordFinder.getDefault());
                if (matchingBeginEndRegionInfo == null) {
                    return;
                }
                region = matchingBeginEndRegionInfo.getBeginEndRegion();
                if (region.getLength() != 0) {
                    textViewer.setSelectedRange(region.getOffset(), region.getLength());
                } else {
                    char c = TextUtils.getChar((IDocument)document, (int)offset);
                    if (Character.isWhitespace(c)) {
                        region = DVTDocumentCommon.getWhitespaceBlockAtOffset((IDocument)document, (int)offset);
                        textViewer.setSelectedRange(region.getOffset(), region.getLength());
                    }
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

