/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.internal.resources.MarkerInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextDropTargetEffect;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.preproc.PreprocUtils;
import ro.amiq.dvt.model.problems.VlogProblemCategories;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.IDVTNotificationsHost;
import ro.amiq.dvt.ui.SimpleDVTNotification;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.CopyFileInfoAction;
import ro.amiq.dvt.ui.actions.CopyFileInfoKind;
import ro.amiq.dvt.ui.actions.DVTQuickMenuCreator;
import ro.amiq.dvt.ui.dnd.RfNamedElementTransfer;
import ro.amiq.dvt.ui.editor.DVTContentAssistAction;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTTextOperationAction;
import ro.amiq.dvt.ui.editor.PersistentDVTNotification;
import ro.amiq.dvt.ui.editor.actions.CopyHierarchyPathAction;
import ro.amiq.dvt.ui.editor.actions.IReferencesAction;
import ro.amiq.dvt.ui.editor.actions.ToggleMarkOccurrencesAction;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.contentasisst.IDVTContentAssistConstants;
import ro.amiq.dvt.ui.editor.emulation.EditorEmulationAction;
import ro.amiq.dvt.ui.editor.emulation.EditorEmulationContributionItem;
import ro.amiq.dvt.ui.editor.formatter.detectindentation.DVTAutoIndentDetectionManager;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.fsbreadcrumb.FSBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.highlight.DVTHlUtils;
import ro.amiq.dvt.ui.editor.highlight.DVTSemanticHighlighter;
import ro.amiq.dvt.ui.editor.hover.DVTInformationControl;
import ro.amiq.dvt.ui.editor.lazy.outline.DVTLazyOutlinePage;
import ro.amiq.dvt.ui.editor.lazy.outline.QuickLazyOutlineView;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbViewer;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;
import ro.amiq.dvt.ui.search.ui.IBaseShowConstraintsAction;
import ro.amiq.dvt.ui.search.ui.IBaseShowEmittersAction;
import ro.amiq.dvt.ui.search.ui.IBaseShowInstancesAction;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTJobsUtils;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.interpreter.IntrpStartAction;
import ro.amiq.vlogdt.interpreter.XAutoAddTracepointsForFileAction;
import ro.amiq.vlogdt.interpreter.XSimDebugAction;
import ro.amiq.vlogdt.linter.ui.LintingProblemsManager;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.model.reflection.util.RfGUIEnclosingScopeUtils;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.views.VlogQuickViewersUtil;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.r2lparser.strategies.VlogR2LCache;
import ro.amiq.vlogdt.templates.TemplateMessages;
import ro.amiq.vlogdt.ui.actions.FieldEditorAction;
import ro.amiq.vlogdt.ui.actions.MacroCollapseAllInlineExpansionsAction;
import ro.amiq.vlogdt.ui.actions.MacroCollapseInlineExpansionAction;
import ro.amiq.vlogdt.ui.actions.MacroExpandAction;
import ro.amiq.vlogdt.ui.actions.MacroExpandAllAction;
import ro.amiq.vlogdt.ui.actions.MacroExpandAllInlineAction;
import ro.amiq.vlogdt.ui.actions.MacroExpandAllLevelsAction;
import ro.amiq.vlogdt.ui.actions.MacroExpandAllLevelsInlineAction;
import ro.amiq.vlogdt.ui.actions.MacroExpandOneLevelAction;
import ro.amiq.vlogdt.ui.actions.MacroExpandOneLevelInlineAction;
import ro.amiq.vlogdt.ui.editor.PVlogReadOnlyGFileErrorDialog;
import ro.amiq.vlogdt.ui.editor.VlogDocumentSetupParticipant;
import ro.amiq.vlogdt.ui.editor.VlogEditorCommon;
import ro.amiq.vlogdt.ui.editor.VlogEditorMessages;
import ro.amiq.vlogdt.ui.editor.VlogFileDocumentProvider;
import ro.amiq.vlogdt.ui.editor.VlogSourceViewerConfiguration;
import ro.amiq.vlogdt.ui.editor.actions.EmacsAutoAction;
import ro.amiq.vlogdt.ui.editor.actions.EmacsDeleteAutoAction;
import ro.amiq.vlogdt.ui.editor.actions.EmacsIndentAction;
import ro.amiq.vlogdt.ui.editor.actions.EmacsInjectAutoAction;
import ro.amiq.vlogdt.ui.editor.actions.GenerateGetterSetter;
import ro.amiq.vlogdt.ui.editor.actions.GoToIncludeAction;
import ro.amiq.vlogdt.ui.editor.actions.GoToPVlogMappedFileAction;
import ro.amiq.vlogdt.ui.editor.actions.OpenDeclarationAction;
import ro.amiq.vlogdt.ui.editor.actions.OverrideConstraintsAction;
import ro.amiq.vlogdt.ui.editor.actions.OverrideMethodsAction;
import ro.amiq.vlogdt.ui.editor.actions.ReferencesInFileAction;
import ro.amiq.vlogdt.ui.editor.actions.ReferencesInProjectAction;
import ro.amiq.vlogdt.ui.editor.actions.ReferencesInWorkingSetAction;
import ro.amiq.vlogdt.ui.editor.actions.ReferencesInWorkspaceAction;
import ro.amiq.vlogdt.ui.editor.actions.ShowConnectedTLMPortsAction;
import ro.amiq.vlogdt.ui.editor.actions.ShowConstraintsAction;
import ro.amiq.vlogdt.ui.editor.actions.ShowDiagramAction;
import ro.amiq.vlogdt.ui.editor.actions.ShowInstancesAction;
import ro.amiq.vlogdt.ui.editor.actions.ShowInstancesInDHAction;
import ro.amiq.vlogdt.ui.editor.actions.ShowReadersUsagesAction;
import ro.amiq.vlogdt.ui.editor.actions.ShowWritersUsagesAction;
import ro.amiq.vlogdt.ui.editor.actions.ToggleCommentAction;
import ro.amiq.vlogdt.ui.editor.actions.VlogDeleteLineAction;
import ro.amiq.vlogdt.ui.editor.actions.VlogRefactorAddParameterAction;
import ro.amiq.vlogdt.ui.editor.actions.VlogRefactorAddPortAction;
import ro.amiq.vlogdt.ui.editor.actions.VlogRefactorBindByNameMethodCallArg;
import ro.amiq.vlogdt.ui.editor.actions.VlogRefactorBindByPositionMethodCallArg;
import ro.amiq.vlogdt.ui.editor.actions.VlogRefactorChangeMethodSignatureAction;
import ro.amiq.vlogdt.ui.editor.actions.VlogRefactorConnectInputAction;
import ro.amiq.vlogdt.ui.editor.actions.VlogRefactorConnectInstancePortsByNameAction;
import ro.amiq.vlogdt.ui.editor.actions.VlogRefactorConnectInstancePortsByPositionAction;
import ro.amiq.vlogdt.ui.editor.actions.VlogRefactorConnectOutputAction;
import ro.amiq.vlogdt.ui.editor.actions.VlogRefactorExpandDotStarNotationAction;
import ro.amiq.vlogdt.ui.editor.actions.VlogRefactorExtractToFunctionAction;
import ro.amiq.vlogdt.ui.editor.actions.VlogRefactorExtractToModuleAction;
import ro.amiq.vlogdt.ui.editor.actions.VlogRefactorExtractToTaskAction;
import ro.amiq.vlogdt.ui.editor.actions.VlogRefactorExtractToVariableAction;
import ro.amiq.vlogdt.ui.editor.actions.VlogRefactorForwardImplicitConnectionsAction;
import ro.amiq.vlogdt.ui.editor.actions.VlogRefactorJoinExternAction;
import ro.amiq.vlogdt.ui.editor.actions.VlogRefactorMoveSelectionToNewFileAction;
import ro.amiq.vlogdt.ui.editor.actions.VlogRefactorRenameInFileAction;
import ro.amiq.vlogdt.ui.editor.actions.VlogRefactorSplitAction;
import ro.amiq.vlogdt.ui.editor.actions.VlogRenameAcrossDesignHierarchyRefactorAction;
import ro.amiq.vlogdt.ui.editor.actions.VlogRenameFileEditorAction;
import ro.amiq.vlogdt.ui.editor.actions.VlogRenameRefactorAction;
import ro.amiq.vlogdt.ui.editor.contentassist.RfContentAssistProcessor;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogAutoInstanceContentAssistProcessor;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogContentAssistProcessorManager;
import ro.amiq.vlogdt.ui.editor.highlight.VlogSemanticHighlighter;
import ro.amiq.vlogdt.ui.editor.hover.VlogHoverSourceInformationPresenter;
import ro.amiq.vlogdt.ui.editor.hyperlink.VlogRfHyperlinkDetector;
import ro.amiq.vlogdt.ui.editor.lazy.outline.VlogLazyOutlinePage;
import ro.amiq.vlogdt.ui.editor.lazy.outline.VlogQuickLazyOutlineView;
import ro.amiq.vlogdt.ui.preferences.PrefConst;
import ro.amiq.vlogdt.utils.VlogFileUtils;
import ro.amiq.vlogdt.wave.view.VlogAddAllSignalsInDVTWaveViewEditorActionHandler;
import ro.amiq.vlogdt.wave.view.VlogAddDriversToWaveViewTextEditorActionHandler;
import ro.amiq.vlogdt.wave.view.VlogAddLoadsToWaveViewTextEditorActionHandler;
import ro.amiq.vlogdt.wave.view.VlogAddPortsInDVTWaveViewEditorActionHandler;
import ro.amiq.vlogdt.wave.view.VlogAddSignalToWaveViewTextEditorHandler;
import ro.amiq.vlogdt.wave.view.VlogRevealInDVTWaveViewEditorAction;

public class VlogEditor
extends VlogEditorCommon {
    protected IPropertyChangeListener fOverrideMarkerPreferenceListener = event -> {
        if (event.getProperty().startsWith("editor.jump_to_defined_function_task_layer") && this.isActivePart()) {
            this.connectFileToDocument(true);
        }
    };
    private IPropertyChangeListener fPVlogReadOnlyGEditorPreferenceListener = event -> {
        if (!"editor.treat_g_editor_as_readonly".equals(event.getProperty())) {
            return;
        }
        this.updateEditorNotification(this.getParserPath());
    };
    private VlogLazyOutlinePage fOutlinePage;
    private IInformationPresenter fMacroPresenter;
    private ShowInstancesAction showInstancesAction;
    private ShowInstancesInDHAction showInstancesInDHAction;
    public static final String OPEN_HELP_SEARCH = "ro.amiq.vlogdt.ui.editor.OpenHelpSearch";
    public static final String TOGGLE_MARK_OCCURRENCES = "ro.amiq.vlogdt.ui.editor.ToggleMarkOccurrences";
    public static final String DEFINE_FOLDING_REGION = "ro.amiq.vlogdt.ui.editor.DefineFoldingRegion";
    public static final String EXPAND_FIRST_LEVEL = "ro.amiq.vlogdt.ui.editor.ExpandFirstLevel";
    public static final String EXPAND_ALL_LEVELS = "ro.amiq.vlogdt.ui.editor.ExpandAllLevels";
    public static final String COLLAPSE_ALL_LEVELS = "ro.amiq.vlogdt.ui.editor.CollapseAllLevels";
    public static final String SHOW_ACTIVE_PREPROCESSING = "ro.amiq.vlogdt.ui.editor.ShowActivePreprocessing";
    public static final String FORWARD_END_OF_WORD = "ro.amiq.vlogdt.ui.editor.ForwardEndOfWord";
    public static final String BACKWARD_START_OF_WORD = "ro.amiq.vlogdt.ui.editor.BackwardStartOfWord";
    public static final String SELECT_ENCLOSING_ELEMENT = "ro.amiq.vlogdt.ui.editor.SelectEnclosingElement";
    public static final String RESTORE_LAST_SELECTION = "ro.amiq.vlogdt.ui.editor.RestoreLastSelection";
    public static final String GOTO_PAIR_BRACKET = "ro.amiq.vlogdt.ui.editor.GoToPairBracket";
    public static final String TOGGLE_COLLAPSE_LINE = "ro.amiq.vlogdt.ui.editor.ToggleCollapseLine";
    public static final String TOGGLE_EXPAND_LINE = "ro.amiq.vlogdt.ui.editor.ToggleExpandLine";
    public static final String TOGGLE_EXPAND_SCOPE = "ro.amiq.vlogdt.ui.editor.ToggleExpandScope";
    public static final String TEMPLATE_PROPOSALS = "template_proposals_action";
    public static final String TOGGLE_COMMENT = "ro.amiq.vlogdt.ui.editor.ToggleComment";
    public static final String FORMAT_SOURCE = "ro.amiq.vlogdt.ui.editor.FormatSource";
    public static final String OPEN_DECLARATION = "ro.amiq.vlogdt.ui.editor.OpenDeclaration";
    public static final String SHOW_PVLOG_MAPPED_FILE = "ro.amiq.vlogdt.ui.editor.ShowPVlogMappedFile";
    public static final String INCLUDING_FILE = "ro.amiq.vlogdt.ui.editor.IncludingFile";
    public static final String OVERRIDE_METHODS = "ro.amiq.vlogdt.ui.editor.OverrideMethods";
    public static final String OVERRIDE_CONSTRAINTS = "ro.amiq.vlogdt.ui.editor.OverrideConstraints";
    public static final String GETTERS_SETTERS = "ro.amiq.vlogdt.ui.editor.GetterSetter";
    public static final String MACROS_EXPAND_ONE_LEVEL = "ro.amiq.vlogdt.ui.editor.MacrosExpandOneLevel";
    public static final String MACROS_EXPAND_ALL_LEVELS = "ro.amiq.vlogdt.ui.editor.MacrosExpandAllLevels";
    public static final String MACROS_EXPAND_ONE_LEVEL_INLINE = "ro.amiq.vlogdt.ui.editor.MacrosExpandOneLevelInline";
    public static final String MACROS_EXPAND_ALL_LEVELS_INLINE = "ro.amiq.vlogdt.ui.editor.MacrosExpandAllLevelsInline";
    public static final String MACROS_EXPAND_ALL_INLINE = "ro.amiq.vlogdt.ui.editor.MacrosExpandAllInline";
    public static final String MACROS_EXPAND_ALL = "ro.amiq.vlogdt.ui.editor.MacrosExpandAll";
    public static final String MACROS_COLLAPSE_INLINE_EXPANSION = "ro.amiq.vlogdt.ui.editor.MacrosCollapseInlineExpansion";
    public static final String MACROS_COLLAPSE_ALL_INLINE_EXPANSIONS = "ro.amiq.vlogdt.ui.editor.MacrosCollapseAllInlineExpansions";
    public static final String METHOD_DEBUG_START = "ro.amiq.vlogdt.ui.editor.MethodDebugStart";
    public static final String SIM_DEBUG = "ro.amiq.vlogdt.ui.editor.SimDebug";
    public static final String ADD_TO_WAVE_VIEW = "ro.amiq.vlogdt.ui.editor.addToWaveView";
    public static final String ADD_PORTS_TO_WAVE_VIEW = "ro.amiq.vlogdt.ui.editor.addPortsToWaveView";
    public static final String ADD_ALL_SIGNALS_TO_WAVE_VIEW = "ro.amiq.vlogdt.ui.editor.addAllSignalsWaveView";
    public static final String ADD_DRIVERS_TO_WAVE_VIEW = "ro.amiq.vlogdt.ui.editor.AddDriversToWave";
    public static final String ADD_LOADS_TO_WAVE_VIEW = "ro.amiq.vlogdt.ui.editor.AddLoadsToWave";
    public static final String REVEAL_IN_WAVE_VIEW = "ro.amiq.vlogdt.ui.editor.RlInWaveView";
    public static final String AUTO_ADD_TRACEPOINTS = "ro.amiq.vlogdt.ui.editor.AutoAddTracepoints";
    public static final String XVM_TEST_DEBUG = "ro.amiq.vlogdt.ui.editor.XVMTestDebug";
    public static final String MACROS_SUBMENU = "ro.amiq.vlogdt.ui.editor.MacrosSubMenu";
    public static final String METHOD_DEBUG_SUBMENU = "ro.amiq.vlogdt.ui.editor.MethodDebugSubMenu";
    public static final String EMACS_AUTO = "ro.amiq.vlogdt.ui.editor.EmacsAuto";
    public static final String EMACS_DEL_AUTO = "ro.amiq.vlogdt.ui.editor.EmacsDeleteAuto";
    public static final String EMACS_INJ_AUTO = "ro.amiq.vlogdt.ui.editor.EmacsInjectAuto";
    public static final String EMACS_INDENT = "ro.amiq.vlogdt.ui.editor.EmacsIndent";
    public static final String EMACS_SUBMENU = "ro.amiq.vlogdt.ui.editor.EmacsSubMenu";
    public static final String SHOW_DIAGRAM = "ro.amiq.vlogdt.ui.editor.ShowDiagram";
    public static final String QUICK_OUTLINE = "ro.amiq.vlogdt.ui.editor.QuickOutline";
    public static final String SOURCE_SUBMENU = "ro.amiq.vlogdt.ui.editor.SourceSubMenu";
    public static final String REFERENCES_IN_WORKSPACE = "ro.amiq.vlogdt.ui.editor.actions.ReferencesInWorkspace";
    public static final String REFERENCES_IN_PROJECT = "ro.amiq.vlogdt.ui.editor.actions.ReferencesInProject";
    public static final String REFERENCES_IN_FILE = "ro.amiq.vlogdt.ui.editor.actions.ReferencesInFile";
    public static final String REFERENCES_IN_WORKING_SET = "ro.amiq.vlogdt.ui.editor.actions.ReferencesInWorkingSet";
    public static final String REFERENCES_SUBMENU_COMMAND_ID = "ro.amiq.vlogdt.ui.editor.ReferencesSubMenu";
    public static final String DEPRECATED_OVM_FIELD_EDITOR = "ro.amiq.vlogdt.ui.editor.OVMFieldEditor";
    public static final String UVM_FIELD_EDITOR = "ro.amiq.vlogdt.ui.editor.UVMFieldEditor";
    public static final String REFACTOR_CONNECT_OUTPUT = "ro.amiq.vlogdt.ui.editor.actions.RefactorConnectOutput";
    public static final String REFACTOR_CONNECT_INPUT = "ro.amiq.vlogdt.ui.editor.actions.RefactorConnectInput";
    public static final String REFACTOR_RENAME = "ro.amiq.vlogdt.ui.editor.actions.RefactorRename";
    public static final String REFACTOR_RENAME_IN_FILE = "ro.amiq.vlogdt.ui.editor.actions.RefactorRenameInFile";
    public static final String REFACTOR_RENAME_ACROSS_DESIGN_HIERARCHY = "ro.amiq.vlogdt.ui.editor.actions.RefactorRenameAcrossDesignHierarchy";
    public static final String REFACTOR_RENAME_FILE = "ro.amiq.vlogdt.ui.editor.actions.RefactorRenameFile";
    public static final String REFACTOR_ADD_PORT = "ro.amiq.vlogdt.ui.editor.actions.VlogRefactorAddPort";
    public static final String REFACTOR_ADD_PARAMETER = "ro.amiq.vlogdt.ui.editor.actions.VlogRefactorAddParameter";
    public static final String REFACTOR_FORWARD_IMPLICIT_CONNECTIONS = "ro.amiq.vlogdt.ui.editor.actions.VlogRefactorForwardImplicitConnections";
    public static final String REFACTOR_EXTRACT_TO_LOCAL_VARIABLE = "ro.amiq.vlogdt.ui.editor.actions.RefactorExtractToLocalVariable";
    private static final String REFACTOR_EXTRACT_TO_FUNCTION = "ro.amiq.vlogdt.ui.editor.actions.RefactorExtractToFunction";
    private static final String REFACTOR_EXTRACT_TO_TASK = "ro.amiq.vlogdt.ui.editor.actions.RefactorExtractToTask";
    private static final String REFACTOR_CHANGE_METHOD_SIGNATURE = "ro.amiq.vlogdt.ui.refactor.ChangeMethodSignature";
    private static final String REFACTOR_SPLIT = "ro.amiq.vlogdt.ui.editor.actions.RefactorSplit";
    private static final String REFACTOR_JOIN_EXTERN = "ro.amiq.vlogdt.ui.editor.actions.RefactorJoinExtern";
    private static final String REFACTOR_BIND_BY_NAME_METHOD_CALL_ARGS = "ro.amiq.vlogdt.ui.editor.actions.RefactorBindByNameMethodCallArg";
    private static final String REFACTOR_BIND_BY_POSITION_METHOD_CALL_ARGS = "ro.amiq.vlogdt.ui.editor.actions.RefactorBindByPositionMethodCallArg";
    private static final String REFACTOR_CONNECT_INSTNACE_PORTS_BY_NAME = "ro.amiq.vlogdt.ui.editor.actions.RefactorConnectInstancePortsByName";
    private static final String REFACTOR_CONNECT_INSTNACE_PORTS_BY_POSITION = "ro.amiq.vlogdt.ui.editor.actions.RefactorConnectInstancePortsByPosition";
    private static final String REFACTOR_MOVE_SELECTION_TO_NEW_FILE = "ro.amiq.vlogdt.ui.editor.actions.RefactorMoveSelectionToNewFile";
    private static final String REFACTOR_EXTRACT_TO_MODULE = "ro.amiq.vlogdt.ui.editor.actions.RefactorExtractToModule";
    public static final String REFACTOR_SUBMENU = "ro.amiq.vlogdt.ui.editor.RefactorSubMenu";
    public static final String REFACTOR_EXPAND_DOT_STAR_NOTATION = "ro.amiq.vlogdt.ui.editor.actions.RefactorExpandDotStarNotation";
    public static final String COPY_FULL_PATH = "ro.amiq.vlogdt.ui.editor.CopyFullPath";
    public static final String COPY_FILE_NAME = "ro.amiq.vlogdt.ui.editor.CopyFileName";
    public static final String SHOW_CONSTRAINTS = "ro.amiq.dvt.ui.views.commands.ShowConstraints";
    public static final String SHOW_CONNECTED_TLM_PORTS = "ro.amiq.dvt.ui.views.commands.ShowConnectedTLMPorts";
    public static final String SHOW_INSTANCES = "ro.amiq.dvt.ui.views.commands.ShowInstances";
    public static final String SHOW_INSTANCES_IN_DH = "ro.amiq.dvt.ui.views.commands.ShowInstancesInDH";
    private static final String COPY_HIERARCHY_PATH = "ro.amiq.vlogdt.ui.editor.CopyHierarchyPath";
    private SimpleDVTNotification fEditorNotification;
    private boolean dirtyAutoEditStrategy;
    private CustomGotoMarker fCustomGotoMarker = new CustomGotoMarker();

    public VlogEditor() {
        this.createEditorConfiguration();
    }

    protected void createEditorConfiguration() {
        super.createEditorConfiguration(this);
        VlogPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fOverrideMarkerPreferenceListener);
        VlogPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPVlogReadOnlyGEditorPreferenceListener);
        VlogPlugin.getDefault().getWorkbench().getDecoratorManager().addListener((ILabelProviderListener)this);
        this.setHelpContextId("ro.amiq.vlogdt.help.editor");
    }

    protected void initializeEditor() {
        this.setDocumentProvider((IDocumentProvider)new VlogFileDocumentProvider());
        super.initializeEditor();
    }

    public void dispose() {
        try {
            try {
                ProjectionViewer viewer;
                VlogSourceViewerConfiguration configuration = (VlogSourceViewerConfiguration)this.getSourceViewerConfiguration();
                if (configuration != null) {
                    configuration.dispose();
                }
                if ((viewer = (ProjectionViewer)this.getSourceViewer()) != null) {
                    viewer.unconfigure();
                    viewer.setProjectionSummary(null);
                }
                DVTAutoIndentDetectionManager.INSTANCE.removeDetectedIndendationDocument(this.getDocument());
                this.disconnectFileFromDocument();
                TextEditorAction action = (TextEditorAction)this.getAction("ToggleMarkOccurrences");
                if (action != null) {
                    action.setEditor(null);
                }
                if ((action = (TextEditorAction)this.getAction("ToggleComment")) != null) {
                    action.setEditor(null);
                }
                if (this.fOutlinePage != null) {
                    this.fOutlinePage.dispose();
                    this.fOutlinePage = null;
                }
                if (this.fMacroPresenter != null) {
                    this.fMacroPresenter.uninstall();
                    this.fMacroPresenter = null;
                }
                VlogDocumentSetupParticipant setupParticipant = (VlogDocumentSetupParticipant)((VlogFileDocumentProvider)this.getDocumentProvider()).getDocumentSetupParticipant();
                setupParticipant.disconnect();
                RfBatchUtils.clearCaches();
                this.disposeListeners();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                super.dispose();
            }
        }
        finally {
            super.dispose();
        }
    }

    public void disposeListeners() {
        VlogPlugin.getDefault().getWorkbench().getDecoratorManager().removeListener((ILabelProviderListener)this);
        VlogPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fOverrideMarkerPreferenceListener);
        VlogPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPVlogReadOnlyGEditorPreferenceListener);
        this.fOverrideMarkerPreferenceListener = null;
        if (this.showInstancesAction != null) {
            DVTMixedLangModelManager.getInstance().removeBuildDoneListener((IBuildDoneListener)this.showInstancesAction);
        }
        this.showInstancesAction = null;
        this.showInstancesInDHAction = null;
        super.disposeListeners();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.setupEditorDropTarget();
    }

    private void setupEditorDropTarget() {
        final StyledText textWidget = this.getSourceViewer().getTextWidget();
        DropTarget dropTarget = (DropTarget)textWidget.getData("DropTarget");
        if (dropTarget == null) {
            dropTarget = new DropTarget((Control)textWidget, 1);
        }
        Transfer[] currentTransfers = dropTarget.getTransfer();
        int currentLength = currentTransfers.length;
        Transfer[] newTransfers = new Transfer[currentLength + 1];
        System.arraycopy(currentTransfers, 0, newTransfers, 0, currentLength);
        newTransfers[currentLength] = RfNamedElementTransfer.getInstance();
        dropTarget.setTransfer(newTransfers);
        dropTarget.addDropListener((DropTargetListener)new StyledTextDropTargetEffect(textWidget){

            public void dragEnter(DropTargetEvent event) {
                if (!RfNamedElementTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    return;
                }
                event.detail = 1;
                event.feedback |= 9;
                super.dragEnter(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                if (!RfNamedElementTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    return;
                }
                event.detail = 1;
                event.feedback |= 9;
                super.dragOperationChanged(event);
            }

            public void dragOver(DropTargetEvent event) {
                if (!RfNamedElementTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    return;
                }
                event.feedback |= 9;
                event.detail = 1;
                super.dragOver(event);
            }

            public void drop(DropTargetEvent event) {
                try {
                    VlogContentAssistProcessorManager contentAssistProcessorManager = (VlogContentAssistProcessorManager)((VlogSourceViewerConfiguration)VlogEditor.this.getSourceViewerConfiguration()).getSourceProcessorManager();
                    int caretOffset = textWidget.getCaretOffset();
                    IFile file = (IFile)VlogEditor.this.getAdapter(IResource.class);
                    RfDefElement initialScope = VlogEditor.this.getRfProject().getFile((IResource)file).getScope(caretOffset, false);
                    VlogAutoInstanceContentAssistProcessor autoInstanceContentAssistProcessor = null;
                    ITextViewer textViewer = VlogEditor.this.getTextViewer();
                    for (IContentAssistProcessor i : contentAssistProcessorManager.getProcessors()) {
                        if (!(i instanceof VlogAutoInstanceContentAssistProcessor)) continue;
                        autoInstanceContentAssistProcessor = (VlogAutoInstanceContentAssistProcessor)i;
                    }
                    if (RfNamedElementTransfer.getInstance().isSupportedType(event.currentDataType) && initialScope instanceof RfDefElement && autoInstanceContentAssistProcessor != null) {
                        IRfNamedElement namedElement = ((IRfNamedElement[])event.data)[0];
                        if (namedElement instanceof IRfDesignElement) {
                            IRfDesignElement payload = (IRfDesignElement)namedElement;
                            autoInstanceContentAssistProcessor.createProposal(textViewer, caretOffset, payload, false, initialScope).apply(VlogEditor.this.getDocument());
                            VlogEditor.this.getSite().getPage().activate((IWorkbenchPart)VlogEditor.this);
                        } else {
                            MessageDialog.openWarning((Shell)Utils.getActiveShell(), (String)"Operation not supported", (String)("Drag and drop for '" + namedElement.getSignature() + "' is not supported."));
                        }
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return;
                }
            }
        });
    }

    public void configureProjectionSupport(ProjectionSupport projectionSupport) {
        projectionSupport.addSummarizableAnnotationType(VlogProblemCategories.SVLOG_SYNTAX.getMarkerId());
        projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.error");
        projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.warning");
        projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.bookmark");
        projectionSupport.addSummarizableAnnotationType("org.eclipse.ui.workbench.texteditor.task");
        projectionSupport.addSummarizableAnnotationType("ro.amiq.dvt.ui.occurrences");
        projectionSupport.setHoverControlCreator(shell -> new DVTInformationControl(shell, (DefaultInformationControl.IInformationPresenter)new VlogHoverSourceInformationPresenter()));
    }

    public void configureSourceViewerConfiguration(ProjectionAnnotationModel annotationModel) {
        VlogSourceViewerConfiguration configuration = (VlogSourceViewerConfiguration)this.getSourceViewerConfiguration();
        configuration.setProjectionAnnotationModel(annotationModel);
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.setMatchingCharacterPainterPreferenceKeys("matchingBracketsVlogEnable", "matchingBracketsVlogColor");
        super.configureSourceViewerDecorationSupport(support);
    }

    public Object getAdapter(Class required) {
        if (IGotoMarker.class.equals((Object)required)) {
            return this.fCustomGotoMarker;
        }
        if (IContentOutlinePage.class.equals((Object)required)) {
            if (this.fOutlinePage == null) {
                this.fOutlinePage = new VlogLazyOutlinePage(this);
            }
            if (this.fOutlinePage.getEditor() == null) {
                this.fOutlinePage.setEditor(this);
            }
            return this.fOutlinePage;
        }
        return super.getAdapter(required);
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        try {
            RfProject rfProject;
            if (this.fCurrentFile != null && (rfProject = RfManager.getInstance().getRfProject(this.fCurrentFile.getProject())) != null) {
                rfProject.editorInputChanged(this.fCurrentFile, input, this);
            }
            super.doSetInput(input);
            LintingProblemsManager.getInstance().updateFile(this.getCurrentFile());
            VlogDocumentSetupParticipant setupParticipant = (VlogDocumentSetupParticipant)((VlogFileDocumentProvider)this.getDocumentProvider()).getDocumentSetupParticipant();
            IDocumentExtension3 extension3 = (IDocumentExtension3)this.getDocument();
            if (extension3.getDocumentPartitioner("__vlog_partitioning") == null) {
                setupParticipant.setup(this.getDocument());
            }
            this.setPrefStore(VlogPlugin.getDefault().getPreferenceStore());
            this.connectFileToDocument(false);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void doSaveAs() {
        try {
            super.doSaveAs();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
        try {
            if (this.isReadOnly(true)) {
                return;
            }
            super.doSave(monitor);
            PreprocUtils.getInstance().resolveRunOnSave((DVTEditor)this);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected boolean isNoIncrementalTrigger() {
        return this.isPrecompiledReadOnly(false);
    }

    private boolean isReadOnly(boolean showErrorMessage) {
        return this.isPrecompiledReadOnly(showErrorMessage) || this.isPVlogGeneratedReadOnly(showErrorMessage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isPrecompiledReadOnly(boolean showErrorMessage) {
        try {
            IDVTFileInstance fileInstance;
            IFile file = (IFile)this.getAdapter(IResource.class);
            if (file == null) {
                return false;
            }
            ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
            List fileInstances = RfMixedLangManager.getInstance().getFileInstances(this.getProject(), parserPath);
            if (fileInstances == null) return false;
            if (fileInstances.isEmpty()) {
                return false;
            }
            Iterator iterator = fileInstances.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!((fileInstance = (IDVTFileInstance)iterator.next()) instanceof VlogFileInstance) || !((VlogFileInstance)fileInstance).isPrecompiledDbManualFile());
            if (!showErrorMessage) return true;
            MessageDialog.openError((Shell)Utils.getActiveShell(), (String)"Operation not supported", (String)("Save of the pre-compiled file '" + new File(fileInstance.getParserPath().path).getName() + "' is not supported."));
            return true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    private boolean isPVlogGeneratedReadOnly(boolean showErrorMessage) {
        IFile file;
        block6: {
            block5: {
                try {
                    if (PrefConst.isPVlogReadOnlyGEditorEnabled()) break block5;
                    return false;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return false;
                }
            }
            file = this.getCurrentFile();
            if (file != null && PreprocUtils.getInstance().isGFile(file)) break block6;
            return false;
        }
        if (showErrorMessage && PVlogReadOnlyGFileErrorDialog.show(file, false)) {
            VlogPlugin.getDefault().getPreferenceStore().setValue("editor.treat_g_editor_as_readonly", false);
            return false;
        }
        return true;
    }

    public Image getTitleImage() {
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        Image image = super.getTitleImage();
        try {
            if (file == null) {
                image = DVTImages.imageCache.getImage(DVTImages.DESC_VLOG_MODULE_GRAY);
            } else {
                IContainer parent = file.getParent();
                while (parent != null && !(parent instanceof IProject)) {
                    if (parent.isLinked()) {
                        image = DVTImages.imageCache.getImage(DVTImages.DESC_VLOG_MODULE_LINKED);
                        break;
                    }
                    parent = parent.getParent();
                }
                Image newImage = ProjectColorUtils.transformImage((ImageDescriptor)DVTImages.DESC_VLOG_MODULE_BLACK_TRANSPARENT, (String)file.getProject().getName());
                image = newImage == null ? image : newImage;
            }
            ILabelDecorator decorator = VlogPlugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator();
            if (decorator != null) {
                return decorator.decorateImage(image, (Object)this);
            }
        }
        catch (Exception exception) {}
        return image;
    }

    protected void handleCursorPositionChanged() {
        super.handleCursorPositionChanged();
    }

    protected void createActions() {
        super.createActions();
        Object a = new DVTEditor.OpenHelpSearch((DVTEditor)this);
        a.setActionDefinitionId(OPEN_HELP_SEARCH);
        this.setAction("OpenHelpSearch", (IAction)a);
        a = new DVTEditor.CollapseAllLevelsAction((DVTEditor)this, VlogEditorMessages.getResourceBundle(), "CollapseAllLevels.", (ITextEditor)this);
        a.setActionDefinitionId(COLLAPSE_ALL_LEVELS);
        this.setAction("CollapseAllLevels", (IAction)a);
        a = new DVTEditor.ShowActivePreprocessingAction((DVTEditor)this, VlogEditorMessages.getResourceBundle(), "ShowActivePreprocessing.", (ITextEditor)this);
        a.setActionDefinitionId(SHOW_ACTIVE_PREPROCESSING);
        this.setAction("ShowActivePreprocessing", (IAction)a);
        a = new DVTEditor.ExpandAllLevelsAction((DVTEditor)this, VlogEditorMessages.getResourceBundle(), "ExpandAllLevels.", (ITextEditor)this);
        a.setActionDefinitionId(EXPAND_ALL_LEVELS);
        this.setAction("ExpandAllLevels", (IAction)a);
        a = new DVTEditor.ShowFirstLevelAction((DVTEditor)this, VlogEditorMessages.getResourceBundle(), "ExpandFirstLevel.", (ITextEditor)this);
        a.setActionDefinitionId(EXPAND_FIRST_LEVEL);
        this.setAction("ExpandFirstLevel", (IAction)a);
        a = new DVTEditor.DefineFoldingRegionAction((DVTEditor)this, VlogEditorMessages.getResourceBundle(), "DefineFoldingRegion.", (ITextEditor)this);
        a.setActionDefinitionId(DEFINE_FOLDING_REGION);
        this.setAction("DefineFoldingRegion", (IAction)a);
        a = new ToggleMarkOccurrencesAction(VlogEditorMessages.getResourceBundle(), "ToggleMarkOccurrences.", (ITextEditor)this);
        a.setActionDefinitionId(TOGGLE_MARK_OCCURRENCES);
        this.setAction("ToggleMarkOccurrences", (IAction)a);
        this.getEditorSite().getActionBars().setGlobalActionHandler(TOGGLE_MARK_OCCURRENCES, (IAction)a);
        a = new DVTEditor.ForwardEndOfWord((DVTEditor)this, VlogEditorMessages.getResourceBundle(), "", (ITextEditor)this);
        a.setActionDefinitionId(FORWARD_END_OF_WORD);
        this.setAction("ForwardEndOfWord", (IAction)a);
        a = new DVTEditor.BackwardStartOfWord((DVTEditor)this, VlogEditorMessages.getResourceBundle(), "", (ITextEditor)this);
        a.setActionDefinitionId(BACKWARD_START_OF_WORD);
        this.setAction("BackwardStartOfWord", (IAction)a);
        a = new DVTEditor.SelectEnclosingElement((DVTEditor)this, VlogEditorMessages.getResourceBundle(), "", (ITextEditor)this);
        a.setActionDefinitionId(SELECT_ENCLOSING_ELEMENT);
        this.setAction("SelectEnclosingElement", (IAction)a);
        a = new DVTEditor.RestoreLastSelection((DVTEditor)this, VlogEditorMessages.getResourceBundle(), "", (ITextEditor)this);
        a.setActionDefinitionId(RESTORE_LAST_SELECTION);
        this.setAction("RestoreLastSelection", (IAction)a);
        a = new DVTEditor.GoToPairMatchingBeginEndBlockOrPairBracket((DVTEditor)this, VlogEditorMessages.getResourceBundle(), "GoToPairBracket.", (ITextEditor)this);
        a.setActionDefinitionId(GOTO_PAIR_BRACKET);
        this.setAction("GoToPairBracket", (IAction)a);
        a = new DVTEditor.ToggleCollapseLineAction((DVTEditor)this, VlogEditorMessages.getResourceBundle(), "ToggleCollapseLine.", (ITextEditor)this);
        a.setActionDefinitionId(TOGGLE_COLLAPSE_LINE);
        this.setAction("ToggleCollapseLine", (IAction)a);
        a = new DVTEditor.ToggleExpandScopeAction((DVTEditor)this, VlogEditorMessages.getResourceBundle(), "ToggleExpandScope.", (ITextEditor)this);
        a.setActionDefinitionId(TOGGLE_EXPAND_SCOPE);
        this.setAction("ToggleExpandScope", (IAction)a);
        a = new DVTContentAssistAction(VlogEditorMessages.getResourceBundle(), "ContentAssistProposal", (ITextEditor)this);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)a);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        a = new DVTTextOperationAction(TemplateMessages.getResourceBundle(), "Editor.template_proposals_action.", (ITextEditor)this, 13);
        a.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction(TEMPLATE_PROPOSALS, (IAction)a);
        this.markAsStateDependentAction(TEMPLATE_PROPOSALS, true);
        a = new DVTEditor.FormatSourceAction((DVTEditor)this, VlogEditorMessages.getResourceBundle(), "FormatSource.", (ITextEditor)this);
        a.setActionDefinitionId(FORMAT_SOURCE);
        this.setAction("FormatSource", (IAction)a);
        a = new OverrideMethodsAction(VlogEditorMessages.getResourceBundle(), "OverrideMethods.", (ITextEditor)this);
        a.setActionDefinitionId(OVERRIDE_METHODS);
        this.setAction("OverrideMethods", (IAction)a);
        a = new OverrideConstraintsAction(VlogEditorMessages.getResourceBundle(), "OverrideConstraints.", (ITextEditor)this);
        a.setActionDefinitionId(OVERRIDE_CONSTRAINTS);
        this.setAction("OverrideConstraints", (IAction)a);
        a = new GenerateGetterSetter(VlogEditorMessages.getResourceBundle(), "GetterSetter.", (ITextEditor)this);
        a.setActionDefinitionId(GETTERS_SETTERS);
        this.setAction("GetterSetter", (IAction)a);
        a = new ToggleCommentAction(VlogEditorMessages.getResourceBundle(), "ToggleComment.", (ITextEditor)this);
        a.setActionDefinitionId(TOGGLE_COMMENT);
        this.setAction("ToggleComment", (IAction)a);
        this.markAsStateDependentAction("ToggleComment", true);
        this.configureToggleCommentAction();
        a = new OpenDeclarationAction(VlogEditorMessages.getResourceBundle(), "OpenDeclaration.", (ITextEditor)this);
        a.setActionDefinitionId(OPEN_DECLARATION);
        this.setAction("OpenDeclaration", (IAction)a);
        a = new GoToIncludeAction(VlogEditorMessages.getResourceBundle(), "IncludingFile.", (ITextEditor)this);
        a.setActionDefinitionId(INCLUDING_FILE);
        this.setAction("IncludingFile", (IAction)a);
        a = new MacroExpandOneLevelAction(VlogEditorMessages.getResourceBundle(), "MacrosExpandOneLevel.", (ITextEditor)this);
        a.setActionDefinitionId(MACROS_EXPAND_ONE_LEVEL);
        this.setAction("MacrosExpandOneLevel", (IAction)a);
        a = new MacroExpandAllLevelsAction(VlogEditorMessages.getResourceBundle(), "MacrosExpandAllLevels.", (ITextEditor)this);
        a.setActionDefinitionId(MACROS_EXPAND_ALL_LEVELS);
        this.setAction("MacrosExpandAllLevels", (IAction)a);
        a = new MacroExpandOneLevelInlineAction(VlogEditorMessages.getResourceBundle(), "MacrosExpandOneLevelInline.", (ITextEditor)this);
        a.setActionDefinitionId(MACROS_EXPAND_ONE_LEVEL_INLINE);
        this.setAction("MacrosExpandOneLevelInline", (IAction)a);
        a = new MacroExpandAllLevelsInlineAction(VlogEditorMessages.getResourceBundle(), "MacrosExpandAllLevelsInline.", (ITextEditor)this);
        a.setActionDefinitionId(MACROS_EXPAND_ALL_LEVELS_INLINE);
        this.setAction("MacrosExpandAllLevelsInline", (IAction)a);
        a = new MacroExpandAllInlineAction(VlogEditorMessages.getResourceBundle(), "MacrosExpandAllInline.", (ITextEditor)this);
        a.setActionDefinitionId(MACROS_EXPAND_ALL_INLINE);
        this.setAction("MacrosExpandAllInline", (IAction)a);
        a = new MacroExpandAllAction(VlogEditorMessages.getResourceBundle(), "MacrosExpandAll.", (ITextEditor)this);
        a.setActionDefinitionId(MACROS_EXPAND_ALL);
        this.setAction("MacrosExpandAll", (IAction)a);
        a = new MacroCollapseInlineExpansionAction(VlogEditorMessages.getResourceBundle(), "MacrosCollapseInlineExpansion.", (ITextEditor)this);
        a.setActionDefinitionId(MACROS_COLLAPSE_INLINE_EXPANSION);
        this.setAction("MacrosCollapseInlineExpansion", (IAction)a);
        a = new MacroCollapseAllInlineExpansionsAction(VlogEditorMessages.getResourceBundle(), "MacrosCollapseAllInlineExpansions.", (ITextEditor)this);
        a.setActionDefinitionId(MACROS_COLLAPSE_ALL_INLINE_EXPANSIONS);
        this.setAction("MacrosCollapseAllInlineExpansions", (IAction)a);
        if (XUtils.DVT_ENABLE_SV_INTERP_DEBUG) {
            if (TestHelper.isTestMode()) {
                a = new XSimDebugAction(VlogEditorMessages.getResourceBundle(), "SimDebug.", (ITextEditor)this);
                a.setActionDefinitionId(SIM_DEBUG);
                this.setAction("SimDebug", (IAction)a);
            }
            if (XUtils.DVT_ENABLE_SV_INTERP_DEBUG_EXTRA) {
                a = new IntrpStartAction(VlogEditorMessages.getResourceBundle(), "MethodDebugStart.", (ITextEditor)this);
                a.setActionDefinitionId(METHOD_DEBUG_START);
                this.setAction("MethodDebugStart", (IAction)a);
                a = new XAutoAddTracepointsForFileAction(VlogEditorMessages.getResourceBundle(), "AutoAddTracepoints.", (ITextEditor)this);
                a.setActionDefinitionId(AUTO_ADD_TRACEPOINTS);
                this.setAction("AutoAddTracepoints", (IAction)a);
            }
        }
        a = new VlogAddSignalToWaveViewTextEditorHandler(VlogEditorMessages.getResourceBundle(), "AddToWave.", (ITextEditor)this);
        a.setActionDefinitionId(ADD_TO_WAVE_VIEW);
        this.setAction("AddToWave", (IAction)a);
        a = new VlogAddDriversToWaveViewTextEditorActionHandler(VlogEditorMessages.getResourceBundle(), "AddDriversToWave.", (ITextEditor)this);
        a.setActionDefinitionId(ADD_DRIVERS_TO_WAVE_VIEW);
        this.setAction("AddDriversToWave", (IAction)a);
        a = new VlogAddLoadsToWaveViewTextEditorActionHandler(VlogEditorMessages.getResourceBundle(), "AddLoadsToWave.", (ITextEditor)this);
        a.setActionDefinitionId(ADD_LOADS_TO_WAVE_VIEW);
        this.setAction("AddLoadsToWave", (IAction)a);
        a = new VlogAddPortsInDVTWaveViewEditorActionHandler(VlogEditorMessages.getResourceBundle(), "AddPortsToWave.", (ITextEditor)this);
        a.setActionDefinitionId(ADD_PORTS_TO_WAVE_VIEW);
        this.setAction("AddPortsToWave", (IAction)a);
        a = new VlogAddAllSignalsInDVTWaveViewEditorActionHandler(VlogEditorMessages.getResourceBundle(), "AddAllSignalsToWave.", (ITextEditor)this);
        a.setActionDefinitionId(ADD_ALL_SIGNALS_TO_WAVE_VIEW);
        this.setAction("AddAllSignalsToWave", (IAction)a);
        a = new VlogRevealInDVTWaveViewEditorAction(VlogEditorMessages.getResourceBundle(), "RevealInWaveView.", (ITextEditor)this);
        a.setActionDefinitionId(REVEAL_IN_WAVE_VIEW);
        this.setAction("RevealInWaveView", (IAction)a);
        a = new EmacsAutoAction(VlogEditorMessages.getResourceBundle(), "EmacsAuto.", (ITextEditor)this);
        a.setActionDefinitionId(EMACS_AUTO);
        this.setAction("EmacsAuto", (IAction)a);
        a = new EmacsDeleteAutoAction(VlogEditorMessages.getResourceBundle(), "EmacsDeleteAuto.", (ITextEditor)this);
        a.setActionDefinitionId(EMACS_DEL_AUTO);
        this.setAction("EmacsDeleteAuto", (IAction)a);
        a = new EmacsInjectAutoAction(VlogEditorMessages.getResourceBundle(), "EmacsInjectAuto.", (ITextEditor)this);
        a.setActionDefinitionId(EMACS_INJ_AUTO);
        this.setAction("EmacsInjectAuto", (IAction)a);
        a = new EmacsIndentAction(VlogEditorMessages.getResourceBundle(), "EmacsIndent.", (ITextEditor)this);
        a.setActionDefinitionId(EMACS_INDENT);
        this.setAction("EmacsIndent", (IAction)a);
        a = new ShowDiagramAction(VlogEditorMessages.getResourceBundle(), "ShowDiagram.", (ITextEditor)this);
        a.setActionDefinitionId(SHOW_DIAGRAM);
        this.setAction("ShowDiagram", (IAction)a);
        a = new ReferencesInWorkspaceAction(VlogEditorMessages.getResourceBundle(), "ReferencesInWorkspace.", (ITextEditor)this);
        a.setActionDefinitionId(REFERENCES_IN_WORKSPACE);
        this.setAction("ReferencesInWorkspace", (IAction)a);
        a = new ReferencesInProjectAction(VlogEditorMessages.getResourceBundle(), "ReferencesInProject.", (ITextEditor)this);
        a.setActionDefinitionId(REFERENCES_IN_PROJECT);
        this.setAction("ReferencesInProject", (IAction)a);
        a = new ReferencesInFileAction(VlogEditorMessages.getResourceBundle(), "ReferencesInFile.", (ITextEditor)this);
        a.setActionDefinitionId(REFERENCES_IN_FILE);
        this.setAction("ReferencesInFile", (IAction)a);
        a = new ReferencesInProjectAction(VlogEditorMessages.getResourceBundle(), "Usages.", (ITextEditor)this);
        a.setActionDefinitionId(REFERENCES_IN_PROJECT);
        this.setAction("Usages", (IAction)a);
        a = new ShowReadersUsagesAction(VlogEditorMessages.getResourceBundle(), "ShowReaders.", (ITextEditor)this);
        a.setActionDefinitionId("ro.amiq.dvt.ui.views.commands.ShowReaders");
        this.setAction("ShowReadersUsages", (IAction)a);
        a = new ShowWritersUsagesAction(VlogEditorMessages.getResourceBundle(), "ShowWriters.", (ITextEditor)this);
        a.setActionDefinitionId("ro.amiq.dvt.ui.views.commands.ShowWriters");
        this.setAction("ShowWritersUsages", (IAction)a);
        a = new ShowConnectedTLMPortsAction(VlogEditorMessages.getResourceBundle(), "ShowConnectedTLMPorts.", (ITextEditor)this);
        a.setActionDefinitionId(SHOW_CONNECTED_TLM_PORTS);
        this.setAction("ShowConnectedTLMPorts", (IAction)a);
        a = new ReferencesInWorkingSetAction(VlogEditorMessages.getResourceBundle(), "ReferencesInWorkingSet.", (ITextEditor)this);
        a.setActionDefinitionId(REFERENCES_IN_WORKING_SET);
        this.setAction("ReferencesInWorkingSet", (IAction)a);
        a = new FieldEditorAction(VlogEditorMessages.getResourceBundle(), "OVMFieldEditor.", (ITextEditor)this, true);
        a.setActionDefinitionId(DEPRECATED_OVM_FIELD_EDITOR);
        this.setAction("OVMFieldEditor", (IAction)a);
        a = new FieldEditorAction(VlogEditorMessages.getResourceBundle(), "UVMFieldEditor.", (ITextEditor)this, false);
        a.setActionDefinitionId(UVM_FIELD_EDITOR);
        this.setAction("UVMFieldEditor", (IAction)a);
        a = new VlogRefactorConnectOutputAction(VlogEditorMessages.getResourceBundle(), "RefactorConnectOutput.", this);
        a.setActionDefinitionId(REFACTOR_CONNECT_OUTPUT);
        this.setAction("RefactorConnectOutput", (IAction)a);
        a = new VlogRefactorConnectInputAction(VlogEditorMessages.getResourceBundle(), "RefactorConnectInput.", this);
        a.setActionDefinitionId(REFACTOR_CONNECT_INPUT);
        this.setAction("RefactorConnectInput", (IAction)a);
        a = new VlogRenameRefactorAction(VlogEditorMessages.getResourceBundle(), "RefactorRename.", this);
        a.setActionDefinitionId(REFACTOR_RENAME);
        this.setAction("RefactorRename", (IAction)a);
        a = new VlogRefactorRenameInFileAction(VlogEditorMessages.getResourceBundle(), "RefactorRenameInFile.", (ITextEditor)this);
        a.setActionDefinitionId(REFACTOR_RENAME_IN_FILE);
        this.setAction("RefactorRenameInFile", (IAction)a);
        a = new VlogRenameAcrossDesignHierarchyRefactorAction(VlogEditorMessages.getResourceBundle(), "RefactorRenameAcrossDesignHierarchy.", this);
        a.setActionDefinitionId(REFACTOR_RENAME_ACROSS_DESIGN_HIERARCHY);
        this.setAction("RefactorRenameAcrossDesignHierarchy", (IAction)a);
        a = new VlogRenameFileEditorAction(VlogEditorMessages.getResourceBundle(), "RefactorRenameFile.", this);
        a.setActionDefinitionId(REFACTOR_RENAME_FILE);
        this.setAction("RefactorRenameFile", (IAction)a);
        a = new VlogRefactorAddPortAction(VlogEditorMessages.getResourceBundle(), "RefactorAddPort.", (ITextEditor)this);
        a.setActionDefinitionId(REFACTOR_ADD_PORT);
        this.setAction("RefactorAddPort", (IAction)a);
        a = new VlogRefactorAddParameterAction(VlogEditorMessages.getResourceBundle(), "RefactorAddParameter.", (ITextEditor)this);
        a.setActionDefinitionId(REFACTOR_ADD_PARAMETER);
        this.setAction("RefactorAddParameter", (IAction)a);
        a = new VlogRefactorForwardImplicitConnectionsAction(VlogEditorMessages.getResourceBundle(), "RefactorForwardImplicitConnections.", (ITextEditor)this);
        a.setActionDefinitionId(REFACTOR_FORWARD_IMPLICIT_CONNECTIONS);
        this.setAction("RefactorForwardImplicitConnections", (IAction)a);
        a = new VlogRefactorExtractToVariableAction(VlogEditorMessages.getResourceBundle(), "RefactorExtractToLocalVariable.", (ITextEditor)this);
        a.setActionDefinitionId(REFACTOR_EXTRACT_TO_LOCAL_VARIABLE);
        this.setAction("RefactorExtractToLocalVariable", (IAction)a);
        a = new VlogRefactorExtractToFunctionAction(VlogEditorMessages.getResourceBundle(), "RefactorExtractToFunction.", (ITextEditor)this);
        a.setActionDefinitionId(REFACTOR_EXTRACT_TO_FUNCTION);
        this.setAction("RefactorExtractToFunction", (IAction)a);
        a = new VlogRefactorExtractToTaskAction(VlogEditorMessages.getResourceBundle(), "RefactorExtractToTask.", (ITextEditor)this);
        a.setActionDefinitionId(REFACTOR_EXTRACT_TO_TASK);
        this.setAction("RefactorExtractToTask", (IAction)a);
        a = new VlogRefactorChangeMethodSignatureAction(VlogEditorMessages.getResourceBundle(), "RefactorChangeMethodSignature.", this);
        a.setActionDefinitionId(REFACTOR_CHANGE_METHOD_SIGNATURE);
        this.setAction("RefactorChangeMethodSignature", (IAction)a);
        a = new VlogRefactorSplitAction(VlogEditorMessages.getResourceBundle(), "RefactorSplit.", (ITextEditor)this);
        a.setActionDefinitionId(REFACTOR_SPLIT);
        this.setAction("RefactorSplit", (IAction)a);
        a = new VlogRefactorExpandDotStarNotationAction(VlogEditorMessages.getResourceBundle(), "RefactorExpandDotStarNotation.", (ITextEditor)this);
        a.setActionDefinitionId(REFACTOR_EXPAND_DOT_STAR_NOTATION);
        this.setAction("RefactorExpandDotStarNotation", (IAction)a);
        a = new VlogRefactorJoinExternAction(VlogEditorMessages.getResourceBundle(), "RefactorJoinExtern.", (ITextEditor)this);
        a.setActionDefinitionId(REFACTOR_JOIN_EXTERN);
        this.setAction("RefactorJoinExtern", (IAction)a);
        a = new VlogRefactorBindByNameMethodCallArg(VlogEditorMessages.getResourceBundle(), "RefactorBindByNameMethodCallArg.", (ITextEditor)this, "Bind method call arguments by name");
        a.setActionDefinitionId(REFACTOR_BIND_BY_NAME_METHOD_CALL_ARGS);
        this.setAction("RefactorBindByNameMethodCallArg", (IAction)a);
        a = new VlogRefactorBindByPositionMethodCallArg(VlogEditorMessages.getResourceBundle(), "RefactorBindByPositionMethodCallArg.", (ITextEditor)this, "Bind method call arguments by position");
        a.setActionDefinitionId(REFACTOR_BIND_BY_POSITION_METHOD_CALL_ARGS);
        this.setAction("RefactorBindByPositionMethodCallArg", (IAction)a);
        a = new VlogRefactorConnectInstancePortsByNameAction(VlogEditorMessages.getResourceBundle(), "RefactorConnectInstancePortsByName.", (ITextEditor)this);
        a.setActionDefinitionId(REFACTOR_CONNECT_INSTNACE_PORTS_BY_NAME);
        this.setAction("RefactorConnectInstancePortsByName", (IAction)a);
        a = new VlogRefactorConnectInstancePortsByPositionAction(VlogEditorMessages.getResourceBundle(), "RefactorConnectInstancePortsByPosition.", (ITextEditor)this);
        a.setActionDefinitionId(REFACTOR_CONNECT_INSTNACE_PORTS_BY_POSITION);
        this.setAction("RefactorConnectInstancePortsByPosition", (IAction)a);
        a = new VlogRefactorMoveSelectionToNewFileAction(VlogEditorMessages.getResourceBundle(), "RefactorMoveSelectionToNewFile.", (ITextEditor)this);
        a.setActionDefinitionId(REFACTOR_MOVE_SELECTION_TO_NEW_FILE);
        this.setAction("RefactorMoveSelectionToNewFile", (IAction)a);
        a = new VlogRefactorExtractToModuleAction(VlogEditorMessages.getResourceBundle(), "RefactorExtractToModule.", (ITextEditor)this);
        a.setActionDefinitionId(REFACTOR_EXTRACT_TO_MODULE);
        this.setAction("RefactorExtractToModule", (IAction)a);
        a = new CopyFileInfoAction(VlogEditorMessages.getResourceBundle(), "CopyFullPath.", (ITextEditor)this, CopyFileInfoKind.COPY_FULL_PATH);
        a.setActionDefinitionId(COPY_FULL_PATH);
        this.setAction("CopyFullPath", (IAction)a);
        a = new CopyFileInfoAction(VlogEditorMessages.getResourceBundle(), "CopyFileName.", (ITextEditor)this, CopyFileInfoKind.COPY_FILE_NAME);
        a.setActionDefinitionId(COPY_FILE_NAME);
        this.setAction("CopyFileName", (IAction)a);
        a = new ShowConstraintsAction(VlogEditorMessages.getResourceBundle(), "ShowConstraints.", (ITextEditor)this);
        a.setActionDefinitionId(SHOW_CONSTRAINTS);
        this.setAction("ShowConstraints", (IAction)a);
        this.showInstancesAction = new ShowInstancesAction(VlogEditorMessages.getResourceBundle(), "ShowInstances.", (ITextEditor)this);
        this.showInstancesAction.setActionDefinitionId(SHOW_INSTANCES);
        this.setAction("ShowInstances", (IAction)this.showInstancesAction);
        this.showInstancesInDHAction = new ShowInstancesInDHAction(VlogEditorMessages.getResourceBundle(), "ShowInstancesInDH.", (ITextEditor)this);
        this.showInstancesInDHAction.setActionDefinitionId(SHOW_INSTANCES_IN_DH);
        this.setAction("ShowInstancesInDH", (IAction)this.showInstancesInDHAction);
        a = new CopyHierarchyPathAction(VlogEditorMessages.getResourceBundle(), "CopyHierarchyPath.", (ITextEditor)this);
        a.setActionDefinitionId(COPY_HIERARCHY_PATH);
        this.setAction("CopyHierarchyPath", (IAction)a);
        a = new GoToPVlogMappedFileAction(VlogEditorMessages.getResourceBundle(), "ShowPVlogMappedFile.", (ITextEditor)this);
        a.setActionDefinitionId(SHOW_PVLOG_MAPPED_FILE);
        this.setAction("ShowPVlogMappedFile", (IAction)a);
        VlogDeleteLineAction action = new VlogDeleteLineAction(VlogEditorMessages.getResourceBundle(), "Editor.DeleteLine.", (ITextEditor)this, 0, false);
        action.setHelpContextId("org.eclipse.ui.DeleteLine_action_context");
        action.setActionDefinitionId("org.eclipse.ui.edit.text.delete.line");
        this.setAction("DeleteLine", (IAction)action);
    }

    private String getSourceMenuLabel() {
        String keyBinding = null;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor(SOURCE_SUBMENU);
        }
        if (keyBinding == null) {
            keyBinding = "";
        }
        return NLS.bind((String)VlogEditorMessages.getString("SourceSubmenu.label"), (Object)keyBinding);
    }

    private String getMacrosMenuLabel() {
        String keyBinding = null;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor(MACROS_SUBMENU);
        }
        if (keyBinding == null) {
            keyBinding = "";
        }
        return NLS.bind((String)VlogEditorMessages.getString("MacrosSubMenu.label"), (Object)keyBinding);
    }

    private String getEmacsMenuLabel() {
        String keyBinding = null;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor(EMACS_SUBMENU);
        }
        if (keyBinding == null) {
            keyBinding = "";
        }
        return NLS.bind((String)VlogEditorMessages.getString("EmacsSubMenu.label"), (Object)keyBinding);
    }

    private String getReferencesMenuLabel() {
        String keyBinding = null;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor(REFERENCES_SUBMENU_COMMAND_ID);
        }
        if (keyBinding == null) {
            keyBinding = "";
        }
        return NLS.bind((String)VlogEditorMessages.getString("ReferencesSubmenu.label"), (Object)keyBinding);
    }

    private String getRefactorMenuLabel() {
        String keyBinding = null;
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
        if (bindingService != null) {
            keyBinding = bindingService.getBestActiveBindingFormattedFor(REFACTOR_SUBMENU);
        }
        if (keyBinding == null) {
            keyBinding = "";
        }
        return NLS.bind((String)VlogEditorMessages.getString("RefactorSubMenu.label"), (Object)keyBinding);
    }

    public void addSourceSubmenuItems(IMenuManager menu) {
        this.addAction(menu, "QuickAssist");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "GoToPairBracket");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "FormatSource");
        this.addAction(menu, "ToggleComment");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "UVMFieldEditor");
        this.addAction(menu, "OverrideMethods");
        this.addAction(menu, "OverrideConstraints");
        this.addAction(menu, "GetterSetter");
    }

    public void addMacrosSubmenuItems(IMenuManager menu) {
        this.addAction(menu, "MacrosExpandOneLevelInline");
        this.addAction(menu, "MacrosExpandAllLevelsInline");
        this.addAction(menu, "MacrosExpandOneLevel");
        this.addAction(menu, "MacrosExpandAllLevels");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "MacrosExpandAllInline");
        this.addAction(menu, "MacrosExpandAll");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "MacrosCollapseInlineExpansion");
        this.addAction(menu, "MacrosCollapseAllInlineExpansions");
    }

    public void addMethodDebugSubmenuItems(IMenuManager menu) {
        this.addAction(menu, "MethodDebugStart");
        this.addAction(menu, "SimDebug");
        this.addAction(menu, "XVMTestDebug");
        this.addAction(menu, "AutoAddTracepoints");
    }

    public void addEmacsSubmenuItems(IMenuManager menu) {
        this.addAction(menu, "EmacsAuto");
        this.addAction(menu, "EmacsDeleteAuto");
        this.addAction(menu, "EmacsInjectAuto");
        this.addAction(menu, "EmacsIndent");
    }

    public void addReferencesSubmenuItems(IMenuManager menu) {
        this.addAction(menu, "ReferencesInWorkspace");
        this.addAction(menu, "ReferencesInProject");
        this.addAction(menu, "ReferencesInFile");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "ReferencesInWorkingSet");
    }

    public void addRefactorSubmenuItems(IMenuManager menu) {
        this.addAction(menu, "RefactorRename");
        this.addAction(menu, "RefactorRenameInFile");
        this.addAction(menu, "RefactorRenameAcrossDesignHierarchy");
        this.addAction(menu, "RefactorRenameFile");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "RefactorAddPort");
        this.addAction(menu, "RefactorAddParameter");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "RefactorForwardImplicitConnections");
        this.addAction(menu, "RefactorExpandDotStarNotation");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "RefactorConnectInstancePortsByName");
        this.addAction(menu, "RefactorConnectInstancePortsByPosition");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "RefactorExtractToLocalVariable");
        this.addAction(menu, "RefactorExtractToFunction");
        this.addAction(menu, "RefactorExtractToTask");
        this.addAction(menu, "RefactorExtractToModule");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "RefactorChangeMethodSignature");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "RefactorSplit");
        this.addAction(menu, "RefactorJoinExtern");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "RefactorBindByNameMethodCallArg");
        this.addAction(menu, "RefactorBindByPositionMethodCallArg");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "RefactorMoveSelectionToNewFile");
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "RefactorConnectOutput");
        this.addAction(menu, "RefactorConnectInput");
    }

    protected void editorContextMenuAboutToShow(IMenuManager menu) {
        MenuManager submenu = new MenuManager("Edit", null, null);
        menu.add((IContributionItem)submenu);
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.CUT);
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.COPY);
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.PASTE);
        submenu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.UNDO);
        this.addAction((IMenuManager)submenu, ITextEditorActionConstants.REDO);
        submenu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)submenu, "CopyFileName");
        this.addAction((IMenuManager)submenu, "CopyFullPath");
        this.addAction((IMenuManager)submenu, "CopyHierarchyPath");
        submenu.add((IContributionItem)new Separator());
        submenu.add((IContributionItem)new EditorEmulationContributionItem(new EditorEmulationAction(false)));
        submenu = new MenuManager("Folding", null, null);
        menu.add((IContributionItem)submenu);
        this.addAction((IMenuManager)submenu, "CollapseAllLevels");
        this.addAction((IMenuManager)submenu, "ShowActivePreprocessing");
        this.addAction((IMenuManager)submenu, "ExpandFirstLevel");
        this.addAction((IMenuManager)submenu, "ExpandAllLevels");
        this.addAction((IMenuManager)submenu, "ToggleExpandScope");
        this.addAction((IMenuManager)submenu, "ToggleCollapseLine");
        this.addAction((IMenuManager)submenu, "DefineFoldingRegion");
        submenu = new MenuManager(this.getMacrosMenuLabel(), null, null);
        menu.add((IContributionItem)submenu);
        this.addMacrosSubmenuItems((IMenuManager)submenu);
        if (XUtils.DVT_ENABLE_SV_INTERP_DEBUG) {
            this.addMethodDebugSubmenuItems(menu);
        }
        this.addWaveSubmenuItems(menu);
        submenu = new MenuManager(this.getSourceMenuLabel(), null, null);
        menu.add((IContributionItem)submenu);
        this.addSourceSubmenuItems((IMenuManager)submenu);
        MenuManager subsubmenu = new MenuManager(this.getEmacsMenuLabel(), null);
        submenu.add((IContributionItem)subsubmenu);
        this.addEmacsSubmenuItems((IMenuManager)subsubmenu);
        submenu = new MenuManager("Show", null, "ro.amiq.dvt.ui.editor.menu.show");
        menu.add((IContributionItem)submenu);
        this.addAction((IMenuManager)submenu, "OpenDeclaration");
        submenu.add((IContributionItem)new Separator());
        submenu.add((IContributionItem)new GroupMarker("ro.amiq.dvt.ui.editor.menu.show.group1"));
        this.addAction((IMenuManager)submenu, "ShowDiagram");
        this.addAction((IMenuManager)submenu, "XShowUVMDiagram");
        submenu.add((IContributionItem)new GroupMarker("ro.amiq.dvt.ui.editor.menu.show.group2"));
        this.addAction((IMenuManager)submenu, "QuickOutline");
        submenu.add((IContributionItem)new GroupMarker("ro.amiq.dvt.ui.editor.menu.show.group3"));
        submenu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)submenu, "ShowConstraints");
        this.addAction((IMenuManager)submenu, "ShowInstances");
        this.addAction((IMenuManager)submenu, "Usages");
        this.addAction((IMenuManager)submenu, "ShowReadersUsages");
        this.addAction((IMenuManager)submenu, "ShowWritersUsages");
        this.addAction((IMenuManager)submenu, "ShowConnectedTLMPorts");
        submenu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)submenu, "ShowInstancesInDH");
        submenu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)submenu, "IncludingFile");
        submenu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)submenu, "ShowPVlogMappedFile");
        menu.add((IContributionItem)new Separator());
        submenu = new MenuManager(this.getReferencesMenuLabel(), null, "ro.amiq.dvt.ui.editor.ReferencesSubMenu");
        menu.add((IContributionItem)submenu);
        this.addReferencesSubmenuItems((IMenuManager)submenu);
        submenu = new MenuManager(this.getRefactorMenuLabel());
        menu.add((IContributionItem)submenu);
        this.addRefactorSubmenuItems((IMenuManager)submenu);
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator("ro.amiq.dvt.ui.editor.menu.debug"));
    }

    private void addWaveSubmenuItems(IMenuManager menu) {
        MenuManager subsubmenu = new MenuManager("Waveform Viewer", null);
        menu.add((IContributionItem)subsubmenu);
        this.addAction((IMenuManager)subsubmenu, "AddToWave");
        menu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)subsubmenu, "AddPortsToWave");
        this.addAction((IMenuManager)subsubmenu, "AddAllSignalsToWave");
        menu.add((IContributionItem)new Separator());
        this.addAction((IMenuManager)subsubmenu, "AddDriversToWave");
        this.addAction((IMenuManager)subsubmenu, "AddLoadsToWave");
        this.addAction((IMenuManager)subsubmenu, "RevealInWaveView");
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{"ro.amiq.vlogdt.vlogEditorScope", "ro.amiq.dvt.ui.vlogVhdlEditorScope", "ro.amiq.dvt.ui.trace.connections.actions.context"});
    }

    public void setFocus() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return;
        }
        if (styledText.isFocusControl()) {
            return;
        }
        super.setFocus();
        if (this.fPropertyChangedEvent) {
            sourceViewer.invalidateTextPresentation();
            this.fPropertyChangedEvent = false;
        }
        if (!PreprocUtils.getInstance().shouldSkipCompilation(this.getProject(), this.getParserPath())) {
            VlogQuickViewersUtil.getInstance().scheduleReparseIfNonTop((ITextEditor)this);
        }
        this.connectFileToDocument(true);
        this.switchPerspective();
        this.sanitizeProposalCache();
        this.resetAutoEditStrategies();
        this.detectIndentation();
    }

    private void sanitizeProposalCache() {
        ParserPath parserPath = this.getParserPath();
        if (parserPath == null) {
            return;
        }
        VlogR2LCache.getInstance().removeDanglingElements(parserPath);
    }

    private void switchPerspective() {
        try {
            boolean disableSwitchPerspective = DVTPlugin.getDefault().getPreferenceStore().getBoolean("ro.amiq.dvt.DISABLE_SWITCH_PERSPECTIVE");
            if (disableSwitchPerspective) {
                return;
            }
            IProject project = this.getProject();
            if (project == null) {
                return;
            }
            IWorkbenchPage activePage = DVTPlugin.getActivePage();
            if (activePage == null) {
                return;
            }
            IPerspectiveDescriptor perspective = activePage.getPerspective();
            if (perspective == null) {
                return;
            }
            if (perspective.getId().equals("ro.amiq.vlogdt.ui.perspectives.VlogPerspective")) {
                return;
            }
            if (project.hasNature("ro.amiq.vlogdt.VlogNature") && (perspective.getId().equals("ro.amiq.edt.ui.perspectives.EDTPerspective") || perspective.getId().equals("ro.amiq.vhdldt.ui.perspectives.VhdlPerspective"))) {
                PlatformUI.getWorkbench().showPerspective("ro.amiq.vlogdt.ui.perspectives.VlogPerspective", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void notifyListeners(int eventType, Event event) {
        this.getSourceViewer().getTextWidget().notifyListeners(eventType, event);
    }

    public ISourceViewer testGetSourceViewer() {
        return this.getSourceViewer();
    }

    public IHyperlinkDetector testGetRfHyperlinkDetector() {
        IHyperlinkDetector[] detectors = this.getSourceViewerConfiguration().getHyperlinkDetectors(this.getSourceViewer());
        int i = 0;
        while (i < detectors.length) {
            if (detectors[i] instanceof VlogRfHyperlinkDetector) {
                return detectors[i];
            }
            ++i;
        }
        return null;
    }

    public IHyperlinkDetector[] testGetAllHyperlinkDetectors() {
        return this.getSourceViewerConfiguration().getHyperlinkDetectors(this.getSourceViewer());
    }

    public int testGetCurrentLine() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        StyledText styledText = sourceViewer.getTextWidget();
        return styledText.getLineAtOffset(styledText.getCaretOffset());
    }

    public int testGetCurrentColumn() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        StyledText styledText = sourceViewer.getTextWidget();
        int line = styledText.getLineAtOffset(styledText.getCaretOffset());
        int offsetAtLine = styledText.getOffsetAtLine(line);
        return styledText.getCaretOffset() - offsetAtLine;
    }

    public VlogSourceViewerConfiguration testGetSourceViewerConfiguration() {
        return (VlogSourceViewerConfiguration)this.getSourceViewerConfiguration();
    }

    public TextEditorAction testGetReferencesInWorkspaceAction() {
        return new ReferencesInWorkspaceAction(VlogEditorMessages.getResourceBundle(), "ReferencesInWorkspace.", (ITextEditor)this);
    }

    public TextEditorAction testGetReferencesInFileAction() {
        return new ReferencesInFileAction(VlogEditorMessages.getResourceBundle(), "ReferencesInFile.", (ITextEditor)this);
    }

    public IBaseShowConstraintsAction testGetShowConstraintsAction() {
        return new ShowConstraintsAction(VlogEditorMessages.getResourceBundle(), "ShowConstraints.", (ITextEditor)this);
    }

    public IBaseShowEmittersAction testGetShowEmittersAction() {
        return null;
    }

    public IReferencesAction testGetShowReadersUsagesAction() {
        return new ShowReadersUsagesAction(VlogEditorMessages.getResourceBundle(), "ShowReaders.", (ITextEditor)this);
    }

    public IReferencesAction testGetShowWritersUsagesAction() {
        return new ShowWritersUsagesAction(VlogEditorMessages.getResourceBundle(), "ShowWriters.", (ITextEditor)this);
    }

    public IRfNamedElementAndScope testGetNamedElementAndScopeAtPosition(int line, int column) {
        RfProject rfProject;
        IDocument document;
        IFile file;
        block11: {
            IProject project;
            block10: {
                block9: {
                    block8: {
                        IEditorInput editorInput;
                        block7: {
                            try {
                                editorInput = this.getEditorInput();
                                if (editorInput != null) break block7;
                                return null;
                            }
                            catch (Exception e) {
                                DVTLogger.INSTANCE.logError((Throwable)e);
                                return null;
                            }
                        }
                        file = (IFile)editorInput.getAdapter(IFile.class);
                        if (file != null) break block8;
                        return null;
                    }
                    project = file.getProject();
                    if (project != null) break block9;
                    return null;
                }
                document = this.getDocument();
                if (document != null) break block10;
                return null;
            }
            rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject != null) break block11;
            return null;
        }
        int offset = document.getLineOffset(line) + column;
        return RfUtils.getRfElement(rfProject, file, document, offset, this);
    }

    public IBaseShowInstancesAction testGetShowInstancesAction() {
        return new ShowInstancesAction(VlogEditorMessages.getResourceBundle(), "ShowInstances.", (ITextEditor)this);
    }

    public CopyHierarchyPathAction testHelpCopyHierarchyWirePathAction() {
        return new CopyHierarchyPathAction(VlogEditorMessages.getResourceBundle(), "CopyHierarchyPath.", (ITextEditor)this);
    }

    public IRfScopeElement getCursorScope() {
        return RfGUIEnclosingScopeUtils.getScope((ITextEditor)this, this.getCursor(), false, true, null);
    }

    protected IPreferenceStore getPluginSpecificPreferenceStore() {
        return VlogPlugin.getDefault().getPreferenceStore();
    }

    public ICompletionProposal[] getContentAssistIncludeProposals(ITextViewer viewer, File[] candidates, int offset, String prefix, boolean addEndQuotes) {
        VlogSourceViewerConfiguration sourceViewerConfiguration = (VlogSourceViewerConfiguration)this.getSourceViewerConfiguration();
        if (sourceViewerConfiguration == null) {
            return null;
        }
        VlogContentAssistProcessorManager sourceProcessorManager = (VlogContentAssistProcessorManager)sourceViewerConfiguration.getSourceProcessorManager();
        if (sourceProcessorManager == null) {
            return null;
        }
        List processors = sourceProcessorManager.getProcessors();
        if (processors == null || ((ArrayList)processors).isEmpty()) {
            return null;
        }
        for (IContentAssistProcessor processor : processors) {
            if (!(processor instanceof RfContentAssistProcessor)) continue;
            return ((RfContentAssistProcessor)processor).getStringIncludeProposals(viewer, candidates, offset, prefix, addEndQuotes);
        }
        return null;
    }

    public void showContentAssistProposalsForCreatedFile() {
        DVTUiUtils.getActiveWorkbenchShell().getDisplay().asyncExec(() -> {
            IContentAssistant contAss = ((VlogSourceViewerConfiguration)this.getSourceViewerConfiguration()).getContentAssistant(this.getSourceViewer());
            contAss.install((ITextViewer)this.getSourceViewer());
            ((VlogSourceViewerConfiguration)this.getSourceViewerConfiguration()).getSourceProcessorManager().showContentAssistPage(IDVTContentAssistConstants.ContentAssistProposalsPage.TEMPLATES.getCode());
            contAss.showPossibleCompletions();
        });
    }

    public void showAutoInstanceProposals() {
        DVTUiUtils.getActiveWorkbenchShell().getDisplay().asyncExec(() -> {
            IContentAssistant contAss = ((VlogSourceViewerConfiguration)this.getSourceViewerConfiguration()).getContentAssistant(this.getSourceViewer());
            contAss.install((ITextViewer)this.getSourceViewer());
            ((VlogSourceViewerConfiguration)this.getSourceViewerConfiguration()).getSourceProcessorManager().showContentAssistPage(IDVTContentAssistConstants.ContentAssistProposalsPage.AUTO_INSTANCE.getCode());
            contAss.showPossibleCompletions();
        });
    }

    public void showAIAssistantProposals() {
        DVTUiUtils.getActiveWorkbenchShell().getDisplay().asyncExec(() -> {
            IContentAssistant contAss = ((VlogSourceViewerConfiguration)this.getSourceViewerConfiguration()).getContentAssistant(this.getSourceViewer());
            contAss.install((ITextViewer)this.getSourceViewer());
            ((VlogSourceViewerConfiguration)this.getSourceViewerConfiguration()).getSourceProcessorManager().showContentAssistPage(IDVTContentAssistConstants.ContentAssistProposalsPage.AI_ASSISTANT.getCode());
            contAss.showPossibleCompletions();
        });
    }

    public boolean isHoverDisabled() {
        return VlogPlugin.getDefault().getPreferenceStore().getBoolean("editor.disable_tool_tips");
    }

    public void installSubmenuActions() {
        this.fHandlerService = (IHandlerService)this.getEditorSite().getService(IHandlerService.class);
        if (this.fHandlerService != null) {
            IHandler handler = new DVTQuickMenuCreator(){

                protected void fillMenu(IMenuManager menu) {
                    VlogEditor.this.addSourceSubmenuItems(menu);
                }
            }.createHandler();
            this.fSubmenuHandlerActivations.put(SOURCE_SUBMENU, this.fHandlerService.activateHandler(SOURCE_SUBMENU, handler));
            handler = new DVTQuickMenuCreator(){

                protected void fillMenu(IMenuManager menu) {
                    VlogEditor.this.addMacrosSubmenuItems(menu);
                }
            }.createHandler();
            this.fSubmenuHandlerActivations.put(MACROS_SUBMENU, this.fHandlerService.activateHandler(MACROS_SUBMENU, handler));
            if (XUtils.DVT_ENABLE_SV_INTERP_DEBUG) {
                handler = new DVTQuickMenuCreator(){

                    protected void fillMenu(IMenuManager menu) {
                        VlogEditor.this.addMethodDebugSubmenuItems(menu);
                    }
                }.createHandler();
                this.fSubmenuHandlerActivations.put(METHOD_DEBUG_SUBMENU, this.fHandlerService.activateHandler(METHOD_DEBUG_SUBMENU, handler));
            }
            handler = new DVTQuickMenuCreator(){

                protected void fillMenu(IMenuManager menu) {
                    VlogEditor.this.addEmacsSubmenuItems(menu);
                }
            }.createHandler();
            this.fSubmenuHandlerActivations.put(EMACS_SUBMENU, this.fHandlerService.activateHandler(EMACS_SUBMENU, handler));
            handler = new DVTQuickMenuCreator(){

                protected void fillMenu(IMenuManager menu) {
                    VlogEditor.this.addReferencesSubmenuItems(menu);
                }
            }.createHandler();
            this.fSubmenuHandlerActivations.put(REFERENCES_SUBMENU_COMMAND_ID, this.fHandlerService.activateHandler(REFERENCES_SUBMENU_COMMAND_ID, handler));
            handler = new DVTQuickMenuCreator(){

                protected void fillMenu(IMenuManager menu) {
                    VlogEditor.this.addRefactorSubmenuItems(menu);
                }
            }.createHandler();
            this.fSubmenuHandlerActivations.put(REFACTOR_SUBMENU, this.fHandlerService.activateHandler(REFACTOR_SUBMENU, handler));
        }
    }

    public void deepClean() {
        this.fCustomGotoMarker = null;
        this.fEditorNotification = null;
        super.deepClean();
    }

    public IRfNamedElement getCursorScopeForBreadcrumb(boolean overrideCache) {
        IRfBreadcrumbElement scopeForBreadcrumb = ((ScopeBreadcrumbUtils)this.getBreadcrumbUtils(ScopeBreadcrumbViewer.class)).getScopeForBreadcrumb((ITextEditor)this, this.getCursor(), overrideCache);
        if (scopeForBreadcrumb instanceof RfDefElement) {
            return ((RfDefElement)scopeForBreadcrumb).getNamedElement();
        }
        return (IRfNamedElement)scopeForBreadcrumb;
    }

    @Override
    public AbstractBreadcrumbUtils getFSBreadcrumbUtils(Class<?> breadcrumbType) {
        if (breadcrumbType == FSBreadcrumbViewer.class) {
            return FSBreadcrumbUtils.getInstance();
        }
        return null;
    }

    public void connectFileToDocument(boolean connectPositionsAfterEditorFocus) {
        try {
            IProject project = this.getProject();
            if (project == null) {
                DVTHlUtils.startHighlight(null, (DVTEditor)this, (DVTSemanticHighlighter)new VlogSemanticHighlighter(this.getDocument()), (AbstractUIPlugin)VlogPlugin.getDefault(), (String)"highlight.semantic");
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            IFile file = (IFile)this.getAdapter(IResource.class);
            if (file == null) {
                ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
            if (parserPath == null) {
                ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            IDocument document = this.getDocument();
            if (document == null) {
                ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
                return;
            }
            if (rfProject != null) {
                rfProject.connectFileToDocument(parserPath, this, connectPositionsAfterEditorFocus, new HashMap<Position, Position>());
            } else {
                ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
            }
            this.updateEditorNotification(parserPath);
            DVTHlUtils.startHighlight((IRfFileDef)(rfProject != null ? rfProject.getFileDefUsingParserPath(parserPath) : null), (DVTEditor)this, (DVTSemanticHighlighter)new VlogSemanticHighlighter(document), (AbstractUIPlugin)VlogPlugin.getDefault(), (String)"highlight.semantic");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void recomputeHighlightPositionsAndInvalidateEditor() {
        IProject project = this.getProject();
        if (project == null) {
            DVTHlUtils.startHighlight(null, (DVTEditor)this, (DVTSemanticHighlighter)new VlogSemanticHighlighter(this.getDocument()), (AbstractUIPlugin)VlogPlugin.getDefault(), (String)"highlight.semantic");
            ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
            return;
        }
        IFile file = (IFile)this.getAdapter(IResource.class);
        if (file == null) {
            ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
            ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
            return;
        }
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
        if (parserPath == null) {
            ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
            ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
            return;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            ObjectionManager.getInstance().clear(Objection.SEMANTIC_HIGHLIGHT);
            ObjectionManager.getInstance().clear(Objection.OVERRIDE_INDICATION);
            return;
        }
        DVTHlUtils.startHighlight((IRfFileDef)rfProject.getFileDefUsingParserPath(parserPath), (DVTEditor)this, (DVTSemanticHighlighter)new VlogSemanticHighlighter(this.getDocument()), (AbstractUIPlugin)VlogPlugin.getDefault(), (String)"highlight.semantic");
    }

    public void updateEditorNotification(ParserPath parserPath) {
        if (!this.isVisible()) {
            return;
        }
        String message = null;
        ArrayList fileInstances = RfMixedLangManager.getInstance().getFileInstances(this.getProject(), parserPath);
        if (fileInstances == null) {
            fileInstances = new ArrayList();
        }
        if (this.isPVlogGeneratedReadOnly(false)) {
            message = "This file is generated (read-only file)";
        }
        for (IDVTFileInstance fileInstance : fileInstances) {
            if (!(fileInstance instanceof VlogFileInstance)) continue;
            ArrayList<String> result = new ArrayList<String>();
            if (((VlogFileInstance)fileInstance).isIncrementalShallowCompiled()) {
                result.add("This file is incremental shallow compiled (certain functionality may be limited)");
            } else if (((VlogFileInstance)fileInstance).isShallowCompiled()) {
                result.add("This file is shallow compiled (certain functionality may be limited)");
            }
            if (((VlogFileInstance)fileInstance).isPrecompiledDbFile()) {
                String precompiledMessage = "This file is precompiled";
                if (((VlogFileInstance)fileInstance).isPrecompiledDbManualFile()) {
                    precompiledMessage = String.valueOf(precompiledMessage) + " (read-only file)";
                }
                result.add(precompiledMessage);
            }
            if (result.isEmpty()) continue;
            message = String.join((CharSequence)"\n", result);
            break;
        }
        if (message == null) {
            if (this.fEditorNotification != null) {
                PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                    this.fEditorNotification.destroy();
                    this.fEditorNotification = null;
                });
            }
            return;
        }
        String notificationMessage = message;
        if (this.fEditorNotification == null) {
            this.fEditorNotification = new PersistentDVTNotification((IDVTNotificationsHost)this, 256, "EDITOR_NOTIFICATION").setText(notificationMessage);
            PlatformUI.getWorkbench().getDisplay().syncExec(() -> this.fEditorNotification.create());
            return;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> this.fEditorNotification.resetText(notificationMessage));
    }

    public QuickLazyOutlineView createQuickOutlineView() {
        return new VlogQuickLazyOutlineView(this);
    }

    public void gotoMarker(IMarker marker) {
        super.gotoMarker(marker);
        this.updateBreadcrumb(marker);
    }

    public DVTLazyOutlinePage getOutlinePage() {
        return this.fOutlinePage;
    }

    public void resetAutoEditStrategies() {
        if (this.dirtyAutoEditStrategy) {
            SourceViewerConfiguration sourceViewerConfiguration = this.getSourceViewerConfiguration();
            if (!(sourceViewerConfiguration instanceof VlogSourceViewerConfiguration)) {
                return;
            }
            String autoEditStrategyPref = VlogPlugin.getDefault().getPreferenceStore().getString("autoindent");
            ((VlogSourceViewerConfiguration)sourceViewerConfiguration).resetAutoEditStrategies(this.getSourceViewer(), autoEditStrategyPref);
        }
    }

    public void setDirtyAutoEditStrategy(boolean dirtyAutoEditStrategy) {
        this.dirtyAutoEditStrategy = dirtyAutoEditStrategy;
    }

    public boolean shouldUseDefaultTabsToSpacesConversion() {
        return !ro.amiq.dvt.ui.preferences.PrefConst.isDetectIndentationEnabled() || !"Advanced".equals(VlogPlugin.getDefault().getPreferenceStore().getString("autoindent"));
    }

    private class CustomGotoMarker
    implements IGotoMarker {
        private CustomGotoMarker() {
        }

        public void gotoMarker(IMarker marker) {
            try {
                String fileName;
                MarkerInfo info = ((Workspace)ResourcesPlugin.getWorkspace()).getMarkerManager().findMarkerInfo(marker.getResource(), marker.getId());
                String string = fileName = info == null ? null : (String)marker.getAttribute("ro.amiq.dvt.file_name");
                if (fileName == null) {
                    ((IGotoMarker)VlogEditor.super.getAdapter(IGotoMarker.class)).gotoMarker(marker);
                } else {
                    int line = (Integer)marker.getAttribute("ro.amiq.dvt.line_number");
                    IFile file = (IFile)VlogEditor.this.getAdapter(IResource.class);
                    if (file != null) {
                        IProject project = file.getProject();
                        if (project == null) {
                            VlogFileUtils.getInstance().openEditor(new File(fileName), line, null);
                        } else {
                            VlogFileUtils.getInstance().openFile(project, fileName, line);
                        }
                    } else {
                        VlogFileUtils.getInstance().openEditor(new File(fileName), line, null);
                    }
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    private class OpenQuickMacro
    extends MacroExpandAction {
        public OpenQuickMacro(ResourceBundle bundle, String prefix, ITextEditor editor) {
            super(bundle, prefix, editor);
            this.setExpandLevel(1);
        }

        @Override
        public void doExpand(String expanded, IDocument document, TextSelection selection) {
            DVTJobsUtils.runWithBusyIndicator(() -> {
                try {
                    if (VlogEditor.this.fMacroPresenter != null) {
                        ((InformationPresenter)VlogEditor.this.fMacroPresenter).setSizeConstraints(50, 20, false, false);
                        IInformationProvider provider = VlogEditor.this.fMacroPresenter.getInformationProvider("__dftl_partition_content_type");
                        ((VlogSourceViewerConfiguration.QuickViewInfoProvider)provider).setDataToShow(expanded.trim());
                        PlatformUI.getWorkbench().getDisplay().syncExec(() -> VlogEditor.this.fMacroPresenter.showInformation());
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            });
        }
    }
}

