/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.preproc.PreprocUtils;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTPairMatcher;
import ro.amiq.dvt.ui.editor.DVTPairMatcherAccessor;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.DVTWordFinder;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.dhbreadcrumb.DHBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathProvider;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.IVlogModule;
import ro.amiq.vlogdt.model.VlogModelManager;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.ui.editor.VlogDHBreadcrumbUtils;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.editor.VlogPairMatcherAccessor;
import ro.amiq.vlogdt.ui.editor.VlogScopeBreadcrumbUtils;
import ro.amiq.vlogdt.ui.editor.VlogSourceViewerConfiguration;
import ro.amiq.vlogdt.ui.editor.VlogVHBreadcrumbUtils;
import ro.amiq.vlogdt.ui.editor.VlogWordFinder;
import ro.amiq.vlogdt.ui.editor.pathmanager.VlogDesignPathProvider;
import ro.amiq.vlogdt.ui.preferences.PrefConst;

public abstract class VlogEditorCommon
extends DVTEditor {
    public static final String ID = "ro.amiq.vlogdt.ui.editor.VlogEditor";

    protected VlogEditorCommon() {
    }

    protected VlogEditorCommon(IDocument document) {
        super(document);
    }

    protected void createEditorConfiguration(VlogEditor editor) {
        VlogSourceViewerConfiguration configuration = new VlogSourceViewerConfiguration(editor, false);
        configuration.setBracketMatcher((ICharacterPairMatcher)DVTPairMatcher.makePairMatcher((LanguageKind)LanguageKind.VLOG, (char[])BRACKETS, (DVTPairMatcherAccessor)new VlogPairMatcherAccessor()));
        this.setSourceViewerConfiguration((SourceViewerConfiguration)configuration);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            super.doSave(monitor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public RfProject getRfProject() {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        return RfManager.getInstance().getRfProject(project);
    }

    protected void disconnectFileFromDocument() {
        try {
            IProject project = this.getProject();
            if (project == null) {
                return;
            }
            IFile file = (IFile)this.getAdapter(IResource.class);
            if (file == null) {
                return;
            }
            ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
            if (parserPath == null) {
                return;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return;
            }
            rfProject.disconnectFileFromDocument(parserPath);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void scheduleReparse(IDocument document, IFile file) {
        IVlogModule module = VlogModelManager.getInstance().getVlogModel().getOrCreateVlogModule(file);
        if (module == null) {
            return;
        }
        module.setDirty(true);
        if (PreprocUtils.getInstance().shouldSkipCompilation(this.getProject(), this.getParserPath())) {
            return;
        }
        boolean isGFile = PreprocUtils.getInstance().isGFile(file);
        if (isGFile && PreprocUtils.getInstance().getPerformedRunOnSaveGMode()) {
            PreprocUtils.getInstance().setPerformedRunOnSaveGMode(false);
            return;
        }
        if (isGFile && PrefConst.isPVlogReadOnlyGEditorEnabled()) {
            return;
        }
        boolean shouldIncrementalBuild = DVTFileUtils.getInstance().shouldIncrementalBuild(document, null, this.getProject());
        if (shouldIncrementalBuild) {
            int buildAutoTime = DVTPlugin.getDefault().getPreferenceStore().getInt("ro.amiq.dvt.TRIGGER_AUTOBUILD_VALUE");
            module.scheduleReparse(false, false, (long)buildAutoTime * 1000L, document, false);
        }
    }

    public DVTWordFinder getWordFinder() {
        return VlogWordFinder.getDefault();
    }

    protected boolean c() {
        return DVTPlugin.getDefault().collect().c(this.getProject(), "F7376");
    }

    public IRfNamedElementAndScope getCursorElement() {
        return this.getCursorElementNonUi(this.getCursor());
    }

    public IRfNamedElementAndScope getCursorElementNonUi(int cursor) {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(rfProject, (ITextEditor)this, this.getDocument(), cursor);
        return namedElementAndScope;
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    public void safelySanityCheckState(IEditorInput input) {
        super.safelySanityCheckState(input);
    }

    public DVTSourceViewerConfiguration makeSourceViewerConfiguration() {
        return new VlogSourceViewerConfiguration(null, false);
    }

    public String getEditorID() {
        return ID;
    }

    public String getCodePartition() {
        return "__vlog_partitioning";
    }

    public IDesignPathProvider getDesignPathProvider() {
        return VlogDesignPathProvider.getInstance();
    }

    public abstract AbstractBreadcrumbUtils getFSBreadcrumbUtils(Class<?> var1);

    public AbstractBreadcrumbUtils getBreadcrumbUtils(Class<?> breadcrumbType) {
        if (breadcrumbType == DHBreadcrumbViewer.class) {
            return VlogDHBreadcrumbUtils.getInstance();
        }
        if (breadcrumbType == VHBreadcrumbViewer.class) {
            return VlogVHBreadcrumbUtils.getInstance();
        }
        if (breadcrumbType == ScopeBreadcrumbViewer.class) {
            return VlogScopeBreadcrumbUtils.getInstance();
        }
        return this.getFSBreadcrumbUtils(breadcrumbType);
    }
}

