/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class VlogPartitionScanner
extends BufferedRuleBasedScanner
implements IPartitionTokenScanner {
    public static final int ML_COMMENT = 0;
    public static final int SL_COMMENT = 1;
    public static final int LITERAL = 2;
    public static final int CODE = 3;
    public static final int CODE_SLASH = 4;
    public static final int ML_COMMENT_STAR = 5;
    public static final int ESCAPED_ID = 6;
    private int fState = 3;
    private int fTokenLength = 0;
    private int fPrefixLength = 0;
    private boolean fBackslash = false;
    private boolean fIgnoreNextNL = false;
    private int fChar = 97;
    private boolean fLimitPartitionLength;

    public VlogPartitionScanner() {
        this.fLimitPartitionLength = true;
    }

    public VlogPartitionScanner(boolean limitPartitionLength) {
        this.fLimitPartitionLength = limitPartitionLength;
    }

    public IToken nextToken() {
        this.fBackslash = false;
        IToken result = this.internalNextToken();
        return result;
    }

    private final IToken internalNextToken() {
        if (this.fTokenOffset >= 0) {
            this.fTokenOffset += this.fTokenLength;
            this.fTokenLength = this.fPrefixLength;
            this.fPrefixLength = 0;
        } else {
            this.fTokenOffset += this.fTokenLength + this.fPrefixLength;
            this.fTokenLength = 0;
            this.fPrefixLength = 0;
        }
        while ((this.fChar = this.read()) != -1) {
            ++this.fTokenLength;
            boolean forceBackslash = false;
            switch (this.fState) {
                case 3: {
                    if (this.fLimitPartitionLength && this.fTokenLength > 2000 && (this.fChar == 13 || this.fChar == 10)) {
                        if (this.fTokenLength - 1 <= 0) break;
                        this.fBackslash = false;
                        --this.fTokenLength;
                        this.fPrefixLength = 1;
                        return new Token((Object)"__dftl_partition_content_type");
                    }
                    if (this.fChar == 47) {
                        this.fState = 4;
                        break;
                    }
                    if (this.fBackslash && !Character.isWhitespace(this.fChar)) {
                        this.fBackslash = false;
                        this.fState = 6;
                        if (this.fTokenLength - 2 <= 0) break;
                        this.fTokenLength -= 2;
                        this.fPrefixLength = 2;
                        return new Token((Object)"__dftl_partition_content_type");
                    }
                    if (this.fChar != 34) break;
                    this.fState = 2;
                    if (this.fTokenLength - 1 <= 0) break;
                    --this.fTokenLength;
                    this.fPrefixLength = 1;
                    return new Token((Object)"__dftl_partition_content_type");
                }
                case 6: {
                    if (!Character.isWhitespace(this.fChar)) break;
                    this.fState = 3;
                    return new Token((Object)"__vlog_escaped_id");
                }
                case 4: {
                    if (this.fChar == 42) {
                        this.fState = 0;
                        if (this.fTokenLength - 2 <= 0) break;
                        this.fTokenLength -= 2;
                        this.fPrefixLength = 2;
                        return new Token((Object)"__dftl_partition_content_type");
                    }
                    if (this.fChar == 47) {
                        this.fState = 1;
                        if (this.fTokenLength - 2 <= 0) break;
                        this.fTokenLength -= 2;
                        this.fPrefixLength = 2;
                        return new Token((Object)"__dftl_partition_content_type");
                    }
                    this.fState = 3;
                    break;
                }
                case 2: {
                    if (this.fLimitPartitionLength && this.fTokenLength > 2000 && (this.fChar == 13 || this.fChar == 10)) {
                        if (this.fTokenLength - 1 <= 0) break;
                        --this.fTokenLength;
                        this.fPrefixLength = 1;
                        return new Token((Object)"__vlog_literal");
                    }
                    if (this.fBackslash) {
                        if (!Character.isWhitespace(this.fChar) || this.fChar == 13 || this.fChar == 10) break;
                        forceBackslash = true;
                        break;
                    }
                    if (this.fChar == 13 || !this.fIgnoreNextNL && this.fChar == 10) {
                        this.fState = 3;
                        if (this.fTokenLength <= 0) break;
                        return new Token((Object)"__vlog_literal");
                    }
                    if (this.fChar != 34 || this.fTokenLength - 1 <= 0) break;
                    this.fState = 3;
                    return new Token((Object)"__vlog_literal");
                }
                case 0: {
                    if (this.fLimitPartitionLength && this.fTokenLength > 2000 && (this.fChar == 13 || this.fChar == 10)) {
                        if (this.fTokenLength - 1 <= 0) break;
                        --this.fTokenLength;
                        this.fPrefixLength = 1;
                        return new Token((Object)"__vlog_ml_comment");
                    }
                    if (this.fChar != 42) break;
                    this.fState = 5;
                    break;
                }
                case 5: {
                    if (this.fChar == 42) break;
                    if (this.fChar == 47) {
                        this.fState = 3;
                        if (this.fTokenLength <= 0) break;
                        return new Token((Object)"__vlog_ml_comment");
                    }
                    this.fState = 0;
                    break;
                }
                case 1: {
                    if (this.fChar != 13 && this.fChar != 10) break;
                    if (this.fChar == 13) {
                        if (this.read() == 10) {
                            ++this.fTokenLength;
                        } else {
                            this.unread();
                        }
                    }
                    this.fState = 3;
                    if (this.fTokenLength <= 0) break;
                    return new Token((Object)"__vlog_sl_comment");
                }
            }
            this.fBackslash = !this.fBackslash && this.fChar == 92 ? true : forceBackslash;
            boolean bl = this.fIgnoreNextNL = this.fChar == 13;
        }
        if (this.fTokenLength > 0) {
            switch (this.fState) {
                case 3: 
                case 4: 
                case 6: {
                    return new Token((Object)"__dftl_partition_content_type");
                }
                case 2: {
                    return new Token((Object)"__vlog_literal");
                }
                case 0: 
                case 5: {
                    return new Token((Object)"__vlog_ml_comment");
                }
            }
            return new Token((Object)"__vlog_sl_comment");
        }
        return Token.EOF;
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        super.setRange(document, offset, length);
        this.fTokenOffset = partitionOffset;
        this.fTokenLength = 0;
        this.fPrefixLength = offset - partitionOffset;
        this.fState = contentType == null ? 3 : (contentType.equals("__dftl_partition_content_type") ? 3 : (contentType.equals("__vlog_literal") ? 2 : (contentType.equals("__vlog_escaped_id") ? 6 : (contentType.equals("__vlog_sl_comment") ? 1 : 0))));
    }

    public void setRange(IDocument document, int offset, int length) {
        super.setRange(document, offset, length);
        this.fTokenOffset = offset;
        this.fPrefixLength = 0;
        this.fTokenLength = 0;
        this.fState = 3;
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public int getTokenOffset() {
        return this.fTokenOffset;
    }
}

