/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfElementFilter;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSerializerRepo;
import ro.amiq.dvt.ui.editor.breadcrumb.IBreadcrumbSerializer;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ActionBlocksTags;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbSerializer;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbViewer;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfConstraint;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHid;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.views.VlogQuickViewersUtil;
import ro.amiq.vlogdt.parser.ReparseInfo;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.ui.editor.VlogScopeBreadcrumbElementFilter;
import ro.amiq.vlogdt.ui.editor.VlogScopeBreadcrumbUtilsCommon;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;
import ro.amiq.vlogdt.ui.preferences.PrefConst;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public class VlogScopeBreadcrumbUtils
extends VlogScopeBreadcrumbUtilsCommon {
    private static VlogScopeBreadcrumbUtils INSTANCE;
    private static final Object SYNC_OBJECT;

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScopeBreadcrumbUtils getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new VlogScopeBreadcrumbUtils();
            }
        }
        return INSTANCE;
    }

    public List<IRfBreadcrumbElement> computeScopeChildren(IRfBreadcrumbElement scope, IProject project, int limit) {
        if (!(scope instanceof IRfScopeElement)) {
            return new ArrayList<IRfBreadcrumbElement>();
        }
        String signature = ((IRfNamedElement)scope).getSignature();
        if (signature != null && signature.equals("ro.amiq.vlogdt.VlogNature")) {
            return new ArrayList<IRfBreadcrumbElement>(this.computeValidLibsOrPacks(project));
        }
        if (scope instanceof RfTypeAlias && ((RfTypeAlias)scope).getTranslatedType() instanceof RfStruct) {
            scope = ((RfTypeAlias)scope).getTranslatedType();
        }
        List<Object> elements = new ArrayList<IRfBreadcrumbElement>();
        VlogScopeBreadcrumbElementFilter elementFilter = new VlogScopeBreadcrumbElementFilter(!(scope instanceof RfActionBlock) && !(scope instanceof RfAssertExpect));
        ((IRfScopeElement)scope).getElementsWithPrefix(elements, "", 2, 1, false, null, (IRfElementFilter)elementFilter);
        if (scope instanceof RfInstance) {
            elements = DesignUtils.getPorts((DesignUtils.DesignRequest)DesignUtils.DesignRequest.of((IRfNamedElement)((IRfNamedElement)scope)), (boolean)false, null);
        }
        if (elements.size() > limit) {
            return elements;
        }
        if (!(scope instanceof RfNamedElement)) {
            return elements;
        }
        this.addActionBlocksAndAsserts(scope, project, limit, elements);
        return elements;
    }

    private void addActionBlocksAndAsserts(IRfBreadcrumbElement scope, IProject project, int limit, List<IRfNamedElement> elements) {
        List<RfActionBlock> actionBlockMembers = ((RfNamedElement)scope).getLocalMembers(RfActionBlock.class);
        if (actionBlockMembers != null && !actionBlockMembers.isEmpty()) {
            List<RfActionBlock> filterActionBlocks = this.filterActionBlocks(elements, actionBlockMembers, project, limit);
            elements.addAll(filterActionBlocks);
        }
        if (elements.size() > limit) {
            return;
        }
        List<RfAssertExpect> assertExpectMembers = ((RfNamedElement)scope).getLocalMembers(RfAssertExpect.class);
        if (assertExpectMembers != null && !assertExpectMembers.isEmpty()) {
            List<RfAssertExpect> filterAssertBlocks = this.filterAssertExpect(elements, assertExpectMembers, project, limit);
            elements.addAll(filterAssertBlocks);
        }
    }

    public List<RfActionBlock> filterActionBlocks(List<IRfNamedElement> elements, List<RfActionBlock> actionBlocks, IProject project, int limit) {
        ArrayList<RfActionBlock> filteredBlocks = new ArrayList<RfActionBlock>();
        for (RfActionBlock block : actionBlocks) {
            RfNamedElement enclosingScope = block.getEnclosingScope();
            if (enclosingScope == null) continue;
            if (block.hasBeginEnd() && enclosingScope instanceof RfActionBlock && ((RfActionBlock)enclosingScope).isFor() && this.isAnonymousElement((IRfBreadcrumbElement)block)) {
                this.addActionBlocksAndAsserts((IRfBreadcrumbElement)block, project, limit, elements);
                continue;
            }
            if (!this.getShowUnnamedActionBlocks() && block.isAnonymous()) {
                this.addActionBlocksAndAsserts((IRfBreadcrumbElement)block, project, limit, elements);
                continue;
            }
            if (VlogScopeBreadcrumbUtils.getInstance().isInsideMacro((Object)block)) continue;
            filteredBlocks.add(block);
        }
        return filteredBlocks;
    }

    public List<RfAssertExpect> filterAssertExpect(List<IRfNamedElement> elements, List<RfAssertExpect> assertExpectBlocks, IProject project, int limit) {
        ArrayList<RfAssertExpect> filteredBlocks = new ArrayList<RfAssertExpect>();
        for (RfAssertExpect block : assertExpectBlocks) {
            if (!this.getShowUnnamedActionBlocks() && block.isAnonymous()) {
                this.addActionBlocksAndAsserts((IRfBreadcrumbElement)block, project, limit, elements);
                continue;
            }
            filteredBlocks.add(block);
        }
        return filteredBlocks;
    }

    protected List<IRfBreadcrumbElement> computeValidLibsOrPacks(IProject project) {
        ArrayList<IRfBreadcrumbElement> validLibs = new ArrayList<IRfBreadcrumbElement>();
        if (project == null) {
            return validLibs;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return validLibs;
        }
        Collection<RfLibrary> rfLibraries = rfProject.getLibraries();
        if (rfLibraries == null || rfLibraries.isEmpty()) {
            return validLibs;
        }
        ArrayList<RfLibrary> libraries = new ArrayList<RfLibrary>(rfLibraries);
        for (RfLibrary lib : libraries) {
            List<RfNamedElement> members;
            if (lib.isNonTopFilesLibrary() && ((members = rfProject.getLocalTypes(lib, false, false, false)) == null || members.isEmpty()) || lib.isPredefined()) continue;
            validLibs.add((IRfBreadcrumbElement)lib);
        }
        return validLibs;
    }

    public String getNameAdditionalInfo(IRfBreadcrumbElement element, boolean isForDropdown) {
        if (!(element instanceof RfStruct)) {
            return null;
        }
        return ((RfStruct)element).getAliasName();
    }

    public boolean isFunction(Object scopeElement) {
        return scopeElement instanceof RfFunction;
    }

    private boolean shouldJumpToImplementation() {
        return PrefConst.getJumpToImplementationFunctionTaskLayerAndSkipExternPrototype();
    }

    public void openElement(IDVTBreadcrumbHost editor, Object scopeElement) {
        if (scopeElement instanceof VlogMacroInfo) {
            RfProject rfProject = ((VlogMacroInfo)scopeElement).getRfProject();
            if (rfProject == null) {
                return;
            }
            RfNamedElementActionHyperlink actionHyperlink = RfUtils.createOpenAction((IRfNamedElement)scopeElement, rfProject.getProject(), null);
            if (actionHyperlink == null) {
                return;
            }
            actionHyperlink.open();
        }
        if (this.isFunction(scopeElement) && this.shouldJumpToImplementation()) {
            scopeElement = ((RfFunction)scopeElement).getImplementation();
            RfDefElement defElement = (RfDefElement)scopeElement;
            RfFileDef defFile = defElement.getDefFile();
            IProject project = defFile.getRfProject().getProject();
            ParserPath parserPath = defFile.getParserPath();
            VlogFileUtils.getInstance().openFile(project, parserPath.path, defElement.getStartLine(), defElement.getName());
            return;
        }
        RfInstance instanceFromBreadcrumb = this.getInstanceFromBreadcrumb(editor);
        if (scopeElement instanceof IRfPortElement && instanceFromBreadcrumb != null) {
            DVTRfUtils.goToPortConnectionOrDeclaration((IRfNamedElement)((IRfNamedElement)scopeElement), (DesignUtils.DesignRequest)DesignUtils.DesignRequest.of((IRfNamedElement)instanceFromBreadcrumb), null, (boolean)true);
            return;
        }
        DVTRfUtils.goToDeclaration((IRfNamedElement)((IRfNamedElement)scopeElement), (boolean)true);
    }

    private RfInstance getInstanceFromBreadcrumb(IDVTBreadcrumbHost editor) {
        AbstractBreadcrumbViewer breadcrumbViewer = editor.getBreadcrumbViewer(ScopeBreadcrumbViewer.class);
        if (!(breadcrumbViewer instanceof ScopeBreadcrumbViewer)) {
            return null;
        }
        IRfBreadcrumbElement leafSegment = ((ScopeBreadcrumbViewer)breadcrumbViewer).getInput().getLeafSegment();
        if (!(leafSegment instanceof RfInstance)) {
            return null;
        }
        return (RfInstance)leafSegment;
    }

    public boolean isInsideMacro(Object element) {
        if (!(element instanceof RfNamedElement)) {
            return false;
        }
        if (this.isMacro(element)) {
            return true;
        }
        RfDefElement declaration = ((RfNamedElement)element).getDeclaration();
        if (declaration == null) {
            return false;
        }
        ReparseInfo reparseInfo = declaration.getReparseInfo();
        return reparseInfo != null;
    }

    public boolean isRootItem(Object element) {
        if (!(element instanceof RfNamedElement)) {
            return false;
        }
        String language = ((IRfNamedElement)element).getSignature();
        return language != null && language.equals("ro.amiq.vlogdt.VlogNature");
    }

    public Image getImage(Object element) {
        if (!(element instanceof RfNamedElement)) {
            return null;
        }
        if (this.isRootItem(element)) {
            return null;
        }
        if (element instanceof IRfActionBlockElement && !(element instanceof RfAssertExpect)) {
            return this.getActionBlockImage((IRfActionBlockElement)element);
        }
        return ((RfNamedElement)element).getImage();
    }

    private Image getActionBlockImage(IRfActionBlockElement element) {
        ActionBlocksTags[] actionBlocksTagsArray = ActionBlocksTags.values();
        int n = actionBlocksTagsArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionBlocksTags actionBlockTag = actionBlocksTagsArray[n2];
            if (element.hasBlockQualifier(actionBlockTag.getValue())) {
                return actionBlockTag.getImage();
            }
            ++n2;
        }
        return null;
    }

    public boolean isLibElement(IRfBreadcrumbElement selectedScope) {
        return selectedScope instanceof IRfLibraryElement;
    }

    public String getLanguageNature() {
        return "ro.amiq.vlogdt.VlogNature";
    }

    public boolean isMacro(Object element) {
        return element instanceof VlogMacroInfo;
    }

    public IRfBreadcrumbElement resolveFunctionHolder(IRfBreadcrumbElement selectedScope) {
        return selectedScope;
    }

    public boolean isLibOrPackage(Object element) {
        return element instanceof IRfLibraryElement;
    }

    public HistoryItem createHistoryItem(IProject project, IRfNamedElement element) {
        return VlogQuickViewersUtil.createViewUpdateEvent(element, project, 0);
    }

    protected IRfNamedElement getTypeHierarchyElement(IRfBreadcrumbElement element) {
        if (element instanceof RfField) {
            element = ((RfField)element).getAssociatedType();
        }
        if (!(element instanceof RfClass) && !(element instanceof RfConstraint)) {
            return null;
        }
        return (IRfNamedElement)element;
    }

    public IBreadcrumbSerializer getBreadcrumbSerializer() {
        return BreadcrumbSerializerRepo.getSerializer((LanguageKind)LanguageKind.VLOG, ScopeBreadcrumbSerializer.class);
    }

    public boolean copyQNExcludeParent(IRfScopeElement elementParent) {
        return elementParent instanceof RfProject;
    }

    public boolean getShowUnnamedActionBlocks() {
        return DVTPlugin.getDefault().getPreferenceStore().getBoolean("show.scope.breadcrumb.unnamed.action.blocks");
    }

    public void setShowUnnamedActionBlocks(boolean value) {
        DVTPlugin.getDefault().getPreferenceStore().setValue("show.scope.breadcrumb.unnamed.action.blocks", !DVTPlugin.getDefault().getPreferenceStore().getBoolean("show.scope.breadcrumb.unnamed.action.blocks"));
    }

    public String getActionBlockName(IRfActionBlockElement element, boolean isForDropDown) {
        if (!element.isAnonymous()) {
            return this.getNamedElementName((RfNamedElement)element, isForDropDown);
        }
        String caseItemName = ActionBlocksTags.CASE_ITEM.getName();
        String blockExpression = this.getBlockExpression(element);
        ActionBlocksTags[] actionBlocksTagsArray = ActionBlocksTags.values();
        int n = actionBlocksTagsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String actionBlockTagName;
            ActionBlocksTags actionBlockTag = actionBlocksTagsArray[n2];
            if (element.hasBlockQualifier(actionBlockTag.getValue()) && (actionBlockTagName = actionBlockTag.getName()) != null) {
                String elementName = actionBlockTagName;
                if (actionBlockTagName.equals(caseItemName) && !isForDropDown) {
                    elementName = String.valueOf(blockExpression) + " " + elementName;
                }
                return this.getAnnonymousElementName((RfNamedElement)element, elementName, isForDropDown);
            }
            ++n2;
        }
        return null;
    }

    private String getBlockExpression(Object element) {
        if (element instanceof RfActionBlock) {
            return this.getActionBlockExpression((IRfActionBlockElement)element);
        }
        if (element instanceof RfAssertExpect) {
            return this.getAssertExpression(element);
        }
        return "";
    }

    private String getActionBlockExpression(IRfActionBlockElement element) {
        String expression = ((RfActionBlock)element).getExpression();
        if (expression == null) {
            return "";
        }
        if (!((RfActionBlock)element).isFor()) {
            return " (" + expression + ")";
        }
        return " " + expression;
    }

    public String getAssertExpectName(Object element, boolean showAdditionalInfo) {
        if (!(element instanceof RfAssertExpect)) {
            return "";
        }
        if (!((RfAssertExpect)element).isAnonymous()) {
            return this.getNamedElementName((RfNamedElement)element, showAdditionalInfo);
        }
        return this.getAnnonymousElementName((RfNamedElement)element, ((RfAssertExpect)element).getKindName(), showAdditionalInfo);
    }

    private String getAssertExpression(Object element) {
        String assertExpression = "";
        IHidObject expression = ((RfAssertExpect)element).getExpression();
        if (expression instanceof RfHid) {
            assertExpression = ((RfHid)expression).getName();
        }
        if (expression instanceof RfHidOperator) {
            assertExpression = expression.toString();
        }
        return " (" + assertExpression + ")";
    }

    private String getNamedElementName(RfNamedElement element, boolean showAdditionalInfo) {
        if (!showAdditionalInfo) {
            return this.trimElementName(element.getName());
        }
        StringBuilder elementName = new StringBuilder();
        if (element.getName() != null) {
            elementName.append(element.getName());
        }
        if (element instanceof RfActionBlock) {
            elementName.append(this.getActionBlockExpression((IRfActionBlockElement)element));
        }
        if (element instanceof RfAssertExpect) {
            elementName.append(this.getAssertExpression(element));
        }
        return this.trimElementName(elementName.toString());
    }

    private String getAnnonymousElementName(RfNamedElement element, String elementName, boolean showAdditionalInfo) {
        if (!showAdditionalInfo) {
            return this.trimElementName(elementName);
        }
        String blockExpression = this.getBlockExpression(element);
        return String.valueOf(this.trimElementName(String.valueOf(elementName) + blockExpression)) + " [line: " + element.getLine() + "]";
    }

    public boolean isAnonymousElement(IRfBreadcrumbElement element) {
        if (!this.isActionBlock(element) && !this.isAssert(element)) {
            return false;
        }
        return ((RfNamedElement)element).isAnonymous();
    }

    public boolean isActionBlock(Object element) {
        return element instanceof RfActionBlock;
    }

    public boolean isAssert(Object element) {
        return element instanceof RfAssertExpect;
    }
}

