/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.DummyScopeBCElement;
import ro.amiq.vlogdt.model.reflection.RfActionBlock;
import ro.amiq.vlogdt.model.reflection.RfActionBlockDef;
import ro.amiq.vlogdt.model.reflection.RfAssertExpect;
import ro.amiq.vlogdt.model.reflection.RfAssertExpectDef;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfCheckerDef;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClassDef;
import ro.amiq.vlogdt.model.reflection.RfConfiguration;
import ro.amiq.vlogdt.model.reflection.RfConfigurationDef;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfCovergroupDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfFunction;
import ro.amiq.vlogdt.model.reflection.RfFunctionDef;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlock;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlockDef;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfInstanceDef;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfInterfaceDef;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfModuleDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackage;
import ro.amiq.vlogdt.model.reflection.RfPackageDef;
import ro.amiq.vlogdt.model.reflection.RfPrimitive;
import ro.amiq.vlogdt.model.reflection.RfPrimitiveDef;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProgramDef;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfTypeAlias;
import ro.amiq.vlogdt.model.reflection.RfTypeAliasDef;
import ro.amiq.vlogdt.parser.VlogMacroInfo;
import ro.amiq.vlogdt.ui.editor.contentassist.PositionalTooltipsNamedElementAndOffsetWrapper;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogParameterHintsUtils;

public abstract class VlogScopeBreadcrumbUtilsCommon
extends ScopeBreadcrumbUtils {
    private static final BreadcrumbSegment LANGUAGE_SEGMENT = new BreadcrumbSegment((IRfBreadcrumbElement)new DummyScopeBCElement("ro.amiq.vlogdt.VlogNature", false));
    private int cachedLine;
    private RfFileDef cachedFileDef;
    private RfNamedElement cachedScope;

    public IRfBreadcrumbElement getScopeForBreadcrumb(ITextEditor editor, int offset, boolean overrideCache) {
        IProject project = this.getProject(editor);
        if (project == null) {
            return null;
        }
        if (!DVTPlugin.getDefault().collect().c(project, "F7376")) {
            return null;
        }
        IDocument document = DVTFileUtils.getInstance().getDocument(editor);
        if (document == null) {
            return null;
        }
        int docLength = document.getLength();
        if (offset < 0 || offset > docLength) {
            return null;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        IFile file = (IFile)editor.getAdapter(IResource.class);
        if (file == null) {
            return null;
        }
        RfFileDef fileDef = rfProject.getFile((IResource)file);
        if (fileDef == null) {
            return null;
        }
        try {
            int line = document.getLineOfOffset(offset);
            if (!overrideCache && this.cachedLine == line && this.cachedFileDef == fileDef && this.cachedScope != null) {
                return this.cachedScope;
            }
            this.cachedLine = line;
            this.cachedFileDef = fileDef;
            Collection<RfDefElement> rfChildren = fileDef.getChildren();
            if (rfChildren == null || rfChildren.isEmpty()) {
                this.cachedScope = fileDef.getNamedElement();
                return this.cachedScope;
            }
            ArrayList<RfDefElement> children = new ArrayList<RfDefElement>(rfChildren);
            RfDefElement scope = this.getScopeRecursiveForBreadcrumb(offset, null, children);
            if (scope == null) {
                this.cachedScope = fileDef.getNamedElement();
                return this.cachedScope;
            }
            this.cachedScope = scope.getNamedElement();
            return this.cachedScope;
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    private RfDefElement getScopeRecursiveForBreadcrumb(int offset, RfDefElement result, Collection<RfDefElement> childList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:760)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IProject getProject(ITextEditor editor) {
        if (editor == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    protected List<BreadcrumbSegment> computeScopeAncestors(AbstractBreadcrumbConfiguration scopeConfig) {
        ArrayList<BreadcrumbSegment> ancestors = new ArrayList<BreadcrumbSegment>();
        if (!(scopeConfig instanceof ScopeBreadcrumbConfiguration)) {
            return ancestors;
        }
        IFile file = ((ScopeBreadcrumbConfiguration)scopeConfig).getFile();
        if (file == null) {
            return ancestors;
        }
        IProject project = file.getProject();
        if (project == null) {
            return ancestors;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return ancestors;
        }
        Object selectedScope = ((ScopeBreadcrumbConfiguration)scopeConfig).getElement();
        if (selectedScope == null) {
            RfNamedElement namedElement;
            RfFileDef fileDef = rfProject.getFile((IResource)file);
            ancestors.add(LANGUAGE_SEGMENT);
            if (fileDef == null) {
                return ancestors;
            }
            RfLibrary enclosingLibrary = fileDef.getEnclosingLibrary();
            if (enclosingLibrary != null) {
                ancestors.add(new BreadcrumbSegment((IRfBreadcrumbElement)enclosingLibrary));
            }
            if ((namedElement = fileDef.getNamedElement()) != null && !namedElement.equals(enclosingLibrary)) {
                ancestors.add(new BreadcrumbSegment((IRfBreadcrumbElement)namedElement));
            }
            return ancestors;
        }
        this.addMacroInfoSegment(scopeConfig, (List<BreadcrumbSegment>)ancestors, file, rfProject, (IRfBreadcrumbElement)selectedScope);
        while (selectedScope != null) {
            if (selectedScope instanceof RfDefElement) {
                selectedScope = ((RfDefElement)selectedScope).getNamedElement();
            }
            if (this.skipUnnamedActionBlock((IRfBreadcrumbElement)selectedScope) || this.removeBeginEndFromFor((IRfBreadcrumbElement)selectedScope)) {
                selectedScope = (IRfBreadcrumbElement)this.getEnclosingScope((IRfBreadcrumbElement)selectedScope);
                continue;
            }
            if (selectedScope instanceof RfLibrary || selectedScope instanceof RfModule || selectedScope instanceof RfProgram || selectedScope instanceof RfInterface || selectedScope instanceof RfChecker || selectedScope instanceof RfCovergroup || selectedScope instanceof RfConfiguration || selectedScope instanceof RfFunction || selectedScope instanceof RfClass || selectedScope instanceof RfPackage || selectedScope instanceof RfTypeAlias || selectedScope instanceof RfGenerateBlock || selectedScope instanceof RfPrimitive || selectedScope instanceof RfInstance || selectedScope instanceof RfActionBlock || selectedScope instanceof RfAssertExpect) {
                ancestors.add(new BreadcrumbSegment(selectedScope));
            }
            selectedScope = (IRfBreadcrumbElement)this.getEnclosingScope((IRfBreadcrumbElement)selectedScope);
        }
        ancestors.add(LANGUAGE_SEGMENT);
        Collections.reverse(ancestors);
        return ancestors;
    }

    private void addMacroInfoSegment(AbstractBreadcrumbConfiguration scopeConfig, List<BreadcrumbSegment> ancestors, IFile file, RfProject rfProject, IRfBreadcrumbElement selectedScope) {
        PositionalTooltipsNamedElementAndOffsetWrapper namedElementAndOffset = this.getNamedElementAtOffset(scopeConfig, file, rfProject, selectedScope);
        if (namedElementAndOffset == null) {
            return;
        }
        RfNamedElement element = namedElementAndOffset.getNamedElement();
        if (!(element instanceof VlogMacroInfo)) {
            return;
        }
        ancestors.add(new BreadcrumbSegment((IRfBreadcrumbElement)element));
        this.addExtraInfoSegment(namedElementAndOffset, element, selectedScope, ancestors);
    }

    private boolean skipUnnamedActionBlock(IRfBreadcrumbElement selectedScope) {
        if (!(selectedScope instanceof RfActionBlock) && !(selectedScope instanceof RfAssertExpect)) {
            return false;
        }
        if (!((RfNamedElement)selectedScope).isAnonymous()) {
            return false;
        }
        return !this.getShowUnnamedActionBlocks();
    }

    private boolean removeBeginEndFromFor(IRfBreadcrumbElement selectedScope) {
        boolean hasBeginEnd;
        if (!(selectedScope instanceof RfActionBlock)) {
            return false;
        }
        RfNamedElement enclosingScope = (RfNamedElement)selectedScope.getEnclosingScope();
        boolean isInsideFor = enclosingScope instanceof RfActionBlock && ((RfActionBlock)enclosingScope).isForOrForeach();
        boolean bl = hasBeginEnd = ((RfActionBlock)selectedScope).hasBeginEnd() && this.isAnonymousElement(selectedScope);
        return isInsideFor && hasBeginEnd;
    }

    private IRfScopeElement getEnclosingScope(IRfBreadcrumbElement selectedScope) {
        IRfScopeElement enclosingScope = selectedScope.getEnclosingScope();
        if (!(enclosingScope instanceof IRfBreadcrumbElement)) {
            return null;
        }
        return enclosingScope;
    }

    private PositionalTooltipsNamedElementAndOffsetWrapper getNamedElementAtOffset(AbstractBreadcrumbConfiguration scopeConfig, IFile file, RfProject rfProject, IRfBreadcrumbElement selectedScope) {
        if (selectedScope instanceof RfLibrary) {
            return null;
        }
        RfFileDef fileDef = rfProject.getFile((IResource)file);
        if (fileDef == null) {
            return null;
        }
        IRfDefElement declaration = ((IRfNamedElement)selectedScope).getDeclaration();
        if (declaration == null) {
            return null;
        }
        int startOffset = declaration.getStartOffset();
        int elementOffset = ((ScopeBreadcrumbConfiguration)scopeConfig).getConfigOffset();
        DVTEditor editor = rfProject.getEditor(fileDef.getParserPath());
        if (editor == null) {
            return null;
        }
        return VlogParameterHintsUtils.getInstance().getNamedElementAndOffsetAtOffset(rfProject, file, editor, elementOffset, startOffset);
    }

    private void addExtraInfoSegment(PositionalTooltipsNamedElementAndOffsetWrapper namedElementAndOffset, RfNamedElement element, IRfBreadcrumbElement selectedScope, List<BreadcrumbSegment> ancestors) {
        int elementStartOffset = namedElementAndOffset.getOffset() - ((VlogMacroInfo)element).getName().length();
        Collection members = ((IRfNamedElement)selectedScope).getMembers(true, true);
        if (members == null) {
            return;
        }
        for (IRfNamedElement member : members) {
            IRfDefElement memberDeclaration = member.getDeclaration();
            if (memberDeclaration == null || !this.getShowUnnamedActionBlocks() || this.isGUIFiltered(member) || member instanceof RfActionBlock && ((RfActionBlock)member).isSimpleBeginEnd() || memberDeclaration.getEndOffset() != elementStartOffset) continue;
            ancestors.add(new BreadcrumbSegment((IRfBreadcrumbElement)member));
        }
    }

    public boolean validateScopeForBreadcrumb(IRfBreadcrumbElement elem) {
        return elem instanceof RfModuleDef || elem instanceof RfProgramDef || elem instanceof RfInterfaceDef || elem instanceof RfCheckerDef || elem instanceof RfCovergroupDef || elem instanceof RfConfigurationDef || elem instanceof RfFunctionDef || elem instanceof RfTypeAliasDef || elem instanceof RfClassDef || elem instanceof RfPackageDef || elem instanceof RfGenerateBlockDef || elem instanceof RfPrimitiveDef || elem instanceof RfInstanceDef || elem instanceof RfActionBlockDef || elem instanceof RfAssertExpectDef;
    }
}

