/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTPresentationReconciler;
import ro.amiq.dvt.ui.editor.DVTSourceViewerConfiguration;
import ro.amiq.dvt.ui.editor.contentasisst.DVTContentAssistProcessorManager;
import ro.amiq.dvt.ui.editor.formatter.DVTContentFormatter;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseCodeFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.strategies.DVTBaseFormattingStrategy;
import ro.amiq.dvt.ui.editor.formatter.strategies.IDVTFormattingStrategy;
import ro.amiq.vlogdt.core.VlogPlugin;
import ro.amiq.vlogdt.ui.editor.VlogCodeScanner;
import ro.amiq.vlogdt.ui.editor.VlogCommentScanner;
import ro.amiq.vlogdt.ui.editor.VlogNonRuleBasedDamagerRepairer;
import ro.amiq.vlogdt.ui.editor.VlogPartitionScanner;
import ro.amiq.vlogdt.ui.editor.VlogReconciler;
import ro.amiq.vlogdt.ui.editor.VlogStyle;
import ro.amiq.vlogdt.ui.editor.contentassist.VlogContentAssistProcessorManager;
import ro.amiq.vlogdt.ui.editor.formatter.VlogCodeFormattingStrategy;
import ro.amiq.vlogdt.ui.editor.formatter.VlogContentFormatter;
import ro.amiq.vlogdt.ui.editor.formatter.VlogEscapedIDFormattingStrategy;
import ro.amiq.vlogdt.ui.editor.formatter.VlogFormattingPreferences;
import ro.amiq.vlogdt.ui.editor.formatter.VlogLiteralFormattingStrategy;
import ro.amiq.vlogdt.ui.editor.formatter.VlogMLCommentFormattingStrategy;
import ro.amiq.vlogdt.ui.editor.formatter.VlogSLCommentFormattingStrategy;
import ro.amiq.vlogdt.ui.preferences.PrefConst;
import ro.amiq.vlogdt.utils.Utils;

public abstract class VlogSourceViewerConfigurationCommon
extends DVTSourceViewerConfiguration {
    protected ITextEditor fEditor;
    protected boolean fIsVerilogAMS;
    protected VlogCodeScanner fCodeScanner;
    protected VlogCommentScanner fCommentScanner;
    protected DVTContentFormatter fFormatter;
    protected ContentAssistant fContentAssistant;
    protected VlogCodeFormattingStrategy fCodeStrategy;
    protected VlogSLCommentFormattingStrategy fSLCommentStrategy;
    protected VlogMLCommentFormattingStrategy fMLCommentStrategy;
    protected VlogLiteralFormattingStrategy fLiteralStrategy;
    protected VlogEscapedIDFormattingStrategy fEscapedIDStrategy;
    protected VlogContentAssistProcessorManager fSourceProcessorManager;
    protected VlogContentAssistProcessorManager fStringProcessorManager;
    protected DVTPresentationReconciler fPresentationReconciler;

    protected VlogSourceViewerConfigurationCommon() {
        super(VlogPlugin.getDefault().getCombinedPreferenceStore());
    }

    protected VlogSourceViewerConfigurationCommon(DVTEditor editor, boolean isVerilogAMS) {
        super(VlogPlugin.getDefault().getCombinedPreferenceStore());
        this.fEditor = editor;
        this.fIsVerilogAMS = isVerilogAMS;
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "__vlog_partitioning";
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        return this.getContentFormatter(sourceViewer, VlogFormattingPreferences.getInstance());
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer, VlogFormattingPreferences formatPreferences) {
        if (this.fFormatter != null) {
            this.fFormatter.dispose();
        }
        this.fFormatter = new VlogContentFormatter(this);
        this.fFormatter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        this.fCodeStrategy = this.getVlogCodeFormattingStrategy(formatPreferences);
        this.fSLCommentStrategy = this.getVlogSLCommentFormattingStrategy(formatPreferences);
        this.fMLCommentStrategy = this.getVlogMLCommentFormattingStrategy(formatPreferences);
        this.fLiteralStrategy = this.getVlogLiteralFormattingStrategy(formatPreferences);
        this.fEscapedIDStrategy = this.getVlogEscapedIDFormattingStrategy(formatPreferences);
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fCodeStrategy, "__dftl_partition_content_type");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fSLCommentStrategy, "__vlog_sl_comment");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fMLCommentStrategy, "__vlog_ml_comment");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fLiteralStrategy, "__vlog_literal");
        this.fFormatter.setFormattingStrategy((IDVTFormattingStrategy)this.fEscapedIDStrategy, "__vlog_escaped_id");
        return this.fFormatter;
    }

    public IPresentationReconciler getPresentationReconciler() {
        return this.getPresentationReconciler(null);
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        if (this.fPresentationReconciler == null) {
            int foldingEnabled;
            this.fPresentationReconciler = new DVTPresentationReconciler();
            this.fPresentationReconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            int nofLines = Utils.getInstance().getCodeFoldingNofLines();
            boolean enable = PrefConst.isCodeFoldingEnabled();
            boolean manualEnable = PrefConst.isManualCodeFoldingEnabled();
            int n = foldingEnabled = !enable ? 0 : nofLines;
            int manualFoldingEnabled = !manualEnable ? 0 : (!enable ? 0 : nofLines);
            this.fPresentationReconciler.setNofLinesFolding(foldingEnabled);
            VlogReconciler dr1 = new VlogReconciler((ITokenScanner)this.getVlogCodeScanner(foldingEnabled), (ITextViewer)sourceViewer);
            this.fPresentationReconciler.setDamager((IPresentationDamager)dr1, "__dftl_partition_content_type");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)dr1, "__dftl_partition_content_type");
            VlogReconciler dr2 = new VlogReconciler((ITokenScanner)this.getVlogCommentScanner(manualFoldingEnabled), (ITextViewer)sourceViewer);
            this.fPresentationReconciler.setDamager((IPresentationDamager)dr2, "__vlog_sl_comment");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)dr2, "__vlog_sl_comment");
            VlogReconciler dr3 = new VlogReconciler((ITokenScanner)this.getVlogCommentScanner(manualFoldingEnabled), (ITextViewer)sourceViewer);
            this.fPresentationReconciler.setDamager((IPresentationDamager)dr3, "__vlog_ml_comment");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)dr3, "__vlog_ml_comment");
            IToken token1 = VlogStyle.getInstance().getToken("highlight.string");
            VlogNonRuleBasedDamagerRepairer ndr1 = new VlogNonRuleBasedDamagerRepairer(token1);
            this.fPresentationReconciler.setDamager((IPresentationDamager)ndr1, "__vlog_literal");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)ndr1, "__vlog_literal");
            IToken token2 = VlogStyle.getInstance().getToken("highlight.escaped_id");
            VlogNonRuleBasedDamagerRepairer ndr2 = new VlogNonRuleBasedDamagerRepairer(token2);
            this.fPresentationReconciler.setDamager((IPresentationDamager)ndr2, "__vlog_escaped_id");
            this.fPresentationReconciler.setRepairer((IPresentationRepairer)ndr2, "__vlog_escaped_id");
        }
        return this.fPresentationReconciler;
    }

    public DVTBaseCodeFormattingStrategy getCodeFormattingStrategy() {
        return this.fCodeStrategy;
    }

    public DVTBaseFormattingStrategy getSLCommentFormattingStrategy() {
        return this.fSLCommentStrategy;
    }

    public DVTContentAssistProcessorManager getSourceProcessorManager() {
        return this.fSourceProcessorManager;
    }

    public void connectCFDocumentPartitioner(IDocument document) {
        if (document == null) {
            return;
        }
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new VlogPartitionScanner(false), new String[]{"__vlog_sl_comment", "__vlog_ml_comment", "__vlog_literal", "__vlog_escaped_id", "__dftl_partition_content_type"});
            extension3.setDocumentPartitioner("__cf_partitioning", (IDocumentPartitioner)partitioner);
            partitioner.connect(document);
        }
    }

    public void disconnectCFDocumentPartitioner(IDocument document) {
        IDocumentExtension3 extension;
        IDocumentPartitioner partitioner;
        if (document == null) {
            return;
        }
        if (document instanceof IDocumentExtension3 && (partitioner = (extension = (IDocumentExtension3)document).getDocumentPartitioner("__cf_partitioning")) != null) {
            partitioner.disconnect();
        }
    }

    public LanguageKind getLanguageKind() {
        return LanguageKind.VLOG;
    }

    public void setupDocumentPartitioner(IDocument document) {
        if (document == null) {
            return;
        }
        if (document instanceof IDocumentExtension3) {
            IDocumentExtension3 extension3 = (IDocumentExtension3)document;
            FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new VlogPartitionScanner(), new String[]{"__vlog_sl_comment", "__vlog_ml_comment", "__vlog_literal", "__vlog_escaped_id", "__dftl_partition_content_type"});
            extension3.setDocumentPartitioner("__vlog_partitioning", (IDocumentPartitioner)partitioner);
            partitioner.connect(document);
        }
    }

    protected abstract VlogCodeScanner getVlogCodeScanner(int var1);

    protected abstract VlogCommentScanner getVlogCommentScanner(int var1);

    protected abstract VlogCodeFormattingStrategy getVlogCodeFormattingStrategy(VlogFormattingPreferences var1);

    protected abstract VlogSLCommentFormattingStrategy getVlogSLCommentFormattingStrategy(VlogFormattingPreferences var1);

    protected abstract VlogMLCommentFormattingStrategy getVlogMLCommentFormattingStrategy(VlogFormattingPreferences var1);

    protected abstract VlogLiteralFormattingStrategy getVlogLiteralFormattingStrategy(VlogFormattingPreferences var1);

    protected abstract VlogEscapedIDFormattingStrategy getVlogEscapedIDFormattingStrategy(VlogFormattingPreferences var1);
}

