/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.DataFormatException;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.vlogdt.core.VlogPlugin;

public class VlogStyle {
    private HashMap<String, Token> fTokenMap = new HashMap();
    private Boolean fSemanticHighlight;
    private Boolean fTemplateIdentifierHighlight;
    private Boolean fXTemplateIdentifierHighlight;
    private HighlightPreferenceListener fPreferenceListener = new HighlightPreferenceListener();
    private IPreferenceStore fStore = VlogPlugin.getDefault().getPreferenceStore();
    private static final Pattern pattern = Pattern.compile(".((color)|(bold)|(italic))");
    private static volatile VlogStyle fInstance;
    private static final Object fSyncInstance;

    static {
        fSyncInstance = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VlogStyle getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new VlogStyle();
            }
        }
        return fInstance;
    }

    public VlogStyle() {
        this.fStore.addPropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
    }

    public void dispose() {
        this.fTokenMap = null;
        this.fStore.removePropertyChangeListener((IPropertyChangeListener)this.fPreferenceListener);
        this.fPreferenceListener = null;
    }

    public boolean isSemanticHighlightEnabled() {
        if (this.fSemanticHighlight != null) {
            return this.fSemanticHighlight;
        }
        IPreferenceStore store = VlogPlugin.getDefault().getPreferenceStore();
        this.fSemanticHighlight = store.getBoolean("highlight.semantic.value");
        return this.fSemanticHighlight;
    }

    public boolean isXTemplateIdentifierHighlightEnabled() {
        if (this.fXTemplateIdentifierHighlight != null) {
            return this.fXTemplateIdentifierHighlight;
        }
        this.fXTemplateIdentifierHighlight = this.fStore.getBoolean("highlight.x_template_id.value");
        return this.fXTemplateIdentifierHighlight;
    }

    public boolean isTemplateIdentifierHighlightEnabled() {
        if (this.fTemplateIdentifierHighlight != null) {
            return this.fTemplateIdentifierHighlight;
        }
        this.fTemplateIdentifierHighlight = this.fStore.getBoolean("highlight.template_id.value");
        return this.fTemplateIdentifierHighlight;
    }

    public void updateTokens() {
        Iterator<Map.Entry<String, Token>> it = this.fTokenMap.entrySet().iterator();
        while (it.hasNext()) {
            IPreferenceStore store = VlogPlugin.getDefault().getPreferenceStore();
            Map.Entry<String, Token> pair = it.next();
            String key = pair.getKey();
            pair.getValue().setData((Object)new TextAttribute(DVTColorUtil.INSTANCE.getColor(PreferenceConverter.getColor((IPreferenceStore)store, (String)(String.valueOf(key) + ".color"))), null, (store.getBoolean(String.valueOf(key) + ".bold") ? 1 : 0) | (store.getBoolean(String.valueOf(key) + ".italic") ? 2 : 0) | (key.contains("highlight.comment_hyperlink") ? 0x40000000 : 0)));
        }
    }

    public IToken getToken(String key) {
        Token res = this.fTokenMap.get(key);
        if (res != null) {
            return res;
        }
        IPreferenceStore store = VlogPlugin.getDefault().getPreferenceStore();
        res = new Token((Object)new TextAttribute(DVTColorUtil.INSTANCE.getColor(PreferenceConverter.getColor((IPreferenceStore)store, (String)(String.valueOf(key) + ".color"))), null, (store.getBoolean(String.valueOf(key) + ".bold") ? 1 : 0) | (store.getBoolean(String.valueOf(key) + ".italic") ? 2 : 0) | (key.contains("highlight.comment_hyperlink") ? 0x40000000 : 0)));
        this.fTokenMap.put(key, res);
        return res;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        String p = event.getProperty();
        String pp = DVTStringUtil.replaceFirst((Pattern)pattern, (CharSequence)p, (String)"");
        if (p.endsWith(".color")) {
            this.adaptColorChange(this.fTokenMap.get(pp), event);
        } else if (p.endsWith(".bold")) {
            this.adaptToStyleChange(this.fTokenMap.get(pp), event, 1);
        } else if (p.endsWith(".italic")) {
            this.adaptToStyleChange(this.fTokenMap.get(pp), event, 2);
        } else if (p.endsWith(".semantic.value")) {
            boolean eventValue = false;
            Object value = event.getNewValue();
            if (value instanceof Boolean) {
                eventValue = (Boolean)value;
            } else if ("true".equals(value)) {
                eventValue = true;
            }
            this.fSemanticHighlight = eventValue;
        } else if (p.endsWith(".x_template_id.value")) {
            boolean eventValue = false;
            Object value = event.getNewValue();
            if (value instanceof Boolean) {
                eventValue = (Boolean)value;
            } else if ("true".equals(value)) {
                eventValue = true;
            }
            this.fXTemplateIdentifierHighlight = eventValue;
        } else if (p.endsWith(".template_id.value")) {
            boolean eventValue = false;
            Object value = event.getNewValue();
            if (value instanceof Boolean) {
                eventValue = (Boolean)value;
            } else if ("true".equals(value)) {
                eventValue = true;
            }
            this.fTemplateIdentifierHighlight = eventValue;
        }
    }

    private void adaptColorChange(Token token, PropertyChangeEvent event) {
        Object data;
        if (token == null) {
            return;
        }
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            try {
                rgb = StringConverter.asRGB((String)((String)value));
            }
            catch (DataFormatException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        if (rgb != null && (data = token.getData()) instanceof TextAttribute) {
            TextAttribute oldAttr = (TextAttribute)data;
            token.setData((Object)new TextAttribute(DVTColorUtil.INSTANCE.getColor(rgb), oldAttr.getBackground(), oldAttr.getStyle()));
        }
    }

    private void adaptToStyleChange(Token token, PropertyChangeEvent event, int styleAttribute) {
        if (token == null) {
            return;
        }
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        Object data = token.getData();
        if (data instanceof TextAttribute) {
            boolean activeValue;
            TextAttribute oldAttr = (TextAttribute)data;
            boolean bl = activeValue = (oldAttr.getStyle() & styleAttribute) == styleAttribute;
            if (activeValue != eventValue) {
                token.setData((Object)new TextAttribute(oldAttr.getForeground(), oldAttr.getBackground(), eventValue ? oldAttr.getStyle() | styleAttribute : oldAttr.getStyle() & ~styleAttribute));
            }
        }
    }

    private class HighlightPreferenceListener
    implements IPropertyChangeListener {
        private HighlightPreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (!event.getProperty().startsWith("highlight")) {
                return;
            }
            VlogStyle.this.adaptToPreferenceChange(event);
        }
    }
}

