/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.diagrams.ch.model.CHUVMComponent;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.breadcrumb.XXVMSerializationWrapper;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbSerializer;
import ro.amiq.vlogdt.interpreter.view.XXVMBuilder;
import ro.amiq.vlogdt.model.reflection.views.RfVHUtils;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmBase;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObject;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObjectInstance;

public class VlogVHBreadcrumbSerializer
extends VHBreadcrumbSerializer {
    private VlogVHBreadcrumbSerializer() {
    }

    public Object computeSerializationObject(List<BreadcrumbSegment> inputSegments) {
        if (inputSegments == null || inputSegments.isEmpty()) {
            return null;
        }
        IRfBreadcrumbElement topElement = inputSegments.get(0).getElement();
        if (topElement instanceof CHUVMComponent) {
            return inputSegments;
        }
        if (topElement instanceof IXXVMComponent) {
            LinkedList<XXVMSerializationWrapper> serializationObject = new LinkedList<XXVMSerializationWrapper>();
            for (BreadcrumbSegment segment : inputSegments) {
                IRfBreadcrumbElement element = segment.getElement();
                if (!(element instanceof IXXVMComponent)) {
                    return null;
                }
                serializationObject.add(new XXVMSerializationWrapper((IXXVMComponent)element));
            }
            return serializationObject;
        }
        if (!(topElement instanceof RfXvmObject)) {
            return null;
        }
        ArrayList<RfXvmObjectInstance> objectInstances = new ArrayList<RfXvmObjectInstance>();
        int i = 1;
        while (i < inputSegments.size()) {
            IRfBreadcrumbElement instanceElement = inputSegments.get(i).getElement();
            if (!(instanceElement instanceof RfXvmObjectInstance)) {
                return null;
            }
            objectInstances.add((RfXvmObjectInstance)instanceElement);
            ++i;
        }
        RfXvmFactory.RfXVMPath rfXvmPath = new RfXvmFactory.RfXVMPath((RfXvmObject)topElement, objectInstances);
        return RfVHUtils.getXVMPath(rfXvmPath);
    }

    public boolean isDirtyInput(List<BreadcrumbSegment> inputSegments) {
        if (inputSegments == null || inputSegments.isEmpty()) {
            return true;
        }
        IXXVMComponent root = XXVMBuilder.INSTANCE.getXVMRootComponent();
        if (root != null) {
            return this.isDirtyXVMElabInput(root, inputSegments);
        }
        for (BreadcrumbSegment inputSegment : inputSegments) {
            IRfBreadcrumbElement element = inputSegment.getElement();
            if (element instanceof CHUVMComponent) continue;
            if (!(element instanceof RfXvmBase)) {
                return true;
            }
            IRfNamedElement namedElement = ((RfXvmBase)element).getNamedElement();
            if (namedElement == null) {
                return true;
            }
            if (!namedElement.hasNoDefs(false)) continue;
            return true;
        }
        return false;
    }

    private boolean isDirtyXVMElabInput(IXXVMComponent root, List<BreadcrumbSegment> inputSegments) {
        if (inputSegments == null || inputSegments.isEmpty()) {
            return true;
        }
        BreadcrumbSegment bcTopSegment = inputSegments.get(0);
        if (bcTopSegment == null) {
            return true;
        }
        IRfBreadcrumbElement bcTopElement = bcTopSegment.getElement();
        if (!(bcTopElement instanceof IXXVMComponent)) {
            return true;
        }
        List children = root.getChildren();
        if (children == null || children.isEmpty()) {
            return true;
        }
        IXXVMComponent currentVHTop = (IXXVMComponent)children.get(0);
        if (currentVHTop == null) {
            return true;
        }
        if (!currentVHTop.equals(bcTopElement)) {
            return true;
        }
        for (BreadcrumbSegment bcSegment : inputSegments) {
            IRfBreadcrumbElement element = bcSegment.getElement();
            if (!(element instanceof IXXVMComponent)) {
                return true;
            }
            IRfNamedElement rfClass = ((IXXVMComponent)element).getRfClass();
            if (rfClass == null) {
                return true;
            }
            if (!rfClass.hasNoDefs(false)) continue;
            return true;
        }
        return false;
    }

    public List<BreadcrumbSegment> restoreBreadcrumbSegments(Object serializedObject, IProject project) {
        if (serializedObject instanceof List) {
            return this.restoreListSerialization((List)serializedObject);
        }
        if (!(serializedObject instanceof RfXvmFactory.XVMPath)) {
            return null;
        }
        IXXVMComponent root = XXVMBuilder.INSTANCE.getXVMRootComponent();
        if (root != null) {
            return null;
        }
        ArrayList<BreadcrumbSegment> inputSegments = new ArrayList<BreadcrumbSegment>();
        ArrayList<RfXvmFactory.XVMPath.XVMPathPoint> points = new ArrayList<RfXvmFactory.XVMPath.XVMPathPoint>(((RfXvmFactory.XVMPath)serializedObject).getPoints());
        int length = points.size();
        while (length > 0) {
            RfXvmFactory.XVMPath path = new RfXvmFactory.XVMPath();
            int i = 0;
            while (i < length) {
                path.addPoint(((RfXvmFactory.XVMPath.XVMPathPoint)points.get(i)).getName(), ((RfXvmFactory.XVMPath.XVMPathPoint)points.get(i)).getType());
                ++i;
            }
            RfXvmBase xvmObject = RfVHUtils.getXVMObject(path, project);
            if (xvmObject == null) {
                return null;
            }
            inputSegments.add(new BreadcrumbSegment((IRfBreadcrumbElement)xvmObject));
            points.remove(--length);
        }
        Collections.reverse(inputSegments);
        return inputSegments;
    }

    private List<BreadcrumbSegment> restoreListSerialization(List<?> serializedObject) {
        if (serializedObject == null || serializedObject.isEmpty()) {
            return null;
        }
        if (serializedObject.get(0) instanceof XXVMSerializationWrapper) {
            return this.restoreXXVMSerialization(serializedObject);
        }
        ArrayList<BreadcrumbSegment> bcSegments = new ArrayList<BreadcrumbSegment>(serializedObject.size());
        for (Object segment : serializedObject) {
            if (!(segment instanceof BreadcrumbSegment)) {
                return null;
            }
            bcSegments.add((BreadcrumbSegment)segment);
        }
        return bcSegments;
    }

    private List<BreadcrumbSegment> restoreXXVMSerialization(List<?> serializedObject) {
        IXXVMComponent root = XXVMBuilder.INSTANCE.getXVMRootComponent();
        if (root == null) {
            return null;
        }
        ArrayList<BreadcrumbSegment> bcSegments = new ArrayList<BreadcrumbSegment>();
        this.internalRestoreXXVMSerialization(root, serializedObject, bcSegments);
        int bcSegmentsSize = bcSegments.size();
        if (bcSegmentsSize == 0 || !serializedObject.isEmpty()) {
            return null;
        }
        return bcSegments;
    }

    private void internalRestoreXXVMSerialization(IXXVMComponent node, List<?> serializedObject, List<BreadcrumbSegment> bcSegments) {
        if (serializedObject.isEmpty()) {
            return;
        }
        Object serializationWrapper = serializedObject.remove(0);
        if (!(serializationWrapper instanceof XXVMSerializationWrapper)) {
            return;
        }
        XXVMSerializationWrapper xxvmSerializationWrapper = (XXVMSerializationWrapper)serializationWrapper;
        String instanceName = xxvmSerializationWrapper.getName();
        String instanceType = xxvmSerializationWrapper.getType();
        if (instanceName == null || instanceType == null) {
            return;
        }
        List children = node.getChildren();
        for (IXXVMComponent child : children) {
            if (child == null) {
                return;
            }
            if (!instanceName.equals(child.getName()) || !instanceType.equals(child.getSVType())) continue;
            bcSegments.add(new BreadcrumbSegment((IRfBreadcrumbElement)child));
            this.internalRestoreXXVMSerialization(child, serializedObject, bcSegments);
            return;
        }
    }
}

