/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.ch.CHDiagram;
import ro.amiq.dvt.diagrams.ch.CHDiagram2;
import ro.amiq.dvt.diagrams.ch.ICHDiagram;
import ro.amiq.dvt.diagrams.ch.editor.CHEditorFactory;
import ro.amiq.dvt.diagrams.ch.model.CHUVMComponent;
import ro.amiq.dvt.diagrams.ch.utils.CHConfig;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorInput;
import ro.amiq.dvt.interpreter.DVTXRunBuildPhaseUtils;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfVHBreadcrumbElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.IVHUtilsContributor;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbUtils;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.tree.TreePath;
import ro.amiq.dvt.ui.views.lazy.tree.utils.TreePathUtils;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHLabelProvider;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.diagrams.chd.VlogCHDiagramHelper;
import ro.amiq.vlogdt.interpreter.view.XXVMBuilder;
import ro.amiq.vlogdt.interpreter.views.verification.hierarchy.XXVMComponent;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.views.RfVHUtils;
import ro.amiq.vlogdt.model.reflection.views.RfVHViewUtils;
import ro.amiq.vlogdt.model.reflection.views.VHXVLOGLabelProvider;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObjectInstance;
import ro.amiq.vlogdt.ui.editor.VlogVHBreadcrumbUtilsCommon;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public class VlogVHBreadcrumbUtils
extends VlogVHBreadcrumbUtilsCommon
implements IVHUtilsContributor {
    private static VlogVHBreadcrumbUtils INSTANCE;
    private static final Object SYNC_OBJECT;
    private IVHLabelProvider xxvmLabelProvider;

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VHBreadcrumbUtils getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new VlogVHBreadcrumbUtils();
            }
        }
        return INSTANCE;
    }

    public void initXVM(IProject project) {
        RfXvmFactory rawFactory = RfVHUtils.getRawXvmFactory(project);
        if (rawFactory == null || !rawFactory.isInitDone()) {
            RfVHUtils.getXvmFactory(project);
        }
    }

    public void openElement(IDVTBreadcrumbHost editor, IProject project, IRfVHBreadcrumbElement vhBCElement, BreadcrumbInput breadcrumbInput) {
        try {
            if (vhBCElement == null) {
                return;
            }
            List segments = breadcrumbInput.getInputSegments();
            if (segments == null) {
                return;
            }
            if (editor instanceof DVTEditor) {
                RfClass targetClass = this.getTargetClass(vhBCElement);
                if (targetClass == null) {
                    return;
                }
                RfDefElement declaration = targetClass.getDeclaration();
                if (declaration == null) {
                    return;
                }
                RfFileDef defFile = declaration.getDefFile();
                if (defFile == null) {
                    if (segments.isEmpty()) {
                        return;
                    }
                    segments.remove(segments.size() - 1);
                    this.openCreate(project, vhBCElement, new BreadcrumbInput(project, segments, this.getBreadcrumbSerializer()));
                    return;
                }
                RfNamedElementActionHyperlink actionHyperlink = RfUtils.createOpenAction(targetClass, project, null);
                if (actionHyperlink == null) {
                    return;
                }
                IResource file = (IResource)defFile.getAdapter(IResource.class);
                if (file == null) {
                    return;
                }
                file.setSessionProperty(IDVTConstants.VH_BREADCRUMB_QN, (Object)breadcrumbInput);
                actionHyperlink.open();
                return;
            }
            if (editor instanceof DDiagramEditor) {
                IDVTElementWrapper wrapper = this.createElementWrapper(project, vhBCElement);
                if (wrapper == null) {
                    return;
                }
                this.setPathForWrapper(wrapper, segments);
                TreePath treePath = TreePathUtils.getTreePathFromBreadcrumb((List)segments, (IVHLabelProvider)this.getVHLabelProvider());
                wrapper.setAdditionalInfo((Object)IDVTElementWrapper.Attribute.TREE_PATH, (Object)treePath);
                DDiagramEditorInput input = ((DDiagramEditor)editor).getInput();
                if (input == null) {
                    return;
                }
                DDiagram diagram = input.getDiagram();
                CHConfig config = new CHConfig(null, LanguageKind.VLOG);
                if (diagram instanceof ICHDiagram) {
                    config = ((ICHDiagram)diagram).getConfig();
                }
                config.setBreadcrumbInput(new BreadcrumbInput(wrapper.getProject(), segments, VlogVHBreadcrumbUtils.getInstance().getBreadcrumbSerializer()));
                if (diagram instanceof CHDiagram) {
                    Object rfElement = wrapper.getRfElement();
                    if (!(rfElement instanceof CHUVMComponent)) {
                        return;
                    }
                    CHEditorFactory.newComponentSubDiagram((ICHDiagram)((ICHDiagram)diagram), (CHUVMComponent)((CHUVMComponent)rfElement), (CHConfig)config, (int)((CHDiagram)diagram).getDepth(), (boolean)((CHDiagram)diagram).isExplicitVifConnections()).openReuseEditor((DDiagramEditor)editor);
                    return;
                }
                VlogCHDiagramHelper.makeComponentDiagramFor(wrapper, project, config);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError(e.getMessage());
        }
    }

    public void openCreate(IProject project, IRfVHBreadcrumbElement element, BreadcrumbInput breadcrumbInput) {
        try {
            if (element instanceof CHUVMComponent) {
                this.openGeneratedCHDCreateCall((CHUVMComponent)element, project);
                return;
            }
            if (element instanceof XXVMComponent) {
                this.openGeneratedXXVMCreateCall((XXVMComponent)element, breadcrumbInput, project);
                return;
            }
            if (!(element instanceof RfXvmObjectInstance)) {
                return;
            }
            List<RfXvmFactory.XVMCreateCall> createCalls = ((RfXvmObjectInstance)element).getCreateCalls();
            if (createCalls == null || createCalls.isEmpty()) {
                return;
            }
            GoToInfo goToInfo = this.getOpenCreateCallGoToInfoXvmObjectInstance(createCalls);
            if (goToInfo == null) {
                return;
            }
            IFile file = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, goToInfo.filePath);
            if (file == null) {
                return;
            }
            file.setSessionProperty(IDVTConstants.VH_BREADCRUMB_QN, (Object)breadcrumbInput);
            RfVHViewUtils.openCreateCall(createCalls, false, project);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError(e.getMessage());
        }
    }

    private void openGeneratedXXVMCreateCall(XXVMComponent element, BreadcrumbInput breadcrumbInput, IProject project) throws CoreException {
        GoToInfo createCall = element.getCreateCallGoToInfo();
        if (createCall == null) {
            return;
        }
        String filePath = createCall.filePath;
        if (filePath == null || filePath.isEmpty()) {
            return;
        }
        IFile file = DVTFileUtils.getInstance().findProjectFileUsingAbsolutePath(project, filePath);
        if (file == null) {
            return;
        }
        file.setSessionProperty(IDVTConstants.VH_BREADCRUMB_QN, (Object)breadcrumbInput);
        createCall.open(project, true);
    }

    private void openGeneratedCHDCreateCall(CHUVMComponent element, IProject project) {
        GoToInfo instanceMarker = element.getInstanceMarker();
        if (instanceMarker == null) {
            return;
        }
        instanceMarker.open(project, true);
    }

    public boolean isInsideMacro(IRfVHBreadcrumbElement element) {
        if (!(element instanceof RfDefElement)) {
            return false;
        }
        return ((RfDefElement)element).hasVirtualOffsets();
    }

    protected BreadcrumbInput getPreservedInput(IDVTBreadcrumbHost editor) {
        return null;
    }

    public VHBreadcrumbUtils getUtils() {
        return this;
    }

    public LanguageKind getNature() {
        return LanguageKind.VLOG;
    }

    public boolean initializeVHBCModel(IProject project) {
        if (project == null) {
            return false;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return false;
        }
        return rfProject.getXvmFactory() != null;
    }

    public String getCHGText(IRfVHBreadcrumbElement element) {
        if (!(element instanceof CHUVMComponent)) {
            return "";
        }
        CHUVMComponent comp = (CHUVMComponent)element;
        String name = comp.getName();
        if (name == null || "".equals(name)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        String type = comp.getType();
        if (type == null || "".equals(type)) {
            return sb.toString();
        }
        sb.append(" : ").append(type);
        return sb.toString();
    }

    public String getXXVMText(IRfVHBreadcrumbElement element) {
        XXVMComponent parent;
        if (!(element instanceof XXVMComponent)) {
            return "";
        }
        XXVMComponent xvhComp = (XXVMComponent)element;
        XXVMComponent xXVMComponent = parent = xvhComp.getParent() instanceof XXVMComponent ? (XXVMComponent)xvhComp.getParent() : null;
        if (parent != null && DVTXRunBuildPhaseUtils.XVM_ROOT.contains(parent.getSVType())) {
            return xvhComp.getTypeName();
        }
        if (xvhComp.getParent() == null) {
            return xvhComp.getTypeName();
        }
        String name = xvhComp.getName();
        if (name == null || "".equals(name)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        String type = xvhComp.getSVType();
        if (type == null || "".equals(type)) {
            return sb.toString();
        }
        sb.append(" : ").append(type);
        return sb.toString();
    }

    public Image getCHGDiagramImage(CHUVMComponent element, boolean forceComponent) {
        if (element == null) {
            return DVTImages.imageCache.getImage(DVTImages.NONE);
        }
        if (forceComponent) {
            return DVTImages.imageCache.getImage(DVTImages.XVM_COMPONENT_INSTANCE);
        }
        if (element.getParent() == null) {
            return DVTImages.imageCache.getImage(DVTImages.XVM_TEST);
        }
        return DVTImages.imageCache.getImage(DVTImages.XVM_COMPONENT_INSTANCE);
    }

    public boolean isXVMElement(RfXvmObjectInstance element) {
        RfField lhField = element.getLHField();
        if (lhField == null) {
            return true;
        }
        IRfNamedElement associatedType = lhField.getAssociatedType();
        if (RfListType.isAssociativeArray((IRfScopeElement)associatedType)) {
            associatedType = ((RfListType)associatedType).getAssociatedType();
        }
        if (!(associatedType instanceof RfClass)) {
            return false;
        }
        return ((VlogVHBreadcrumbUtils)VlogVHBreadcrumbUtils.getInstance()).isXVMComponent((RfClass)associatedType);
    }

    protected IResource getTargetFile(IRfVHBreadcrumbElement element) {
        if (element instanceof XXVMComponent) {
            IRfNamedElement namedElem = ((XXVMComponent)element).getNamedElement();
            if (namedElem == null) {
                return null;
            }
            IRfDefElement declaration = namedElem.getDeclaration();
            if (declaration == null) {
                return null;
            }
            IRfFileDef defFile = declaration.getDefFile();
            if (defFile == null) {
                return null;
            }
            return (IResource)defFile.getAdapter(IResource.class);
        }
        return super.getTargetFile(element);
    }

    public IVHLabelProvider getXxvmLabelProvider() {
        if (this.xxvmLabelProvider == null) {
            this.xxvmLabelProvider = new VHXVLOGLabelProvider();
        }
        return this.xxvmLabelProvider;
    }

    @Override
    protected List<IRfBreadcrumbElement> getVClassesInDiagramEditors(int numberOfClasses, IProject project, IEditorInput editorInput) {
        if (!(editorInput instanceof DDiagramEditorInput)) {
            return null;
        }
        DDiagram diagram = ((DDiagramEditorInput)editorInput).getDiagram();
        if (!(diagram instanceof CHDiagram2)) {
            return null;
        }
        IDVTElementWrapper wrapper = ((CHDiagram2)diagram).getWrapper();
        if (wrapper == null) {
            return null;
        }
        Object element = wrapper.getRfElement();
        if (!(element instanceof IXXVMComponent)) {
            return null;
        }
        ArrayList<IRfBreadcrumbElement> bcElements = new ArrayList<IRfBreadcrumbElement>();
        bcElements.add((IRfBreadcrumbElement)((IXXVMComponent)element));
        return bcElements;
    }

    @Override
    protected BreadcrumbInput computeXVMElabHyperlinkBreadcrumb(IProject project, BreadcrumbInput oldBCInput, RfNamedElementActionHyperlink hyperlinkAction) {
        XXVMComponent root = (XXVMComponent)XXVMBuilder.INSTANCE.getXVMRootComponent();
        if (root == null) {
            return null;
        }
        IRfBreadcrumbElement bcLeaf = oldBCInput.getLeafSegment();
        if (!(bcLeaf instanceof XXVMComponent)) {
            return null;
        }
        XXVMComponent leafComponent = (XXVMComponent)bcLeaf;
        List<IXXVMComponent> childrenComponents = leafComponent.getChildren();
        if (childrenComponents == null) {
            return null;
        }
        IRfNamedElement hyperlinkNamedElem = hyperlinkAction.getRfNamedElement();
        Object hyperlinkMeta = hyperlinkAction.getMeta("ASSOC_TYPE_OF");
        IRegion hyperlinkRegion = hyperlinkAction.getHyperlinkRegion();
        IResource hyperlinkFile = this.getHyperlinkFile(hyperlinkAction.getScope());
        IXXVMComponent toAppend = null;
        for (IXXVMComponent childComponent : childrenComponents) {
            if (childComponent instanceof XXVMComponent && (toAppend = this.checkHyperlinkSegmentByHyperlinkAction(hyperlinkNamedElem, hyperlinkMeta, hyperlinkRegion, hyperlinkFile, childComponent)) != null) break;
        }
        if (toAppend == null) {
            return null;
        }
        BreadcrumbInput newBCInput = new BreadcrumbInput(project, oldBCInput, this.getBreadcrumbSerializer());
        newBCInput.append(toAppend);
        return newBCInput;
    }

    private IResource getHyperlinkFile(IRfScopeElement scopeElement) {
        if (!(scopeElement instanceof IRfDefElement)) {
            return null;
        }
        IRfFileDef defFile = ((IRfDefElement)scopeElement).getDefFile();
        if (defFile == null) {
            return null;
        }
        return (IResource)defFile.getAdapter(IResource.class);
    }

    private IXXVMComponent checkHyperlinkSegmentByHyperlinkAction(IRfNamedElement hyperlinkActionTarget, Object fieldFromMeta, IRegion hyperlinkRegion, IResource hyperlinkFile, IXXVMComponent childComponent) {
        if (hyperlinkActionTarget == null) {
            return null;
        }
        IRfNamedElement candidateRfClass = childComponent.getRfClass();
        if (candidateRfClass == hyperlinkActionTarget && this.validateCandidate(childComponent, fieldFromMeta, hyperlinkRegion, hyperlinkFile)) {
            return childComponent;
        }
        return null;
    }

    private boolean validateCandidate(IXXVMComponent candidateXVMComp, Object fieldFromMeta, IRegion hyperlinkRegion, IResource hyperlinkFile) {
        if (!(fieldFromMeta instanceof RfField)) {
            return this.validateCandidateByCreateCallRegion(candidateXVMComp, hyperlinkRegion, hyperlinkFile) || this.validateCandidateByFieldDeclaration(candidateXVMComp.getNamedElement(), hyperlinkRegion, hyperlinkFile);
        }
        String hyperlinkFieldName = ((RfField)fieldFromMeta).getName();
        if (hyperlinkFieldName == null) {
            return false;
        }
        return hyperlinkFieldName.equals(candidateXVMComp.getName());
    }

    private boolean validateCandidateByCreateCallRegion(IXXVMComponent candidateXVMComp, IRegion hyperlinkRegion, IResource hyperlinkFile) {
        if (!(hyperlinkFile instanceof IFile)) {
            return false;
        }
        if (hyperlinkRegion == null) {
            return false;
        }
        GoToInfo createCallGoToInfo = candidateXVMComp.getCreateCallGoToInfo();
        if (createCallGoToInfo == null) {
            return false;
        }
        int startLine = createCallGoToInfo.line;
        int endLine = createCallGoToInfo.endLine;
        int hyperlinkStartOffset = hyperlinkRegion.getOffset();
        int hyperlinkEndOffset = hyperlinkStartOffset + hyperlinkRegion.getLength() - 1;
        int hyperlinkStartLine = DVTFileUtils.getInstance().getLineFromOffset((IFile)hyperlinkFile, hyperlinkStartOffset);
        int hyperlinkEndLine = DVTFileUtils.getInstance().getLineFromOffset((IFile)hyperlinkFile, hyperlinkEndOffset);
        return startLine <= hyperlinkStartLine && hyperlinkStartLine <= endLine && startLine <= hyperlinkEndLine && hyperlinkEndLine <= endLine;
    }

    private boolean validateCandidateByFieldDeclaration(IRfNamedElement namedElement, IRegion hyperlinkRegion, IResource hyperlinkFile) {
        if (!(hyperlinkFile instanceof IFile)) {
            return false;
        }
        if (namedElement == null) {
            return false;
        }
        IRfDefElement declaration = namedElement.getDeclaration();
        if (declaration == null) {
            return false;
        }
        int startLine = declaration.getStartLine();
        int endLine = declaration.getEndLine();
        int hyperlinkStartOffset = hyperlinkRegion.getOffset();
        int hyperlinkEndOffset = hyperlinkRegion.getOffset() + hyperlinkRegion.getLength() - 1;
        int hyperlinkStartLine = DVTFileUtils.getInstance().getLineFromOffset((IFile)hyperlinkFile, hyperlinkStartOffset);
        int hyperlinkEndLine = DVTFileUtils.getInstance().getLineFromOffset((IFile)hyperlinkFile, hyperlinkEndOffset);
        return startLine <= hyperlinkStartLine && hyperlinkStartLine <= endLine && startLine <= hyperlinkEndLine && hyperlinkEndLine <= endLine;
    }
}

