/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.DDiagram;
import ro.amiq.dvt.diagrams.ch.ICHDiagram;
import ro.amiq.dvt.diagrams.ch.model.CHContainer;
import ro.amiq.dvt.diagrams.ch.model.CHUVMComponent;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorInput;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.interpreter.IXXVMObject;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfVHBreadcrumbElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtilsCommon;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSerializerRepo;
import ro.amiq.dvt.ui.editor.breadcrumb.IBreadcrumbSerializer;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.StopComputeVHBCInstacePathsException;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbInstancePath;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbInstancePathsResult;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbUtils;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHLabelProvider;
import ro.amiq.vlogdt.interpreter.view.XXVMBuilder;
import ro.amiq.vlogdt.interpreter.views.verification.hierarchy.XXVMComponent;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfClassDef;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfFileDef;
import ro.amiq.vlogdt.model.reflection.RfGenerateBlockDef;
import ro.amiq.vlogdt.model.reflection.RfInterfaceDef;
import ro.amiq.vlogdt.model.reflection.RfLibrary;
import ro.amiq.vlogdt.model.reflection.RfListType;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfModuleDef;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfPackageDef;
import ro.amiq.vlogdt.model.reflection.RfProgramDef;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.semantic.extension.RfHidOperator;
import ro.amiq.vlogdt.model.reflection.views.RfTreeElementWrapper;
import ro.amiq.vlogdt.model.reflection.views.RfVHUtils;
import ro.amiq.vlogdt.model.reflection.views.VHLabelProvider;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmBase;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmComponent;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmFactory;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObject;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmObjectInstance;
import ro.amiq.vlogdt.ui.editor.VlogVHBreadcrumbSerializer;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfNamedElementActionHyperlink;

public abstract class VlogVHBreadcrumbUtilsCommon
extends VHBreadcrumbUtils {
    private static final String UVM_COMPONENT = "uvm_component";
    private static final String OVM_COMPONENT = "ovm_component";
    protected IVHLabelProvider vhLabelProvider;

    public IVHLabelProvider getVHLabelProvider() {
        return this.vhLabelProvider == null ? new VHLabelProvider() : this.vhLabelProvider;
    }

    public IDVTElementWrapper createElementWrapper(IProject project, IRfVHBreadcrumbElement element) {
        List<RfXvmObjectInstance> childInstances;
        if (element == null) {
            return null;
        }
        if (element instanceof CHUVMComponent) {
            return this.createCHUVMWrapper((CHUVMComponent)element);
        }
        if (element instanceof XXVMComponent) {
            return this.createXXVMTreeWrapper((XXVMComponent)element, project);
        }
        IRfNamedElement namedElement = element.getNamedElement();
        if (!(namedElement instanceof RfField) && !(namedElement instanceof RfClass)) {
            return null;
        }
        RfXvmObject xvmObject = null;
        RfXvmBase instance = null;
        if (namedElement instanceof RfField) {
            IRfScopeElement fieldClass = namedElement.getEnclosingScope();
            if (!(fieldClass instanceof RfClass)) {
                return null;
            }
            xvmObject = RfVHUtils.getXvmObject(project, (RfClass)fieldClass);
            childInstances = RfXvmFactory.getChildInstances(xvmObject);
            if (childInstances == null) {
                return null;
            }
            for (RfXvmObjectInstance instanceCandidate : childInstances) {
                if (instanceCandidate.getLHField() != namedElement) continue;
                xvmObject = instanceCandidate.getObject();
                instance = instanceCandidate;
                break;
            }
        }
        if (namedElement instanceof RfClass) {
            xvmObject = RfVHUtils.getXvmObject(project, (RfClass)namedElement);
        }
        if (xvmObject == null) {
            return null;
        }
        RfTreeElementWrapper rootTop = new RfTreeElementWrapper(instance != null ? instance : xvmObject);
        childInstances = RfXvmFactory.getChildInstances(xvmObject);
        for (RfXvmObjectInstance chInstance : childInstances) {
            if (!(chInstance.getObject() instanceof RfXvmComponent)) continue;
            rootTop.addChild(new RfTreeElementWrapper(chInstance));
        }
        return rootTop;
    }

    private IDVTElementWrapper createXXVMTreeWrapper(XXVMComponent element, IProject project) {
        DVTTreeElementWrapper xXVMTreeElementWrapper = new DVTTreeElementWrapper((Object)element);
        xXVMTreeElementWrapper.setProject(project);
        IXXVMComponent parent = element.getParent();
        if (parent instanceof XXVMComponent) {
            xXVMTreeElementWrapper.setParent(new DVTTreeElementWrapper((Object)parent));
        }
        List<IXXVMComponent> children = element.getChildren();
        for (IXXVMComponent child : children) {
            if (!(child instanceof XXVMComponent)) continue;
            xXVMTreeElementWrapper.addChild((IDVTElementWrapper)new DVTTreeElementWrapper((Object)child));
        }
        return xXVMTreeElementWrapper;
    }

    private IDVTElementWrapper createCHUVMWrapper(CHUVMComponent element) {
        if (element == null) {
            return null;
        }
        DVTTreeElementWrapper chUVMWrapper = new DVTTreeElementWrapper((Object)element);
        CHContainer parent = element.getParent();
        if (parent instanceof CHUVMComponent) {
            chUVMWrapper.setParent(new DVTTreeElementWrapper((Object)parent));
        }
        List children = element.getChildren();
        for (CHContainer container : children) {
            if (!(container instanceof CHUVMComponent)) continue;
            chUVMWrapper.addChild((IDVTElementWrapper)new DVTTreeElementWrapper((Object)container));
        }
        return chUVMWrapper;
    }

    protected IRfVHBreadcrumbElement getVHElemFromNamedElem(IProject project, IRfNamedElement element) {
        if (!(element instanceof RfField) && !(element instanceof RfClass)) {
            return null;
        }
        if (element instanceof RfField) {
            IRfScopeElement fieldClass = element.getEnclosingScope(RfClass.class);
            if (!(fieldClass instanceof RfClass)) {
                return null;
            }
            RfXvmObject xvmObject = RfVHUtils.getXvmObject(project, (RfClass)fieldClass);
            return RfXvmFactory.findChildInstance(xvmObject, (RfField)element);
        }
        return RfVHUtils.getXvmObject(project, (RfClass)element);
    }

    public boolean validateScopeForBreadcrumb(IRfBreadcrumbElement elem) {
        return elem instanceof RfPackageDef || elem instanceof RfModuleDef || elem instanceof RfInterfaceDef || elem instanceof RfProgramDef || elem instanceof RfGenerateBlockDef;
    }

    public boolean shouldOpenCreate() {
        return true;
    }

    public IBreadcrumbSerializer getBreadcrumbSerializer() {
        return BreadcrumbSerializerRepo.getSerializer((LanguageKind)LanguageKind.VLOG, VlogVHBreadcrumbSerializer.class);
    }

    protected List<IRfBreadcrumbElement> getVClassesInFile(IDVTBreadcrumbHost editor, int numberOfClasses) {
        if (editor == null) {
            return null;
        }
        IProject project = editor.getProject();
        if (project == null) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (!(editorInput instanceof FileEditorInput)) {
            return this.getVClassesInDiagramEditors(numberOfClasses, project, editorInput);
        }
        return this.getVClassesInDVTEditors(numberOfClasses, project, editorInput);
    }

    protected List<IRfBreadcrumbElement> getVClassesInDiagramEditors(int numberOfClasses, IProject project, IEditorInput editorInput) {
        return null;
    }

    private List<IRfBreadcrumbElement> getVClassesInDVTEditors(int numberOfClasses, IProject project, IEditorInput editorInput) {
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        IFile fileEditorInput = ((FileEditorInput)editorInput).getFile();
        RfFileDef fileDef = rfProject.getFile((IResource)fileEditorInput);
        if (fileDef == null) {
            return null;
        }
        Collection<RfDefElement> rfChildren = fileDef.getChildren();
        if (rfChildren == null || rfChildren.isEmpty()) {
            return null;
        }
        ArrayList<RfDefElement> children = new ArrayList<RfDefElement>(rfChildren);
        ArrayList<IRfBreadcrumbElement> vClassesInFile = new ArrayList<IRfBreadcrumbElement>();
        boolean isElabMode = XXVMBuilder.INSTANCE.getXVMRootComponent() != null;
        return this.getClassesRecursive(numberOfClasses, project, children, vClassesInFile, isElabMode);
    }

    private List<IRfBreadcrumbElement> getClassesRecursive(int numberOfClasses, IProject project, Collection<RfDefElement> children, List<IRfBreadcrumbElement> vClassesInFile, boolean isElabMode) {
        if (children == null) {
            return vClassesInFile;
        }
        for (RfDefElement child : children) {
            if (child instanceof RfClassDef) {
                RfClass clazz = (RfClass)child.getNamedElement();
                if (this.isXVMComponent(clazz)) {
                    if (isElabMode) {
                        vClassesInFile.add(this.getXXVMComponent(clazz));
                    } else {
                        vClassesInFile.add(RfVHUtils.getXvmObject(project, clazz));
                    }
                }
                if (vClassesInFile.size() == numberOfClasses) {
                    return vClassesInFile;
                }
            }
            if (!this.validateScopeForBreadcrumb(child)) continue;
            return this.getClassesRecursive(numberOfClasses, project, child.getChildren(), vClassesInFile, isElabMode);
        }
        return vClassesInFile;
    }

    public boolean isXVMComponent(RfClass clazz) {
        while (clazz != null) {
            if (UVM_COMPONENT.equals(clazz.getName()) || OVM_COMPONENT.equals(clazz.getName())) {
                return true;
            }
            clazz = clazz.getParent();
        }
        return false;
    }

    protected IRfBreadcrumbElement getEnclosingClassOrUnit(IRfBreadcrumbElement element) {
        if (element instanceof RfXvmObjectInstance) {
            element = ((RfXvmObjectInstance)element).getLHField();
        } else if (element instanceof RfXvmObject) {
            element = ((RfXvmObject)element).getRfClass();
        }
        if (element instanceof RfField) {
            IRfNamedElement associatedType = ((RfField)element).getAssociatedType();
            if (associatedType instanceof RfClass) {
                return associatedType;
            }
            if (RfListType.isAssociativeArray((IRfScopeElement)associatedType)) {
                return ((RfListType)associatedType).getAssociatedType();
            }
        }
        return element;
    }

    protected String getVElementName(IRfVHBreadcrumbElement element) {
        if (element == null) {
            return "";
        }
        IRfBreadcrumbElement enclosingClassOrUnit = this.getEnclosingClassOrUnit((IRfBreadcrumbElement)element);
        if (enclosingClassOrUnit == null) {
            return "";
        }
        return enclosingClassOrUnit.getName();
    }

    public boolean checkClassesInFile(IDVTBreadcrumbHost editor) {
        if (editor instanceof DVTEditor) {
            IProject project = editor.getProject();
            if (project == null) {
                return false;
            }
            IEditorInput editorInput = editor.getEditorInput();
            if (!(editorInput instanceof FileEditorInput)) {
                return false;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return false;
            }
            IFile fileEditorInput = ((FileEditorInput)editorInput).getFile();
            RfFileDef fileDef = rfProject.getFile((IResource)fileEditorInput);
            if (fileDef == null) {
                return false;
            }
            Collection<RfDefElement> rfChildren = fileDef.getChildren();
            if (rfChildren == null || rfChildren.isEmpty()) {
                return false;
            }
            ArrayList<RfDefElement> children = new ArrayList<RfDefElement>(rfChildren);
            for (RfDefElement child : children) {
                if (!(child instanceof RfClassDef)) continue;
                return true;
            }
            return this.hasVerificationElementsInFile(children);
        }
        if (editor instanceof DDiagramEditor) {
            DDiagramEditor diagramEditor = (DDiagramEditor)editor;
            DDiagramEditorInput diagramEditorInput = diagramEditor.getInput();
            if (diagramEditorInput == null) {
                return false;
            }
            DDiagram diagram = diagramEditorInput.getDiagram();
            return diagram instanceof ICHDiagram;
        }
        return false;
    }

    private boolean hasVerificationElementsInFile(Collection<RfDefElement> children) {
        for (RfDefElement element : children) {
            Collection<RfDefElement> members;
            if (element instanceof RfClassDef) {
                return true;
            }
            if (!this.validateScopeForBreadcrumb(element) || (members = element.getChildren()) == null || members.isEmpty() || !this.hasVerificationElementsInFile(members)) continue;
            return true;
        }
        return false;
    }

    protected void setDummyParent(IDVTElementWrapper wrapper) {
        wrapper.setParent((IDVTElementWrapper)new RfTreeElementWrapper());
    }

    public String getUnitOrComponentLabel() {
        return "UVM components";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public VHBreadcrumbInstancePathsResult computeVHBreadcrumbInstancePaths(IRfBreadcrumbElement root, IRfVHBreadcrumbElement vhBCElement, int limit, IProgressMonitor monitor) {
        VHBreadcrumbInstancePathsResult result = new VHBreadcrumbInstancePathsResult();
        try {
            if (monitor.isCanceled()) {
                return null;
            }
            if (vhBCElement instanceof IXXVMComponent) {
                XXVMComponent verificationRoot = (XXVMComponent)XXVMBuilder.INSTANCE.getXVMRootComponent();
                if (verificationRoot == null) {
                    return null;
                }
                List<IXXVMComponent> children = verificationRoot.getChildren();
                if (children == null) {
                    return null;
                }
                this.computeInterpretedInstancePaths((IRfBreadcrumbElement)children.get(0), (IXXVMComponent)vhBCElement, result, limit, monitor);
                return result;
            }
            if (vhBCElement instanceof CHUVMComponent) {
                this.computeGeneratedCHDInstancePaths(root, (CHUVMComponent)vhBCElement, result, limit, monitor);
                return result;
            }
            if (!(vhBCElement instanceof RfXvmBase)) {
                return result;
            }
            IRfNamedElement namedElement = ((RfXvmBase)vhBCElement).getNamedElement();
            if (namedElement == null) {
                return result;
            }
            IRfSingleLangProject rfProject = namedElement.getRfProject();
            if (rfProject == null) {
                return result;
            }
            RfXvmObject xvmObject = null;
            if (vhBCElement instanceof RfXvmObjectInstance) {
                xvmObject = ((RfXvmObjectInstance)vhBCElement).getObject();
            }
            if (vhBCElement instanceof RfXvmObject) {
                xvmObject = (RfXvmObject)vhBCElement;
            }
            if (xvmObject == null) {
                return result;
            }
            Set<VHBreadcrumbInstancePathsResult> visited = Collections.newSetFromMap(new IdentityHashMap());
            this.internalRecursiveComputeVHBreadcrumbInstancePaths((RfProject)rfProject, xvmObject, new ArrayDeque<RfXvmObjectInstance>(), result, limit, visited, monitor);
            return result;
        }
        catch (StopComputeVHBCInstacePathsException stopComputeVHBCInstacePathsException) {
            return result;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    private void computeInterpretedInstancePaths(IRfBreadcrumbElement root, IXXVMComponent vhBCElement, VHBreadcrumbInstancePathsResult result, int limit, IProgressMonitor monitor) throws StopComputeVHBCInstacePathsException {
        if (vhBCElement == null || !(root instanceof IXXVMComponent)) {
            throw new StopComputeVHBCInstacePathsException();
        }
        if (limit <= 0) {
            throw new StopComputeVHBCInstacePathsException();
        }
        XXVMComponent component = (XXVMComponent)vhBCElement;
        String type = component.getTypeName();
        if (type == null || "".equals(type)) {
            return;
        }
        ArrayDeque<XXVMComponent> partialPath = new ArrayDeque<XXVMComponent>();
        XXVMComponent rootComponent = (XXVMComponent)root;
        this.addInterpretedInstancePaths(rootComponent, rootComponent, partialPath, type, result, limit, monitor);
    }

    private void addInterpretedInstancePaths(XXVMComponent root, XXVMComponent node, ArrayDeque<XXVMComponent> partialPath, String type, VHBreadcrumbInstancePathsResult result, int limit, IProgressMonitor monitor) throws StopComputeVHBCInstacePathsException {
        if (monitor.isCanceled()) {
            return;
        }
        if (type.equals(node.getTypeName())) {
            this.populateInterpretedResult(result, partialPath, root, limit);
            return;
        }
        List<IXXVMComponent> children = node.getChildren();
        for (IXXVMComponent child : children) {
            if (monitor.isCanceled()) {
                return;
            }
            if (!(child instanceof XXVMComponent)) continue;
            XXVMComponent childComp = (XXVMComponent)child;
            partialPath.push(childComp);
            this.addInterpretedInstancePaths(root, childComp, partialPath, type, result, limit, monitor);
            partialPath.pop();
        }
    }

    private void populateInterpretedResult(VHBreadcrumbInstancePathsResult result, ArrayDeque<XXVMComponent> partialPath, XXVMComponent root, int limit) throws StopComputeVHBCInstacePathsException {
        List instancePaths = result.instancePaths;
        if (instancePaths == null) {
            return;
        }
        ArrayList<XXVMComponent> resultPath = new ArrayList<XXVMComponent>(partialPath);
        Collections.reverse(resultPath);
        VHBreadcrumbInstancePath vhBCInstancePath = new VHBreadcrumbInstancePath(resultPath, (IRfVHBreadcrumbElement)root);
        if (instancePaths.contains(vhBCInstancePath)) {
            return;
        }
        instancePaths.add(vhBCInstancePath);
        if (instancePaths.size() >= limit) {
            result.limitExceeded = true;
            throw new StopComputeVHBCInstacePathsException();
        }
    }

    private void computeGeneratedCHDInstancePaths(IRfBreadcrumbElement root, CHUVMComponent vhBCElement, VHBreadcrumbInstancePathsResult result, int limit, IProgressMonitor monitor) throws StopComputeVHBCInstacePathsException {
        if (vhBCElement == null || !(root instanceof CHUVMComponent)) {
            throw new StopComputeVHBCInstacePathsException();
        }
        if (limit <= 0) {
            throw new StopComputeVHBCInstacePathsException();
        }
        String type = vhBCElement.getType();
        if (type == null || "".equals(type)) {
            return;
        }
        CHUVMComponent rootElement = (CHUVMComponent)root;
        ArrayDeque<CHUVMComponent> partialPath = new ArrayDeque<CHUVMComponent>();
        partialPath.add(rootElement);
        this.addGeneratedCHDInstancePaths(rootElement, rootElement, partialPath, type, result, limit, monitor);
    }

    private void addGeneratedCHDInstancePaths(CHUVMComponent root, CHUVMComponent chNode, ArrayDeque<CHUVMComponent> partialPath, String type, VHBreadcrumbInstancePathsResult result, int limit, IProgressMonitor monitor) throws StopComputeVHBCInstacePathsException {
        if (monitor.isCanceled()) {
            return;
        }
        if (type.equals(chNode.getType())) {
            this.populateCHDResult(result, partialPath, root, limit);
            return;
        }
        List children = chNode.getChildren();
        for (CHContainer child : children) {
            if (monitor.isCanceled()) {
                return;
            }
            if (!(child instanceof CHUVMComponent)) continue;
            CHUVMComponent childComp = (CHUVMComponent)child;
            partialPath.push(childComp);
            this.addGeneratedCHDInstancePaths(root, childComp, partialPath, type, result, limit, monitor);
            partialPath.pop();
        }
    }

    private void internalRecursiveComputeVHBreadcrumbInstancePaths(RfProject rfProject, RfXvmObject xvmObject, Deque<RfXvmObjectInstance> partial, VHBreadcrumbInstancePathsResult result, int limit, Set<VHBreadcrumbInstancePathsResult> visited, IProgressMonitor monitor) throws StopComputeVHBCInstacePathsException {
        if (monitor.isCanceled()) {
            return;
        }
        List<RfXvmObjectInstance> instances = this.computeXVMInstances(rfProject, xvmObject, limit, monitor);
        if (instances == null || instances.isEmpty()) {
            VHBreadcrumbInstancePath instancePath = new VHBreadcrumbInstancePath(new ArrayList<RfXvmObjectInstance>(partial), (IRfVHBreadcrumbElement)xvmObject);
            if (result.instancePaths.contains(instancePath)) {
                return;
            }
            result.instancePaths.add(instancePath);
            if (result.instancePaths.size() >= limit) {
                result.limitExceeded = true;
                throw new StopComputeVHBCInstacePathsException();
            }
            return;
        }
        for (RfXvmObjectInstance instance : instances) {
            IRfVHBreadcrumbElement enclosingXvmObject;
            if (monitor.isCanceled()) {
                return;
            }
            IRfScopeElement enclosingScope = instance.getEnclosingScope();
            if (!(enclosingScope instanceof RfClass) || !((enclosingXvmObject = this.getVHElemFromNamedElem(rfProject.getProject(), (RfClass)enclosingScope)) instanceof RfXvmComponent)) continue;
            if (enclosingXvmObject instanceof RfXvmObjectInstance) {
                enclosingXvmObject = ((RfXvmObjectInstance)enclosingXvmObject).getObject();
            }
            if (partial.contains(instance)) continue;
            partial.push(instance);
            this.internalRecursiveComputeVHBreadcrumbInstancePaths(rfProject, (RfXvmObject)enclosingXvmObject, partial, result, limit, visited, monitor);
            partial.pop();
        }
    }

    private void populateCHDResult(VHBreadcrumbInstancePathsResult result, ArrayDeque<CHUVMComponent> partialPath, CHUVMComponent root, int limit) throws StopComputeVHBCInstacePathsException {
        List instancePaths = result.instancePaths;
        if (instancePaths == null) {
            return;
        }
        ArrayList<CHUVMComponent> resultPath = new ArrayList<CHUVMComponent>(partialPath);
        Collections.reverse(resultPath);
        VHBreadcrumbInstancePath vhBCInstancePath = new VHBreadcrumbInstancePath(resultPath, (IRfVHBreadcrumbElement)root);
        if (instancePaths.contains(vhBCInstancePath)) {
            return;
        }
        instancePaths.add(vhBCInstancePath);
        if (instancePaths.size() >= limit) {
            result.limitExceeded = true;
            throw new StopComputeVHBCInstacePathsException();
        }
    }

    public List<RfXvmObjectInstance> computeXVMInstances(RfProject rfProject, RfXvmObject xvmType, int limit, IProgressMonitor monitor) {
        if (xvmType == null) {
            return Collections.emptyList();
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        ArrayList<RfXvmObjectInstance> result = new ArrayList<RfXvmObjectInstance>(0);
        Collection<RfLibrary> rfLibraries = rfProject.getLibraries();
        if (rfLibraries == null || rfLibraries.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<RfLibrary> libraries = new ArrayList<RfLibrary>(rfLibraries);
        if (TestHelper.isTestMode()) {
            libraries = AbstractBreadcrumbUtilsCommon.sort(libraries);
        }
        for (IRfNamedElement iRfNamedElement : libraries) {
            if (monitor.isCanceled()) {
                return Collections.emptyList();
            }
            Collection rfReferences = ((RfLibrary)iRfNamedElement).getReferences(xvmType.getName());
            if (rfReferences == null || rfReferences.isEmpty()) continue;
            if (TestHelper.isTestMode()) {
                rfReferences = AbstractBreadcrumbUtilsCommon.sort(rfReferences);
            }
            Set<IRfNamedElement> references = Collections.newSetFromMap(new IdentityHashMap());
            references.addAll(rfReferences);
            if (TestHelper.isTestMode()) {
                ArrayList<IRfNamedElement> listForTests = new ArrayList<IRfNamedElement>(references);
                references = new LinkedHashSet<IRfNamedElement>(AbstractBreadcrumbUtilsCommon.sort(listForTests));
            }
            for (IRfNamedElement reference : references) {
                if (monitor.isCanceled()) {
                    return Collections.emptyList();
                }
                if (!(reference instanceof RfClass)) continue;
                ((RfNamedElement)reference).accept(rfProject, namedElement -> {
                    if (!(namedElement instanceof RfField)) {
                        return true;
                    }
                    if (namedElement.hasNoDefs(false)) {
                        return true;
                    }
                    IRfVHBreadcrumbElement vhElement = this.getVHElemFromNamedElem(rfProject.getProject(), namedElement);
                    if (!(vhElement instanceof RfXvmObjectInstance)) {
                        return true;
                    }
                    if (!xvmType.equals(((RfXvmObjectInstance)vhElement).getObject())) {
                        return true;
                    }
                    result.add((RfXvmObjectInstance)vhElement);
                    return false;
                });
                if (result.size() < limit) continue;
                return result;
            }
        }
        return result;
    }

    public RfClass getTargetClass(IRfVHBreadcrumbElement vhBCElement) {
        if (vhBCElement instanceof XXVMComponent) {
            IRfNamedElement rfClass = ((XXVMComponent)vhBCElement).getRfClass();
            return rfClass instanceof RfClass ? (RfClass)rfClass : null;
        }
        RfClass targetClass = null;
        if (vhBCElement instanceof RfXvmObject) {
            targetClass = ((RfXvmObject)vhBCElement).getRfClass();
        }
        if (vhBCElement instanceof RfXvmObjectInstance) {
            if ((vhBCElement = ((RfXvmObjectInstance)vhBCElement).getObject()) == null) {
                return null;
            }
            targetClass = ((RfXvmObject)vhBCElement).getRfClass();
        }
        return targetClass;
    }

    public BreadcrumbInput computeHyperlinkBreadcrumb(IProject project, BreadcrumbInput oldBCInput, RfField hyperlinkField, RfNamedElementActionHyperlink hyperlinkAction) {
        BreadcrumbInput xvmBCInput = this.computeXVMElabHyperlinkBreadcrumb(project, oldBCInput, hyperlinkAction);
        if (xvmBCInput != null) {
            return xvmBCInput;
        }
        IRegion hyperlinkRegion = hyperlinkAction.getHyperlinkRegion();
        IRfBreadcrumbElement bcLeaf = oldBCInput.getLeafSegment();
        if (bcLeaf instanceof RfXvmObjectInstance) {
            bcLeaf = ((RfXvmObjectInstance)bcLeaf).getObject();
        }
        if (!(bcLeaf instanceof RfXvmObject)) {
            return null;
        }
        List<RfXvmObjectInstance> bcLeafChildren = RfXvmFactory.getChildInstances((RfXvmObject)bcLeaf);
        if (bcLeafChildren == null || bcLeafChildren.isEmpty()) {
            return null;
        }
        RfXvmObjectInstance toAppend = null;
        for (RfXvmObjectInstance childCandidate : bcLeafChildren) {
            if (hyperlinkField != null && hyperlinkField != childCandidate.getLHField()) continue;
            if (hyperlinkField != null) {
                toAppend = childCandidate;
                break;
            }
            if (!this.isContained(childCandidate.getLHField(), hyperlinkRegion) && !this.isContained(childCandidate.getCreateCalls(), hyperlinkRegion)) continue;
            toAppend = childCandidate;
            break;
        }
        if (toAppend == null) {
            return null;
        }
        BreadcrumbInput newBCInput = new BreadcrumbInput(project, oldBCInput, this.getBreadcrumbSerializer());
        newBCInput.append((IRfBreadcrumbElement)toAppend);
        return newBCInput;
    }

    protected BreadcrumbInput computeXVMElabHyperlinkBreadcrumb(IProject project, BreadcrumbInput oldBCInput, RfNamedElementActionHyperlink hyperlinkAction) {
        return null;
    }

    protected boolean isContained(RfField lhField, IRegion region) {
        if (lhField == null) {
            return false;
        }
        RfDefElement declaration = lhField.getDeclaration();
        if (declaration == null) {
            return false;
        }
        if (declaration.getStartOffset() <= region.getOffset() && declaration.getStartOffset() + declaration.getName().length() >= region.getOffset() + region.getLength()) {
            return true;
        }
        DataType dataType = lhField.getDataType();
        return dataType != null && dataType.getOffset() <= region.getOffset() && dataType.getOffset() + dataType.getType().length() >= region.getOffset() + region.getLength();
    }

    protected boolean isContained(List<RfXvmFactory.XVMCreateCall> createCalls, IRegion region) {
        if (createCalls == null) {
            return false;
        }
        for (RfXvmFactory.XVMCreateCall call : createCalls) {
            if (!(call.call instanceof RfHidOperator) || ((RfHidOperator)call.call).getOpenBoundary() > region.getOffset() || ((RfHidOperator)call.call).getCloseBoundary() < region.getOffset() + region.getLength()) continue;
            return true;
        }
        return false;
    }

    public GoToInfo getOpenCreateCallGoToInfo(IRfVHBreadcrumbElement element) {
        if (element instanceof CHUVMComponent) {
            return ((CHUVMComponent)element).getInstanceMarker();
        }
        if (element instanceof XXVMComponent) {
            return ((XXVMComponent)element).getCreateCallGoToInfo();
        }
        if (!(element instanceof RfXvmObjectInstance)) {
            return null;
        }
        List<RfXvmFactory.XVMCreateCall> createCalls = ((RfXvmObjectInstance)element).getCreateCalls();
        if (createCalls == null || createCalls.isEmpty()) {
            return null;
        }
        return this.getOpenCreateCallGoToInfoXvmObjectInstance(createCalls);
    }

    protected GoToInfo getOpenCreateCallGoToInfoXvmObjectInstance(List<RfXvmFactory.XVMCreateCall> createCalls) {
        RfXvmFactory.XVMCreateCall xvmCreateCall = createCalls.get(createCalls.size() - 1);
        if (xvmCreateCall == null) {
            return null;
        }
        GoToInfo[] goTos = xvmCreateCall.getGoTos();
        if (goTos == null || goTos.length == 0) {
            return null;
        }
        GoToInfo goToInfo = goTos[goTos.length - 1];
        return goToInfo;
    }

    public List<IRfBreadcrumbElement> getPathSegmentsForDiagram(CHContainer component, boolean isSIMGenerated) {
        CHContainer element;
        if (component == null) {
            return Collections.emptyList();
        }
        CHContainer enclosingGate = component.getParent();
        if (component.getParent() == null) {
            return Collections.emptyList();
        }
        Object object = element = isSIMGenerated ? component : component.getWrapper().getRfElement();
        if (!(element instanceof IRfBreadcrumbElement)) {
            return Collections.emptyList();
        }
        ArrayList<IRfBreadcrumbElement> result = new ArrayList<IRfBreadcrumbElement>();
        result.add((IRfBreadcrumbElement)element);
        result.addAll(this.getPathSegmentsForDiagram(enclosingGate, isSIMGenerated));
        return result;
    }

    protected IRfBreadcrumbElement getXXVMComponent(RfClass clazz) {
        XXVMComponent root = (XXVMComponent)XXVMBuilder.INSTANCE.getXVMRootComponent();
        if (root == null) {
            return null;
        }
        return this.getXXVMComponentInternal(clazz, root);
    }

    private IRfBreadcrumbElement getXXVMComponentInternal(RfClass clazz, IXXVMComponent root) {
        List children = root.getChildren();
        if (children == null || children.isEmpty()) {
            return null;
        }
        for (IXXVMComponent child : children) {
            IRfNamedElement childElement = child.getRfClass();
            if (childElement instanceof RfClass) {
                childElement = ((RfClass)childElement).getGenericClass();
            }
            if (childElement.equals(clazz)) {
                return child;
            }
            IRfBreadcrumbElement foundXXVMComponent = this.getXXVMComponentInternal(clazz, child);
            if (foundXXVMComponent == null) continue;
            return foundXXVMComponent;
        }
        return null;
    }

    public boolean checkClassExistsInFile(IProject project, IFile file, IRfNamedElement clazz) {
        IRfSingleLangProject rfProject = RfMixedLangManager.getInstance().getRfSingleLangProject(project, "ro.amiq.vlogdt.VlogNature", false);
        if (rfProject == null) {
            return false;
        }
        RfFileDef fileDef = ((RfProject)rfProject).getFile((IResource)file);
        if (fileDef == null) {
            return false;
        }
        Collection<RfDefElement> rfChildren = fileDef.getChildren();
        for (RfDefElement child : rfChildren) {
            if (!(child instanceof RfClassDef) || clazz != child.getNamedElement()) continue;
            return true;
        }
        return false;
    }

    public IXXVMObject findFirstXVMComponentOccurence(IXXVMObject root, String elementName) {
        if (elementName == null || root == null) {
            return null;
        }
        List<IXXVMComponent> children = ((XXVMComponent)root).getChildren();
        if (children == null) {
            return null;
        }
        for (IXXVMComponent child : children) {
            if (elementName.equals(child.getName()) || elementName.equals(child.getRfClass().getName())) {
                return child;
            }
            IXXVMObject foundXXVMComponent = this.findFirstXVMComponentOccurence((IXXVMObject)child, elementName);
            if (foundXXVMComponent == null) continue;
            return foundXXVMComponent;
        }
        return null;
    }
}

