/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTCharacterScanner;
import ro.amiq.dvt.ui.editor.DVTWordFinder;
import ro.amiq.dvt.utils.DVTStringBuilder;
import ro.amiq.vlogdt.ui.editor.WordAtOffsetInfo;

public class VlogWordFinder
extends DVTWordFinder {
    private static VlogWordFinder fVlogWordFinder;

    public static VlogWordFinder getDefault() {
        if (fVlogWordFinder == null) {
            fVlogWordFinder = new VlogWordFinder();
        }
        return fVlogWordFinder;
    }

    public IRegion getWordAtOffset(IDocument document, int offset) {
        return this.getWordAtOffset(document, offset, false);
    }

    public WordAtOffsetInfo getWordStringAndRegionAtOffset(IDocument document, int offset) {
        return this.getWordStringAndRegionAtOffset(document, offset, false);
    }

    public IRegion getWordAtOffset(IDocument document, int offset, boolean enableNumerics) {
        return this.getWordAtOffset(document, offset, enableNumerics, "");
    }

    public WordAtOffsetInfo getWordStringAndRegionAtOffset(IDocument document, int offset, boolean enableNumerics) {
        return this.getWordStringAndRegionAtOffset(document, offset, enableNumerics, "");
    }

    public IRegion getWordAtOffset(IDocument document, int offset, String customChars) {
        return this.getWordAtOffset(document, offset, false, customChars);
    }

    public WordAtOffsetInfo getWordStringAndRegionAtOffset(IDocument document, int offset, String customChars) {
        return this.getWordStringAndRegionAtOffset(document, offset, false, customChars);
    }

    public IRegion getWordAtOffset(IDocument document, int offset, boolean enableNumerics, String customChars) {
        try {
            if (document == null) {
                return new Region(0, 0);
            }
            if (customChars == null) {
                customChars = "";
            }
            int start = -1;
            int end = -1;
            ITypedRegion region = this.getTypedRegion(document, offset);
            if (region == null) {
                return new Region(0, 0);
            }
            if (region.getType().equals("__vlog_escaped_id")) {
                return region;
            }
            int pos = offset;
            if (pos < 0 || document.getLength() == 0) {
                return new Region(0, 0);
            }
            char ch = this.getChar(document, pos - 1);
            if (!Character.isJavaIdentifierPart(ch) && customChars.indexOf(ch) == -1) {
                ch = this.getChar(document, pos);
                if (!Character.isJavaIdentifierPart(ch) && customChars.indexOf(ch) == -1) {
                    return new Region(0, 0);
                }
                ++pos;
            }
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, Math.max(0, pos - 1), false);
            char pch = ch;
            while (pos >= 0) {
                pch = ch;
                ch = (char)scanner.read();
                if (!Character.isJavaIdentifierPart(ch) && ch != '$' && ch != '`' && ch != '\'' && customChars.indexOf(ch) == -1) break;
                --pos;
            }
            ch = this.getChar(document, pos);
            if (!Character.isJavaIdentifierStart(ch) && ch != '$' && ch != '`' && ch != '\'' && !enableNumerics && customChars.indexOf(ch) == -1) {
                return new Region(0, 0);
            }
            if (pch == '\'') {
                ++pos;
            }
            start = pos;
            pos = offset;
            scanner = new DVTCharacterScanner(20, document, pos, true);
            while (ch != '\uffff') {
                ch = (char)scanner.read();
                if (!Character.isJavaIdentifierPart(ch) && customChars.indexOf(ch) == -1) break;
                ++pos;
            }
            end = pos;
            if (start > -1 && end > -1) {
                if (start == offset && end == offset) {
                    return new Region(offset, 0);
                }
                return new Region(start, end - start);
            }
            return new Region(0, 0);
        }
        catch (Exception exception) {
            return new Region(0, 0);
        }
    }

    public WordAtOffsetInfo getWordStringAndRegionAtOffset(IDocument document, int offset, boolean enableNumerics, String customChars) {
        try {
            if (document == null) {
                return new WordAtOffsetInfo((IRegion)new Region(0, 0), null);
            }
            if (customChars == null) {
                customChars = "";
            }
            int start = -1;
            int end = -1;
            ITypedRegion region = this.getTypedRegion(document, offset);
            if (region == null) {
                return new WordAtOffsetInfo((IRegion)new Region(0, 0), null);
            }
            if (region.getType().equals("__vlog_escaped_id")) {
                return new WordAtOffsetInfo((IRegion)region, null);
            }
            int pos = offset;
            if (pos < 0 || document.getLength() == 0) {
                return new WordAtOffsetInfo((IRegion)new Region(0, 0), null);
            }
            char ch = this.getChar(document, pos - 1);
            if (!Character.isJavaIdentifierPart(ch) && customChars.indexOf(ch) == -1) {
                ch = this.getChar(document, pos);
                if (!Character.isJavaIdentifierPart(ch) && customChars.indexOf(ch) == -1) {
                    return new WordAtOffsetInfo((IRegion)new Region(0, 0), null);
                }
                ++pos;
            }
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, Math.max(0, pos - 1), false);
            DVTStringBuilder word = new DVTStringBuilder();
            char pch = ch;
            while (pos >= 0) {
                pch = ch;
                ch = (char)scanner.read();
                if (!Character.isJavaIdentifierPart(ch) && ch != '$' && ch != '`' && ch != '\'' && customChars.indexOf(ch) == -1) break;
                word.prepend(ch);
                --pos;
            }
            ch = this.getChar(document, pos);
            if (!Character.isJavaIdentifierStart(ch) && ch != '$' && ch != '`' && ch != '\'' && !enableNumerics && customChars.indexOf(ch) == -1) {
                return new WordAtOffsetInfo((IRegion)new Region(0, 0), null);
            }
            if (pch == '\'') {
                ++pos;
            }
            start = pos;
            pos = offset;
            scanner = new DVTCharacterScanner(20, document, pos, true);
            while (ch != '\uffff') {
                ch = (char)scanner.read();
                if (!Character.isJavaIdentifierPart(ch) && customChars.indexOf(ch) == -1) break;
                word.append(ch);
                ++pos;
            }
            end = pos;
            if (start > -1 && end > -1) {
                if (start == offset && end == offset) {
                    return new WordAtOffsetInfo((IRegion)new Region(offset, 0), "");
                }
                return new WordAtOffsetInfo((IRegion)new Region(start, end - start), word.toString());
            }
            return new WordAtOffsetInfo((IRegion)new Region(0, 0), null);
        }
        catch (Exception exception) {
            return new WordAtOffsetInfo((IRegion)new Region(0, 0), null);
        }
    }

    public ITypedRegion getTypedRegion(IDocument document, int offset) {
        block3: {
            try {
                if (offset >= 0) break block3;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        IDocumentExtension3 extension3 = (IDocumentExtension3)document;
        return extension3.getPartition("__vlog_partitioning", offset, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRegion getExpressionAtOffset(IDocument document, int offset) {
        int start = -1;
        int end = -1;
        try {
            int pos = offset;
            if (pos < 0 || document.getLength() == 0) {
                return new Region(0, 0);
            }
            int ch = this.getChar(document, pos - 1);
            if (!Character.isJavaIdentifierPart((char)ch)) {
                ch = this.getChar(document, pos);
                if (!Character.isJavaIdentifierPart((char)ch)) {
                    return new Region(0, 0);
                }
                ++pos;
            }
            DVTCharacterScanner scanner = new DVTCharacterScanner(20, document, Math.max(0, pos - 1), false);
            EXPRESSION_STATE state = EXPRESSION_STATE.CODE;
            int nested = 0;
            boolean shouldStop = false;
            boolean atLeastOneDot = false;
            block11: while (pos > 0) {
                ch = scanner.read();
                if (nested == -1) {
                    ++pos;
                    break;
                }
                switch (state) {
                    case CODE: {
                        if ((char)ch == '\"') {
                            state = EXPRESSION_STATE.LITERAL_START;
                        } else if ((char)ch == '.') {
                            state = EXPRESSION_STATE.DOT;
                        } else {
                            if (((char)ch == '{' || (char)ch == '[' || (char)ch == '(') && nested == 0) break block11;
                            if ((char)ch == '(' || (char)ch == '{' || (char)ch == '[') {
                                --nested;
                            } else if ((char)ch == ')' || (char)ch == '}' || (char)ch == ']') {
                                ++nested;
                            } else {
                                if (Character.isWhitespace((char)ch)) {
                                    state = EXPRESSION_STATE.WS_CODE;
                                    break;
                                }
                                if (!Character.isJavaIdentifierPart((char)ch) && (char)ch != '.' && (char)ch != '$' && (char)ch != '\'') break block11;
                            }
                        }
                        shouldStop = (char)ch != '.' && (char)ch != '[' && (char)ch != ']';
                        break;
                    }
                    case LITERAL_START: {
                        if ((char)ch == '\\') {
                            state = EXPRESSION_STATE.CODE;
                            break;
                        }
                        if ((char)ch == '\"') {
                            state = EXPRESSION_STATE.LITERAL_END;
                            break;
                        }
                        state = EXPRESSION_STATE.LITERAL;
                        break;
                    }
                    case LITERAL: {
                        if ((char)ch != '\"') break;
                        state = EXPRESSION_STATE.LITERAL_END;
                        break;
                    }
                    case LITERAL_END: {
                        if ((char)ch == '\\') {
                            state = EXPRESSION_STATE.LITERAL;
                            break;
                        }
                        if ((char)ch == '\"') {
                            state = EXPRESSION_STATE.LITERAL_START;
                            break;
                        }
                        state = EXPRESSION_STATE.CODE;
                        break;
                    }
                    case DOT: {
                        atLeastOneDot = true;
                        if (Character.isWhitespace((char)ch)) {
                            state = EXPRESSION_STATE.WS_DOT;
                        } else {
                            if (((char)ch == '{' || (char)ch == '(') && nested == 0) break block11;
                            if ((char)ch == ']') {
                                ++nested;
                            }
                        }
                        state = EXPRESSION_STATE.CODE;
                        break;
                    }
                    case WS_DOT: {
                        if (((char)ch == '{' || (char)ch == '(') && nested == 0) break block11;
                        if ((char)ch == ']') {
                            ++nested;
                        }
                        state = EXPRESSION_STATE.CODE;
                        break;
                    }
                    case WS_CODE: {
                        if ((char)ch == '.') {
                            shouldStop = false;
                            state = EXPRESSION_STATE.DOT;
                        } else {
                            if (Character.isWhitespace((char)ch)) {
                                state = EXPRESSION_STATE.WS_CODE;
                                break;
                            }
                            if ((char)ch == ']' && atLeastOneDot) {
                                shouldStop = false;
                                ++nested;
                            } else if ((char)ch == '[') {
                                shouldStop = false;
                                --nested;
                            } else {
                                if (!Character.isJavaIdentifierPart((char)ch) && (char)ch != '.' && (char)ch != '$' && (char)ch != '\'' && nested == 0) break block11;
                                state = EXPRESSION_STATE.CODE;
                            }
                        }
                        if (shouldStop && nested == 0) break block11;
                    }
                }
                --pos;
            }
            start = pos;
            pos = offset;
            nested = 0;
            scanner = new DVTCharacterScanner(20, document, pos, true);
            shouldStop = false;
            while (ch != -1) {
                ch = scanner.read();
                if ((char)ch == '[') {
                    shouldStop = false;
                    ++nested;
                    ++pos;
                    continue;
                }
                if ((char)ch == ']' && nested == 0) break;
                if ((char)ch == ']') {
                    --nested;
                    ++pos;
                    continue;
                }
                if ((char)ch == '.' && nested != 0) {
                    ++pos;
                    continue;
                }
                if (Character.isWhitespace((char)ch) && nested == 0) {
                    ++pos;
                    shouldStop = true;
                    continue;
                }
                if (shouldStop || !Character.isJavaIdentifierPart((char)ch) && (char)ch != '$' && (char)ch != '\'' && nested == 0) break;
                ++pos;
            }
            end = pos;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (start > -1 && end > -1) {
            if (start == offset && end == offset) {
                return new Region(offset, 0);
            }
            return new Region(start, end - start);
        }
        return new Region(0, 0);
    }

    private static enum EXPRESSION_STATE {
        SL_COMMENT,
        LITERAL,
        LITERAL_START,
        LITERAL_END,
        CODE,
        DOT,
        WS_CODE,
        WS_DOT;

    }
}

