/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.actions;

import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.emacs.EmacsJob;

public abstract class AbstractEmacsAutoAction
extends TextEditorAction {
    private String function;

    protected AbstractEmacsAutoAction(String function, ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        this.function = function;
    }

    public void run() {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            return;
        }
        IEditorInput editorInput = textEditor.getEditorInput();
        if (editorInput == null) {
            return;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            return;
        }
        if (!DVTPlugin.getDefault().collect().c(file.getProject(), "F7376")) {
            return;
        }
        if (textEditor.isSaveOnCloseNeeded()) {
            textEditor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        final IFile[] files = new IFile[]{file};
        boolean userDeclined = DVTFileUtils.getInstance().fixFileModificationValidatorPermissions((IResource[])files, (Callable)new Callable<IStatus>(){

            @Override
            public IStatus call() {
                return ResourcesPlugin.getWorkspace().validateEdit(files, (Object)DVTUiUtils.getActiveWorkbenchShell());
            }
        }, false, (IProgressMonitor)new NullProgressMonitor());
        if (userDeclined) {
            return;
        }
        new EmacsJob(file, this.function).schedule();
    }
}

