/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;

public class BaseRefactorAction
extends TextEditorAction {
    protected String dialogTitle;
    protected ITextEditor fTextEditor;
    protected IDocument fDocument;
    protected ITextViewer fViewer;
    protected RfNamedElement fElementAtCursor;

    protected BaseRefactorAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public void run() {
        this.fTextEditor = this.getTextEditor();
        if (this.fTextEditor == null || !(this.fTextEditor instanceof DVTEditor)) {
            return;
        }
        IResource resouce = (IResource)this.fTextEditor.getAdapter(IResource.class);
        if (resouce == null) {
            return;
        }
        IProject project = resouce.getProject();
        if (project == null) {
            return;
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return;
        }
        IDocumentProvider documentProvider = this.fTextEditor.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        this.fDocument = documentProvider.getDocument((Object)this.fTextEditor.getEditorInput());
        if (this.fDocument == null) {
            return;
        }
        int offset = ((DVTEditor)this.fTextEditor).getCursor();
        if (offset < 0) {
            return;
        }
        this.fViewer = ((DVTEditor)this.fTextEditor).getTextViewer();
        RfWNamedElementAndScope elementAndScopeAtCursor = RfUtils.getRfElement(rfProject, this.fTextEditor, this.fDocument, offset);
        if (elementAndScopeAtCursor == null) {
            return;
        }
        this.fElementAtCursor = elementAndScopeAtCursor.getNamedElement();
    }

    protected void popUnsupportedElement(final RfNamedElement elementAtCursor) {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), BaseRefactorAction.this.dialogTitle, null, "The operation is unavailable on the current element " + (elementAtCursor == null ? "." : ": '" + elementAtCursor.getName() + "'.") + "\nPlease select another Verilog Language element.", 2, new String[]{"OK"}, 0);
                dialog.open();
            }
        });
    }

    protected void popEmptySelection() {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), BaseRefactorAction.this.dialogTitle, null, "The operation is unavailable on empty selection.\n", 2, new String[]{"OK"}, 0);
                dialog.open();
            }
        });
    }
}

