/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.actions;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.model.preproc.PreprocConstCommon;
import ro.amiq.dvt.model.preproc.PreprocUtils;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.ui.editor.compare.PVlogCompareEditorInput;
import ro.amiq.vlogdt.ui.editor.compare.PVlogCompareScrollInfo;

public class CompareWithPVlogMappedFileHandler
extends AbstractHandler {
    private IFile pFile;
    private IFile gFile;

    public boolean isEnabled() {
        Object element;
        ISelection selection = DVTPlugin.getSelectionManager().getLastSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() != 1) {
                return false;
            }
            element = structuredSelection.getFirstElement();
        } else {
            element = DVTPlugin.getSelectionManager().getLastSelectedResource();
        }
        if (!(element instanceof IFile)) {
            return false;
        }
        IFile file = (IFile)element;
        IProject project = file.getProject();
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser((IResource)file);
        if (project == null || parserPath == null) {
            return false;
        }
        PreprocConstCommon.PreprocFileType fileType = PreprocUtils.getInstance().getPreprocFileType(project, parserPath);
        if (fileType == null) {
            return false;
        }
        String mappedFilePath = fileType.getMappedFilePath(project, parserPath.toString());
        IFile mappedFile = DVTFileUtils.getInstance().findProjectFile(project, mappedFilePath);
        if (mappedFile == null) {
            return false;
        }
        if (fileType == PreprocConstCommon.PreprocFileType.P_FILE) {
            this.pFile = file;
            this.gFile = mappedFile;
        } else {
            this.pFile = mappedFile;
            this.gFile = file;
        }
        return true;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        PVlogCompareEditorInput pVlogCompareEditorInput = new PVlogCompareEditorInput(this.pFile, this.gFile, this.computeCompareScrollInfo());
        CompareUI.openCompareEditor((CompareEditorInput)pVlogCompareEditorInput);
        return null;
    }

    private PVlogCompareScrollInfo computeCompareScrollInfo() {
        IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
        if (!(activeEditor instanceof DVTEditor)) {
            return null;
        }
        DVTEditor dvtEditor = (DVTEditor)activeEditor;
        IFile currentFile = dvtEditor.getCurrentFile();
        String currentFilePath = currentFile.getFullPath().toOSString();
        String pFilePath = this.pFile.getFullPath().toOSString();
        String gFilePath = this.gFile.getFullPath().toOSString();
        if (!currentFilePath.equals(pFilePath) && !currentFilePath.equals(gFilePath)) {
            return null;
        }
        ITextViewer textViewer = dvtEditor.getTextViewer();
        if (textViewer == null) {
            return null;
        }
        return new PVlogCompareScrollInfo(currentFilePath.equals(gFilePath), textViewer.getTopIndex());
    }
}

