/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.actions;

import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.ui.editor.override.GetterSetterMethodsUtils;
import ro.amiq.vlogdt.ui.editor.override.VlogGetterSetterMethodsDialog;

public class GenerateGetterSetter
extends TextEditorAction {
    private String replacementPrefix;
    private int cursorPosition;

    public GenerateGetterSetter(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public String getReplacementPrefix() {
        return this.replacementPrefix;
    }

    public void setReplacementPrefix(String replacementPrefix) {
        this.replacementPrefix = replacementPrefix;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    public void setCursorPosition(int cursorPosition) {
        this.cursorPosition = cursorPosition;
    }

    public void run() {
        try {
            RfClass localClass = GetterSetterMethodsUtils.getInstance().getLocalClass(this.getTextEditor(), true);
            VlogGetterSetterMethodsDialog dialog = new VlogGetterSetterMethodsDialog(this.replacementPrefix);
            if (localClass == null) {
                return;
            }
            Map<RfField, List<String>> context = GetterSetterMethodsUtils.getInstance().getGetterSetterMethodsContext(localClass);
            if (context.isEmpty()) {
                return;
            }
            List<String> selectedFunctions = dialog.getSelectedFunctions(context);
            if (selectedFunctions == null || selectedFunctions.isEmpty()) {
                return;
            }
            this.setCursorPosition(GetterSetterMethodsUtils.getInstance().insertInEditor(this.getTextEditor(), this.replacementPrefix == null ? 0 : this.replacementPrefix.length(), selectedFunctions, context));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

