/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.BuildFilePathLine;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.ui.editor.actions.GoToIncludeActionCommon;
import ro.amiq.vlogdt.utils.VlogFileUtils;

public class GoToIncludeAction
extends GoToIncludeActionCommon {
    public GoToIncludeAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public void run() {
        try {
            if (!(this.getTextEditor() instanceof DVTEditor)) {
                return;
            }
            DVTEditor dvtEditor = (DVTEditor)this.getTextEditor();
            IProject project = dvtEditor.getProject();
            if (project == null) {
                return;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return;
            }
            IResource resource = (IResource)dvtEditor.getAdapter(IResource.class);
            if (resource == null) {
                return;
            }
            ParserPath parserPath = DVTFileUtils.getInstance().resource2parser(resource);
            if (parserPath == null) {
                return;
            }
            VlogFileInstance topInstance = rfProject.getPreprocessingTable().getTopFileInstance();
            if (topInstance == null) {
                return;
            }
            List<VlogFileInstance> fileInstances = topInstance.getFileInstances(parserPath);
            if (fileInstances == null || fileInstances.isEmpty()) {
                return;
            }
            if (fileInstances.size() == 1) {
                VlogFileInstance fileInstance = fileInstances.get(0);
                GoToIncludeActionCommon.DestinationFileLine destInfo = this.getDestinationInfo(fileInstance, project, rfProject);
                if (destInfo == null) {
                    return;
                }
                VlogFileUtils.getInstance().openEditor(destInfo.getDestinationFile(), destInfo.getDestinationLineNumber(), null);
            } else {
                HashSet<GoToIncludeActionCommon.DestinationFileLine> destFilesInfo = new HashSet<GoToIncludeActionCommon.DestinationFileLine>();
                for (VlogFileInstance fins : fileInstances) {
                    GoToIncludeActionCommon.DestinationFileLine destInfo = this.getDestinationInfo(fins, project, rfProject);
                    if (destInfo == null) continue;
                    destFilesInfo.add(destInfo);
                }
                if (destFilesInfo.isEmpty()) {
                    return;
                }
                ArrayList<GoToIncludeActionCommon.DestinationFileLine> selectedDestFiles = this.getDestinationFileLineFromDialog(destFilesInfo, fileInstances.get(0).getShortFileName());
                if (selectedDestFiles == null || selectedDestFiles.isEmpty()) {
                    return;
                }
                for (GoToIncludeActionCommon.DestinationFileLine destFileInfo : selectedDestFiles) {
                    VlogFileUtils.getInstance().openEditor(destFileInfo.getDestinationFile(), destFileInfo.getDestinationLineNumber(), null);
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private ArrayList<GoToIncludeActionCommon.DestinationFileLine> getDestinationFileLineFromDialog(Set<GoToIncludeActionCommon.DestinationFileLine> includingFiles, String fileBaseName) {
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                IPath fullPath = ((GoToIncludeActionCommon.DestinationFileLine)element).getDestinationFile().getLocation();
                int lineNumber = ((GoToIncludeActionCommon.DestinationFileLine)element).getDestinationLineNumber();
                return String.valueOf(fullPath.lastSegment()) + " @ line " + lineNumber + " - " + fullPath.toOSString();
            }

            public Image getImage(Object element) {
                IFile file = ((GoToIncludeActionCommon.DestinationFileLine)element).getDestinationFile();
                String propertyValue = PropertiesManager.getSessionProperty((IResource)file, (String)PropertyTypes.QN_IMPORTED_FILE);
                if (propertyValue != null) {
                    if (propertyValue.equals("ro.amiq.dvt.ui.editor.BuildConfigEditor")) {
                        return DVTImages.imageCache.getImage(DVTImages.DESC_BC_MODULE);
                    }
                    return DVTImages.imageCache.getImage(DVTImages.DESC_VLOG_MODULE);
                }
                IContentDescription contentDescription = null;
                try {
                    contentDescription = file.getContentDescription();
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                if (contentDescription == null) {
                    return DVTImages.imageCache.getImage(DVTImages.DESC_BC_MODULE);
                }
                IContentType contentType = contentDescription.getContentType();
                if (contentType != null && contentType.getId().equals("ro.amiq.vlogdt.VlogSource")) {
                    return DVTImages.imageCache.getImage(DVTImages.DESC_VLOG_MODULE);
                }
                return DVTImages.imageCache.getImage(DVTImages.DESC_BC_MODULE);
            }
        };
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILabelProvider)labelProvider, (ILabelProvider)labelProvider){
            private final /* synthetic */ ILabelProvider val$labelProvider;
            {
                this.val$labelProvider = iLabelProvider;
                super($anonymous0, $anonymous1);
            }

            protected FilteredList createFilteredList(Composite parent) {
                FilteredList list = super.createFilteredList(parent);
                list.setLabelProvider(this.val$labelProvider);
                list.setFilterMatcher(new FilteredList.FilterMatcher(){
                    private StringMatcher fMatcher;

                    public void setFilter(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
                        this.fMatcher = ViewsUtils.createCamelCaseOrRegexMatcher((String)pattern, (boolean)ignoreCase, (boolean)ignoreWildCards);
                    }

                    public boolean match(Object element) {
                        return ViewsUtils.matchCamelCaseOrRegex((StringMatcher)this.fMatcher, (String)fFilteredList.getLabelProvider().getText(element));
                    }
                });
                return list;
            }
        };
        dialog.setTitle("Go To Include");
        dialog.setMessage("Select the locations you want to open ('" + fileBaseName + "' is included multiple times):");
        dialog.setElements(includingFiles.toArray());
        dialog.setMultipleSelection(true);
        ArrayList<GoToIncludeActionCommon.DestinationFileLine> selectionFilesInfo = new ArrayList<GoToIncludeActionCommon.DestinationFileLine>();
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            if (result == null) {
                return null;
            }
            Object[] objectArray = result;
            int n = result.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object != null) {
                    GoToIncludeActionCommon.DestinationFileLine selection = (GoToIncludeActionCommon.DestinationFileLine)object;
                    selectionFilesInfo.add(selection);
                }
                ++n2;
            }
        }
        return selectionFilesInfo;
    }

    @Override
    protected IFile getBuildFile(IProject project, BuildFilePathLine includedTopFile) {
        return DVTFileUtils.getInstance().getProjectFile(project, includedTopFile.getPath());
    }
}

