/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.actions;

import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.utils.BuildFilePathLine;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.parser.VlogFileInstance;
import ro.amiq.vlogdt.parser.VlogIncludingScope;
import ro.amiq.vlogdt.utils.SourceFileToBuildFileMapping;

public abstract class GoToIncludeActionCommon
extends TextEditorAction {
    protected GoToIncludeActionCommon(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public DestinationFileLine getDestinationInfo(VlogFileInstance fileInstance, IProject project, RfProject rfProject) {
        VlogIncludingScope includingScope = fileInstance.getIncludingScope();
        if (includingScope == null) {
            return null;
        }
        VlogFileInstance includingFileInstance = includingScope.getIncludingInstance();
        if (includingFileInstance == null) {
            return null;
        }
        if (!this.isBuildFile(includingFileInstance, project)) {
            IFile file = RfUtils.getFile(includingFileInstance, project);
            return new DestinationFileLine(file, includingScope.getIncludingLine());
        }
        SourceFileToBuildFileMapping sourceFileToBuildMapping = rfProject.getSourceFileToBuildFileMapping();
        if (sourceFileToBuildMapping == null) {
            return null;
        }
        Map<Integer, BuildFilePathLine> includedTopFilesMap = sourceFileToBuildMapping.getIncludedTopFilesMap().get(fileInstance.getInvocNumber());
        if (includedTopFilesMap == null) {
            return null;
        }
        BuildFilePathLine includedTopFile = includedTopFilesMap.get(includingScope.getIncludingLine());
        if (includedTopFile != null) {
            IFile buildFile = this.getBuildFile(project, includedTopFile);
            if (buildFile == null) {
                return null;
            }
            return new DestinationFileLine(buildFile, includedTopFile.getBuildFileLine());
        }
        Map<String, BuildFilePathLine> includedLibrariesMap = sourceFileToBuildMapping.getIncludedLibrariesMap().get(fileInstance.getInvocNumber());
        if (includedLibrariesMap == null) {
            return null;
        }
        BuildFilePathLine inclLibrary = includedLibrariesMap.get(fileInstance.getParserPath().path);
        if (inclLibrary == null) {
            return null;
        }
        IFile buildFile = this.getBuildFile(project, inclLibrary);
        if (buildFile == null) {
            return null;
        }
        return new DestinationFileLine(buildFile, inclLibrary.getBuildFileLine());
    }

    protected boolean isBuildFile(VlogFileInstance includingFileInstance, IProject project) {
        IFile file = RfUtils.getFile(includingFileInstance, project);
        return file == null;
    }

    protected abstract IFile getBuildFile(IProject var1, BuildFilePathLine var2);

    public static class DestinationFileLine {
        private IFile destFile;
        private int destLine;

        public DestinationFileLine(IFile destFile, int destLineNr) {
            this.destFile = destFile;
            this.destLine = destLineNr;
        }

        public IFile getDestinationFile() {
            return this.destFile;
        }

        public int getDestinationLineNumber() {
            return this.destLine;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.destFile == null ? 0 : this.destFile.hashCode());
            result = 31 * result + this.destLine;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DestinationFileLine)) {
                return false;
            }
            DestinationFileLine other = (DestinationFileLine)obj;
            if (this.destFile == null ? other.destFile != null : !this.destFile.getLocation().equals((Object)other.destFile.getLocation())) {
                return false;
            }
            return this.destLine == other.destLine;
        }
    }
}

