/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.preproc.PreprocUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.editor.actions.BaseRfAction;

public class GoToPVlogMappedFileAction
extends BaseRfAction {
    public GoToPVlogMappedFileAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        this.setText("PVerilog Preprocessed/Generated File");
    }

    public void run() {
        try {
            ITextEditor textEditor = this.getTextEditor();
            if (!(textEditor instanceof VlogEditor)) {
                this.popInformationDialog();
                return;
            }
            VlogEditor vlogEditor = (VlogEditor)textEditor;
            if (!PreprocUtils.getInstance().isMappedFile(vlogEditor.getProject(), vlogEditor.getParserPath())) {
                this.popInformationDialog();
                return;
            }
            PreprocUtils.getInstance().showMappedFileRegion(vlogEditor.getProject(), vlogEditor.getParserPath(), vlogEditor.getCursor());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void popInformationDialog() {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Operation not Available", null, "The operation is not allowed on the current selection. Please place the cursor inside a PVerilog preprocessed/generated file.", 2, new String[]{"OK"}, 0);
            dialog.open();
        });
    }
}

