/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.actions.IReferencesAction;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.search.BaseReferencesInWorkspaceAction;
import ro.amiq.dvt.ui.search.RWSearchTypeEnum;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.vlogdt.model.reflection.RfInstance;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfBatchUtils;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.ui.search.ReferenceSearchPageInput;
import ro.amiq.vlogdt.ui.search.SearchQueryProvider;

public class ReferencesInWorkspaceAction
extends BaseReferencesInWorkspaceAction
implements IReferencesAction {
    public ReferencesInWorkspaceAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    protected void informationDialog() {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Limited Operation", null, "The operation is unavailable on the current selection (the scope could not be determined). Please select another Verilog Language element name or the same element from another location.", 2, new String[]{"OK"}, 0);
                dialog.open();
            }
        });
    }

    public void run() {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            return;
        }
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
        if (document == null) {
            return;
        }
        if (!(textEditor instanceof DVTEditor)) {
            return;
        }
        int offset = ((DVTEditor)textEditor).getCursor();
        this.searchReferences(textEditor, document, offset, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ISearchQuery searchReferences(ITextEditor textEditor, IDocument document, int offset, boolean includeDeclarations) {
        try {
            IRfScopeElement iRfScopeElement;
            FileTextSearchScope searchScope;
            RfWNamedElementAndScope namedElementAndScope;
            IRfNamedElement namedElement;
            IProject project;
            block13: {
                block12: {
                    IResource resouce = (IResource)textEditor.getAdapter(IResource.class);
                    if (resouce == null) {
                        return null;
                    }
                    project = resouce.getProject();
                    if (project == null) {
                        return null;
                    }
                    DVTBuildUtils.waitForAllBuildJobsDone((Object)IDVTConstants.VLOG_FAMILY_REPARSE);
                    RfProject rfProject = RfManager.getInstance().getRfProject(project);
                    if (rfProject == null) {
                        return null;
                    }
                    namedElement = null;
                    namedElementAndScope = RfUtils.getRfElement(rfProject, textEditor, document, offset);
                    if (namedElementAndScope != null) {
                        namedElement = namedElementAndScope.getIRfNamedElement();
                    }
                    if (namedElement == null) {
                        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser(resouce);
                        if (parserPath == null) {
                            return null;
                        }
                        namedElement = RfBatchUtils.getMacro(rfProject, parserPath, document, offset);
                    }
                    if (namedElement == null) {
                        this.informationDialog();
                        return null;
                    }
                    while (true) {
                        if (!(namedElement instanceof RfInstance.RfInstanceList)) {
                            searchScope = this.getSearchScope(ReferencesInWorkspaceAction.getFileExtensions((IRfSingleLangProject)rfProject), textEditor);
                            if (namedElementAndScope == null) break block12;
                            if (namedElementAndScope.getAssocScope() == null) break;
                            iRfScopeElement = namedElementAndScope.getAssocScope();
                            break block13;
                        }
                        IRfNamedElement associatedType = ((RfInstance.RfInstanceList)namedElement).getAssociatedType();
                        if (associatedType == null) {
                            this.informationDialog();
                            return null;
                        }
                        namedElement = associatedType;
                    }
                    iRfScopeElement = namedElementAndScope.getScope();
                    break block13;
                }
                iRfScopeElement = null;
            }
            IRfScopeElement scopeElement = iRfScopeElement;
            ElementPath exactDesignContext = DesignPathManager.getInstance().getPathFor((DVTEditor)textEditor, offset, namedElement, scopeElement, false, false);
            ReferenceSearchPageInput input = new ReferenceSearchPageInput(namedElement, scopeElement, exactDesignContext, true, false, true, RfReferencesUtils.isHierarchicalAccess((IRfNamedElementAndScope)namedElementAndScope), searchScope, VlogRfReferencesUtils.getSearchedStringFromOffset(document, offset));
            return ReferencesInWorkspaceAction.searchReferencesHelper(input, includeDeclarations, project, RWSearchTypeEnum.USAGES);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public static ISearchQuery searchReferencesHelper(ReferenceSearchPageInput input, boolean includeDeclarations, IProject project, RWSearchTypeEnum searchRWType) {
        try {
            input.setProject(project);
            ISearchQuery query = new SearchQueryProvider(1, 6, includeDeclarations, true, false, false, searchRWType).createQuery((TextSearchQueryProvider.TextSearchInput)input);
            if (query != null) {
                NewSearchUI.runQueryInBackground((ISearchQuery)query);
            }
            return query;
        }
        catch (OperationCanceledException operationCanceledException) {
            return null;
        }
    }

    protected FileTextSearchScope getSearchScope(String[] fileExtensions, ITextEditor textEditor) {
        return FileTextSearchScope.newWorkspaceScope((String[])fileExtensions, (boolean)false);
    }

    protected IProject getProject(ITextEditor textEditor) {
        IFile file = this.getFile(textEditor);
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    protected IFile getFile(ITextEditor textEditor) {
        if (textEditor == null) {
            return null;
        }
        IEditorInput editorInput = textEditor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        return file;
    }
}

