/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.actions;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.BiPredicate;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.actions.IReferencesAction;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.model.reflection.util.VlogRfGUIReferencesUtils;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.model.reflection.xvm.RfXvmBase;
import ro.amiq.vlogdt.ui.editor.actions.ReferencesInWorkspaceAction;
import ro.amiq.vlogdt.ui.editor.hyperlink.RfHyperlinkDetector;

public class ShowConnectedTLMPortsAction
extends ReferencesInWorkspaceAction
implements IReferencesAction {
    public ShowConnectedTLMPortsAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        this.setText("Connected TLM Ports");
    }

    public void runWithEvent(Event event) {
        this.run();
    }

    @Override
    protected void informationDialog() {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Operation not Available", null, "The operation is not available on the current selection.\nPlease select a TLM port to use Show Connected TLM Ports.", 2, new String[]{"OK"}, 0);
            dialog.open();
        });
    }

    @Override
    public void run() {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            return;
        }
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
        if (document == null) {
            return;
        }
        if (!(textEditor instanceof DVTEditor)) {
            return;
        }
        int offset = ((DVTEditor)textEditor).getCursor();
        IResource resouce = (IResource)textEditor.getAdapter(IResource.class);
        if (resouce == null) {
            return;
        }
        IProject project = resouce.getProject();
        if (project == null) {
            return;
        }
        DVTBuildUtils.waitForAllBuildJobsDone((Object)IDVTConstants.VLOG_FAMILY_REPARSE);
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return;
        }
        this.findNamedElementAndShowConnectedTLMPorts(rfProject, textEditor, document, offset);
    }

    private void findNamedElementAndShowConnectedTLMPorts(RfProject rfProject, ITextEditor textEditor, IDocument document, int offset) {
        IRfNamedElement namedElement = null;
        RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(rfProject, textEditor, document, offset);
        if (namedElementAndScope == null) {
            this.informationDialog();
            return;
        }
        namedElement = namedElementAndScope.getIRfNamedElement();
        if (namedElement == null) {
            this.informationDialog();
            return;
        }
        if (!RfHyperlinkDetector.checkSelectionIsTLMPort(namedElement)) {
            this.informationDialog();
            return;
        }
        AbstractBreadcrumbViewer breadcrumbViewer = ((DVTEditor)textEditor).getBreadcrumbViewer(VHBreadcrumbViewer.class);
        if (!(breadcrumbViewer instanceof VHBreadcrumbViewer)) {
            return;
        }
        VHBreadcrumbViewer vhBreadcrumbViewer = (VHBreadcrumbViewer)breadcrumbViewer;
        BreadcrumbInput input = vhBreadcrumbViewer.getInput();
        if (input == null) {
            return;
        }
        List segments = input.getInputSegments();
        if (segments == null) {
            return;
        }
        ArrayList<RfXvmBase> portTreePathElements = new ArrayList<RfXvmBase>();
        int index = segments.size() - 1;
        while (index >= 0) {
            BreadcrumbSegment segment = (BreadcrumbSegment)segments.get(index);
            IRfBreadcrumbElement element = segment.getElement();
            if (!(element instanceof RfXvmBase)) {
                return;
            }
            portTreePathElements.add((RfXvmBase)element);
            --index;
        }
        ArrayList<RfWNamedElementAndScope> elemsAndScopeList = new ArrayList<RfWNamedElementAndScope>();
        Deque elementAndScopeStack = namedElementAndScope.getElementAndScopeStack();
        while (!elementAndScopeStack.isEmpty()) {
            elemsAndScopeList.add((RfWNamedElementAndScope)elementAndScopeStack.pollLast());
        }
        BiPredicate<IHidObject, IRfClassElement> filterPredicate = (iHidObj, enclosingScope) -> RfHyperlinkDetector.shouldFilterIHidObject(iHidObj, enclosingScope, namedElementAndScope.getIRfNamedElement(), portTreePathElements, elemsAndScopeList);
        VlogRfGUIReferencesUtils.showFilteredUsagesAction(namedElement, namedElementAndScope.getAssocScope(), rfProject.getProject(), VlogRfReferencesUtils.getSearchedStringFromOffset(document, offset), filterPredicate);
    }
}

