/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.search.ui.IBaseShowConstraintsAction;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.ui.editor.actions.ReferencesInWorkspaceAction;
import ro.amiq.vlogdt.ui.search.constraints.ConstraintsSearchQuery;

public class ShowConstraintsAction
extends ReferencesInWorkspaceAction
implements IBaseShowConstraintsAction {
    public ShowConstraintsAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        this.setImageDescriptor(DVTImages.OUTLINE_CONSTRAINT);
    }

    public void runWithEvent(Event event) {
        this.run();
    }

    @Override
    protected void informationDialog() {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Operation not Available", null, "The operation is not available on the current selection.\nPlease select a class field to use Show Constraints.", 2, new String[]{"OK"}, 0);
                dialog.open();
            }
        });
    }

    @Override
    public void run() {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            return;
        }
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
        if (document == null) {
            return;
        }
        if (!(textEditor instanceof DVTEditor)) {
            return;
        }
        int offset = ((DVTEditor)textEditor).getCursor();
        IResource resouce = (IResource)textEditor.getAdapter(IResource.class);
        if (resouce == null) {
            return;
        }
        IProject project = resouce.getProject();
        if (project == null) {
            return;
        }
        DVTBuildUtils.waitForAllBuildJobsDone((Object)IDVTConstants.VLOG_FAMILY_REPARSE);
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return;
        }
        this.findNamedElementAndShowConstraints(rfProject, textEditor, document, offset, resouce);
    }

    public ISearchQuery showConstraintsTest(ITextEditor textEditor, IDocument document, int offset) {
        RfProject rfProject;
        IResource resouce;
        block7: {
            IProject project;
            block6: {
                block5: {
                    try {
                        resouce = (IResource)textEditor.getAdapter(IResource.class);
                        if (resouce != null) break block5;
                        return null;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                project = resouce.getProject();
                if (project != null) break block6;
                return null;
            }
            DVTBuildUtils.waitForAllBuildJobsDone((Object)IDVTConstants.VLOG_FAMILY_REPARSE);
            rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject != null) break block7;
            return null;
        }
        return this.findNamedElementAndShowConstraints(rfProject, textEditor, document, offset, resouce);
    }

    private ISearchQuery findNamedElementAndShowConstraints(RfProject rfProject, ITextEditor textEditor, IDocument document, int offset, IResource resource) {
        IRfNamedElement namedElement = null;
        RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(rfProject, textEditor, document, offset);
        if (namedElementAndScope != null) {
            namedElement = namedElementAndScope.getIRfNamedElement();
        }
        if (namedElement == null) {
            this.informationDialog();
            return null;
        }
        if (!(namedElement instanceof RfField)) {
            this.informationDialog();
            return null;
        }
        return ShowConstraintsAction.showConstraints((RfField)namedElement);
    }

    public static ISearchQuery showConstraints(RfField field) {
        ConstraintsSearchQuery query = new ConstraintsSearchQuery(field);
        NewSearchUI.runQueryInBackground((ISearchQuery)query);
        return query;
    }
}

