/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.actions.IMenuCommandDelegate;
import ro.amiq.dvt.ui.actions.MenuCommandDelegatesManager;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.ui.editor.actions.BaseRfAction;

public class ShowDiagramAction
extends BaseRfAction {
    public ShowDiagramAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        this.setImageDescriptor(DVTImages.DIAGRAMS);
    }

    public void run() {
        try {
            IEditorInput editorInput = this.getTextEditor().getEditorInput();
            if (editorInput == null) {
                return;
            }
            IFile file = (IFile)editorInput.getAdapter(IFile.class);
            if (file == null) {
                return;
            }
            IProject project = file.getProject();
            if (project == null) {
                return;
            }
            IDocument document = this.getDocument(this.getTextEditor());
            if (document == null) {
                return;
            }
            RfProject rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject == null) {
                return;
            }
            int offset = ((DVTEditor)this.getTextEditor()).getCursor();
            RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(rfProject, file, document, offset, (DVTEditor)this.getTextEditor());
            if (namedElementAndScope == null) {
                return;
            }
            DVTTreeElementWrapper wrapper = new DVTTreeElementWrapper((Object)namedElementAndScope);
            IMenuCommandDelegate delegate = MenuCommandDelegatesManager.getCommandDelegate((IDVTElementWrapper)wrapper);
            if (delegate != null) {
                delegate.showDiagram((IDVTElementWrapper)wrapper, "ro.amiq.dvt.ui.editor.DVTEditor");
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private IDocument getDocument(ITextEditor _editor) {
        if (_editor == null) {
            return null;
        }
        IDocumentProvider documentProvider = _editor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IEditorInput editorInput = _editor.getEditorInput();
        if (editorInput == null) {
            return null;
        }
        return documentProvider.getDocument((Object)editorInput);
    }
}

