/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IBuildDoneListener;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.util.RfSearchUtils;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.search.ui.BaseShowInstancesAction;
import ro.amiq.dvt.ui.search.ui.IBaseShowInstancesAction;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.ui.editor.VlogEditor;
import ro.amiq.vlogdt.ui.search.instances.InstancesSearchQuery;

public class ShowInstancesAction
extends BaseShowInstancesAction
implements IBaseShowInstancesAction,
IBuildDoneListener {
    public ShowInstancesAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        if (!(editor instanceof VlogEditor)) {
            return;
        }
        this.fProject = ((VlogEditor)editor).getProject();
        DVTMixedLangModelManager.getInstance().addBuildDoneListener((IBuildDoneListener)this);
    }

    public void runWithEvent(Event event) {
        this.run();
    }

    protected void informationDialog() {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Operation not Available", null, "The operation is not available on the current selection.\nPlease select a design element which can be instantiated to use Show Instances.", 2, new String[]{"OK"}, 0);
                dialog.open();
            }
        });
    }

    public void run() {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            return;
        }
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
        if (document == null) {
            return;
        }
        if (!(textEditor instanceof DVTEditor)) {
            return;
        }
        int offset = ((DVTEditor)textEditor).getCursor();
        IResource resouce = (IResource)textEditor.getAdapter(IResource.class);
        if (resouce == null) {
            return;
        }
        IProject project = resouce.getProject();
        if (project == null) {
            return;
        }
        DVTBuildUtils.waitForAllBuildJobsDone((Object)IDVTConstants.VLOG_FAMILY_REPARSE);
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return;
        }
        this.findNamedElementAndShowInstances(rfProject, textEditor, document, offset);
    }

    public ISearchQuery showInstancesTest(ITextEditor textEditor, IDocument document, int offset) {
        RfProject rfProject;
        block7: {
            IProject project;
            block6: {
                IResource resouce;
                block5: {
                    try {
                        resouce = (IResource)textEditor.getAdapter(IResource.class);
                        if (resouce != null) break block5;
                        return null;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                project = resouce.getProject();
                if (project != null) break block6;
                return null;
            }
            DVTBuildUtils.waitForAllBuildJobsDone((Object)IDVTConstants.VLOG_FAMILY_REPARSE);
            rfProject = RfManager.getInstance().getRfProject(project);
            if (rfProject != null) break block7;
            return null;
        }
        return this.findNamedElementAndShowInstances(rfProject, textEditor, document, offset);
    }

    private ISearchQuery findNamedElementAndShowInstances(RfProject rfProject, ITextEditor textEditor, IDocument document, int offset) {
        IRfNamedElement namedElement = null;
        RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(rfProject, textEditor, document, offset);
        if (namedElementAndScope != null) {
            namedElement = namedElementAndScope.getIRfNamedElement();
        }
        if (namedElement == null) {
            this.informationDialog();
            return null;
        }
        boolean canSearchForInstances = RfSearchUtils.isInstantiable((IRfNamedElement)namedElement);
        if (!canSearchForInstances) {
            this.informationDialog();
            return null;
        }
        return ShowInstancesAction.showInstances(namedElement);
    }

    public static ISearchQuery showInstances(IRfNamedElement element) {
        InstancesSearchQuery query = new InstancesSearchQuery(element);
        NewSearchUI.runQueryInBackground((ISearchQuery)query);
        return query;
    }
}

