/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfNamedElementAndScope;
import ro.amiq.dvt.model.reflection.util.RfReferencesUtils;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.actions.IReferencesAction;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.utils.DVTBuildUtils;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.model.reflection.util.VlogRfGUIReferencesUtils;
import ro.amiq.vlogdt.model.reflection.util.VlogRfReferencesUtils;
import ro.amiq.vlogdt.ui.editor.actions.ReferencesInWorkspaceAction;

public class ShowWritersUsagesAction
extends ReferencesInWorkspaceAction
implements IReferencesAction {
    public ShowWritersUsagesAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        this.setText("Writers");
    }

    public void runWithEvent(Event event) {
        this.run();
    }

    @Override
    protected void informationDialog() {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Operation not Available", null, "The operation is not available on the current selection.\nPlease select a variable or port to use Show Writers.", 2, new String[]{"OK"}, 0);
                dialog.open();
            }
        });
    }

    @Override
    public void run() {
        ITextEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            return;
        }
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IDocument document = documentProvider.getDocument((Object)textEditor.getEditorInput());
        if (document == null) {
            return;
        }
        if (!(textEditor instanceof DVTEditor)) {
            return;
        }
        int offset = ((DVTEditor)textEditor).getCursor();
        IResource resouce = (IResource)textEditor.getAdapter(IResource.class);
        if (resouce == null) {
            return;
        }
        IProject project = resouce.getProject();
        if (project == null) {
            return;
        }
        DVTBuildUtils.waitForAllBuildJobsDone((Object)IDVTConstants.VLOG_FAMILY_REPARSE);
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return;
        }
        this.findNamedElementAndShowWritersUsages(rfProject, textEditor, document, offset);
    }

    private ISearchQuery findNamedElementAndShowWritersUsages(RfProject rfProject, ITextEditor textEditor, IDocument document, int offset) {
        RfWNamedElementAndScope namedElementAndScope = RfUtils.getRfElement(rfProject, textEditor, document, offset);
        if (namedElementAndScope == null) {
            this.informationDialog();
            return null;
        }
        IRfNamedElement namedElement = namedElementAndScope.getIRfNamedElement();
        if (namedElement == null) {
            this.informationDialog();
            return null;
        }
        if (!VlogRfReferencesUtils.canBeReadOrWritten((IRfNamedElement)namedElement)) {
            this.informationDialog();
            return null;
        }
        ElementPath designContextPath = null;
        if (textEditor instanceof DVTEditor) {
            designContextPath = DesignPathManager.getInstance().getPathFor((DVTEditor)textEditor, offset, namedElement, namedElementAndScope.getScope(), false, false);
        }
        boolean isHierarchicalAccess = RfReferencesUtils.isHierarchicalAccess((IRfNamedElementAndScope)namedElementAndScope);
        return VlogRfGUIReferencesUtils.showWritersAction((IRfFieldElement)namedElement, namedElementAndScope.getScope(), designContextPath, namedElementAndScope.getHidContext(), rfProject.getProject(), VlogRfReferencesUtils.getSearchedStringFromOffset(document, offset), isHierarchicalAccess);
    }

    @Override
    public ISearchQuery searchReferences(ITextEditor textEditor, IDocument document, int offset, boolean includeDeclarations) {
        IResource resouce = (IResource)textEditor.getAdapter(IResource.class);
        if (resouce == null) {
            return null;
        }
        IProject project = resouce.getProject();
        if (project == null) {
            return null;
        }
        DVTBuildUtils.waitForAllBuildJobsDone((Object)IDVTConstants.VLOG_FAMILY_REPARSE);
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            return null;
        }
        return this.findNamedElementAndShowWritersUsages(rfProject, textEditor, document, offset);
    }
}

