/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.util.RfUtils;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.ui.editor.actions.VlogAbstractRefactorAddActionCommon;

public abstract class VlogAbstractRefactorAddAction
extends VlogAbstractRefactorAddActionCommon {
    protected VlogAbstractRefactorAddAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    @Override
    protected void popUnsupportedElement() {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Limited Operation", null, "The operation is unavailable on the current selection (the scope could not be determined). Please select another Verilog Language element name or the same element from another location.", 2, new String[]{"OK"}, 0);
                dialog.open();
            }
        });
    }

    @Override
    protected void popPrecompiledElement() {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Limited Operation", null, "The selected element cannot be refactored because it is precompiled.", 1, new String[]{"OK"}, 0);
            dialog.open();
        });
    }

    public void run() {
        try {
            this.initDefaultValues();
            this.computeInfo();
            this.wizardInput = this.getInfo();
            if (this.wizardInput != null) {
                if (this.wizardInput.getModule() != null && this.wizardInput.getModule().isPrecompiledDB()) {
                    this.popPrecompiledElement();
                } else {
                    this.showWizard();
                }
            } else {
                this.popUnsupportedElement();
            }
        }
        catch (Exception e) {
            if (e instanceof CoreException) {
                this.popUnsupportedElement();
            }
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    protected int getOffset(ITextEditor textEditor) {
        return ((DVTEditor)textEditor).getCursor();
    }

    @Override
    protected RfWNamedElementAndScope getElementAndScope(ITextEditor textEditor, RfProject rfProject, int offset, IFile file, IDocument document) {
        return RfUtils.getRfElement(rfProject, file, document, offset, (DVTEditor)textEditor);
    }
}

