/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.actions;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.vlogdt.model.reflection.DataType;
import ro.amiq.vlogdt.model.reflection.RfChecker;
import ro.amiq.vlogdt.model.reflection.RfClass;
import ro.amiq.vlogdt.model.reflection.RfCovergroup;
import ro.amiq.vlogdt.model.reflection.RfDefElement;
import ro.amiq.vlogdt.model.reflection.RfField;
import ro.amiq.vlogdt.model.reflection.RfInterface;
import ro.amiq.vlogdt.model.reflection.RfManager;
import ro.amiq.vlogdt.model.reflection.RfModule;
import ro.amiq.vlogdt.model.reflection.RfNamedElement;
import ro.amiq.vlogdt.model.reflection.RfProgram;
import ro.amiq.vlogdt.model.reflection.RfProject;
import ro.amiq.vlogdt.model.reflection.RfStruct;
import ro.amiq.vlogdt.model.reflection.util.RfWNamedElementAndScope;
import ro.amiq.vlogdt.ui.editor.VlogWordFinder;
import ro.amiq.vlogdt.ui.refactor.addport.VlogRefactorAddWizardInput;

public abstract class VlogAbstractRefactorAddActionCommon
extends TextEditorAction {
    protected VlogRefactorAddWizardInput wizardInput;
    protected String name;
    protected String type;
    protected String width;
    protected RfNamedElement module;

    protected VlogAbstractRefactorAddActionCommon(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    protected void computeInfo() throws CoreException, BadLocationException {
        ITextEditor textEditor = this.getTextEditor();
        if (!(textEditor instanceof DVTEditor)) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IResource resouce = (IResource)textEditor.getAdapter(IResource.class);
        if (resouce == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IProject project = resouce.getProject();
        if (project == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        RfProject rfProject = RfManager.getInstance().getRfProject(project);
        if (rfProject == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IEditorInput editorInput = textEditor.getEditorInput();
        if (editorInput == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IFile file = (IFile)editorInput.getAdapter(IFile.class);
        if (file == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IDocument document = ((DVTEditor)textEditor).getDocument();
        if (document == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        int offset = this.getOffset(textEditor);
        RfWNamedElementAndScope elemAndScope = this.getElementAndScope(textEditor, rfProject, offset, file, document);
        if (elemAndScope == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        RfNamedElement elemAtOffset = elemAndScope.getNamedElement();
        RfNamedElement rfScope = elemAndScope.getCalledFromScope();
        if (rfScope == null) {
            rfScope = elemAndScope.getScope();
        }
        this.module = rfScope instanceof RfDefElement ? ((RfDefElement)((Object)rfScope)).getNamedElement() : rfScope;
        while (this.module != null && !(this.module instanceof RfModule)) {
            if (!this.isValidScope(this.module)) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            this.module = this.module.getEnclosingScope();
        }
        if (!(this.module instanceof RfModule)) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (elemAtOffset instanceof RfField && !elemAtOffset.equals(rfScope)) {
            DataType dataType = ((RfField)elemAtOffset).getDataType();
            if (dataType != null) {
                String netType = dataType.getNetType();
                String dataTypeName = dataType.getType();
                this.type = String.valueOf(netType == null ? "" : netType) + (dataTypeName != null ? String.valueOf(netType != null ? " " : "") + dataTypeName : "");
                this.width = dataType.getPackedDimensionString();
            }
            this.name = ((RfField)elemAtOffset).getName();
        } else {
            String candidateName;
            IRegion wordRegion = VlogWordFinder.getDefault().getWordAtOffset(document, offset);
            if (wordRegion != null && (candidateName = document.get(wordRegion.getOffset(), wordRegion.getLength()).trim()) != null && !candidateName.equals(this.module.getName()) && !candidateName.trim().isEmpty()) {
                this.name = candidateName;
            }
        }
    }

    private boolean isValidScope(RfNamedElement namedElement) {
        return !(namedElement instanceof RfClass) && !(namedElement instanceof RfStruct) && !(namedElement instanceof RfChecker) && !(namedElement instanceof RfProgram) && !(namedElement instanceof RfInterface) && !(namedElement instanceof RfCovergroup);
    }

    protected void clean() {
        this.name = null;
        this.type = null;
        this.width = null;
        this.module = null;
    }

    protected abstract VlogRefactorAddWizardInput getInfo();

    public abstract void showWizard();

    protected abstract void initDefaultValues();

    protected abstract int getOffset(ITextEditor var1);

    protected abstract RfWNamedElementAndScope getElementAndScope(ITextEditor var1, RfProject var2, int var3, IFile var4, IDocument var5);

    protected abstract void popUnsupportedElement();

    protected abstract void popPrecompiledElement();
}

