/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.vlogdt.ui.editor.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.texteditor.DeleteLineAction;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.vlogdt.linter.ui.LintingProblemsManager;
import ro.amiq.vlogdt.ui.editor.VlogEditor;

public class VlogDeleteLineAction
extends DeleteLineAction {
    public VlogDeleteLineAction(ResourceBundle bundle, String prefix, ITextEditor editor, int type, boolean copyToClipboard) {
        super(bundle, prefix, editor, type, copyToClipboard);
    }

    public void run() {
        this.removeAnnotations();
        super.run();
    }

    private void removeAnnotations() {
        if (!this.isEnabled()) {
            return;
        }
        try {
            ITextEditor editor = this.getTextEditor();
            if (!(editor instanceof VlogEditor)) {
                return;
            }
            VlogEditor vlogEditor = (VlogEditor)editor;
            ISelection selection = vlogEditor.getSelectionProvider().getSelection();
            if (!(selection instanceof TextSelection)) {
                return;
            }
            TextSelection textSelection = (TextSelection)selection;
            int startLine = textSelection.getStartLine();
            int endLine = textSelection.getEndLine();
            IAnnotationModel annotationModel = vlogEditor.getAnnotationModel();
            if (annotationModel == null) {
                return;
            }
            IDocument document = vlogEditor.getDocument();
            if (document == null) {
                return;
            }
            ArrayList<MarkerAnnotation> removeAnnotations = new ArrayList<MarkerAnnotation>();
            Iterator iterator = annotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                int annotationLine;
                Annotation annotation = (Annotation)iterator.next();
                Position position = annotationModel.getPosition(annotation);
                if (position == null || (annotationLine = document.getLineOfOffset(position.offset)) < startLine || annotationLine > endLine || !(annotation instanceof MarkerAnnotation)) continue;
                MarkerAnnotation markerAnnotation = (MarkerAnnotation)annotation;
                if (!LintingProblemsManager.getInstance().isLintingMarker(markerAnnotation.getMarker())) continue;
                removeAnnotations.add(markerAnnotation);
            }
            if (removeAnnotations.isEmpty()) {
                return;
            }
            for (MarkerAnnotation markerAnnotation : removeAnnotations) {
                annotationModel.removeAnnotation((Annotation)markerAnnotation);
            }
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

